<?php
namespace SG\SgEstateCore\Command;

use Doctrine\DBAL\Exception;
use SG\SgEstateCore\Util\Services;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use TYPO3\CMS\Core\Configuration\Exception\ExtensionConfigurationExtensionNotConfiguredException;
use TYPO3\CMS\Core\Configuration\Exception\ExtensionConfigurationPathDoesNotExistException;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class GeocodeCommand extends Command
{
    protected static $defaultName = 'sg.estate.core.geocode';

    public function __construct(
        private readonly Services          $sgEstateCoreServices,
        ?string                            $name = null,
    )
    {
        parent::__construct($name);
    }

    public function configure(): void
    {
        parent::configure();
        $this->setName('sg.estate.core.geocode');
        $this->setDescription('Geokodierung der einzelnen Immobilien via Google API');
        $this->addOption('renewAll', 'a', InputOption::VALUE_NONE, 'Renew all Coordinates');
    }

    /**
     * @throws ExtensionConfigurationPathDoesNotExistException
     * @throws ExtensionConfigurationExtensionNotConfiguredException
     * @throws Exception
     * @throws \JsonException
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->sgEstateCoreServices->geocodeRealties($input->getOption('renewAll'));
        return 0;
    }
}
