<?php
namespace SG\SgEstateCore\Command;

use Doctrine\DBAL\Exception;
use JsonException;
use SG\SgEstateCore\Util\Services;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CountCommand extends Command
{
    protected static string $defaultName = 'sg.estate.core.count';

    public function __construct(
        private readonly Services          $sgEstateCoreServices,
        ?string                            $name = null,
    )
    {
        parent::__construct($name);
    }

    public function configure(): void
    {
        parent::configure();
        $this->setName('sg.estate.core.count');
        $this->setDescription('Zählen der Immobilien');
    }

    /**
     * @throws Exception
     * @throws JsonException
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->sgEstateCoreServices->countRealties();
        return 0;
    }
}
