<?php

declare(strict_types=1);

namespace SG\SgEstateCore\Backend\Controller;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use SG\SgEstateCore\Domain\Model\Altertyp;
use SG\SgEstateCore\Domain\Model\Anhangtyp;
use SG\SgEstateCore\Domain\Model\Ausbaustufe;
use SG\SgEstateCore\Domain\Model\Ausblick;
use SG\SgEstateCore\Domain\Model\Austattungskategorie;
use SG\SgEstateCore\Domain\Model\Badausstattung;
use SG\SgEstateCore\Domain\Model\Bauweise;
use SG\SgEstateCore\Domain\Model\Bebaubarnach;
use SG\SgEstateCore\Domain\Model\Befeuerungsart;
use SG\SgEstateCore\Domain\Model\Bodenbelag;
use SG\SgEstateCore\Domain\Model\Dachform;
use SG\SgEstateCore\Domain\Model\Energiepassart;
use SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart;
use SG\SgEstateCore\Domain\Model\Energiepassjahrgang;
use SG\SgEstateCore\Domain\Model\Energietyp;
use SG\SgEstateCore\Domain\Model\Erschliessung;
use SG\SgEstateCore\Domain\Model\Erschliessungdetails;
use SG\SgEstateCore\Domain\Model\Geschlecht;
use SG\SgEstateCore\Domain\Model\Heizungsart;
use SG\SgEstateCore\Domain\Model\Himmelrichtung;
use SG\SgEstateCore\Domain\Model\Kuechenausstattung;
use SG\SgEstateCore\Domain\Model\Lage;
use SG\SgEstateCore\Domain\Model\Land;
use SG\SgEstateCore\Domain\Model\Nutzungsart;
use SG\SgEstateCore\Domain\Model\Objektart;
use SG\SgEstateCore\Domain\Model\Objektarttyp;
use SG\SgEstateCore\Domain\Model\Periode;
use SG\SgEstateCore\Domain\Model\Verkaufstatus;
use SG\SgEstateCore\Domain\Model\Vermarktungsart;
use SG\SgEstateCore\Domain\Model\Waehrung;
use SG\SgEstateCore\Domain\Model\Zustand;
use SG\SgEstateCore\Domain\Repository\AltertypRepository;
use SG\SgEstateCore\Domain\Repository\AnhangtypRepository;
use SG\SgEstateCore\Domain\Repository\AusbaustufeRepository;
use SG\SgEstateCore\Domain\Repository\AusblickRepository;
use SG\SgEstateCore\Domain\Repository\AustattungskategorieRepository;
use SG\SgEstateCore\Domain\Repository\BadausstattungRepository;
use SG\SgEstateCore\Domain\Repository\BauweiseRepository;
use SG\SgEstateCore\Domain\Repository\BebaubarnachRepository;
use SG\SgEstateCore\Domain\Repository\BefeuerungsartRepository;
use SG\SgEstateCore\Domain\Repository\BodenbelagRepository;
use SG\SgEstateCore\Domain\Repository\DachformRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassartRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassgebaeudeartRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassjahrgangRepository;
use SG\SgEstateCore\Domain\Repository\EnergietypRepository;
use SG\SgEstateCore\Domain\Repository\ErschliessungdetailsRepository;
use SG\SgEstateCore\Domain\Repository\ErschliessungRepository;
use SG\SgEstateCore\Domain\Repository\GeschlechtRepository;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\HimmelrichtungRepository;
use SG\SgEstateCore\Domain\Repository\ImmobilieRepository;
use SG\SgEstateCore\Domain\Repository\KuechenausstattungRepository;
use SG\SgEstateCore\Domain\Repository\LageRepository;
use SG\SgEstateCore\Domain\Repository\LandRepository;
use SG\SgEstateCore\Domain\Repository\NutzungsartRepository;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\PeriodeRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use SG\SgEstateCore\Domain\Repository\VerkaufstatusRepository;
use SG\SgEstateCore\Domain\Repository\VermarktungsartRepository;
use SG\SgEstateCore\Domain\Repository\WaehrungRepository;
use SG\SgEstateCore\Domain\Repository\ZustandRepository;
use SG\SgEstateCore\Util\Services;
use TYPO3\CMS\Backend\Attribute\AsController;
use TYPO3\CMS\Backend\Template\Components\ButtonBar;
use TYPO3\CMS\Backend\Template\Components\Menu\Menu;
use TYPO3\CMS\Backend\Template\ModuleTemplate;
use TYPO3\CMS\Backend\Template\ModuleTemplateFactory;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Imaging\IconSize;
use TYPO3\CMS\Core\Localization\LanguageService;
use TYPO3\CMS\Core\Localization\LanguageServiceFactory;
use TYPO3\CMS\Core\Package\Exception;
use TYPO3\CMS\Core\Type\Bitmask\Permission;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Persistence\Exception\IllegalObjectTypeException;

#[AsController]
final class ManagementController extends ActionController
{
    protected int $pageUid = 0;

    public function __construct(
        protected ImmobilieRepository              $immobilieRepository,
        protected AltertypRepository               $altertypRepository,
        protected AnhangtypRepository              $anhangtypRepository,
        protected AusbaustufeRepository            $ausbaustufeRepository,
        protected AusblickRepository               $ausblickRepository,
        protected AustattungskategorieRepository   $austattungskategorieRepository,
        protected BadausstattungRepository         $badausstattungRepository,
        protected BauweiseRepository               $bauweiseRepository,
        protected BebaubarnachRepository           $bebaubarnachRepository,
        protected BefeuerungsartRepository         $befeuerungsartRepository,
        protected BodenbelagRepository             $bodenbelagRepository,
        protected DachformRepository               $dachformRepository,
        protected EnergiepassartRepository         $energiepassartRepository,
        protected EnergiepassjahrgangRepository    $energiepassjahrgangRepository,
        protected EnergiepassgebaeudeartRepository $energiepassgebaeudeartRepository,
        protected EnergietypRepository             $energietypRepository,
        protected ErschliessungRepository          $erschliessungRepository,
        protected ErschliessungdetailsRepository   $erschliessungdetailsRepository,
        protected GeschlechtRepository             $geschlechtRepository,
        protected HeizungsartRepository            $heizungsartRepository,
        protected HimmelrichtungRepository         $himmelrichtungRepository,
        protected KuechenausstattungRepository     $kuechenausstattungRepository,
        protected LageRepository                   $lageRepository,
        protected LandRepository                   $landRepository,
        protected NutzungsartRepository            $nutzungsartRepository,
        protected ObjektartRepository              $objektartRepository,
        protected PeriodeRepository                $periodeRepository,
        protected VerkaufstatusRepository          $verkaufstatusRepository,
        protected VermarktungsartRepository        $vermarktungsartRepository,
        protected WaehrungRepository               $waehrungRepository,
        protected ZustandRepository                $zustandRepository,
        protected OrtRepository                    $ortRepository,
        protected RegionRepository                 $regionRepository,
        protected readonly ModuleTemplateFactory   $moduleTemplateFactory,
        private readonly IconFactory               $iconFactory,
        private readonly LanguageServiceFactory    $languageServiceFactory,
        private readonly ConnectionPool            $connectionPool,
        private readonly FrontendInterface         $sgEstateCoreCache,
        private readonly Services                  $sgEstateCoreServices,
    )
    {
    }

    /**
     * @noinspection PhpUnused
     */
    public function indexAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        return $view->renderResponse('Management/Index');
    }

    /**
     * @noinspection PhpUnused
     */
    public function listAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $view->assign('realties', $this->immobilieRepository->findAll());
        return $view->renderResponse('Management/List');
    }

    /**
     * @noinspection PhpUnused
     */
    public function placesAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $view->assignMultiple([
            'regions' => $this->regionRepository->findAll(),
            'cities' => $this->ortRepository->findAll(),
        ]);
        return $view->renderResponse('Management/Places');
    }

    /**
     * @noinspection PhpUnused
     */
    public function cacheAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        /**
         * @todo Mit Caching nachgucken
         * @var $cache FrontendInterface
         */
        if ($this->request->hasArgument('activity')) {
            switch ($this->request->getArgument('activity')) {
                case 'flush_cache':
                    $this->sgEstateCoreCache->flush();
                    $view->assign('state', 'flush_cache_done');
                    break;
                case 'collect_garbage':
                    $this->sgEstateCoreCache->collectGarbage();
                    $view->assign('state', 'collect_garbage_done');
                    break;
                default:
                    break;
            }
        }
        return $view->renderResponse('Management/Cache');
    }

    /**
     * @noinspection PhpUnused
     */
    public function maintenanceAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        if ($this->request->hasArgument('activity')) {
            $activity = $this->request->getArgument('activity');
            if ($activity === 'delete' && $this->request->hasArgument('object')) {
                $objectFromRequest = $this->request->getArgument('object');
                if ($objectFromRequest === 'realties' && $this->request->hasArgument('type')) {
                    if ($this->request->getArgument('type') === 'all') {
                        $this->sgEstateCoreServices->deleteAllRealties();
                        $view->assign('state', 'delete_object_all_success');
                    } elseif ($this->request->getArgument('type') === 'updatable') {
                        $this->sgEstateCoreServices->deleteAllUpdatableRealties();
                        $view->assign('state', 'delete_object_updatable_success');
                    } elseif ($this->request->getArgument('type') === 'importNumber') {
                        $importNumber = $this->request->getArgument('importNumber');
                        if (is_numeric($importNumber)) {
                            $this->sgEstateCoreServices->deleteAllUpdatableRealties($importNumber);
                            $view->assign('state', 'delete_object_importnumber_success');
                        } else {
                            $view->assign('state', 'delete_object_importnumber_failure');
                        }
                    }
                }
            }
        }
        return $view->renderResponse('Management/Maintenance');
    }

    /**
     * @noinspection PhpUnused
     */
    /**
     * @throws IllegalObjectTypeException
     */
    public function importstandardsAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        if ($this->request->hasArgument('doimport')) {
            $this->importAltertyp();
            $this->importAnhangtyp();
            $this->importAusbaustufe();
            $this->importAusblick();
            $this->importAusstattungskategorie();
            $this->importBadausstattung();
            $this->importBauweise();
            $this->importBebaubarnach();
            $this->importBefeuerungsart();
            $this->importBodenbelag();
            $this->importDachform();
            $this->importEnergiepassart();
            $this->importEnergiepassjahrgang();
            $this->importEnergiepassgebaeudeart();
            $this->importEnergietyp();
            $this->importErschliessung();
            $this->importErschliessungdetails();
            $this->importGeschlecht();
            $this->importHeizungsart();
            $this->importHimmelrichtung();
            $this->importKuechenausstattung();
            $this->importLage();
            $this->importLand();
            $this->importNutzungsart();
            $this->importObjektart();
            $this->importPeriode();
            $this->importVerkaufstatus();
            $this->importVermarktungsart();
            $this->importWaehrung();
            $this->importZustand();
        }


        return $view->renderResponse('Management/Importstandards');
    }

    /**
     * @noinspection PhpUnused
     */
    public function logAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        return $view->renderResponse('Management/Log');
    }

    /**
     * @noinspection PhpUnused
     */
    /**
     * @throws \JsonException
     * @throws \Doctrine\DBAL\Exception
     */
    public function servicesAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        if ($this->request->hasArgument('type')) {
            if ($this->request->getArgument('type') === 'countRealties') {
                $this->sgEstateCoreServices->countRealties();
                $view->assign('state', 'counting_realties_done');
            }
        }
        return $view->renderResponse('Management/Services');
    }

    /**
     * @noinspection PhpUnused
     */
    /**
     * @throws Exception
     */
    public function systeminfoAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $view->assign('installedModules', $this->getInstalledEstateModules());
        return $view->renderResponse('Management/Systeminfo');
    }

    /**
     * @noinspection PhpUnused
     */
    public function logGeocodeAction(): ResponseInterface
    {
        $view = $this->initializeModuleTemplate($this->request);
        $logFilename = Environment::getVarPath() . '/log/sg_estate_core_geocode.log';
        $logLines = [];
        if (file_exists($logFilename)) {
            $logLines = $this->fileGetTail($logFilename, 1000);
        }
        $view->assignMultiple([
            'filename' => $logFilename,
            'log' => $logLines,
        ]);
        return $view->renderResponse('Management/LogGeocode');
    }

    public function fileGetTail($filename, $num_lines = 10): array
    {
        $file = fopen($filename, 'r');

        fseek($file, -1, SEEK_END);

        for ($line = 0, $lines = []; $line < $num_lines && false !== ($char = fgetc($file));) {
            if ($char === "\n") {
                if (isset($lines[$line])) {
                    $lines[$line][] = $char;
                    $lines[$line] = implode('', array_reverse($lines[$line]));
                    $line++;
                }
            } else {
                $lines[$line][] = $char;
            }
            fseek($file, -2, SEEK_CUR);
        }
        fclose($file);

        if ($line < $num_lines) {
            $lines[$line] = implode('', array_reverse($lines[$line]));
        }

        return array_reverse($lines);
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importAltertyp(): void
    {
        $importData = [
            'Altbau' => 'ALTBAU',
            'Neubau' => 'NEUBAU',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_altertyp');
        $connection->truncate('tx_sgestatecore_domain_model_altertyp');

        if ($this->altertypRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Altertyp();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->altertypRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importAnhangtyp(): void
    {
        $importData = [
            'Titelbild' => 'TITELBILD',
            'Innenansichten' => 'INNENANSICHTEN',
            'Aussenansichten' => 'AUSSENANSICHTEN',
            'Grundriss' => 'GRUNDRISS',
            'Karten Lageplan' => 'KARTEN_LAGEPLAN',
            'Anbieterlogo' => 'ANBIETERLOGO',
            'Bild' => 'BILD',
            'Dokumente' => 'DOKUMENTE',
            'Links' => 'LINKS',
            'Panorama' => 'PANORAMA',
            'QR-Code' => 'QRCODE',
            'Film' => 'FILM',
            'Filmlink' => 'FILMLINK',
            'Energieausweis' => 'EPASS-SKALA',
            'URL' => 'ANBOBJURL',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_anhangtyp');
        $connection->truncate('tx_sgestatecore_domain_model_anhangtyp');

        if ($this->anhangtypRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Anhangtyp();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->anhangtypRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importAusbaustufe(): void
    {
        $importData = [
            'Bausatzhaus' => 'BAUSATZHAUS',
            'Ausbauhaus' => 'AUSBAUHAUS',
            'Schlüsselfertig mit Keller' => 'SCHLUESSELFERTIGMITKELLER',
            'Schlüsselfertig ohne Bodenplatte' => 'SCHLUESSELFERTIGOHNEBODENPLATTE',
            'Schlüsselfertig mit Bodenplatte' => 'SCHLUESSELFERTIGMITBODENPLATTE',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_ausbaustufe');
        $connection->truncate('tx_sgestatecore_domain_model_ausbaustufe');

        if ($this->ausbaustufeRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Ausbaustufe();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausbaustufeRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importAusblick(): void
    {
        $importData = [
            'Ferne' => 'FERNE',
            'See' => 'SEE',
            'Berge' => 'BERGE',
            'Meer' => 'MEER',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_ausblick');
        $connection->truncate('tx_sgestatecore_domain_model_ausblick');

        if ($this->ausblickRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Ausblick();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausblickRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importAusstattungskategorie(): void
    {
        $importData = [
            'Keine Angabe' => 'KEINE_ANGABE',
            'Einfach' => 'EINFACH',
            'Standard' => 'STANDARD',
            'Gehoben' => 'GEHOBEN',
            'Luxus' => 'LUXUS'
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_austattungskategorie');
        $connection->truncate('tx_sgestatecore_domain_model_austattungskategorie');

        if ($this->austattungskategorieRepository->countAll() === 0) {

            foreach ($importData as $key => $value) {
                $item = new Austattungskategorie();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->austattungskategorieRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importBadausstattung(): void
    {
        $importData = [
            'Dusche' => 'DUSCHE',
            'Wanne' => 'WANNE',
            'Fenster' => 'FENSTER',
            'Bidet' => 'BIDET',
            'Pissoir' => 'PISSOIR',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_badausstattung');
        $connection->truncate('tx_sgestatecore_domain_model_badausstattung');

        if ($this->badausstattungRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Badausstattung();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->badausstattungRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importBauweise(): void
    {
        $importData = [
            'Massiv' => 'MASSIV',
            'Fertigteile' => 'FERTIGTEILE',
            'Holz' => 'HOLZ',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_bauweise');
        $connection->truncate('tx_sgestatecore_domain_model_bauweise');

        if ($this->bauweiseRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Bauweise();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bauweiseRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importBebaubarnach(): void
    {
        $importData = [
            '34 Nachbarschaft' => '34_NACHBARSCHAFT',
            '35 Aussengebiet' => '35_AUSSENGEBIET',
            'Bebauungsplan' => 'B_PLAN',
            'Kein Bauland' => 'KEIN BAULAND',
            'Bauerwartungsland' => 'BAUERWARTUNGSLAND',
            'Länderspezifisch' => 'LAENDERSPEZIFISCH',
            'Bauland ohne Bebauungsplan' => 'BAULAND_OHNE_B_PLAN',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_bebaubarnach');
        $connection->truncate('tx_sgestatecore_domain_model_bebaubarnach');

        if ($this->bebaubarnachRepository->countAll() === 0) {

            foreach ($importData as $key => $value) {
                $item = new Bebaubarnach();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bebaubarnachRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importBefeuerungsart(): void
    {
        $importData = [
            'Öl' => 'OEL',
            'Gas' => 'GAS',
            'Strom' => 'ELEKTRO',
            'Alternativ' => 'ALTERNATIV',
            'Solar' => 'SOLAR',
            'Erdwärme' => 'ERDWAERME',
            'Luft-Wärmepumpe' => 'LUFTWP',
            'Fernwärme' => 'FERN',
            'Blockheizkraftwerk' => 'BLOCK',
            'Wasser Elektro' => 'WASSER-ELEKTRO',
            'Pellets' => 'PELLET',
            'Kohle' => 'KOHLE',
            'Erdgas leicht' => 'ERDGAS_LEICHT',
            'Erdgas schwer' => 'ERDGAS_SCHWER',
            'Flüssiggas' => 'FLUESSIGGAS',
            'Fernwärme Dampf' => 'FERNWAERME_DAMPF',
            'Holz' => 'HOLZ',
            'Holz-Hackschnitzel' => 'HOLZ-HACKSCHNITZEL',
            'Kohle/Koks' => 'KOHLE_KOKS',
            'Nahwärme' => 'NAHWAERME',
            'Wärmelieferung' => 'WAERMELIEFERUNG',
            'BIO Energie' => 'BIOENERGIE',
            'Windenergie' => 'WINDENERGIE',
            'Wasserenergie' => 'WASSERENERGIE',
            'Umweltwärme' => 'UMWELTWAERME',
            'KWK fossil' => 'KWK_FOSSIL',
            'KWK erneuerbar' => 'KWK_ERNEUERBAR',
            'KWK regenerativ' => 'KWK_REGENERATIV',
            'KWK bio' => 'KWK_BIO',
            'Keine Angabe' => 'KEIN_ANGABE'
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_befeuerungsart');
        $connection->truncate('tx_sgestatecore_domain_model_befeuerungsart');

        if ($this->befeuerungsartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Befeuerungsart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->befeuerungsartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importBodenbelag(): void
    {
        $importData = [
            'Fliesen' => 'FLIESEN',
            'Stein' => 'STEIN',
            'Teppich' => 'TEPPICH',
            'Parkett' => 'PARKETT',
            'Fertigparkett' => 'FERTIGPARKETT',
            'Laminat' => 'LAMINAT',
            'Dielen' => 'DIELEN',
            'Kunststoff' => 'KUNSTSTOFF',
            'Estrich' => 'ESTRICH',
            'Doppelboden' => 'DOPPELBODEN',
            'Linoleum' => 'LINOLEUM',
            'Marmor' => 'MARMOR',
            'Terrakotta' => 'TERRAKOTTA',
            'Granit' => 'GRANIT',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_bodenbelag');
        $connection->truncate('tx_sgestatecore_domain_model_bodenbelag');

        if ($this->bodenbelagRepository->countAll() === 0) {

            foreach ($importData as $key => $value) {
                $item = new Bodenbelag();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bodenbelagRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importDachform(): void
    {
        $importData = [
            'Krüppelwalmdach' => 'KRUEPPELWALMDACH',
            'Mansarddach' => 'MANSARDDACH',
            'Pultdach' => 'PULTDACH',
            'Satteldach' => 'SATTELDACH',
            'Walmdach' => 'WALMDACH',
            'Flachdach' => 'FLACHDACH',
            'Pyramidendach' => 'PYRAMIDENDACH',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_dachform');
        $connection->truncate('tx_sgestatecore_domain_model_dachform');

        if ($this->dachformRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Dachform();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->dachformRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importEnergiepassart(): void
    {
        $importData = [
            'Bedarfsausweis' => 'BEDARF',
            'Verbrauchsausweis' => 'VERBRAUCH',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_energiepassart');
        $connection->truncate('tx_sgestatecore_domain_model_energiepassart');

        if ($this->energiepassartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Energiepassart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importEnergiepassjahrgang(): void
    {
        $importData = [
            'Vor 2014' => '2008',
            'Ab 1.5.2014' => '2014',
            'es liegt kein E-pass vor' => 'OHNE',
            'nicht notwendig' => 'NICHT_NOETIG',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_energiepassjahrgang');
        $connection->truncate('tx_sgestatecore_domain_model_energiepassjahrgang');

        if ($this->energiepassjahrgangRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Energiepassjahrgang();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassjahrgangRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importEnergiepassgebaeudeart(): void
    {
        $importData = [
            'Wohnimmobilie' => 'WOHN',
            'Gewerbe und Mischformen' => 'NICHTWOHN',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_energiepassgebaeudeart');
        $connection->truncate('tx_sgestatecore_domain_model_energiepassgebaeudeart');

        if ($this->energiepassgebaeudeartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Energiepassgebaeudeart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energiepassgebaeudeartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importEnergietyp(): void
    {
        $importData = [
            'Passivhaus' => 'PASSIVHAUS',
            'Niedrigenergie' => 'NIEDRIGENERGIE',
            'Neubaustandard' => 'NEUBAUSTANDARD',
            'Kfw 40' => 'KFW40',
            'Kfw 60' => 'KFW60',
            'Kfw 55' => 'KFW55',
            'Kfw 70' => 'KFW70',
            'Minergiebauweise' => 'MINERGIEBAUWEISE',
            'Minergie zertifiziert' => 'MINERGIE_ZERTIFIZIERT',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_energietyp');
        $connection->truncate('tx_sgestatecore_domain_model_energietyp');

        if ($this->energietypRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Energietyp();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energietypRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importErschliessung(): void
    {
        $importData = [
            'Unerschlossen' => 'UNERSCHLOSSEN',
            'Teilerschlossen' => 'TEILERSCHLOSSEN',
            'Vollerschlossen' => 'VOLLERSCHLOSSEN',
            'Ortsüblich erschlossen' => 'ORTSUEBLICHERSCHLOSSEN',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_erschliessung');
        $connection->truncate('tx_sgestatecore_domain_model_erschliessung');

        if ($this->erschliessungRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Erschliessung();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importErschliessungdetails(): void
    {
        $importData = [
            'Gas' => 'GAS',
            'Wasser' => 'WASSER',
            'Strom' => 'STROM',
            'TK' => 'TK',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_erschliessungdetails');
        $connection->truncate('tx_sgestatecore_domain_model_erschliessungdetails');

        if ($this->erschliessungdetailsRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Erschliessungdetails();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungdetailsRepository->add($item);
            }
        }
    }


    /**
     * @throws IllegalObjectTypeException
     */
    private function importGeschlecht(): void
    {
        $importData = [
            'Egal' => 'EGAL',
            'nur Männer' => 'NUR_MANN',
            'nur Frauen' => 'NUR_FRAU',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_geschlecht');
        $connection->truncate('tx_sgestatecore_domain_model_geschlecht');

        if ($this->geschlechtRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Geschlecht();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->geschlechtRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importHeizungsart(): void
    {
        $importData = [
            'Ofenheizung' => 'OFEN',
            'Etagenheizung' => 'ETAGE',
            'Zentralheizung' => 'ZENTRAL',
            'Fernwärme' => 'FERN',
            'Fussbodenheizung' => 'FUSSBODEN',
            'Gas-Heizung' => 'GAS-HEIZUNG',
            'Holz-Pelletheizung' => 'HOLZ-PELLETHEIZUNG',
            'Nachtspeicherofen' => 'nachtspeicherofen',
            'Ölheizung' => 'ÖLHEIZUNG',
            'Solar-Heizung' => 'SOLAR-HEIZUNG',
            'Wärmepumpe' => 'WAERMEPUMPE',
            'Blockheizkraftwerk' => 'BLOCKHEIZKRAFTWERK',
            'Elektro-Heizung' => 'ELEKTRO-HEIZUNG',
            'Keine Angabe' => 'KEIN_ANGABE',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_heizungsart');
        $connection->truncate('tx_sgestatecore_domain_model_heizungsart');

        if ($this->heizungsartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Heizungsart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->heizungsartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importHimmelrichtung(): void
    {
        $importData = [
            'Nord' => 'NORD',
            'Ost' => 'OST',
            'Süd' => 'SUED',
            'West' => 'WEST',
            'Nordost' => 'NORDOST',
            'Nordwest' => 'NORDWEST',
            'Südost' => 'SUEDOST',
            'Südwest' => 'SUEDWEST',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_himmelrichtung');
        $connection->truncate('tx_sgestatecore_domain_model_himmelrichtung');

        if ($this->himmelrichtungRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Himmelrichtung();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->himmelrichtungRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importKuechenausstattung(): void
    {
        $importData = [
            'Einbauküche' => 'EBK',
            'Offene Küche' => 'OFFEN',
            'Pantry' => 'PANTRY',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_kuechenausstattung');
        $connection->truncate('tx_sgestatecore_domain_model_kuechenausstattung');

        if ($this->kuechenausstattungRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Kuechenausstattung();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->kuechenausstattungRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importLage(): void
    {
        $importData = [
            'Wohn' => 'WOHN',
            'Gewerbe' => 'GEWERBE',
            'Industrie' => 'INDUSTRIE',
            'Misch' => 'MISCH',
            'Neubau' => 'NEUBAU',
            'Ortslage' => 'ORTSLAGE',
            'Siedlung' => 'SIEDLUNG',
            'Stadtrand' => 'STADTRAND',
            'Stadtteil' => 'STADTTEIL',
            'Stadtzentrum' => 'STADTZENTRUM',
            'Nebenzentrum' => 'NEBENZENTRUM',
            '1A' => '1A',
            '1B' => '1B',
            'Einkaufszentrum' => 'EINKAUFSZENTRUM',
            'Keine Angabe' => 'KEINE_ANGABE'
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_lage');
        $connection->truncate('tx_sgestatecore_domain_model_lage');

        if ($this->lageRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Lage();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->lageRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importLand(): void
    {
        // @todo: Restliche Länder ergänzen
        $importData = [
            'Deutschland' => 'DEU'
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_land');
        $connection->truncate('tx_sgestatecore_domain_model_land');

        if ($this->landRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Land();
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $this->landRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importNutzungsart(): void
    {
        $importData = [
            'Wohnen' => 'WOHNEN',
            'Gewerbe' => 'GEWERBE',
            'Anlage' => 'ANLAGE',
            'Wohnen auf Zeit' => 'WAZ',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_nutzungsart');
        $connection->truncate('tx_sgestatecore_domain_model_nutzungsart');

        if ($this->nutzungsartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Nutzungsart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->nutzungsartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importObjektart(): void
    {
        $importData = [
            'Zimmer' => [
                'kuerzel' => 'ZIMMER',
                'typen' => [
                    'Zimmer' => 'ZIMMER'
                ],
            ],
            'Wohnung' => [
                'kuerzel' => 'WOHNUNG',
                'typen' => [
                    'Dachgeschoss' => 'DACHGESCHOSS',
                    'Maisonette' => 'MAISONETTE',
                    'Loft Studio Atelier' => 'LOFT',
                    'Penthouse' => 'PENTHOUSE',
                    'Terrassen' => 'TERASSEN',
                    'Etage' => 'ETAGE',
                    'Erdgeschoss' => 'ERDGESCHOSS',
                    'Hochpaterre' => 'HOCHPATERRE',
                    'Souterrain' => 'SOUTERRAIN',
                    'Apartment' => 'APARTMENT',
                    'Ferienwohnung' => 'FERIENWOHNUNG',
                    'Galerie' => 'GALERIE',
                    'Rohdachboden' => 'ROHDACHBODEN',
                    'Attikawohnung' => 'ATTIKAWOHNUNG',
                    'Sonstiges' => 'SONSTIGE',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ],
            ],
            'Haus' => [
                'kuerzel' => 'HAUS',
                'typen' => [
                    'Reihenhaus' => 'REIHENHAUS',
                    'Reihenend' => 'REIHENEND',
                    'Reihenmittel' => 'REIHENMITTEL',
                    'Reiheneck' => 'REIHENECK',
                    'Doppelhaushaelfte' => 'DOPPELHAUSHAELFTE',
                    'Einfamilienhaus' => 'EINFAMILIENHAUS',
                    'Stadthaus' => 'STADTHAUS',
                    'Bungalow' => 'BUNGALOW',
                    'Villa' => 'VILLA',
                    'Resthof' => 'RESTHOF',
                    'Bauernhaus' => 'BAUERNHAUS',
                    'Landhaus' => 'LANDHAUS',
                    'Schloss' => 'SCHLOSS',
                    'Zweifamilienhaus' => 'ZWEIFAMILIENHAUS',
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Ferienhaus' => 'FERIENHAUS',
                    'Berghuette' => 'BERGHUETTE',
                    'Chalet' => 'CHALET',
                    'Strandhaus' => 'STRANDHAUS',
                    'laube-datsche-gartenhaus' => 'LAUBE-DATSCHE-GARTENHAUS',
                    'Apartmenthaus' => 'APARTMENTHAUS',
                    'Burg' => 'BURG',
                    'Herrenhaus' => 'HERRENHAUS',
                    'Finca' => 'FINCA',
                    'Rustico' => 'RUSTICO',
                    'Fertighaus' => 'FERTIGHAUS',
                    'Besondere Immobilie' => 'SPECIAL_REAL_ESTATE',
                    'Wohnimmobilie (sonstige)' => 'OTHER',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ],
            ],
            'Grundstück' => [
                'kuerzel' => 'GRUNDSTUECK',
                'typen' => [
                    'Wohnen' => 'WOHNEN',
                    'Gewerbe' => 'GEWERBE',
                    'Industrie' => 'INDUSTRIE',
                    'Land Forstwirschaft' => 'LAND_FORSTWIRSCHAFT',
                    'Freizeit' => 'FREIZEIT',
                    'Gemischt' => 'GEMISCHT',
                    'Gewerbepark' => 'GEWERBEPARK',
                    'Sondernutzung' => 'SONDERNUTZUNG',
                    'Seeliegenschaft' => 'SEELIEGENSCHAFT',
                ],
            ],
            'Büro & Praxen' => [
                'kuerzel' => 'BUERO_PRAXEN',
                'typen' => [
                    'Bueroflaeche' => 'BUEROFLAECHE',
                    'Bueroetage' => 'OFFICE_FLOOR',
                    'Buerohaus' => 'BUEROHAUS',
                    'Buerozentrum' => 'BUEROZENTRUM',
                    'Buero und Lager Gebaeude' => 'OFFICE_STORAGE_BUILDING',
                    'Loft Atelier' => 'LOFT',
                    'Studio' => 'STUDIO',
                    'Praxis' => 'PRAXIS',
                    'Praxisetage' => 'SURGERY_FLOOR',
                    'Praxisflaeche' => 'PRAXISFLAECHE',
                    'Praxishaus' => 'PRAXISHAUS',
                    'Gewerbezentrum' => 'COMMERCIAL_CENTRE',
                    'Wohn und Geschaeftsgebaeude' => 'LIVING_AND_COMMERCIAL_BUILDING',
                    'Buero und Geschaeftsgebaeude' => 'OFFICE_AND_COMMERCIAL_BUILDING',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                    'Coworking' => 'COWORKING',
                    'Shared Office' => 'SHARED_OFFICE',
                ],
            ],
            'Einzelhandel' => [
                'kuerzel' => 'EINZELHANDEL',
                'typen' => [
                    'Ladenlokal' => 'LADENLOKAL',
                    'Einzelhandelsladen' => 'EINZELHANDELSLADEN',
                    'Verbrauchermarkt' => 'VERBRAUCHERMARKT',
                    'Einkaufszentrum' => 'EINKAUFSZENTRUM',
                    'Kaufhaus' => 'KAUFHAUS',
                    'Factory Outlet' => 'FACTORY_OUTLET',
                    'Kiosk' => 'KIOSK',
                    'Verkaufsflaeche' => 'VERKAUFSFLAECHE',
                    'Verkaufshalle' => 'VERKAUFSHALLE',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                ],
            ],
            'Gastgewerbe' => [
                'kuerzel' => 'GASTGEWERBE',
                'typen' => [
                    'Gastronomie' => 'GASTRONOMIE',
                    'Gastronomie & Wohnung' => 'GASTRONOMIE_UND_WOHNUNG',
                    'Pensionen' => 'PENSIONEN',
                    'Hotels' => 'HOTELS',
                    'Weitere Beherbergungsbetriebe' => 'WEITERE_BEHERBERGUNGSBETRIEBE',
                    'Bar' => 'BAR',
                    'Cafe' => 'CAFE',
                    'Discothek' => 'DISCOTHEK',
                    'Restaurant' => 'RESTAURANT',
                    'Raucherlokal' => 'RAUCHERLOKAL',
                    'Einraumlokal' => 'EINRAUMLOKAL',
                ],
            ],
            'Hallen, Lager & Produktion' => [
                'kuerzel' => 'HALLEN_LAGER_PROD',
                'typen' => [
                    'Halle' => 'HALLE',
                    'Industriehalle' => 'INDUSTRIEHALLE',
                    'Lager' => 'LAGER',
                    'Lagerflaechen' => 'LAGERFLAECHEN',
                    'Lager mit Freiflaeche' => 'LAGER_MIT_FREIFLAECHE',
                    'Hochregallager' => 'HOCHREGALLAGER',
                    'Speditionslager' => 'SPEDITIONSLAGER',
                    'Produktion' => 'PRODUKTION',
                    'Werkstatt' => 'WERKSTATT',
                    'Service' => 'SERVICE',
                    'Freiflaechen' => 'FREIFLAECHEN',
                    'Kühlhaus' => 'KUEHLHAUS',
                ],
            ],
            'Land & Forstwirtschaft' => [
                'kuerzel' => 'LAND_UND_FORSTWIRTSCHAFT',
                'typen' => [
                    'Landwirtschaftliche_betriebe' => 'LANDWIRTSCHAFTLICHE_BETRIEBE',
                    'Bauernhof' => 'BAUERNHOF',
                    'Aussiedlerhof' => 'AUSSIEDLERHOF',
                    'Gartenbau' => 'GARTENBAU',
                    'Ackerbau' => 'ACKERBAU',
                    'Weinbau' => 'WEINBAU',
                    'Viehwirtschaft' => 'VIEHWIRTSCHAFT',
                    'Jagd & Forstwirtschaft' => 'JAGD_UND_FORSTWIRTSCHAFT',
                    'Teich & Fischwirtschaft' => 'TEICH_UND_FISCHWIRTSCHAFT',
                    'Scheunen' => 'SCHEUNEN',
                    'Reiterhoefe' => 'REITERHOEFE',
                    'Sonstige Landwirtschaftsimmobilien' => 'SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN',
                    'Anwesen' => 'ANWESEN',
                    'Jagdrevier' => 'JAGDREVIER',
                ],
            ],
            'Parken' => [
                'kuerzel' => 'PARKEN',
                'typen' => [
                    'Stellplatz' => 'STELLPLATZ',
                    'Carport' => ['CARPORT', 'CARPORT'],
                    'Doppelgarage' => 'DOPPELGARAGE',
                    'Duplex' => ['DUPLEX', 'DUPLEX'],
                    'Tiefgarage' => ['TIEFGARAGE', 'UNDERGROUND_GARAGE'],
                    'Bootsliegeplatz' => 'BOOTSLIEGEPLATZ',
                    'Einzelgarage' => 'EINZELGARAGE',
                    'Parkhaus' => ['PARKHAUS', 'CAR_PARK'],
                    'Tiefgaragenstellplatz' => 'TIEFGARAGENSTELLPLATZ',
                    'Parkplatz mit Strom' => 'PARKPLATZ_STROM',
                    'Garage' => ['GARAGE', 'GARAGE'],
                    'Außenstellplatz' => ['', 'OUTSIDE'],
                ],
            ],
            'Sonstige' => [
                'kuerzel' => 'SONSTIGE',
                'typen' => [
                    'Parkhaus' => 'PARKHAUS',
                    'Tankstelle' => 'TANKSTELLE',
                    'Krankenhaus' => 'KRANKENHAUS',
                    'Sonstige' => 'SONSTIGE',
                ],
            ],
            'Freizeitimmobilie gewerblich' => [
                'kuerzel' => 'FREIZEITIMMOBILIE_GEWERBLICH',
                'typen' => [
                    'Sportanlagen' => 'SPORTANLAGEN',
                    'Vergnuegungsparks & Center' => 'VERGNUEGUNGSPARKS_UND_CENTER',
                    'Freizeitanlage' => 'FREIZEITANLAGE',
                ],
            ],
            'Renditeobjekt' => [
                'kuerzel' => 'ZINSHAUS_RENDITEOBJEKT',
                'typen' => [
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Wohn- und Geschaeftshaus' => 'WOHN_UND_GESCHAEFTSHAUS',
                    'Geschaeftshaus' => 'GESCHAEFTSHAUS',
                    'Buerogebaeude' => 'BUEROGEBAEUDE',
                    'SB Märkte' => 'SB_MAERKTE',
                    'Einkaufscentren' => 'EINKAUFSCENTREN',
                    'Wohnanlagen' => 'WOHNANLAGEN',
                    'Verbrauchermärkte' => 'VERBRAUCHERMAERKTE',
                    'Industrieanlagen' => 'INDUSTRIEANLAGEN',
                    'Pflegeheim' => 'PFLEGEHEIM',
                    'Sanatorium' => 'SANATORIUM',
                    'Seniorenheim' => 'SENIORENHEIM',
                    'Betreutes Wohnen' => 'BETREUTES-WOHNEN',
                ],
            ],
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_objektart');
        $connection->truncate('tx_sgestatecore_domain_model_objektart');

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_objektarttyp');
        $connection->truncate('tx_sgestatecore_domain_model_objektarttyp');

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_objektart_objektarttyp_mm');
        $connection->truncate('tx_sgestatecore_objektart_objektarttyp_mm');

        if ($this->nutzungsartRepository->countAll() === 0) {
            foreach ($importData as $key => $data) {
                $objektart = new Objektart();
                $objektart->setBezeichner($key);
                $objektart->setKuerzel($data['kuerzel']);
                foreach ($data['typen'] as $typKey => $typValue) {
                    $objektarttyp = new Objektarttyp();
                    $objektarttyp->setBezeichner($typKey);

                    if (is_array($typValue)) {
                        $objektarttyp->setKuerzel($typValue[0]);
                        $objektarttyp->setKuerzelis24($typValue[1]);
                    } else {
                        $objektarttyp->setKuerzel($typValue);
                    }
                    $objektart->addObjektarttyp($objektarttyp);

                }
                $this->objektartRepository->add($objektart);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importPeriode(): void
    {
        $importData = [
            'Tag' => 'TAG',
            'Woche' => 'WOCHE',
            'Monat' => 'MONAT',
            'Jahr' => 'JAHR',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_periode');
        $connection->truncate('tx_sgestatecore_domain_model_periode');

        if ($this->periodeRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Periode();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->periodeRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importVerkaufstatus(): void
    {
        $importData = [
            'Offen' => 'OFFEN',
            'Reserviert' => 'RESERVIERT',
            'Verkauft' => 'VERKAUFT',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_verkaufstatus');
        $connection->truncate('tx_sgestatecore_domain_model_verkaufstatus');

        if ($this->verkaufstatusRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Verkaufstatus();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->verkaufstatusRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importVermarktungsart(): void
    {
        $importData = [
            'Kauf' => 'KAUF',
            'Miete Pacht' => 'MIETE_PACHT',
            'Erbpacht' => 'ERBPACHT',
            'Leasing' => 'LEASING',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_vermarktungsart');
        $connection->truncate('tx_sgestatecore_domain_model_vermarktungsart');

        if ($this->vermarktungsartRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Vermarktungsart();
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->vermarktungsartRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importWaehrung(): void
    {
        // @todo: Restliche Währungen einpflegen
        $importData = [
            'Euro' => 'EUR',
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_waehrung');
        $connection->truncate('tx_sgestatecore_domain_model_waehrung');

        if ($this->waehrungRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Waehrung();
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $item->setSymbol($value);
                $this->waehrungRepository->add($item);
            }
        }
    }

    /**
     * @throws IllegalObjectTypeException
     */
    private function importZustand(): void
    {
        $importData = [
            'Erstbezug' => 'ERSTBEZUG',
            'Erstbezug nach Sanierung' => 'ERSTBEZUG_NACH_SANIERUNG',
            'Teil- Vollrenovierungsbed' => 'TEIL_VOLLRENOVIERUNGSBED',
            'Neuwertig' => 'NEUWERTIG',
            'Teil- Vollsaniert' => 'TEIL_VOLLSANIERT',
            'Teil- Vollrenoviert' => 'TEIL_VOLLRENOVIERT',
            'Teilsaniert' => 'TEIL_SANIERT',
            'Vollsaniert' => 'VOLL_SANIERT',
            'Sanierungsbeduerftig' => 'SANIERUNGSBEDUERFTIG',
            'Baufaellig' => 'BAUFAELLIG',
            'Nach Vereinbarung' => 'NACH_VEREINBARUNG',
            'Modernisiert' => 'MODERNISIERT',
            'Gepflegt' => 'GEPFLEGT',
            'Rohbau' => 'ROHBAU',
            'Entkernt' => 'ENTKERNT',
            'Abrissobjekt' => 'ABRISSOBJEKT',
            'Projektiert' => 'PROJEKTIERT',
            'Keine Angabe' => 'NO_INFORMATION'
        ];

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_zustand');
        $connection->truncate('tx_sgestatecore_domain_model_zustand');

        if ($this->zustandRepository->countAll() === 0) {
            foreach ($importData as $key => $value) {
                $item = new Zustand();
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->zustandRepository->add($item);
            }
        }
    }

    /**
     * @throws Exception
     */
    private function getInstalledEstateModules(): array
    {
        $installedModules = [];
        if (ExtensionManagementUtility::isLoaded('sg_estate_core')) {
            $installedModules[] = [
                'key' => 'sg_estate_core',
                'title' => 'sg.estate - Core Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_core')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_base')) {
            $installedModules[] = [
                'key' => 'sg_estate_base',
                'title' => 'sg.estate - Base Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_base')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_landingpage')) {
            $installedModules[] = [
                'key' => 'sg_estate_landingpage',
                'title' => 'sg.estate - Landingpage Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_landingpage')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_immosolve')) {
            $installedModules[] = [
                'key' => 'sg_estate_immosolve',
                'title' => 'sg.estate - Immosolve Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_immosolve')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_csv')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_csv',
                'title' => 'sg.estate - CSV-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_csv')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_is24')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_is24',
                'title' => 'sg.estate - Immobilienscout24-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_is24')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_openimmo')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_openimmo',
                'title' => 'sg.estate - Openimmo-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_openimmo')
            ];
        }
        return $installedModules;
    }

    /**
     * Generates the action menu
     */
    protected function initializeModuleTemplate(
        ServerRequestInterface $request,
    ): ModuleTemplate
    {
        $view = $this->moduleTemplateFactory->create($request);

        $context = '';
        $this->modifyDocHeaderComponent($view, $context);
        $view->setFlashMessageQueue($this->getFlashMessageQueue());
        $view->setTitle(
            'Title 1', //$this->getLanguageService()->sL('LLL:EXT:blog_example/Resources/Private/Language/Module/locallang_mod.xlf:mlang_tabs_tab'),
            $context,
        );

        return $view;
    }

    private function modifyDocHeaderComponent(ModuleTemplate $view, string &$context): void
    {
        $menu = $this->buildMenu($view, $context);
        $view->getDocHeaderComponent()->getMenuRegistry()->addMenu($menu);

        $buttonBar = $view->getDocHeaderComponent()->getButtonBar();
        $this->addButtons($buttonBar);

        $metaInformation = $this->getMetaInformation();
        if (is_array($metaInformation)) {
            $view->getDocHeaderComponent()->setMetaInformation($metaInformation);
        }
    }

    public function addButtons(ButtonBar $buttonBar): void
    {
        $this->addShortCutButton($buttonBar);
        $this->addReloadButton($buttonBar);
    }

    /**
     * @return array<string,scalar>|false
     */
    public function getMetaInformation(): array|false
    {
        $permissionClause = $GLOBALS['BE_USER']->getPagePermsClause(Permission::PAGE_SHOW);
        return BackendUtility::readPageAccess(
            $this->pageUid,
            $permissionClause,
        );
    }

    private function addReloadButton(ButtonBar $buttonBar): void
    {
        $reloadButton = $buttonBar->makeLinkButton()
            ->setHref($this->request->getAttribute('normalizedParams')->getRequestUri())
            ->setTitle($this->getLanguageService()->sL('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:labels.reload'))
            ->setIcon($this->iconFactory->getIcon('actions-refresh', IconSize::SMALL));
        $buttonBar->addButton($reloadButton, ButtonBar::BUTTON_POSITION_RIGHT);
    }

    private function addShortCutButton(ButtonBar $buttonBar): void
    {
        $shortcutButton = $buttonBar
            ->makeShortcutButton()
            ->setDisplayName($this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:shortcut'))
            ->setRouteIdentifier('tx_sg_estate_core_management');
        $shortcutButton->setArguments(['controller' => 'ManagementController', 'action' => 'index']);

        $buttonBar->addButton($shortcutButton, ButtonBar::BUTTON_POSITION_RIGHT);
    }

    protected function getLanguageService(): LanguageService
    {
        return $this->languageServiceFactory->createFromUserPreferences($GLOBALS['BE_USER']);
    }

    private function buildMenu(ModuleTemplate $view, string &$context): Menu
    {
        $menuItems = [
            'index' => [
                'controller' => 'Management',
                'action' => 'index',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.index'),
            ],
            'list' => [
                'controller' => 'Management',
                'action' => 'list',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.list'),
            ],
            'places' => [
                'controller' => 'Management',
                'action' => 'places',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.places'),
            ],
            'cache' => [
                'controller' => 'Management',
                'action' => 'cache',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.cache'),
            ],
            'maintenance' => [
                'controller' => 'Management',
                'action' => 'maintenance',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.maintenance'),
            ],
            'importstandards' => [
                'controller' => 'Management',
                'action' => 'importstandards',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.importstandards'),
            ],
            'log' => [
                'controller' => 'Management',
                'action' => 'log',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.log'),
            ],
            'services' => [
                'controller' => 'Management',
                'action' => 'services',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.services'),
            ],
            'systeminfo' => [
                'controller' => 'Management',
                'action' => 'systeminfo',
                'label' => $this->getLanguageService()->sL('LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_mod1.xlf:menu.systeminfo'),
            ],
        ];

        $menu = $view->getDocHeaderComponent()->getMenuRegistry()->makeMenu();
        $menu->setIdentifier('BlogExampleModuleMenu');

        foreach ($menuItems as $menuItemConfig) {
            $isActive = $this->request->getControllerActionName() === $menuItemConfig['action'];
            $menuItem = $menu->makeMenuItem()
                ->setTitle($menuItemConfig['label'])
                ->setHref($this->uriBuilder->reset()->uriFor(
                    $menuItemConfig['action'],
                    [],
                    $menuItemConfig['controller'],
                ))
                ->setActive($isActive);
            $menu->addMenuItem($menuItem);
            if ($isActive) {
                $context = $menuItemConfig['label'];
            }
        }
        return $menu;
    }
}