<?php
namespace SG\SgEstateCore\Controller;

use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

class ManagementController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController {

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AltertypRepository
     * @inject
     */
    protected $altertypRepository;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AnhangtypRepository
     * @inject
     */
    protected $anhangtypRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AusbaustufeRepository
     * @inject
     */
    protected $ausbaustufeRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AusblickRepository
     * @inject
     */
    protected $ausblickRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AustattungskategorieRepository
     * @inject
     */
    protected $austattungskategorieRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\BadausstattungRepository
     * @inject
     */
    protected $badausstattungRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\BauweiseRepository
     * @inject
     */
    protected $bauweiseRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\BebaubarnachRepository
     * @inject
     */
    protected $bebaubarnachRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\BefeuerungsartRepository
     * @inject
     */
    protected $befeuerungsartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\BodenbelagRepository
     * @inject
     */
    protected $bodenbelagRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\DachformRepository
     * @inject
     */
    protected $dachformRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\EnergiepassartRepository
     * @inject
     */
    protected $energiepassartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\EnergiepassjahrgangRepository
     * @inject
     */
    protected $energiepassjahrgangRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\EnergiepassgebaeudeartRepository
     * @inject
     */
    protected $energiepassgebaeudeartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\EnergietypRepository
     * @inject
     */
    protected $energietypRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\ErschliessungRepository
     * @inject
     */
    protected $erschliessungRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\ErschliessungdetailsRepository
     * @inject
     */
    protected $erschliessungdetailsRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\GeschlechtRepository
     * @inject
     */
    protected $geschlechtRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\HeizungsartRepository
     * @inject
     */
    protected $heizungsartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\HimmelrichtungRepository
     * @inject
     */
    protected $himmelrichtungRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\KuechenausstattungRepository
     * @inject
     */
    protected $kuechenausstattungRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\LageRepository
     * @inject
     */
    protected $lageRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\LandRepository
     * @inject
     */
    protected $landRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\NutzungsartRepository
     * @inject
     */
    protected $nutzungsartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\ObjektartRepository
     * @inject
     */
    protected $objektartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\PeriodeRepository
     * @inject
     */
    protected $periodeRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\VerkaufstatusRepository
     * @inject
     */
    protected $verkaufstatusRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\VermarktungsartRepository
     * @inject
     */
    protected $vermarktungsartRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\WaehrungRepository
     * @inject
     */
    protected $waehrungRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\ZustandRepository
     * @inject
     */
    protected $zustandRepository = NULL;

    /**
     * @var \SG\SgEstateCore\Domain\Repository\ImmobilieRepository
     * @inject
     */
    protected $immobilieRepository = NULL;

    public function indexAction(){
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $this->view->assign('realties', $this->immobilieRepository->findAll());
    }

    public function importstandardsAction(){
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        if ($this->request->hasArgument('doimport')){
            //$resetData = ($this->request->hasArgument('resetData')&&$this->request->getArgument('resetData')==1) ? true : false;
            $resetData = true;

            $this->importAltertyp($resetData);
            $this->importAnhangtyp($resetData);
            $this->importAusbaustufe($resetData);
            $this->importAusblick($resetData);
            $this->importAusstattungskategorie($resetData);
            $this->importBadausstattung($resetData);
            $this->importBauweise($resetData);
            $this->importBebaubarnach($resetData);
            $this->importBefeuerungsart($resetData);
            $this->importBodenbelag($resetData);
            $this->importDachform($resetData);
            $this->importEnergiepassart($resetData);
            $this->importEnergiepassjahrgang($resetData);
            $this->importEnergiepassgebaeudeart($resetData);
            $this->importEnergietyp($resetData);
            $this->importErschliessung($resetData);
            $this->importErschliessungdetails($resetData);
            $this->importGeschlecht($resetData);
            $this->importHeizungsart($resetData);
            $this->importHimmelrichtung($resetData);
            $this->importKuechenausstattung($resetData);
            $this->importLage($resetData);
            $this->importLand($resetData);
            $this->importNutzungsart($resetData);
            $this->importObjektart($resetData);
            $this->importPeriode($resetData);
            $this->importVerkaufstatus($resetData);
            $this->importVermarktungsart($resetData);
            $this->importWaehrung($resetData);
            $this->importZustand($resetData);
        }
    }

    public function maintenanceAction(){
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        /**
         * @var $sgCoreServices \SG\SgEstateCore\Util\Services
         */
        if ($this->request->hasArgument('activity')){
            switch ($this->request->getArgument('activity')){
                case 'delete':
                    if ($this->request->hasArgument('object')){
                        switch ($this->request->getArgument('object')){
                            case 'realties':
                                if ($this->request->hasArgument('type')){
                                    $sgCoreServices = $this->objectManager->get('SG\SgEstateCore\Util\Services');
                                    if ($this->request->getArgument('type') == 'all'){
                                        $sgCoreServices->deleteAllRealties();
                                        $this->view->assign('state','delete_object_all_success');
                                    }elseif($this->request->getArgument('type') == 'updatable'){
                                        $sgCoreServices->deleteAllUpdatableRealties();
                                        $this->view->assign('state','delete_object_updatable_success');
                                    }elseif($this->request->getArgument('type') == 'importNumber'){
                                      $importNumber = $this->request->getArgument('importNumber');
                                      if (is_numeric($importNumber)){
                                        $sgCoreServices->deleteAllUpdatableRealties($importNumber);
                                        $this->view->assign('state','delete_object_importnumber_success');
                                      }else{
                                        $this->view->assign('state','delete_object_importnumber_failure');
                                      }


                                    }
                                }
                                break;
                            default:
                                break;
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    }

    public function cacheAction(){
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        /**
         * @var $cache FrontendInterface
         */
        if ($this->request->hasArgument('activity')){
            $cache = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class)->getCache('sgestate_cache');
            switch ($this->request->getArgument('activity')){
                case 'flush_cache':
                    $cache->flush();
                    $this->view->assign('state','flush_cache_done');
                    break;
                case 'collect_garbage':
                    $cache->collectGarbage();
                    $this->view->assign('state', 'collect_garbage_done');
                    break;
                default:
                    break;
            }
        }
    }

    public function systemInfoAction() {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $this->view->assign('installedModules', $this->getInstalledEstateModules());
    }

    /**
     * @return array
     */
    private function getInstalledEstateModules() {
        $installedModules = array();
        if (ExtensionManagementUtility::isLoaded('sg_estate_core')){
            $installedModules[] = array(
                'key' => 'sg_estate_core',
                'title' => 'sg.estate - Core Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_core')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_base')){
            $installedModules[] = array(
                'key' => 'sg_estate_base',
                'title' => 'sg.estate - Base Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_base')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_landingpage')){
            $installedModules[] = array(
                'key' => 'sg_estate_landingpage',
                'title' => 'sg.estate - Landingpage Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_landingpage')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_immosolve')){
            $installedModules[] = array(
                'key' => 'sg_estate_immosolve',
                'title' => 'sg.estate - Immosolve Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_immosolve')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_csv')){
            $installedModules[] = array(
                'key' => 'sg_estate_import_csv',
                'title' => 'sg.estate - CSV-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_csv')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_is24')){
            $installedModules[] = array(
                'key' => 'sg_estate_import_is24',
                'title' => 'sg.estate - Immobilienscout24-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_is24')
            );
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_openimmo')){
            $installedModules[] = array(
                'key' => 'sg_estate_import_openimmo',
                'title' => 'sg.estate - Openimmo-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_openimmo')
            );
        }
        return $installedModules;
    }

    /**
     * @param bool $resetData
     */
    private function importAltertyp($resetData = false){
        $importData = array(
            'Altbau' => 'ALTBAU',
            'Neubau' => 'NEUBAU',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_altertyp');
        }
        if ($this->altertypRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Altertyp
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Altertyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->altertypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAnhangtyp($resetData = false){
        $importData = array(
            'Titelbild' => 'TITELBILD',
            'Innenansichten' => 'INNENANSICHTEN',
            'Aussenansichten' => 'AUSSENANSICHTEN',
            'Grundriss' => 'GRUNDRISS',
            'Karten Lageplan' => 'KARTEN_LAGEPLAN',
            'Anbieterlogo' => 'ANBIETERLOGO',
            'Bild' => 'BILD',
            'Dokumente' => 'DOKUMENTE',
            'Links' => 'LINKS',
            'Panorama' => 'PANORAMA',
            'QR-Code' => 'QRCODE',
            'Film' => 'FILM',
            'Filmlink' => 'FILMLINK',
            'Energieausweis' => 'EPASS-SKALA',
            'URL' => 'ANBOBJURL',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_anhangtyp');
        }
        if ($this->anhangtypRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Anhangtyp
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Anhangtyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->anhangtypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusbaustufe($resetData = false){
        $importData = array(
            'Bausatzhaus' => 'BAUSATZHAUS',
            'Ausbauhaus' => 'AUSBAUHAUS',
            'Schlüsselfertig mit Keller' => 'SCHLUESSELFERTIGMITKELLER',
            'Schlüsselfertig ohne Bodenplatte' => 'SCHLUESSELFERTIGOHNEBODENPLATTE',
            'Schlüsselfertig mit Bodenplatte' => 'SCHLUESSELFERTIGMITBODENPLATTE',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_ausbaustufe');
        }
        if ($this->ausbaustufeRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Ausbaustufe
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Ausbaustufe');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausbaustufeRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusblick($resetData = false){
        $importData = array(
            'Ferne' => 'FERNE',
            'See' => 'SEE',
            'Berge' => 'BERGE',
            'Meer' => 'MEER',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_ausblick');
        }
        if ($this->ausblickRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Ausblick
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Ausblick');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausblickRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusstattungskategorie($resetData = false){
        $importData = array(
            'Keine Angabe' => 'KEINE_ANGABE',
            'Einfach' => 'EINFACH',
            'Standard' => 'STANDARD',
            'Gehoben' => 'GEHOBEN',
            'Luxus' => 'LUXUS'
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_austattungskategorie');
        }
        if ($this->austattungskategorieRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Austattungskategorie
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Austattungskategorie');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->austattungskategorieRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBadausstattung($resetData = false){
        $importData = array(
            'Dusche' => 'DUSCHE',
            'Wanne' => 'WANNE',
            'Fenster' => 'FENSTER',
            'Bidet' => 'BIDET',
            'Pissoir' => 'PISSOIR',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_badausstattung');
        }
        if ($this->badausstattungRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Badausstattung
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Badausstattung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->badausstattungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBauweise($resetData = false){
        $importData = array(
            'Massiv' => 'MASSIV',
            'Fertigteile' => 'FERTIGTEILE',
            'Holz' => 'HOLZ',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_bauweise');
        }
        if ($this->bauweiseRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bauweise
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bauweise');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bauweiseRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBebaubarnach($resetData = false){
        $importData = array(
            '34 Nachbarschaft' => '34_NACHBARSCHAFT',
            '35 Aussengebiet' => '35_AUSSENGEBIET',
            'Bebauungsplan' => 'B_PLAN',
            'Kein Bauland' => 'KEIN BAULAND',
            'Bauerwartungsland' => 'BAUERWARTUNGSLAND',
            'Länderspezifisch' => 'LAENDERSPEZIFISCH',
            'Bauland ohne Bebauungsplan' => 'BAULAND_OHNE_B_PLAN',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_bebaubarnach');
        }
        if ($this->bebaubarnachRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bebaubarnach
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bebaubarnach');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bebaubarnachRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBefeuerungsart($resetData = false){
        $importData = array(
            'Öl' => 'OEL',
            'Gas' => 'GAS',
            'Strom' => 'STROM',
            'Alternativ' => 'ALTERNATIV',
            'Solar' => 'SOLAR',
            'Erdwärme' => 'ERDWAERME',
            'Luft-Wärmepumpe' => 'LUFTWP',
            'Fernwärme' => 'FERNWAERME',
            'Blockheizkraftwerk' => 'BLOCK',
            'Wasser Elektro' => 'WASSER-ELEKTRO',
            'Pellets' => 'PELLET',
            'Kohle' => 'KOHLE',
            'Erdgas leicht' => 'ERDGAS_LEICHT',
            'Erdgas schwer' => 'ERDGAS_SCHWER',
            'Flüssiggas' => 'FLUESSIGGAS',
            'Fernwärme Dampf' => 'FERNWAERME_DAMPF',
            'Holz' => 'HOLZ',
            'Holz-Hackschnitzel' => 'HOLZ-HACKSCHNITZEL',
            'Kohle/Koks' => 'KOHLE_KOKS',
            'Nahwärme' => 'NAHWÄRME',
            'Wärmelieferung' => 'WÄRMELIEFERUNG',
            'BIO Energie' => 'BIO_ENERGIE',
            'Windenergie' => 'WINDENERGIE',
            'Wasserenergie' => 'WASSERENERGIE',
            'Umweltwärme' => 'UMWELTWAERME',
            'KWK fossil' => 'KWK_FOSSIL',
            'KWK erneuerbar' => 'KWK_ERNEUERBAR',
            'KWK regenerativ' => 'KWK_REGENERATIV',
            'KWK bio' => 'KWK_BIO',
            'Keine Angabe' => 'KEIN_ANGABE'
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_befeuerungsart');
        }
        if ($this->befeuerungsartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Befeuerungsart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Befeuerungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->befeuerungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBodenbelag($resetData = false){
        $importData = array(
            'Fliesen' => 'FLIESEN',
            'Stein' => 'STEIN',
            'Teppich' => 'TEPPICH',
            'Parkett' => 'PARKETT',
            'Fertigparkett' => 'FERTIGPARKETT',
            'Laminat' => 'LAMINAT',
            'Dielen' => 'DIELEN',
            'Kunststoff' => 'KUNSTSTOFF',
            'Estrich' => 'ESTRICH',
            'Doppelboden' => 'DOPPELBODEN',
            'Linoleum' => 'LINOLEUM',
            'Marmor' => 'MARMOR',
            'Terrakotta' => 'TERRAKOTTA',
            'Granit' => 'GRANIT',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_bodenbelag');
        }
        if ($this->bodenbelagRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bodenbelag
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bodenbelag');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bodenbelagRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importDachform($resetData = false){
        $importData = array(
            'Krüppelwalmdach' => 'KRUEPPELWALMDACH',
            'Mansarddach' => 'MANSARDDACH',
            'Pultdach' => 'PULTDACH',
            'Satteldach' => 'SATTELDACH',
            'Walmdach' => 'WALMDACH',
            'Flachdach' => 'FLACHDACH',
            'Pyramidendach' => 'PYRAMIDENDACH',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_dachform');
        }
        if ($this->dachformRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Dachform
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Dachform');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->dachformRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassart($resetData = false){
        $importData = array(
            'Bedarfsausweis' => 'BEDARF',
            'Verbrauchsausweis' => 'VERBRAUCH',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_energiepassart');
        }
        if ($this->energiepassartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassjahrgang($resetData = false){
        $importData = array(
            'Vor 2014' => '2008',
            'Ab 1.5.2014' => '2014',
            'es liegt kein E-pass vor' => 'OHNE',
            'nicht notwendig' => 'NICHT_NOETIG',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_energiepassjahrgang');
        }
        if ($this->energiepassjahrgangRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassjahrgang
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassjahrgang');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassjahrgangRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassgebaeudeart($resetData = false){
        $importData = array(
            'Wohnimmobilie' => 'WOHN',
            'Gewerbe und Mischformen' => 'NICHTWOHN',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_energiepassgebaeudeart');
        }
        if ($this->energiepassgebaeudeartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energiepassgebaeudeartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergietyp($resetData = false){
        $importData = array(
            'Passivhaus' => 'PASSIVHAUS',
            'Niedrigenergie' => 'NIEDRIGENERGIE',
            'Neubaustandard' => 'NEUBAUSTANDARD',
            'Kfw 40' => 'KFW40',
            'Kfw 60' => 'KFW60',
            'Kfw 55' => 'KFW55',
            'Kfw 70' => 'KFW70',
            'Minergiebauweise' => 'MINERGIEBAUWEISE',
            'Minergie zertifiziert' => 'MINERGIE_ZERTIFIZIERT',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_energietyp');
        }
        if ($this->energietypRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energietyp
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energietyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energietypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importErschliessung($resetData = false){
        $importData = array(
            'Unerschlossen' => 'UNERSCHLOSSEN',
            'Teilerschlossen' => 'TEILERSCHLOSSEN',
            'Vollerschlossen' => 'VOLLERSCHLOSSEN',
            'Ortsüblich erschlossen' => 'ORTSUEBLICHERSCHLOSSEN',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_erschliessung');
        }
        if ($this->erschliessungRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Erschliessung
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Erschliessung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importErschliessungdetails($resetData = false){
        $importData = array(
            'Gas' => 'GAS',
            'Wasser' => 'WASSER',
            'Strom' => 'STROM',
            'TK' => 'TK',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_erschliessungdetails');
        }
        if ($this->erschliessungdetailsRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Erschliessungdetails
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Erschliessungdetails');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungdetailsRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importGeschlecht($resetData = false){
        $importData = array(
            'Egal' => 'EGAL',
            'nur Männer' => 'NUR_MANN',
            'nur Frauen' => 'NUR_FRAU',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_geschlecht');
        }
        if ($this->geschlechtRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Geschlecht
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Geschlecht');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->geschlechtRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importHeizungsart($resetData = false){
        $importData = array(
            'Ofenheizung' => 'OFEN',
            'Etagenheizung' => 'ETAGEN',
            'Zentralheizung' => 'ZENTRAL',
            'Fernwärme' => 'FERN',
            'Fussbodenheizung' => 'FUSSBODEN',
            'Gas-Heizung' => 'GAS-HEIZUNG',
            'Holz-Pelletheizung' => 'HOLZ-PELLETHEIZUNG',
            'Nachtspeicherofen' => 'nachtspeicherofen',
            'Ölheizung' => 'ÖLHEIZUNG',
            'Solar-Heizung' => 'SOLAR-HEIZUNG',
            'Wärmepumpe' => 'WAERMEPUMPE',
            'Blockheizkraftwerk' => 'BLOCKHEIZKRAFTWERK',
            'Elektro-Heizung' => 'ELEKTRO-HEIZUNG',
            'Keine Angabe' => 'KEIN_ANGABE',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_heizungsart');
        }
        if ($this->heizungsartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Heizungsart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Heizungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->heizungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importHimmelrichtung($resetData = false){
        $importData = array(
            'Nord' => 'NORD',
            'Ost' => 'OST',
            'Süd' => 'SUED',
            'West' => 'WEST',
            'Nordost' => 'NORDOST',
            'Nordwest' => 'NORDWEST',
            'Südost' => 'SUEDOST',
            'Südwest' => 'SUEDWEST',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_himmelrichtung');
        }
        if ($this->himmelrichtungRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Himmelrichtung
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Himmelrichtung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->himmelrichtungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importKuechenausstattung($resetData = false){
        $importData = array(
            'Einbauküche' => 'EBK',
            'Offene Küche' => 'OFFEN',
            'Pantry' => 'PANTRY',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_kuechenausstattung');
        }
        if ($this->kuechenausstattungRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Kuechenausstattung
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Kuechenausstattung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->kuechenausstattungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importLage($resetData = false){
        $importData = array(
            'Wohn' => 'WOHN',
            'Gewerbe' => 'GEWERBE',
            'Industrie' => 'INDUSTRIE',
            'Misch' => 'MISCH',
            'Neubau' => 'NEUBAU',
            'Ortslage' => 'ORTSLAGE',
            'Siedlung' => 'SIEDLUNG',
            'Stadtrand' => 'STADTRAND',
            'Stadtteil' => 'STADTTEIL',
            'Stadtzentrum' => 'STADTZENTRUM',
            'Nebenzentrum' => 'NEBENZENTRUM',
            '1A' => '1A',
            '1B' => '1B',
            'Einkaufszentrum' => 'EINKAUFSZENTRUM',
            'Keine Angabe' => 'KEINE_ANGABE'
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_lage');
        }
        if ($this->lageRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Lage
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Lage');

                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->lageRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importLand($resetData = false){
        // @todo: Restliche Länder ergänzen
        $importData = array(
            'Deutschland' => 'DEU'
        );
        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_land');
        }
        if ($this->landRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Land
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Land');
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $this->landRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importNutzungsart($resetData = false){
        $importData = array(
            'Wohnen' => 'WOHNEN',
            'Gewerbe' => 'GEWERBE',
            'Anlage' => 'ANLAGE',
            'Wohnen auf Zeit' => 'WAZ',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_nutzungsart');
        }
        if ($this->nutzungsartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Nutzungsart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Nutzungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->nutzungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importObjektart($resetData = false){
        $importData = array(
            'Zimmer' => array(
                'kuerzel' => 'ZIMMER',
                'typen' => array(
                    'Zimmer' => 'ZIMMER'
                ),
            ),
            'Wohnung' => array(
                'kuerzel' => 'WOHNUNG',
                'typen' => array(
                    'Dachgeschoss' => 'DACHGESCHOSS',
                    'Maisonette' => 'MAISONETTE',
                    'Loft Studio Atelier' => 'LOFT',
                    'Penthouse' => 'PENTHOUSE',
                    'Terrassen' => 'TERASSEN',
                    'Etage' => 'ETAGE',
                    'Erdgeschoss' => 'ERDGESCHOSS',
                    'Hochpaterre' => 'HOCHPATERRE',
                    'Souterrain' => 'SOUTERRAIN',
                    'Apartment' => 'APARTMENT',
                    'Ferienwohnung' => 'FERIENWOHNUNG',
                    'Galerie' => 'GALERIE',
                    'Rohdachboden' => 'ROHDACHBODEN',
                    'Attikawohnung' => 'ATTIKAWOHNUNG',
                    'Sonstiges' => 'SONSTIGE',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ),
            ),
            'Haus' => array(
                'kuerzel' => 'HAUS',
                'typen' => array(
                    'Reihenhaus' => 'REIHENHAUS',
                    'Reihenend' => 'REIHENEND',
                    'Reihenmittel' => 'REIHENMITTEL',
                    'Reiheneck' => 'REIHENECK',
                    'Doppelhaushaelfte' => 'DOPPELHAUSHAELFTE',
                    'Einfamilienhaus' => 'EINFAMILIENHAUS',
                    'Stadthaus' => 'STADTHAUS',
                    'Bungalow' => 'BUNGALOW',
                    'Villa' => 'VILLA',
                    'Resthof' => 'RESTHOF',
                    'Bauernhaus' => 'BAUERNHAUS',
                    'Landhaus' => 'LANDHAUS',
                    'Schloss' => 'SCHLOSS',
                    'Zweifamilienhaus' => 'ZWEIFAMILIENHAUS',
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Ferienhaus' => 'FERIENHAUS',
                    'Berghuette' => 'BERGHUETTE',
                    'Chalet' => 'CHALET',
                    'Strandhaus' => 'STRANDHAUS',
                    'laube-datsche-gartenhaus' => 'LAUBE-DATSCHE-GARTENHAUS',
                    'Apartmenthaus' => 'APARTMENTHAUS',
                    'Burg' => 'BURG',
                    'Herrenhaus' => 'HERRENHAUS',
                    'Finca' => 'FINCA',
                    'Rustico' => 'RUSTICO',
                    'Fertighaus' => 'FERTIGHAUS',
                    'Besondere Immobilie' => 'SPECIAL_REAL_ESTATE',
                    'Wohnimmobilie (sonstige)' => 'OTHER',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ),
            ),
            'Grundstück' => array(
                'kuerzel' => 'GRUNDSTUECK',
                'typen' => array(
                    'Wohnen' => 'WOHNEN',
                    'Gewerbe' => 'GEWERBE',
                    'Industrie' => 'INDUSTRIE',
                    'Land Forstwirschaft' => 'LAND_FORSTWIRSCHAFT',
                    'Freizeit' => 'FREIZEIT',
                    'Gemischt' => 'GEMISCHT',
                    'Gewerbepark' => 'GEWERBEPARK',
                    'Sondernutzung' => 'SONDERNUTZUNG',
                    'Seeliegenschaft' => 'SEELIEGENSCHAFT',
                ),
            ),
            'Büro & Praxen' => array(
                'kuerzel' => 'BUERO_PRAXEN',
                'typen' => array(
                    'Bueroflaeche' => 'BUEROFLAECHE',
                    'Bueroetage' => 'OFFICE_FLOOR',
                    'Buerohaus' => 'BUEROHAUS',
                    'Buerozentrum' => 'BUEROZENTRUM',
                    'Buero und Lager Gebaeude' => 'OFFICE_STORAGE_BUILDING',
                    'Loft Atelier' => 'LOFT',
                    'Studio' => 'STUDIO',
                    'Praxis' => 'PRAXIS',
                    'Praxisetage' => 'SURGERY_FLOOR',
                    'Praxisflaeche' => 'PRAXISFLAECHE',
                    'Praxishaus' => 'PRAXISHAUS',
                    'Gewerbezentrum' => 'COMMERCIAL_CENTRE',
                    'Wohn und Geschaeftsgebaeude' => 'LIVING_AND_COMMERCIAL_BUILDING',
                    'Buero und Geschaeftsgebaeude' => 'OFFICE_AND_COMMERCIAL_BUILDING',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                    'Coworking' => 'COWORKING',
                    'Shared Office' => 'SHARED_OFFICE',
                ),
            ),
            'Einzelhandel' => array(
                'kuerzel' => 'EINZELHANDEL',
                'typen' => array(
                    'Ladenlokal' => 'LADENLOKAL',
                    'Einzelhandelsladen' => 'EINZELHANDELSLADEN',
                    'Verbrauchermarkt' => 'VERBRAUCHERMARKT',
                    'Einkaufszentrum' => 'EINKAUFSZENTRUM',
                    'Kaufhaus' => 'KAUFHAUS',
                    'Factory Outlet' => 'FACTORY_OUTLET',
                    'Kiosk' => 'KIOSK',
                    'Verkaufsflaeche' => 'VERKAUFSFLAECHE',
                    'Verkaufshalle' => 'VERKAUFSHALLE',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                ),
            ),
            'Gastgewerbe' => array(
                'kuerzel' => 'GASTGEWERBE',
                'typen' => array(
                    'Gastronomie' => 'GASTRONOMIE',
                    'Gastronomie & Wohnung' => 'GASTRONOMIE_UND_WOHNUNG',
                    'Pensionen' => 'PENSIONEN',
                    'Hotels' => 'HOTELS',
                    'Weitere Beherbergungsbetriebe' => 'WEITERE_BEHERBERGUNGSBETRIEBE',
                    'Bar' => 'BAR',
                    'Cafe' => 'CAFE',
                    'Discothek' => 'DISCOTHEK',
                    'Restaurant' => 'RESTAURANT',
                    'Raucherlokal' => 'RAUCHERLOKAL',
                    'Einraumlokal' => 'EINRAUMLOKAL',
                ),
            ),
            'Hallen, Lager & Produktion' => array(
                'kuerzel' => 'HALLEN_LAGER_PROD',
                'typen' => array(
                    'Halle' => 'HALLE',
                    'Industriehalle' => 'INDUSTRIEHALLE',
                    'Lager' => 'LAGER',
                    'Lagerflaechen' => 'LAGERFLAECHEN',
                    'Lager mit Freiflaeche' => 'LAGER_MIT_FREIFLAECHE',
                    'Hochregallager' => 'HOCHREGALLAGER',
                    'Speditionslager' => 'SPEDITIONSLAGER',
                    'Produktion' => 'PRODUKTION',
                    'Werkstatt' => 'WERKSTATT',
                    'Service' => 'SERVICE',
                    'Freiflaechen' => 'FREIFLAECHEN',
                    'Kühlhaus' => 'KUEHLHAUS',
                ),
            ),
            'Land & Forstwirtschaft' => array(
                'kuerzel' => 'LAND_UND_FORSTWIRTSCHAFT',
                'typen' => array(
                    'Landwirtschaftliche_betriebe' => 'LANDWIRTSCHAFTLICHE_BETRIEBE',
                    'Bauernhof' => 'BAUERNHOF',
                    'Aussiedlerhof' => 'AUSSIEDLERHOF',
                    'Gartenbau' => 'GARTENBAU',
                    'Ackerbau' => 'ACKERBAU',
                    'Weinbau' => 'WEINBAU',
                    'Viehwirtschaft' => 'VIEHWIRTSCHAFT',
                    'Jagd & Forstwirtschaft' => 'JAGD_UND_FORSTWIRTSCHAFT',
                    'Teich & Fischwirtschaft' => 'TEICH_UND_FISCHWIRTSCHAFT',
                    'Scheunen' => 'SCHEUNEN',
                    'Reiterhoefe' => 'REITERHOEFE',
                    'Sonstige Landwirtschaftsimmobilien' => 'SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN',
                    'Anwesen' => 'ANWESEN',
                    'Jagdrevier' => 'JAGDREVIER',
                ),
            ),
            'Parken' => array(
                'kuerzel' => 'PARKEN',
                'typen' => array(
                    'Stellplatz' => 'STELLPLATZ',
                    'Carport' => 'CARPORT',
                    'Doppelgarage' => 'DOPPELGARAGE',
                    'Duplex' => 'DUPLEX',
                    'Tiefgarage' => 'TIEFGARAGE',
                    'Bootsliegeplatz' => 'BOOTSLIEGEPLATZ',
                    'Einzelgarage' => 'EINZELGARAGE',
                    'Parkhaus' => 'PARKHAUS',
                    'Tiefgaragenstellplatz' => 'TIEFGARAGENSTELLPLATZ',
                    'Parkplatz mit Strom' => 'PARKPLATZ_STROM',
                    'Garage' => 'GARAGE',
                ),
            ),
            'Sonstige' => array(
                'kuerzel' => 'SONSTIGE',
                'typen' => array(
                    'Parkhaus' => 'PARKHAUS',
                    'Tankstelle' => 'TANKSTELLE',
                    'Krankenhaus' => 'KRANKENHAUS',
                    'Sonstige' => 'SONSTIGE',
                ),
            ),
            'Freizeitimmobilie gewerblich' => array(
                'kuerzel' => 'FREIZEITIMMOBILIE_GEWERBLICH',
                'typen' => array(
                    'Sportanlagen' => 'SPORTANLAGEN',
                    'Vergnuegungsparks & Center' => 'VERGNUEGUNGSPARKS_UND_CENTER',
                    'Freizeitanlage' => 'FREIZEITANLAGE',
                ),
            ),
            'Renditeobjekt' => array(
                'kuerzel' => 'ZINSHAUS_RENDITEOBJEKT',
                'typen' => array(
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Wohn- und Geschaeftshaus' => 'WOHN_UND_GESCHAEFTSHAUS',
                    'Geschaeftshaus' => 'GESCHAEFTSHAUS',
                    'Buerogebaeude' => 'BUEROGEBAEUDE',
                    'SB Märkte' => 'SB_MAERKTE',
                    'Einkaufscentren' => 'EINKAUFSCENTREN',
                    'Wohnanlagen' => 'WOHNANLAGEN',
                    'Verbrauchermärkte' => 'VERBRAUCHERMAERKTE',
                    'Industrieanlagen' => 'INDUSTRIEANLAGEN',
                    'Pflegeheim' => 'PFLEGEHEIM',
                    'Sanatorium' => 'SANATORIUM',
                    'Seniorenheim' => 'SENIORENHEIM',
                    'Betreutes Wohnen' => 'BETREUTES-WOHNEN',
                ),
            ),
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_objektart');
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_objektarttyp');
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_objektart_objektarttyp_mm');
        }
        if ($this->nutzungsartRepository->countAll() == 0){
            /**
             * @var $objektart \SG\SgEstateCore\Domain\Model\Objektart
             * @var $objektarttyp \SG\SgEstateCore\Domain\Model\Objektarttyp
             */
            foreach ($importData as $key => $data){
                $objektart = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Objektart');
                $objektart->setBezeichner($key);
                $objektart->setKuerzel($data['kuerzel']);
                foreach ($data['typen'] as $typKey => $typValue){
                    $objektarttyp = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Objektarttyp');
                    $objektarttyp->setBezeichner($typKey);
                    $objektarttyp->setKuerzel($typValue);
                    $objektart->addObjektarttyp($objektarttyp);
                }
                $this->objektartRepository->add($objektart);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importPeriode($resetData = false){
        $importData = array(
            'Tag' => 'TAG',
            'Woche' => 'WOCHE',
            'Monat' => 'MONAT',
            'Jahr' => 'JAHR',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_periode');
        }
        if ($this->periodeRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Periode
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Periode');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->periodeRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importVerkaufstatus($resetData = false){
        $importData = array(
            'Offen' => 'OFFEN',
            'Reserviert' => 'RESERVIERT',
            'Verkauft' => 'VERKAUFT',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_verkaufstatus');
        }
        if ($this->verkaufstatusRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Verkaufstatus
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Verkaufstatus');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->verkaufstatusRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importVermarktungsart($resetData = false){
        $importData = array(
            'Kauf' => 'KAUF',
            'Miete Pacht' => 'MIETE_PACHT',
            'Erbpacht' => 'ERBPACHT',
            'Leasing' => 'LEASING',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_vermarktungsart');
        }
        if ($this->vermarktungsartRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Vermarktungsart
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Vermarktungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->vermarktungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importWaehrung($resetData = false){
        // @todo: Restliche Währungen einpflegen
        $importData = array(
            'Euro' => 'EUR',
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_waehrung');
        }
        if ($this->waehrungRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Waehrung
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Waehrung');
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $item->setSymbol($value);
                $this->waehrungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importZustand($resetData = false){
        $importData = array(
            'Erstbezug' => 'ERSTBEZUG',
            'Erstbezug nach Sanierung' => 'ERSTBEZUG_NACH_SANIERUNG',
            'Teil- Vollrenovierungsbed' => 'TEIL_VOLLRENOVIERUNGSBED',
            'Neuwertig' => 'NEUWERTIG',
            'Teil- Vollsaniert' => 'TEIL_VOLLSANIERT',
            'Teil- Vollrenoviert' => 'TEIL_VOLLRENOVIERT',
            'Teilsaniert' => 'TEIL_SANIERT',
            'Vollsaniert' => 'VOLL_SANIERT',
            'Sanierungsbeduerftig' => 'SANIERUNGSBEDUERFTIG',
            'Baufaellig' => 'BAUFAELLIG',
            'Nach Vereinbarung' => 'NACH_VEREINBARUNG',
            'Modernisiert' => 'MODERNISIERT',
            'Gepflegt' => 'GEPFLEGT',
            'Rohbau' => 'ROHBAU',
            'Entkernt' => 'ENTKERNT',
            'Abrissobjekt' => 'ABRISSOBJEKT',
            'Projektiert' => 'PROJEKTIERT',
            'Keine Angabe' => 'NO_INFORMATION'
        );

        if ($resetData){
            $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_sgestatecore_domain_model_zustand');
        }
        if ($this->zustandRepository->countAll() == 0){
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Zustand
             */
            foreach ($importData as $key => $value){
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Zustand');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->zustandRepository->add($item);
            }
        }
    }
}
