<?php
namespace SG\SgEstateCore\Domain\Repository;

use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Region;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

class RegionRepository extends Repository{

    public function initializeObject() {
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    protected $defaultOrderings = array(
        'bezeichner' => QueryInterface::ORDER_ASCENDING,
    );

    public function getAllForFilter(){
        /**
         * @var $item Region
         */

        $return = null;
        $query = $this->createQuery();
        $result = $query->execute();

        foreach ($result as $item){
            if ($item instanceof Region){
                $return[$item->getUid()] = $item->getBezeichner();
            }
        }
        return $return;
    }

    public function findRegionsForCity(Ort $ort){
        $query = $this->createQuery();

        $constraint = $query->contains('orte', $ort);

        $query->matching($constraint);
        $result = $query->execute();


        return $result;
    }
}