<?php
namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class ContentBlock extends AbstractEntity
{
    /**
     * @var string
     */
    protected $internalIdentfier = '';

    /**
     * @var string
     */
    protected $headline = '';

    /**
     * @var string
     */
    protected $body = '';

    /**
     * @var FileReference
     */
    protected $imageMain = NULL;

    /**
     * @var FileReference
     */
    protected $imageOptional = NULL;

    /**
     * @var string
     */
    protected $linkCaption = '';

    /**
     * @var string
     */
    protected $link = '';

    /**
     * @var string
     */
    protected $blockType = '';

    /**
     * @var ObjectStorage<Stadtteil>
     */
    protected $districts = null;

    /**
     * @var ObjectStorage<Ort>
     */
    protected $cities = null;

    /**
     * @var ObjectStorage<Region>
     */
    protected $regions = null;

    /**
     * @return string
     */
    public function getInternalIdentfier()
    {
        return $this->internalIdentfier;
    }

    /**
     * @param string $internalIdentfier
     */
    public function setInternalIdentfier(string $internalIdentfier)
    {
        $this->internalIdentfier = $internalIdentfier;
    }

    /**
     * @return string
     */
    public function getHeadline()
    {
        return $this->headline;
    }

    /**
     * @param string $headline
     */
    public function setHeadline(string $headline)
    {
        $this->headline = $headline;
    }

    /**
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * @param string $body
     */
    public function setBody(string $body): void
    {
        $this->body = $body;
    }

    /**
     * @return FileReference
     */
    public function getImageMain()
    {
        return $this->imageMain;
    }

    /**
     * @param FileReference $imageMain
     */
    public function setImageMain(FileReference $imageMain)
    {
        $this->imageMain = $imageMain;
    }

    /**
     * @return FileReference
     */
    public function getImageOptional()
    {
        return $this->imageOptional;
    }

    /**
     * @param FileReference $imageOptional
     */
    public function setImageOptional(FileReference $imageOptional)
    {
        $this->imageOptional = $imageOptional;
    }

    /**
     * @return string
     */
    public function getLinkCaption()
    {
        return $this->linkCaption;
    }

    /**
     * @param string $linkCaption
     */
    public function setLinkCaption(string $linkCaption)
    {
        $this->linkCaption = $linkCaption;
    }

    /**
     * @return string
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param string $link
     */
    public function setLink(string $link)
    {
        $this->link = $link;
    }

    /**
     * @return string
     */
    public function getBlockType()
    {
        return $this->blockType;
    }

    /**
     * @param string $blockType
     */
    public function setBlockType(string $blockType)
    {
        $this->blockType = $blockType;
    }

    /**
     * @return ObjectStorage
     */
    public function getDistricts()
    {
        return $this->districts;
    }

    /**
     * @param ObjectStorage $districts
     */
    public function setDistricts(ObjectStorage $districts)
    {
        $this->districts = $districts;
    }

    /**
     * @return ObjectStorage
     */
    public function getCities()
    {
        return $this->cities;
    }

    /**
     * @param ObjectStorage $cities
     */
    public function setCities(ObjectStorage $cities)
    {
        $this->cities = $cities;
    }

    /**
     * @return ObjectStorage
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * @param ObjectStorage $regions
     */
    public function setRegions(ObjectStorage $regions)
    {
        $this->regions = $regions;
    }




}