<?php

return [
    'ctrl' => [
        'title' => 'LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_db.xlf:tx_sgestatecore_domain_model_kampagne',
        'label' => 'bezeichner',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'dividers2tabs' => true,

        'versioningWS' => true,

        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'bezeichner,kuerzel,orte,stadtteile',
        'iconfile' => 'EXT:sg_estate_core/Resources/Public/Icons/tx_sgestatecore_domain_model_kampagne.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, bezeichner, kuerzel, orte, stadtteile',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid;;;, l10n_parent, l10n_diffsource, hidden, --palette--;;1, bezeichner, kuerzel, orte, stadtteile, --div--;LLL:EXT:cms/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'palettes' => [
        '1' => ['showitem' => ''],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'sys_language',
                'foreign_table_where' => 'ORDER BY sys_language.title',
                'items' => [
                    ['LLL:EXT:lang/locallang_general.xlf:LGL.allLanguages', -1],
                    ['LLL:EXT:lang/locallang_general.xlf:LGL.default_value', 0]
                ],
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_sgestatecore_domain_model_anhang',
                'foreign_table_where' => 'AND tx_sgestatecore_domain_model_anhang.pid=###CURRENT_PID### AND tx_sgestatecore_domain_model_anhang.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        't3ver_label' => [
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ]
        ],

        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
            ],
        ],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 13,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 13,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'bezeichner' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_db.xlf:tx_sgestatecore_domain_model_kampagne.bezeichner',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'kuerzel' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_db.xlf:tx_sgestatecore_domain_model_kampagne.kuerzel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'orte' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_db.xlf:tx_sgestatecore_domain_model_kampagne.ort',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_sgestatecore_domain_model_ort',
                'foreign_field' => 'kampagnen',
                'foreign_table_where' => 'ORDER BY bezeichner ASC',
                'MM' => 'tx_sgestatecore_kampagne_ort_mm',
                'maxitems' => 9999,
                'enableMultiSelectFilterTextfield' => true,
            ],
        ],
        'stadtteile' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:sg_estate_core/Resources/Private/Language/locallang_db.xlf:tx_sgestatecore_domain_model_ort.stadtteile',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_sgestatecore_domain_model_stadtteil',
                'foreign_table_where' => 'ORDER BY bezeichner ASC',
                'foreign_field' => 'kampagnen',
                'MM' => 'tx_sgestatecore_kampagne_stadtteil_mm',
                'maxitems' => 9999,
                'enableMultiSelectFilterTextfield' => true,
            ],
        ],

    ],
];
