<?php
namespace SG\SgEstateCore\Tasks;

class Geocode extends \TYPO3\CMS\Scheduler\Task\AbstractTask{

    /**
     * @var bool
     */
    protected $renewAll = false;

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    private $objectManager;

    /**
     * @var $sgEstateCoreServices \SG\SgEstateCore\Util\Services
     */
    private $sgEstateCoreServices;

    /**
     * Initializes All needed Variables
     */
    private function initialize(){
        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $this->sgEstateCoreServices = $this->objectManager->get('SG\SgEstateCore\Util\Services');
    }

    /**
     * Main Execution Method of Task
     */
    public function execute()
    {
        $this->initialize();
        $this->sgEstateCoreServices->geocodeRealties($this->renewAll);
        return true;
    }

    /**
     * @return boolean
     */
    public function isRenewAll()
    {
        return $this->renewAll;
    }

    /**
     * @param boolean $renewAll
     * @return $this
     */
    public function setRenewAll($renewAll)
    {
        $this->renewAll = $renewAll;
        return $this;
    }



}