<?php
namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * Immobilie
 */
class Immobilie extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity {

    /**
     * @var \SG\SgEstateCore\Util\SessionHandler
     * @inject
     */
    protected $sessionHandler;

	/**
	 * objektartZusatz
	 *
	 * @var string
	 */
	protected $objektartZusatz = '';

	/**
	 * objektPlz
	 *
	 * @var string
	 */
	protected $objektPlz = '';

	/**
	 * objektStrasse
	 *
	 * @var string
	 */
	protected $objektStrasse = '';

	/**
	 * objektHausnummer
	 *
	 * @var string
	 */
	protected $objektHausnummer = '';

	/**
	 * objektBundesland
	 *
	 * @var string
	 */
	protected $objektBundesland = '';

	/**
	 * objektGemeindecode
	 *
	 * @var string
	 */
	protected $objektGemeindecode = '';

	/**
	 * objektFlur
	 *
	 * @var string
	 */
	protected $objektFlur = '';

	/**
	 * objektFlurstueck
	 *
	 * @var string
	 */
	protected $objektFlurstueck = '';

	/**
	 * objektGemarkung
	 *
	 * @var string
	 */
	protected $objektGemarkung = '';

	/**
	 * objektEtage
	 *
	 * @var integer
	 */
	protected $objektEtage = 0;

	/**
	 * objektAnzahlEtagen
	 *
	 * @var integer
	 */
	protected $objektAnzahlEtagen = 0;

	/**
	 * objektWohnungsnr
	 *
	 * @var string
	 */
	protected $objektWohnungsnr = '';

	/**
	 * objektRegionalerZusatz
	 *
	 * @var string
	 */
	protected $objektRegionalerZusatz = '';

	/**
	 * objektKartenMakro
	 *
	 * @var integer
	 */
	protected $objektKartenMakro = 0;

	/**
	 * objektKartenMikro
	 *
	 * @var integer
	 */
	protected $objektKartenMikro = 0;

	/**
	 * objektVirtuelletour
	 *
	 * @var integer
	 */
	protected $objektVirtuelletour = 0;

	/**
	 * objektLuftbilder
	 *
	 * @var integer
	 */
	protected $objektLuftbilder = 0;

	/**
	 * objektLageImBauLinks
	 *
	 * @var integer
	 */
	protected $objektLageImBauLinks = 0;

	/**
	 * objektLageImBauRechts
	 *
	 * @var integer
	 */
	protected $objektLageImBauRechts = 0;

	/**
	 * objektLageImBauVorne
	 *
	 * @var integer
	 */
	protected $objektLageImBauVorne = 0;

	/**
	 * objektLageImBauHinten
	 *
	 * @var integer
	 */
	protected $objektLageImBauHinten = 0;

	/**
	 * objektBreitengrad
	 *
	 * @var float
	 */
	protected $objektBreitengrad = 0.0;

	/**
	 * objektLaengengrad
	 *
	 * @var float
	 */
	protected $objektLaengengrad = 0.0;

	/**
	 * kaufpreis
	 *
	 * @var float
	 */
	protected $kaufpreis = 0.0;

	/**
	 * kaufpreisNetto
	 *
	 * @var float
	 */
	protected $kaufpreisNetto = 0.0;

	/**
	 * kaufpreisNettoUst
	 *
	 * @var float
	 */
	protected $kaufpreisNettoUst = 0.0;

	/**
	 * kaufpreisBrutto
	 *
	 * @var float
	 */
	protected $kaufpreisBrutto = 0.0;

	/**
	 * nettokaltmiete
	 *
	 * @var float
	 */
	protected $nettokaltmiete = 0.0;

	/**
	 * kaltmiete
	 *
	 * @var float
	 */
	protected $kaltmiete = 0.0;

	/**
	 * warmmiete
	 *
	 * @var float
	 */
	protected $warmmiete = 0.0;

	/**
	 * nebenkosten
	 *
	 * @var float
	 */
	protected $nebenkosten = 0.0;

	/**
	 * heizkostenEnthalten
	 *
	 * @var integer
	 */
	protected $heizkostenEnthalten = 0;

	/**
	 * heizkosten
	 *
	 * @var float
	 */
	protected $heizkosten = 0.0;

	/**
	 * zzglMehrwertsteuer
	 *
	 * @var integer
	 */
	protected $zzglMehrwertsteuer = 0;

	/**
	 * mietzuschlaege
	 *
	 * @var float
	 */
	protected $mietzuschlaege = 0.0;

	/**
	 * hauptmietzinsNetto
	 *
	 * @var float
	 */
	protected $hauptmietzinsNetto = 0.0;

	/**
	 * hauptmietzinsNettoUst
	 *
	 * @var float
	 */
	protected $hauptmietzinsNettoUst = 0.0;

	/**
	 * pauschalmiete
	 *
	 * @var float
	 */
	protected $pauschalmiete = 0.0;

	/**
	 * betriebskostenNetto
	 *
	 * @var float
	 */
	protected $betriebskostenNetto = 0.0;

	/**
	 * betriebskostenNettoUst
	 *
	 * @var float
	 */
	protected $betriebskostenNettoUst = 0.0;

	/**
	 * evbNetto
	 *
	 * @var float
	 */
	protected $evbNetto = 0.0;

	/**
	 * evbNettoUst
	 *
	 * @var float
	 */
	protected $evbNettoUst = 0.0;

	/**
	 * gesamtmieteNetto
	 *
	 * @var float
	 */
	protected $gesamtmieteNetto = 0.0;

	/**
	 * gesamtmieteNettoUst
	 *
	 * @var float
	 */
	protected $gesamtmieteNettoUst = 0.0;

	/**
	 * gesamtmieteBrutto
	 *
	 * @var float
	 */
	protected $gesamtmieteBrutto = 0.0;

	/**
	 * gesamtbelastungNetto
	 *
	 * @var float
	 */
	protected $gesamtbelastungNetto = 0.0;

	/**
	 * gesamtbelastungNettoUst
	 *
	 * @var float
	 */
	protected $gesamtbelastungNettoUst = 0.0;

	/**
	 * gesamtbelastungBrutto
	 *
	 * @var float
	 */
	protected $gesamtbelastungBrutto = 0.0;

	/**
	 * gesamtkostenProM2Von
	 *
	 * @var float
	 */
	protected $gesamtkostenProM2Von = 0.0;

	/**
	 * gesamtkostenProM2Bis
	 *
	 * @var float
	 */
	protected $gesamtkostenProM2Bis = 0.0;

	/**
	 * heizkostenNetto
	 *
	 * @var float
	 */
	protected $heizkostenNetto = 0.0;

	/**
	 * heizkostenNettoUst
	 *
	 * @var float
	 */
	protected $heizkostenNettoUst = 0.0;

	/**
	 * monatlichekostenNetto
	 *
	 * @var float
	 */
	protected $monatlichekostenNetto = 0.0;

	/**
	 * monatlichekostenNettoUst
	 *
	 * @var float
	 */
	protected $monatlichekostenNettoUst = 0.0;

	/**
	 * monatlichekostenbrutto
	 *
	 * @var float
	 */
	protected $monatlichekostenbrutto = 0.0;

	/**
	 * nebenkostenProM2Von
	 *
	 * @var float
	 */
	protected $nebenkostenProM2Von = 0.0;

	/**
	 * nebenkostenProM2Bis
	 *
	 * @var float
	 */
	protected $nebenkostenProM2Bis = 0.0;

	/**
	 * ruecklageNetto
	 *
	 * @var float
	 */
	protected $ruecklageNetto = 0.0;

	/**
	 * ruecklageNettoUst
	 *
	 * @var float
	 */
	protected $ruecklageNettoUst = 0.0;

	/**
	 * sonstigekostenNetto
	 *
	 * @var float
	 */
	protected $sonstigekostenNetto = 0.0;

	/**
	 * sonstigekostenNettoUst
	 *
	 * @var float
	 */
	protected $sonstigekostenNettoUst = 0.0;

	/**
	 * sonstigemieteNetto
	 *
	 * @var float
	 */
	protected $sonstigemieteNetto = 0.0;

	/**
	 * sonstigemieteNettoUst
	 *
	 * @var float
	 */
	protected $sonstigemieteNettoUst = 0.0;

	/**
	 * summemieteNetto
	 *
	 * @var float
	 */
	protected $summemieteNetto = 0.0;

	/**
	 * summemieteNettoUst
	 *
	 * @var float
	 */
	protected $summemieteNettoUst = 0.0;

	/**
	 * nettomieteProM2Von
	 *
	 * @var float
	 */
	protected $nettomieteProM2Von = 0.0;

	/**
	 * nettomieteProM2Bis
	 *
	 * @var float
	 */
	protected $nettomieteProM2Bis = 0.0;

	/**
	 * pacht
	 *
	 * @var float
	 */
	protected $pacht = 0.0;

	/**
	 * erbpacht
	 *
	 * @var float
	 */
	protected $erbpacht = 0.0;

	/**
	 * hausgeld
	 *
	 * @var float
	 */
	protected $hausgeld = 0.0;

	/**
	 * abstand
	 *
	 * @var float
	 */
	protected $abstand = 0.0;

	/**
	 * preisZeitraumVon
	 *
	 * @var \DateTime
	 */
	protected $preisZeitraumVon = NULL;

	/**
	 * preisZeitraumBis
	 *
	 * @var \DateTime
	 */
	protected $preisZeitraumBis = NULL;

	/**
	 * mietpreisProM2
	 *
	 * @var float
	 */
	protected $mietpreisProM2 = 0.0;

	/**
	 * kaufpreisProM2
	 *
	 * @var float
	 */
	protected $kaufpreisProM2 = 0.0;

	/**
	 * provisionspflichtig
	 *
	 * @var integer
	 */
	protected $provisionspflichtig = 0;

	/**
	 * innencourtage
	 *
	 * @var string
	 */
	protected $innencourtage = '';

	/**
	 * innencourtageMitMwst
	 *
	 * @var integer
	 */
	protected $innencourtageMitMwst = 0;

	/**
	 * aussencourtage
	 *
	 * @var string
	 */
	protected $aussencourtage = '';

	/**
	 * aussencourtageMitMwst
	 *
	 * @var integer
	 */
	protected $aussencourtageMitMwst = 0;

	/**
	 * courtageHinweis
	 *
	 * @var string
	 */
	protected $courtageHinweis = '';

	/**
	 * provisionNetto
	 *
	 * @var float
	 */
	protected $provisionNetto = 0.0;

	/**
	 * provisionNettoUst
	 *
	 * @var float
	 */
	protected $provisionNettoUst = 0.0;

	/**
	 * provisionBrutto
	 *
	 * @var float
	 */
	protected $provisionBrutto = 0.0;

	/**
	 * mwstSatz
	 *
	 * @var float
	 */
	protected $mwstSatz = 0.0;

	/**
	 * mwstGesamt
	 *
	 * @var float
	 */
	protected $mwstGesamt = 0.0;

	/**
	 * freitextPreis
	 *
	 * @var string
	 */
	protected $freitextPreis = '';

	/**
	 * xfache
	 *
	 * @var string
	 */
	protected $xfache = '';

	/**
	 * nettorendite
	 *
	 * @var float
	 */
	protected $nettorendite = 0.0;

	/**
	 * nettorenditeSoll
	 *
	 * @var float
	 */
	protected $nettorenditeSoll = 0.0;

	/**
	 * nettorenditeIst
	 *
	 * @var float
	 */
	protected $nettorenditeIst = 0.0;

	/**
	 * mieteinnahmenIst
	 *
	 * @var float
	 */
	protected $mieteinnahmenIst = 0.0;

	/**
	 * mieteinnahmenSoll
	 *
	 * @var float
	 */
	protected $mieteinnahmenSoll = 0.0;

	/**
	 * erschliessungskosten
	 *
	 * @var float
	 */
	protected $erschliessungskosten = 0.0;

	/**
	 * kaution
	 *
	 * @var float
	 */
	protected $kaution = 0.0;

	/**
	 * kautionText
	 *
	 * @var string
	 */
	protected $kautionText = '';

	/**
	 * geschaeftsguthaben
	 *
	 * @var float
	 */
	protected $geschaeftsguthaben = 0.0;

  /**
   * Genossenschaftsanteile
   *
   * @var float
   */
	protected $genossenschaftsanteile = 0.0;

  /**
   * Vetragsabschlussgebühr
   *
   * @var float
   */
	protected $vertragsabschlussgebuehr = 0.0;

	/**
	 * stpCarport
	 *
	 * @var string
	 */
	protected $stpCarport = '';

	/**
	 * stpDuplex
	 *
	 * @var string
	 */
	protected $stpDuplex = '';

	/**
	 * stpFreiplatz
	 *
	 * @var string
	 */
	protected $stpFreiplatz = '';

	/**
	 * stpGarage
	 *
	 * @var string
	 */
	protected $stpGarage = '';

	/**
	 * stpParkhaus
	 *
	 * @var string
	 */
	protected $stpParkhaus = '';

	/**
	 * stpTiefgarage
	 *
	 * @var string
	 */
	protected $stpTiefgarage = '';

	/**
	 * richtpreis
	 *
	 * @var float
	 */
	protected $richtpreis = 0.0;

	/**
	 * richtpreisProM2
	 *
	 * @var float
	 */
	protected $richtpreisProM2 = 0.0;

	/**
	 * wohnflaeche
	 *
	 * @var float
	 */
	protected $wohnflaeche = 0.0;

	/**
	 * nutzflaeche
	 *
	 * @var float
	 */
	protected $nutzflaeche = 0.0;

	/**
	 * gesamtflaeche
	 *
	 * @var float
	 */
	protected $gesamtflaeche = 0.0;

	/**
	 * ladenflaeche
	 *
	 * @var float
	 */
	protected $ladenflaeche = 0.0;

	/**
	 * lagerflaeche
	 *
	 * @var float
	 */
	protected $lagerflaeche = 0.0;

	/**
	 * verkaufsflaeche
	 *
	 * @var float
	 */
	protected $verkaufsflaeche = 0.0;

	/**
	 * freiflaeche
	 *
	 * @var float
	 */
	protected $freiflaeche = 0.0;

	/**
	 * bueroflaeche
	 *
	 * @var float
	 */
	protected $bueroflaeche = 0.0;

	/**
	 * bueroteilflaeche
	 *
	 * @var float
	 */
	protected $bueroteilflaeche = 0.0;

	/**
	 * fensterfront
	 *
	 * @var float
	 */
	protected $fensterfront = 0.0;

	/**
	 * verwaltungsflaeche
	 *
	 * @var float
	 */
	protected $verwaltungsflaeche = 0.0;

	/**
	 * gastroflaeche
	 *
	 * @var float
	 */
	protected $gastroflaeche = 0.0;

	/**
	 * grundflaechenzahl
	 *
	 * @var string
	 */
	protected $grundflaechenzahl = '';

	/**
	 * geschossflaechenzahl
	 *
	 * @var string
	 */
	protected $geschossflaechenzahl = '';

	/**
	 * baumassenzahl
	 *
	 * @var string
	 */
	protected $baumassenzahl = '';

	/**
	 * bruttogeschossflaechenzahl
	 *
	 * @var float
	 */
	protected $bruttogeschossflaechenzahl = 0.0;

	/**
	 * grundstuecksflaeche
	 *
	 * @var float
	 */
	protected $grundstuecksflaeche = 0.0;

	/**
	 * sonstflaeche
	 *
	 * @var float
	 */
	protected $sonstflaeche = 0.0;

	/**
	 * anzahlZimmer
	 *
	 * @var float
	 */
	protected $anzahlZimmer = 0.0;

	/**
	 * anzahlSchlafzimmer
	 *
	 * @var float
	 */
	protected $anzahlSchlafzimmer = 0.0;

	/**
	 * anzahlBadezimmer
	 *
	 * @var float
	 */
	protected $anzahlBadezimmer = 0.0;

	/**
	 * anzahlSeparateWc
	 *
	 * @var float
	 */
	protected $anzahlSeparateWc = 0.0;

	/**
	 * balkonTerasseFlaeche
	 *
	 * @var float
	 */
	protected $balkonTerasseFlaeche = 0.0;

	/**
	 * anzahlWohnSchlafzimmer
	 *
	 * @var float
	 */
	protected $anzahlWohnSchlafzimmer = 0.0;

	/**
	 * gartenflaeche
	 *
	 * @var float
	 */
	protected $gartenflaeche = 0.0;

	/**
	 * anzahlBalkone
	 *
	 * @var float
	 */
	protected $anzahlBalkone = 0.0;

	/**
	 * anzahlTerassen
	 *
	 * @var float
	 */
	protected $anzahlTerassen = 0.0;

	/**
	 * anzahlLogia
	 *
	 * @var float
	 */
	protected $anzahlLogia = 0.0;

	/**
	 * fensterfrontM2
	 *
	 * @var float
	 */
	protected $fensterfrontM2 = 0.0;

	/**
	 * grundstuecksfront
	 *
	 * @var float
	 */
	protected $grundstuecksfront = 0.0;

	/**
	 * dachbodenflaeche
	 *
	 * @var float
	 */
	protected $dachbodenflaeche = 0.0;

	/**
	 * teilbarAb
	 *
	 * @var float
	 */
	protected $teilbarAb = 0.0;

	/**
	 * kellerflaeche
	 *
	 * @var float
	 */
	protected $kellerflaeche = 0.0;

	/**
	 * beheizbareFlaeche
	 *
	 * @var float
	 */
	protected $beheizbareFlaeche = 0.0;

	/**
	 * anzahlStellplaetze
	 *
	 * @var float
	 */
	protected $anzahlStellplaetze = 0.0;

	/**
	 * plaetzeGastraum
	 *
	 * @var float
	 */
	protected $plaetzeGastraum = 0.0;

	/**
	 * anzahlBetten
	 *
	 * @var float
	 */
	protected $anzahlBetten = 0.0;

	/**
	 * anzahlTagungsraeume
	 *
	 * @var float
	 */
	protected $anzahlTagungsraeume = 0.0;

	/**
	 * vermietbareFlaeche
	 *
	 * @var float
	 */
	protected $vermietbareFlaeche = 0.0;

	/**
	 * anzahlWohneinheiten
	 *
	 * @var float
	 */
	protected $anzahlWohneinheiten = 0.0;

	/**
	 * anzahlGewerbeeinheiten
	 *
	 * @var float
	 */
	protected $anzahlGewerbeeinheiten = 0.0;

	/**
	 * einliegerwohnung
	 *
	 * @var integer
	 */
	protected $einliegerwohnung = 0;

	/**
	 * kubatur
	 *
	 * @var float
	 */
	protected $kubatur = 0.0;

	/**
	 * ausnuetzungsziffer
	 *
	 * @var float
	 */
	protected $ausnuetzungsziffer = 0.0;

	/**
	 * flaechevon
	 *
	 * @var float
	 */
	protected $flaechevon = 0.0;

	/**
	 * flaechebis
	 *
	 * @var float
	 */
	protected $flaechebis = 0.0;

	/**
	 * wgGeeignet
	 *
	 * @var integer
	 */
	protected $wgGeeignet = 0;

	/**
	 * raeumeVeraenderbar
	 *
	 * @var integer
	 */
	protected $raeumeVeraenderbar = 0;

	/**
	 * kamin
	 *
	 * @var integer
	 */
	protected $kamin = 0;

	/**
	 * klimatisiert
	 *
	 * @var integer
	 */
	protected $klimatisiert = 0;

	/**
	 * aufzugPersonen
	 *
	 * @var integer
	 */
	protected $aufzugPersonen = 0;

	/**
	 * aufzugLasten
	 *
	 * @var integer
	 */
	protected $aufzugLasten = 0;

	/**
	 * gartennutzung
	 *
	 * @var integer
	 */
	protected $gartennutzung = 0;

	/**
	 * moebliert
	 *
	 * @var integer
	 */
	protected $moebliert = 0;

	/**
	 * rollstuhlgerecht
	 *
	 * @var integer
	 */
	protected $rollstuhlgerecht = 0;

	/**
	 * kabelSatTv
	 *
	 * @var integer
	 */
	protected $kabelSatTv = 0;

    /**
     * kabelfernsehen
     *
     * @var integer
     */
    protected $kabelfernsehen = 0;

    /**
     * satellitenfernsehen
     *
     * @var integer
     */
    protected $satellitenfernsehen = 0;

	/**
	 * dvbt
	 *
	 * @var integer
	 */
	protected $dvbt = 0;

	/**
	 * barrierefrei
	 *
	 * @var integer
	 */
	protected $barrierefrei = 0;

	/**
	 * sauna
	 *
	 * @var integer
	 */
	protected $sauna = 0;

	/**
	 * swimmingpool
	 *
	 * @var integer
	 */
	protected $swimmingpool = 0;

	/**
	 * waschTrockenraum
	 *
	 * @var integer
	 */
	protected $waschTrockenraum = 0;

	/**
	 * wintergarten
	 *
	 * @var integer
	 */
	protected $wintergarten = 0;

	/**
	 * dvVerkabelung
	 *
	 * @var integer
	 */
	protected $dvVerkabelung = 0;

	/**
	 * rampe
	 *
	 * @var integer
	 */
	protected $rampe = 0;

	/**
	 * hebebuehne
	 *
	 * @var integer
	 */
	protected $hebebuehne = 0;

	/**
	 * kran
	 *
	 * @var integer
	 */
	protected $kran = 0;

	/**
	 * gastterrasse
	 *
	 * @var integer
	 */
	protected $gastterrasse = 0;

	/**
	 * stromanschlusswert
	 *
	 * @var float
	 */
	protected $stromanschlusswert = 0.0;

	/**
	 * katineCafeteria
	 *
	 * @var integer
	 */
	protected $katineCafeteria = 0;

	/**
	 * teekueche
	 *
	 * @var integer
	 */
	protected $teekueche = 0;

	/**
	 * hallenhoehe
	 *
	 * @var float
	 */
	protected $hallenhoehe = 0.0;

	/**
	 * hotelrestaurantAngeschlossen
	 *
	 * @var integer
	 */
	protected $hotelrestaurantAngeschlossen = 0;

	/**
	 * barAngeschlossen
	 *
	 * @var integer
	 */
	protected $barAngeschlossen = 0;

	/**
	 * brauereibindung
	 *
	 * @var integer
	 */
	protected $brauereibindung = 0;

	/**
	 * sporteinrichtungen
	 *
	 * @var integer
	 */
	protected $sporteinrichtungen = 0;

	/**
	 * wellnessbereich
	 *
	 * @var integer
	 */
	protected $wellnessbereich = 0;

	/**
	 * serviceBetreutesWohnen
	 *
	 * @var integer
	 */
	protected $serviceBetreutesWohnen = 0;

	/**
	 * serviceCatering
	 *
	 * @var integer
	 */
	protected $serviceCatering = 0;

	/**
	 * serviceReinigung
	 *
	 * @var integer
	 */
	protected $serviceReinigung = 0;

	/**
	 * serviceEinkauf
	 *
	 * @var integer
	 */
	protected $serviceEinkauf = 0;

	/**
	 * serviceWachdienst
	 *
	 * @var integer
	 */
	protected $serviceWachdienst = 0;

	/**
	 * telefonFerienimmobilie
	 *
	 * @var integer
	 */
	protected $telefonFerienimmobilie = 0;

	/**
	 * breitbandZugangArt
	 *
	 * @var string
	 */
	protected $breitbandZugangArt = '';

	/**
	 * breitbandZugangSpeed
	 *
	 * @var float
	 */
	protected $breitbandZugangSpeed = 0.0;

	/**
	 * umtsEmpfang
	 *
	 * @var integer
	 */
	protected $umtsEmpfang = 0;

	/**
	 * sicherheitAlarmanlage
	 *
	 * @var integer
	 */
	protected $sicherheitAlarmanlage = 0;

	/**
	 * sicherheitKamera
	 *
	 * @var integer
	 */
	protected $sicherheitKamera = 0;

	/**
	 * sicherheitPolizeiruf
	 *
	 * @var integer
	 */
	protected $sicherheitPolizeiruf = 0;

	/**
	 * unterkellert
	 *
	 * @var integer
	 */
	protected $unterkellert = 0;

	/**
	 * abstellraum
	 *
	 * @var integer
	 */
	protected $abstellraum = 0;

	/**
	 * fahrradraum
	 *
	 * @var integer
	 */
	protected $fahrradraum = 0;

	/**
	 * rolladen
	 *
	 * @var integer
	 */
	protected $rolladen = 0;

	/**
	 * bibliothek
	 *
	 * @var integer
	 */
	protected $bibliothek = 0;

	/**
	 * dachboden
	 *
	 * @var integer
	 */
	protected $dachboden = 0;

	/**
	 * gaestewc
	 *
	 * @var integer
	 */
	protected $gaestewc = 0;

	/**
	 * kabelkanaele
	 *
	 * @var integer
	 */
	protected $kabelkanaele = 0;

	/**
	 * seniorengerecht
	 *
	 * @var integer
	 */
	protected $seniorengerecht = 0;

	/**
	 * baujahr
	 *
	 * @var string
	 */
	protected $baujahr = '';

	/**
	 * letztemodernisierung
	 *
	 * @var string
	 */
	protected $letztemodernisierung = '';

	/**
	 * altertyp
	 *
	 * @var integer
	 */
	protected $altertyp = 0;

	/**
	 * bauzone
	 *
	 * @var string
	 */
	protected $bauzone = '';

	/**
	 * altlasten
	 *
	 * @var string
	 */
	protected $altlasten = '';

	/**
	 * energiepassArt
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Energiepassart
	 */
	protected $energiepassArt = 0;

	/**
	 * energiepassGueltigBis
	 *
	 * @var string
	 */
	protected $energiepassGueltigBis = '';

	/**
	 * energiepassEnergieverbrauchkennwert
	 *
	 * @var string
	 */
	protected $energiepassEnergieverbrauchkennwert = '';

	/**
	 * energiepassMitwarmwasser
	 *
	 * @var integer
	 */
	protected $energiepassMitwarmwasser = 0;

	/**
	 * energiepassEndenergiebedarf
	 *
	 * @var string
	 */
	protected $energiepassEndenergiebedarf = '';

    /**
     * @var \SG\SgEstateCore\Domain\Model\Befeuerungsart
     */
    protected $energiepassPrimaerenergietraeger;

    /**
     * @var string
     */
    protected $energiepassStromwert;

    /**
     * @var string
     */
    protected $energiepassWaermewert;

    /**
     * @var string
     */
    protected $energiepassWertklasse;

    /**
     * @var string
     */
    protected $energiepassBaujahr;

    /**
     * @var \DateTime
     */
    protected $energiepassAusstelldatum;

    /**
     * @var \SG\SgEstateCore\Domain\Model\Energiepassjahrgang
     */
    protected $energiepassJahrgang;

    /**
     * @var \SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart
     */
    protected $energiepassGebaeudeart;

    /**
     * @var string
     */
    protected $energiepassEpasstext;

    /**
     * @var string
     */
    protected $energiepassHwbwert;

    /**
     * @var string
     */
    protected $energiepassHwbklasse;

    /**
     * @var string
     */
    protected $energiepassFgeewert;

    /**
     * @var string
     */
    protected $energiepassFgeeklasse;

	/**
	 * verkaufstatus
	 *
	 * @var integer
	 */
	protected $verkaufstatus = 0;

	/**
	 * zulieferung
	 *
	 * @var integer
	 */
	protected $zulieferung = 0;

	/**
	 * ausblick
	 *
	 * @var integer
	 */
	protected $ausblick = 0;

	/**
	 * objekttitel
	 *
	 * @var string
	 */
	protected $objekttitel = '';

	/**
	 * kurzbeschreibung
	 *
	 * @var string
	 */
	protected $kurzbeschreibung = '';

	/**
	 * lage
	 *
	 * @var string
	 */
	protected $lage = '';

	/**
	 * austattungsbeschreibung
	 *
	 * @var string
	 */
	protected $austattungsbeschreibung = '';

	/**
	 * objektbeschreibung
	 *
	 * @var string
	 */
	protected $objektbeschreibung = '';

	/**
	 * sonstigeAngaben
	 *
	 * @var string
	 */
	protected $sonstigeAngaben = '';

	/**
	 * objektadresseFreigeben
	 *
	 * @var boolean
	 */
	protected $objektadresseFreigeben = FALSE;

	/**
	 * verfuegbarAb
	 *
	 * @var string
	 */
	protected $verfuegbarAb = '';

	/**
	 * verfuegbarAbDatum
	 *
	 * @var \DateTime
	 */
	protected $verfuegbarAbDatum = NULL;

	/**
	 * verfuegbarBisDatum
	 *
	 * @var \DateTime
	 */
	protected $verfuegbarBisDatum = NULL;

	/**
	 * versteigerungstermin
	 *
	 * @var \DateTime
	 */
	protected $versteigerungstermin = NULL;

	/**
	 * wbsErforderlich
	 *
	 * @var integer
	 */
	protected $wbsErforderlich = 0;

	/**
	 * vermietet
	 *
	 * @var integer
	 */
	protected $vermietet = 0;

	/**
	 * gruppennummer
	 *
	 * @var string
	 */
	protected $gruppennummer = '';

	/**
	 * zugang
	 *
	 * @var string
	 */
	protected $zugang = '';

	/**
	 * laufzeit
	 *
	 * @var float
	 */
	protected $laufzeit = 0.0;

	/**
	 * maximalePersonenanzahl
	 *
	 * @var integer
	 */
	protected $maximalePersonenanzahl = 0;

	/**
	 * nichtraucher
	 *
	 * @var integer
	 */
	protected $nichtraucher = 0;

	/**
	 * haustiere
	 *
	 * @var integer
	 */
	protected $haustiere = 0;

	/**
	 * geschlecht
	 *
	 * @var integer
	 */
	protected $geschlecht = 0;

	/**
	 * denkmalgeschuetzt
	 *
	 * @var integer
	 */
	protected $denkmalgeschuetzt = 0;

	/**
	 * alsFerien
	 *
	 * @var integer
	 */
	protected $alsFerien = 0;

	/**
	 * gewerblicheNutzung
	 *
	 * @var integer
	 */
	protected $gewerblicheNutzung = 0;

    /**
     * badModernisiert
     *
     * @var integer
     */
    protected $badModernisiert = 0;

	/**
	 * branchen
	 *
	 * @var string
	 */
	protected $branchen = '';

	/**
	 * hochhaus
	 *
	 * @var integer
	 */
	protected $hochhaus = 0;

	/**
	 * objektnrIntern
	 *
	 * @var string
	 */
	protected $objektnrIntern = '';

	/**
	 * objektnrExtern
	 *
	 * @var string
	 */
	protected $objektnrExtern = '';

	/**
	 * anzeigeAb
	 *
	 * @var \DateTime
	 */
	protected $anzeigeAb = NULL;

	/**
	 * anzeigeBis
	 *
	 * @var \DateTime
	 */
	protected $anzeigeBis = NULL;

	/**
	 * openimmoObjid
	 *
	 * @var string
	 */
	protected $openimmoObjid = '';

	/**
	 * kennungUrsprung
	 *
	 * @var string
	 */
	protected $kennungUrsprung = '';

	/**
	 * standVom
	 *
	 * @var \DateTime
	 */
	protected $standVom = NULL;

	/**
	 * weitergabeGenerell
	 *
	 * @var boolean
	 */
	protected $weitergabeGenerell = FALSE;

	/**
	 * weitergabePositivliste
	 *
	 * @var string
	 */
	protected $weitergabePositivliste = '';

	/**
	 * weitergabeNegativliste
	 *
	 * @var string
	 */
	protected $weitergabeNegativliste = '';

	/**
	 * gruppenKennung
	 *
	 * @var string
	 */
	protected $gruppenKennung = '';

	/**
	 * masterObjekt
	 *
	 * @var string
	 */
	protected $masterObjekt = '';

	/**
	 * masterVisible
	 *
	 * @var boolean
	 */
	protected $masterVisible = FALSE;

	/**
	 * sprache
	 *
	 * @var string
	 */
	protected $sprache = '';

	/**
	 * nutzungsart
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Nutzungsart>
	 */
	protected $nutzungsart = NULL;

	/**
	 * vermarktungsart
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Vermarktungsart>
	 */
	protected $vermarktungsart = NULL;

	/**
	 * objektart
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Objektart
	 */
	protected $objektart = NULL;

	/**
	 * objektarttyp
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Objektarttyp
	 */
	protected $objektarttyp = NULL;

	/**
	 * objektOrt
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Ort
	 */
	protected $objektOrt = NULL;

	/**
	 * objektStadtteil
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Stadtteil
	 */
	protected $objektStadtteil = NULL;

	/**
	 * objektLand
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Land
	 */
	protected $objektLand = NULL;

	/**
	 * objektLage
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Lage
	 */
	protected $objektLage = NULL;

	/**
	 * kontaktperson
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Kontaktperson
	 */
	protected $kontaktperson = NULL;

	/**
	 * weitereAdressen
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kontaktperson>
	 */
	protected $weitereAdressen = NULL;

	/**
	 * preisZeiteinheit
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Periode
	 */
	protected $preisZeiteinheit = NULL;

	/**
	 * mieteinnahmenIstPeriode
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Periode
	 */
	protected $mieteinnahmenIstPeriode = NULL;

	/**
	 * mieteinnahmenSollPeriode
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Periode
	 */
	protected $mieteinnahmenSollPeriode = NULL;

	/**
	 * waehrung
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Waehrung
	 */
	protected $waehrung = NULL;

	/**
	 * ausstattungsKategorie
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Austattungskategorie
	 */
	protected $ausstattungsKategorie = NULL;

	/**
	 * ausstattungBad
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Badausstattung>
	 */
	protected $ausstattungBad = NULL;

	/**
	 * ausstattungKueche
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kuechenausstattung>
	 */
	protected $ausstattungKueche = NULL;

	/**
	 * ausstattungBoden
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bodenbelag>
	 */
	protected $ausstattungBoden = NULL;

	/**
	 * heizungsart
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Heizungsart>
	 */
	protected $heizungsart = NULL;

	/**
	 * befeuerungsart
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Befeuerungsart>
	 */
	protected $befeuerungsart = NULL;

	/**
	 * ausrichtBalkonTerasse
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Himmelrichtung>
	 */
	protected $ausrichtBalkonTerasse = NULL;

	/**
	 * dachform
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Dachform>
	 */
	protected $dachform = NULL;

	/**
	 * bauweise
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bauweise>
	 */
	protected $bauweise = NULL;

	/**
	 * ausbaustufe
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ausbaustufe>
	 */
	protected $ausbaustufe = NULL;

	/**
	 * energietyp
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Energietyp
	 */
	protected $energietyp = NULL;

	/**
	 * zustand
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Zustand
	 */
	protected $zustand = NULL;

	/**
	 * bebaubarNach
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Bebaubarnach
	 */
	protected $bebaubarNach = NULL;

	/**
	 * erschliessung
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Erschliessung
	 */
	protected $erschliessung = NULL;

	/**
	 * erschliessungUmfang
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Erschliessungdetails>
	 */
	protected $erschliessungUmfang = NULL;

	/**
	 * anhaenge
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Anhang>
	 * @cascade remove
	 */
	protected $anhaenge = NULL;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @cascade remove
     */
    protected $media = null;

	/**
	 * minimaleMietdauer
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Periode
	 */
	protected $minimaleMietdauer = NULL;

	/**
	 * maximaleMietdauer
	 *
	 * @var \SG\SgEstateCore\Domain\Model\Periode
	 */
	protected $maximaleMietdauer = NULL;

    /**
     * gegensprechanlage
     *
     * @var integer
     */
    protected $gegensprechanlage = 0;

    /**
     * leichtErreichbar
     *
     * @var integer
     */
    protected $leichtErreichbar = 0;


	/**
	 * @var bool
	 */
	protected $updatable = true;

  /**
   * @var int
   */
  protected $importNumber = 0;

	/**
	 * __construct
	 */
	public function __construct() {
		//Do not remove the next line: It would break the functionality
		$this->initStorageObjects();
	}

	/**
	 * Initializes all ObjectStorage properties
	 * Do not modify this method!
	 * It will be rewritten on each save in the extension builder
	 * You may modify the constructor of this class instead
	 *
	 * @return void
	 */
	protected function initStorageObjects() {
		$this->nutzungsart = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->vermarktungsart = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->weitereAdressen = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->ausstattungBad = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->ausstattungKueche = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->ausstattungBoden = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->heizungsart = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->befeuerungsart = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->ausrichtBalkonTerasse = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->dachform = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->bauweise = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->ausbaustufe = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->erschliessungUmfang = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->anhaenge = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
		$this->media = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
	}

	/**
	 * Returns the objektartZusatz
	 *
	 * @return string $objektartZusatz
	 */
	public function getObjektartZusatz() {
		return $this->objektartZusatz;
	}

	/**
	 * Sets the objektartZusatz
	 *
	 * @param string $objektartZusatz
	 * @return void
	 */
	public function setObjektartZusatz($objektartZusatz) {
		$this->objektartZusatz = $objektartZusatz;
	}

	/**
	 * Returns the objektPlz
	 *
	 * @return string $objektPlz
	 */
	public function getObjektPlz() {
		return $this->objektPlz;
	}

	/**
	 * Sets the objektPlz
	 *
	 * @param string $objektPlz
	 * @return void
	 */
	public function setObjektPlz($objektPlz) {
		$this->objektPlz = $objektPlz;
	}

	/**
	 * Returns the objektStrasse
	 *
	 * @return string $objektStrasse
	 */
	public function getObjektStrasse() {
		return $this->objektStrasse;
	}

	/**
	 * Sets the objektStrasse
	 *
	 * @param string $objektStrasse
	 * @return void
	 */
	public function setObjektStrasse($objektStrasse) {
		$this->objektStrasse = $objektStrasse;
	}

	/**
	 * Returns the objektHausnummer
	 *
	 * @return string $objektHausnummer
	 */
	public function getObjektHausnummer() {
		return $this->objektHausnummer;
	}

	/**
	 * Sets the objektHausnummer
	 *
	 * @param string $objektHausnummer
	 * @return void
	 */
	public function setObjektHausnummer($objektHausnummer) {
		$this->objektHausnummer = $objektHausnummer;
	}

	/**
	 * Returns the objektBundesland
	 *
	 * @return string $objektBundesland
	 */
	public function getObjektBundesland() {
		return $this->objektBundesland;
	}

	/**
	 * Sets the objektBundesland
	 *
	 * @param string $objektBundesland
	 * @return void
	 */
	public function setObjektBundesland($objektBundesland) {
		$this->objektBundesland = $objektBundesland;
	}

	/**
	 * Returns the objektGemeindecode
	 *
	 * @return string $objektGemeindecode
	 */
	public function getObjektGemeindecode() {
		return $this->objektGemeindecode;
	}

	/**
	 * Sets the objektGemeindecode
	 *
	 * @param string $objektGemeindecode
	 * @return void
	 */
	public function setObjektGemeindecode($objektGemeindecode) {
		$this->objektGemeindecode = $objektGemeindecode;
	}

	/**
	 * Returns the objektFlur
	 *
	 * @return string $objektFlur
	 */
	public function getObjektFlur() {
		return $this->objektFlur;
	}

	/**
	 * Sets the objektFlur
	 *
	 * @param string $objektFlur
	 * @return void
	 */
	public function setObjektFlur($objektFlur) {
		$this->objektFlur = $objektFlur;
	}

	/**
	 * Returns the objektFlurstueck
	 *
	 * @return string $objektFlurstueck
	 */
	public function getObjektFlurstueck() {
		return $this->objektFlurstueck;
	}

	/**
	 * Sets the objektFlurstueck
	 *
	 * @param string $objektFlurstueck
	 * @return void
	 */
	public function setObjektFlurstueck($objektFlurstueck) {
		$this->objektFlurstueck = $objektFlurstueck;
	}

	/**
	 * Returns the objektGemarkung
	 *
	 * @return string $objektGemarkung
	 */
	public function getObjektGemarkung() {
		return $this->objektGemarkung;
	}

	/**
	 * Sets the objektGemarkung
	 *
	 * @param string $objektGemarkung
	 * @return void
	 */
	public function setObjektGemarkung($objektGemarkung) {
		$this->objektGemarkung = $objektGemarkung;
	}

	/**
	 * Returns the objektEtage
	 *
	 * @return integer $objektEtage
	 */
	public function getObjektEtage() {
		return $this->objektEtage;
	}

	/**
	 * Sets the objektEtage
	 *
	 * @param integer $objektEtage
	 * @return void
	 */
	public function setObjektEtage($objektEtage) {
		$this->objektEtage = $objektEtage;
	}

	/**
	 * Returns the objektAnzahlEtagen
	 *
	 * @return integer $objektAnzahlEtagen
	 */
	public function getObjektAnzahlEtagen() {
		return $this->objektAnzahlEtagen;
	}

	/**
	 * Sets the objektAnzahlEtagen
	 *
	 * @param integer $objektAnzahlEtagen
	 * @return void
	 */
	public function setObjektAnzahlEtagen($objektAnzahlEtagen) {
		$this->objektAnzahlEtagen = $objektAnzahlEtagen;
	}

	/**
	 * Returns the objektWohnungsnr
	 *
	 * @return string $objektWohnungsnr
	 */
	public function getObjektWohnungsnr() {
		return $this->objektWohnungsnr;
	}

	/**
	 * Sets the objektWohnungsnr
	 *
	 * @param string $objektWohnungsnr
	 * @return void
	 */
	public function setObjektWohnungsnr($objektWohnungsnr) {
		$this->objektWohnungsnr = $objektWohnungsnr;
	}

	/**
	 * Returns the objektRegionalerZusatz
	 *
	 * @return string $objektRegionalerZusatz
	 */
	public function getObjektRegionalerZusatz() {
		return $this->objektRegionalerZusatz;
	}

	/**
	 * Sets the objektRegionalerZusatz
	 *
	 * @param string $objektRegionalerZusatz
	 * @return void
	 */
	public function setObjektRegionalerZusatz($objektRegionalerZusatz) {
		$this->objektRegionalerZusatz = $objektRegionalerZusatz;
	}

	/**
	 * Returns the objektKartenMakro
	 *
	 * @return integer $objektKartenMakro
	 */
	public function getObjektKartenMakro() {
		return $this->objektKartenMakro;
	}

	/**
	 * Sets the objektKartenMakro
	 *
	 * @param integer $objektKartenMakro
	 * @return void
	 */
	public function setObjektKartenMakro($objektKartenMakro) {
		$this->objektKartenMakro = $objektKartenMakro;
	}

	/**
	 * Returns the objektKartenMikro
	 *
	 * @return integer $objektKartenMikro
	 */
	public function getObjektKartenMikro() {
		return $this->objektKartenMikro;
	}

	/**
	 * Sets the objektKartenMikro
	 *
	 * @param integer $objektKartenMikro
	 * @return void
	 */
	public function setObjektKartenMikro($objektKartenMikro) {
		$this->objektKartenMikro = $objektKartenMikro;
	}

	/**
	 * Returns the objektVirtuelletour
	 *
	 * @return integer $objektVirtuelletour
	 */
	public function getObjektVirtuelletour() {
		return $this->objektVirtuelletour;
	}

	/**
	 * Sets the objektVirtuelletour
	 *
	 * @param integer $objektVirtuelletour
	 * @return void
	 */
	public function setObjektVirtuelletour($objektVirtuelletour) {
		$this->objektVirtuelletour = $objektVirtuelletour;
	}

	/**
	 * Returns the objektLuftbilder
	 *
	 * @return integer $objektLuftbilder
	 */
	public function getObjektLuftbilder() {
		return $this->objektLuftbilder;
	}

	/**
	 * Sets the objektLuftbilder
	 *
	 * @param integer $objektLuftbilder
	 * @return void
	 */
	public function setObjektLuftbilder($objektLuftbilder) {
		$this->objektLuftbilder = $objektLuftbilder;
	}

	/**
	 * Returns the objektLageImBauLinks
	 *
	 * @return integer $objektLageImBauLinks
	 */
	public function getObjektLageImBauLinks() {
		return $this->objektLageImBauLinks;
	}

	/**
	 * Sets the objektLageImBauLinks
	 *
	 * @param integer $objektLageImBauLinks
	 * @return void
	 */
	public function setObjektLageImBauLinks($objektLageImBauLinks) {
		$this->objektLageImBauLinks = $objektLageImBauLinks;
	}

	/**
	 * Returns the objektLageImBauRechts
	 *
	 * @return integer $objektLageImBauRechts
	 */
	public function getObjektLageImBauRechts() {
		return $this->objektLageImBauRechts;
	}

	/**
	 * Sets the objektLageImBauRechts
	 *
	 * @param integer $objektLageImBauRechts
	 * @return void
	 */
	public function setObjektLageImBauRechts($objektLageImBauRechts) {
		$this->objektLageImBauRechts = $objektLageImBauRechts;
	}

	/**
	 * Returns the objektLageImBauVorne
	 *
	 * @return integer $objektLageImBauVorne
	 */
	public function getObjektLageImBauVorne() {
		return $this->objektLageImBauVorne;
	}

	/**
	 * Sets the objektLageImBauVorne
	 *
	 * @param integer $objektLageImBauVorne
	 * @return void
	 */
	public function setObjektLageImBauVorne($objektLageImBauVorne) {
		$this->objektLageImBauVorne = $objektLageImBauVorne;
	}

	/**
	 * Returns the objektLageImBauHinten
	 *
	 * @return integer $objektLageImBauHinten
	 */
	public function getObjektLageImBauHinten() {
		return $this->objektLageImBauHinten;
	}

	/**
	 * Sets the objektLageImBauHinten
	 *
	 * @param integer $objektLageImBauHinten
	 * @return void
	 */
	public function setObjektLageImBauHinten($objektLageImBauHinten) {
		$this->objektLageImBauHinten = $objektLageImBauHinten;
	}

	/**
	 * Returns the objektBreitengrad
	 *
	 * @return float $objektBreitengrad
	 */
	public function getObjektBreitengrad() {
		return $this->objektBreitengrad;
	}

	/**
	 * Sets the objektBreitengrad
	 *
	 * @param float $objektBreitengrad
	 * @return void
	 */
	public function setObjektBreitengrad($objektBreitengrad) {
		$this->objektBreitengrad = $objektBreitengrad;
	}

	/**
	 * Returns the objektLaengengrad
	 *
	 * @return float $objektLaengengrad
	 */
	public function getObjektLaengengrad() {
		return $this->objektLaengengrad;
	}

	/**
	 * Sets the objektLaengengrad
	 *
	 * @param float $objektLaengengrad
	 * @return void
	 */
	public function setObjektLaengengrad($objektLaengengrad) {
		$this->objektLaengengrad = $objektLaengengrad;
	}

	/**
	 * Returns the kaufpreis
	 *
	 * @return float $kaufpreis
	 */
	public function getKaufpreis() {
		return $this->kaufpreis;
	}

	/**
	 * Sets the kaufpreis
	 *
	 * @param float $kaufpreis
	 * @return void
	 */
	public function setKaufpreis($kaufpreis) {
		$this->kaufpreis = $kaufpreis;
	}

	/**
	 * Returns the kaufpreisNetto
	 *
	 * @return float $kaufpreisNetto
	 */
	public function getKaufpreisNetto() {
		return $this->kaufpreisNetto;
	}

	/**
	 * Sets the kaufpreisNetto
	 *
	 * @param float $kaufpreisNetto
	 * @return void
	 */
	public function setKaufpreisNetto($kaufpreisNetto) {
		$this->kaufpreisNetto = $kaufpreisNetto;
	}

	/**
	 * Returns the kaufpreisNettoUst
	 *
	 * @return float $kaufpreisNettoUst
	 */
	public function getKaufpreisNettoUst() {
		return $this->kaufpreisNettoUst;
	}

	/**
	 * Sets the kaufpreisNettoUst
	 *
	 * @param float $kaufpreisNettoUst
	 * @return void
	 */
	public function setKaufpreisNettoUst($kaufpreisNettoUst) {
		$this->kaufpreisNettoUst = $kaufpreisNettoUst;
	}

	/**
	 * Returns the kaufpreisBrutto
	 *
	 * @return float $kaufpreisBrutto
	 */
	public function getKaufpreisBrutto() {
		return $this->kaufpreisBrutto;
	}

	/**
	 * Sets the kaufpreisBrutto
	 *
	 * @param float $kaufpreisBrutto
	 * @return void
	 */
	public function setKaufpreisBrutto($kaufpreisBrutto) {
		$this->kaufpreisBrutto = $kaufpreisBrutto;
	}

	/**
	 * Returns the nettokaltmiete
	 *
	 * @return float $nettokaltmiete
	 */
	public function getNettokaltmiete() {
		return $this->nettokaltmiete;
	}

	/**
	 * Sets the nettokaltmiete
	 *
	 * @param float $nettokaltmiete
	 * @return void
	 */
	public function setNettokaltmiete($nettokaltmiete) {
		$this->nettokaltmiete = $nettokaltmiete;
	}

	/**
	 * Returns the kaltmiete
	 *
	 * @return float $kaltmiete
	 */
	public function getKaltmiete() {
		return $this->kaltmiete;
	}

	/**
	 * Sets the kaltmiete
	 *
	 * @param float $kaltmiete
	 * @return void
	 */
	public function setKaltmiete($kaltmiete) {
		$this->kaltmiete = $kaltmiete;
	}

	/**
	 * Returns the warmmiete
	 *
	 * @return float $warmmiete
	 */
	public function getWarmmiete() {
		return $this->warmmiete;
	}

	/**
	 * Sets the warmmiete
	 *
	 * @param float $warmmiete
	 * @return void
	 */
	public function setWarmmiete($warmmiete) {
		$this->warmmiete = $warmmiete;
	}

	/**
	 * Returns the nebenkosten
	 *
	 * @return float $nebenkosten
	 */
	public function getNebenkosten() {
    return $this->nebenkosten;
	}

	/**
	 * Sets the nebenkosten
	 *
	 * @param float $nebenkosten
	 * @return void
	 */
	public function setNebenkosten($nebenkosten) {
		$this->nebenkosten = $nebenkosten;
	}

	public function getGesamtmiete(){
		return $this->kaltmiete+$this->nebenkosten+$this->heizkosten;
	}

	/**
	 * Returns the heizkostenEnthalten
	 *
	 * @return integer $heizkostenEnthalten
	 */
	public function getHeizkostenEnthalten() {
		return $this->heizkostenEnthalten;
	}

	/**
	 * Sets the heizkostenEnthalten
	 *
	 * @param integer $heizkostenEnthalten
	 * @return void
	 */
	public function setHeizkostenEnthalten($heizkostenEnthalten) {
		$this->heizkostenEnthalten = $heizkostenEnthalten;
	}

	/**
	 * Returns the heizkosten
	 *
	 * @return float $heizkosten
	 */
	public function getHeizkosten() {
		return $this->heizkosten;
	}

	/**
	 * Sets the heizkosten
	 *
	 * @param float $heizkosten
	 * @return void
	 */
	public function setHeizkosten($heizkosten) {
		$this->heizkosten = $heizkosten;
	}

	/**
	 * Returns the zzglMehrwertsteuer
	 *
	 * @return integer $zzglMehrwertsteuer
	 */
	public function getZzglMehrwertsteuer() {
		return $this->zzglMehrwertsteuer;
	}

	/**
	 * Sets the zzglMehrwertsteuer
	 *
	 * @param integer $zzglMehrwertsteuer
	 * @return void
	 */
	public function setZzglMehrwertsteuer($zzglMehrwertsteuer) {
		$this->zzglMehrwertsteuer = $zzglMehrwertsteuer;
	}

	/**
	 * Returns the mietzuschlaege
	 *
	 * @return float $mietzuschlaege
	 */
	public function getMietzuschlaege() {
		return $this->mietzuschlaege;
	}

	/**
	 * Sets the mietzuschlaege
	 *
	 * @param float $mietzuschlaege
	 * @return void
	 */
	public function setMietzuschlaege($mietzuschlaege) {
		$this->mietzuschlaege = $mietzuschlaege;
	}

	/**
	 * Returns the hauptmietzinsNetto
	 *
	 * @return float $hauptmietzinsNetto
	 */
	public function getHauptmietzinsNetto() {
		return $this->hauptmietzinsNetto;
	}

	/**
	 * Sets the hauptmietzinsNetto
	 *
	 * @param float $hauptmietzinsNetto
	 * @return void
	 */
	public function setHauptmietzinsNetto($hauptmietzinsNetto) {
		$this->hauptmietzinsNetto = $hauptmietzinsNetto;
	}

	/**
	 * Returns the hauptmietzinsNettoUst
	 *
	 * @return float $hauptmietzinsNettoUst
	 */
	public function getHauptmietzinsNettoUst() {
		return $this->hauptmietzinsNettoUst;
	}

	/**
	 * Sets the hauptmietzinsNettoUst
	 *
	 * @param float $hauptmietzinsNettoUst
	 * @return void
	 */
	public function setHauptmietzinsNettoUst($hauptmietzinsNettoUst) {
		$this->hauptmietzinsNettoUst = $hauptmietzinsNettoUst;
	}

	/**
	 * Returns the pauschalmiete
	 *
	 * @return float $pauschalmiete
	 */
	public function getPauschalmiete() {
		return $this->pauschalmiete;
	}

	/**
	 * Sets the pauschalmiete
	 *
	 * @param float $pauschalmiete
	 * @return void
	 */
	public function setPauschalmiete($pauschalmiete) {
		$this->pauschalmiete = $pauschalmiete;
	}

	/**
	 * Returns the betriebskostenNetto
	 *
	 * @return float $betriebskostenNetto
	 */
	public function getBetriebskostenNetto() {
		return $this->betriebskostenNetto;
	}

	/**
	 * Sets the betriebskostenNetto
	 *
	 * @param float $betriebskostenNetto
	 * @return void
	 */
	public function setBetriebskostenNetto($betriebskostenNetto) {
		$this->betriebskostenNetto = $betriebskostenNetto;
	}

	/**
	 * Returns the betriebskostenNettoUst
	 *
	 * @return float $betriebskostenNettoUst
	 */
	public function getBetriebskostenNettoUst() {
		return $this->betriebskostenNettoUst;
	}

	/**
	 * Sets the betriebskostenNettoUst
	 *
	 * @param float $betriebskostenNettoUst
	 * @return void
	 */
	public function setBetriebskostenNettoUst($betriebskostenNettoUst) {
		$this->betriebskostenNettoUst = $betriebskostenNettoUst;
	}

	/**
	 * Returns the evbNetto
	 *
	 * @return float $evbNetto
	 */
	public function getEvbNetto() {
		return $this->evbNetto;
	}

	/**
	 * Sets the evbNetto
	 *
	 * @param float $evbNetto
	 * @return void
	 */
	public function setEvbNetto($evbNetto) {
		$this->evbNetto = $evbNetto;
	}

	/**
	 * Returns the evbNettoUst
	 *
	 * @return float $evbNettoUst
	 */
	public function getEvbNettoUst() {
		return $this->evbNettoUst;
	}

	/**
	 * Sets the evbNettoUst
	 *
	 * @param float $evbNettoUst
	 * @return void
	 */
	public function setEvbNettoUst($evbNettoUst) {
		$this->evbNettoUst = $evbNettoUst;
	}

	/**
	 * Returns the gesamtmieteNetto
	 *
	 * @return float $gesamtmieteNetto
	 */
	public function getGesamtmieteNetto() {
		return $this->gesamtmieteNetto;
	}

	/**
	 * Sets the gesamtmieteNetto
	 *
	 * @param float $gesamtmieteNetto
	 * @return void
	 */
	public function setGesamtmieteNetto($gesamtmieteNetto) {
		$this->gesamtmieteNetto = $gesamtmieteNetto;
	}

	/**
	 * Returns the gesamtmieteNettoUst
	 *
	 * @return float $gesamtmieteNettoUst
	 */
	public function getGesamtmieteNettoUst() {
		return $this->gesamtmieteNettoUst;
	}

	/**
	 * Sets the gesamtmieteNettoUst
	 *
	 * @param float $gesamtmieteNettoUst
	 * @return void
	 */
	public function setGesamtmieteNettoUst($gesamtmieteNettoUst) {
		$this->gesamtmieteNettoUst = $gesamtmieteNettoUst;
	}

	/**
	 * Returns the gesamtmieteBrutto
	 *
	 * @return float $gesamtmieteBrutto
	 */
	public function getGesamtmieteBrutto() {
		if ($this->gesamtmieteBrutto == 0){
			$return = 0;
			$return += $this->getKaltmiete();
			$return += $this->getNebenkosten();
			if ($this->getHeizkostenEnthalten() != 1){
				$return += $this->getHeizkosten();
			}
			return $return;
		}else{
			return $this->gesamtmieteBrutto;
		}
	}

	/**
	 * Sets the gesamtmieteBrutto
	 *
	 * @param float $gesamtmieteBrutto
	 * @return void
	 */
	public function setGesamtmieteBrutto($gesamtmieteBrutto) {
		$this->gesamtmieteBrutto = $gesamtmieteBrutto;
	}

	/**
	 * Returns the gesamtbelastungNetto
	 *
	 * @return float $gesamtbelastungNetto
	 */
	public function getGesamtbelastungNetto() {
		return $this->gesamtbelastungNetto;
	}

	/**
	 * Sets the gesamtbelastungNetto
	 *
	 * @param float $gesamtbelastungNetto
	 * @return void
	 */
	public function setGesamtbelastungNetto($gesamtbelastungNetto) {
		$this->gesamtbelastungNetto = $gesamtbelastungNetto;
	}

	/**
	 * Returns the gesamtbelastungNettoUst
	 *
	 * @return float $gesamtbelastungNettoUst
	 */
	public function getGesamtbelastungNettoUst() {
		return $this->gesamtbelastungNettoUst;
	}

	/**
	 * Sets the gesamtbelastungNettoUst
	 *
	 * @param float $gesamtbelastungNettoUst
	 * @return void
	 */
	public function setGesamtbelastungNettoUst($gesamtbelastungNettoUst) {
		$this->gesamtbelastungNettoUst = $gesamtbelastungNettoUst;
	}

	/**
	 * Returns the gesamtbelastungBrutto
	 *
	 * @return float $gesamtbelastungBrutto
	 */
	public function getGesamtbelastungBrutto() {
		return $this->gesamtbelastungBrutto;
	}

	/**
	 * Sets the gesamtbelastungBrutto
	 *
	 * @param float $gesamtbelastungBrutto
	 * @return void
	 */
	public function setGesamtbelastungBrutto($gesamtbelastungBrutto) {
		$this->gesamtbelastungBrutto = $gesamtbelastungBrutto;
	}

	/**
	 * Returns the gesamtkostenProM2Von
	 *
	 * @return float $gesamtkostenProM2Von
	 */
	public function getGesamtkostenProM2Von() {
		return $this->gesamtkostenProM2Von;
	}

	/**
	 * Sets the gesamtkostenProM2Von
	 *
	 * @param float $gesamtkostenProM2Von
	 * @return void
	 */
	public function setGesamtkostenProM2Von($gesamtkostenProM2Von) {
		$this->gesamtkostenProM2Von = $gesamtkostenProM2Von;
	}

	/**
	 * Returns the gesamtkostenProM2Bis
	 *
	 * @return float $gesamtkostenProM2Bis
	 */
	public function getGesamtkostenProM2Bis() {
		return $this->gesamtkostenProM2Bis;
	}

	/**
	 * Sets the gesamtkostenProM2Bis
	 *
	 * @param float $gesamtkostenProM2Bis
	 * @return void
	 */
	public function setGesamtkostenProM2Bis($gesamtkostenProM2Bis) {
		$this->gesamtkostenProM2Bis = $gesamtkostenProM2Bis;
	}

	/**
	 * Returns the heizkostenNetto
	 *
	 * @return float $heizkostenNetto
	 */
	public function getHeizkostenNetto() {
		return $this->heizkostenNetto;
	}

	/**
	 * Sets the heizkostenNetto
	 *
	 * @param float $heizkostenNetto
	 * @return void
	 */
	public function setHeizkostenNetto($heizkostenNetto) {
		$this->heizkostenNetto = $heizkostenNetto;
	}

	/**
	 * Returns the heizkostenNettoUst
	 *
	 * @return float $heizkostenNettoUst
	 */
	public function getHeizkostenNettoUst() {
		return $this->heizkostenNettoUst;
	}

	/**
	 * Sets the heizkostenNettoUst
	 *
	 * @param float $heizkostenNettoUst
	 * @return void
	 */
	public function setHeizkostenNettoUst($heizkostenNettoUst) {
		$this->heizkostenNettoUst = $heizkostenNettoUst;
	}

	/**
	 * Returns the monatlichekostenNetto
	 *
	 * @return float $monatlichekostenNetto
	 */
	public function getMonatlichekostenNetto() {
		return $this->monatlichekostenNetto;
	}

	/**
	 * Sets the monatlichekostenNetto
	 *
	 * @param float $monatlichekostenNetto
	 * @return void
	 */
	public function setMonatlichekostenNetto($monatlichekostenNetto) {
		$this->monatlichekostenNetto = $monatlichekostenNetto;
	}

	/**
	 * Returns the monatlichekostenNettoUst
	 *
	 * @return float $monatlichekostenNettoUst
	 */
	public function getMonatlichekostenNettoUst() {
		return $this->monatlichekostenNettoUst;
	}

	/**
	 * Sets the monatlichekostenNettoUst
	 *
	 * @param float $monatlichekostenNettoUst
	 * @return void
	 */
	public function setMonatlichekostenNettoUst($monatlichekostenNettoUst) {
		$this->monatlichekostenNettoUst = $monatlichekostenNettoUst;
	}

	/**
	 * Returns the monatlichekostenbrutto
	 *
	 * @return float $monatlichekostenbrutto
	 */
	public function getMonatlichekostenbrutto() {
		return $this->monatlichekostenbrutto;
	}

	/**
	 * Sets the monatlichekostenbrutto
	 *
	 * @param float $monatlichekostenbrutto
	 * @return void
	 */
	public function setMonatlichekostenbrutto($monatlichekostenbrutto) {
		$this->monatlichekostenbrutto = $monatlichekostenbrutto;
	}

	/**
	 * Returns the nebenkostenProM2Von
	 *
	 * @return float $nebenkostenProM2Von
	 */
	public function getNebenkostenProM2Von() {
		return $this->nebenkostenProM2Von;
	}

	/**
	 * Sets the nebenkostenProM2Von
	 *
	 * @param float $nebenkostenProM2Von
	 * @return void
	 */
	public function setNebenkostenProM2Von($nebenkostenProM2Von) {
		$this->nebenkostenProM2Von = $nebenkostenProM2Von;
	}

	/**
	 * Returns the nebenkostenProM2Bis
	 *
	 * @return float $nebenkostenProM2Bis
	 */
	public function getNebenkostenProM2Bis() {
		return $this->nebenkostenProM2Bis;
	}

	/**
	 * Sets the nebenkostenProM2Bis
	 *
	 * @param float $nebenkostenProM2Bis
	 * @return void
	 */
	public function setNebenkostenProM2Bis($nebenkostenProM2Bis) {
		$this->nebenkostenProM2Bis = $nebenkostenProM2Bis;
	}

	/**
	 * Returns the ruecklageNetto
	 *
	 * @return float $ruecklageNetto
	 */
	public function getRuecklageNetto() {
		return $this->ruecklageNetto;
	}

	/**
	 * Sets the ruecklageNetto
	 *
	 * @param float $ruecklageNetto
	 * @return void
	 */
	public function setRuecklageNetto($ruecklageNetto) {
		$this->ruecklageNetto = $ruecklageNetto;
	}

	/**
	 * Returns the ruecklageNettoUst
	 *
	 * @return float $ruecklageNettoUst
	 */
	public function getRuecklageNettoUst() {
		return $this->ruecklageNettoUst;
	}

	/**
	 * Sets the ruecklageNettoUst
	 *
	 * @param float $ruecklageNettoUst
	 * @return void
	 */
	public function setRuecklageNettoUst($ruecklageNettoUst) {
		$this->ruecklageNettoUst = $ruecklageNettoUst;
	}

	/**
	 * Returns the sonstigekostenNetto
	 *
	 * @return float $sonstigekostenNetto
	 */
	public function getSonstigekostenNetto() {
		return $this->sonstigekostenNetto;
	}

	/**
	 * Sets the sonstigekostenNetto
	 *
	 * @param float $sonstigekostenNetto
	 * @return void
	 */
	public function setSonstigekostenNetto($sonstigekostenNetto) {
		$this->sonstigekostenNetto = $sonstigekostenNetto;
	}

	/**
	 * Returns the sonstigekostenNettoUst
	 *
	 * @return float $sonstigekostenNettoUst
	 */
	public function getSonstigekostenNettoUst() {
		return $this->sonstigekostenNettoUst;
	}

	/**
	 * Sets the sonstigekostenNettoUst
	 *
	 * @param float $sonstigekostenNettoUst
	 * @return void
	 */
	public function setSonstigekostenNettoUst($sonstigekostenNettoUst) {
		$this->sonstigekostenNettoUst = $sonstigekostenNettoUst;
	}

	/**
	 * Returns the sonstigemieteNetto
	 *
	 * @return float $sonstigemieteNetto
	 */
	public function getSonstigemieteNetto() {
		return $this->sonstigemieteNetto;
	}

	/**
	 * Sets the sonstigemieteNetto
	 *
	 * @param float $sonstigemieteNetto
	 * @return void
	 */
	public function setSonstigemieteNetto($sonstigemieteNetto) {
		$this->sonstigemieteNetto = $sonstigemieteNetto;
	}

	/**
	 * Returns the sonstigemieteNettoUst
	 *
	 * @return float $sonstigemieteNettoUst
	 */
	public function getSonstigemieteNettoUst() {
		return $this->sonstigemieteNettoUst;
	}

	/**
	 * Sets the sonstigemieteNettoUst
	 *
	 * @param float $sonstigemieteNettoUst
	 * @return void
	 */
	public function setSonstigemieteNettoUst($sonstigemieteNettoUst) {
		$this->sonstigemieteNettoUst = $sonstigemieteNettoUst;
	}

	/**
	 * Returns the summemieteNetto
	 *
	 * @return float $summemieteNetto
	 */
	public function getSummemieteNetto() {
		return $this->summemieteNetto;
	}

	/**
	 * Sets the summemieteNetto
	 *
	 * @param float $summemieteNetto
	 * @return void
	 */
	public function setSummemieteNetto($summemieteNetto) {
		$this->summemieteNetto = $summemieteNetto;
	}

	/**
	 * Returns the summemieteNettoUst
	 *
	 * @return float $summemieteNettoUst
	 */
	public function getSummemieteNettoUst() {
		return $this->summemieteNettoUst;
	}

	/**
	 * Sets the summemieteNettoUst
	 *
	 * @param float $summemieteNettoUst
	 * @return void
	 */
	public function setSummemieteNettoUst($summemieteNettoUst) {
		$this->summemieteNettoUst = $summemieteNettoUst;
	}

	/**
	 * Returns the nettomieteProM2Von
	 *
	 * @return float $nettomieteProM2Von
	 */
	public function getNettomieteProM2Von() {
		return $this->nettomieteProM2Von;
	}

	/**
	 * Sets the nettomieteProM2Von
	 *
	 * @param float $nettomieteProM2Von
	 * @return void
	 */
	public function setNettomieteProM2Von($nettomieteProM2Von) {
		$this->nettomieteProM2Von = $nettomieteProM2Von;
	}

	/**
	 * Returns the nettomieteProM2Bis
	 *
	 * @return float $nettomieteProM2Bis
	 */
	public function getNettomieteProM2Bis() {
		return $this->nettomieteProM2Bis;
	}

	/**
	 * Sets the nettomieteProM2Bis
	 *
	 * @param float $nettomieteProM2Bis
	 * @return void
	 */
	public function setNettomieteProM2Bis($nettomieteProM2Bis) {
		$this->nettomieteProM2Bis = $nettomieteProM2Bis;
	}

	/**
	 * Returns the pacht
	 *
	 * @return float $pacht
	 */
	public function getPacht() {
		return $this->pacht;
	}

	/**
	 * Sets the pacht
	 *
	 * @param float $pacht
	 * @return void
	 */
	public function setPacht($pacht) {
		$this->pacht = $pacht;
	}

	/**
	 * Returns the erbpacht
	 *
	 * @return float $erbpacht
	 */
	public function getErbpacht() {
		return $this->erbpacht;
	}

	/**
	 * Sets the erbpacht
	 *
	 * @param float $erbpacht
	 * @return void
	 */
	public function setErbpacht($erbpacht) {
		$this->erbpacht = $erbpacht;
	}

	/**
	 * Returns the hausgeld
	 *
	 * @return float $hausgeld
	 */
	public function getHausgeld() {
		return $this->hausgeld;
	}

	/**
	 * Sets the hausgeld
	 *
	 * @param float $hausgeld
	 * @return void
	 */
	public function setHausgeld($hausgeld) {
		$this->hausgeld = $hausgeld;
	}

	/**
	 * Returns the abstand
	 *
	 * @return float $abstand
	 */
	public function getAbstand() {
		return $this->abstand;
	}

	/**
	 * Sets the abstand
	 *
	 * @param float $abstand
	 * @return void
	 */
	public function setAbstand($abstand) {
		$this->abstand = $abstand;
	}

	/**
	 * Returns the preisZeitraumVon
	 *
	 * @return \DateTime $preisZeitraumVon
	 */
	public function getPreisZeitraumVon() {
		return $this->preisZeitraumVon;
	}

	/**
	 * Sets the preisZeitraumVon
	 *
	 * @param \DateTime $preisZeitraumVon
	 * @return void
	 */
	public function setPreisZeitraumVon(\DateTime $preisZeitraumVon) {
		$this->preisZeitraumVon = $preisZeitraumVon;
	}

	/**
	 * Returns the preisZeitraumBis
	 *
	 * @return \DateTime $preisZeitraumBis
	 */
	public function getPreisZeitraumBis() {
		return $this->preisZeitraumBis;
	}

	/**
	 * Sets the preisZeitraumBis
	 *
	 * @param \DateTime $preisZeitraumBis
	 * @return void
	 */
	public function setPreisZeitraumBis(\DateTime $preisZeitraumBis) {
		$this->preisZeitraumBis = $preisZeitraumBis;
	}

	/**
	 * Returns the mietpreisProM2
	 *
	 * @return float $mietpreisProM2
	 */
	public function getMietpreisProM2() {
		return $this->mietpreisProM2;
	}

	/**
	 * Sets the mietpreisProM2
	 *
	 * @param float $mietpreisProM2
	 * @return void
	 */
	public function setMietpreisProM2($mietpreisProM2) {
		$this->mietpreisProM2 = $mietpreisProM2;
	}

	/**
	 * Returns the kaufpreisProM2
	 *
	 * @return float $kaufpreisProM2
	 */
	public function getKaufpreisProM2() {
		return $this->kaufpreisProM2;
	}

	/**
	 * Sets the kaufpreisProM2
	 *
	 * @param float $kaufpreisProM2
	 * @return void
	 */
	public function setKaufpreisProM2($kaufpreisProM2) {
		$this->kaufpreisProM2 = $kaufpreisProM2;
	}

	/**
	 * Returns the provisionspflichtig
	 *
	 * @return integer $provisionspflichtig
	 */
	public function getProvisionspflichtig() {
		return $this->provisionspflichtig;
	}

	/**
	 * Sets the provisionspflichtig
	 *
	 * @param integer $provisionspflichtig
	 * @return void
	 */
	public function setProvisionspflichtig($provisionspflichtig) {
		$this->provisionspflichtig = $provisionspflichtig;
	}

	/**
	 * Returns the innencourtage
	 *
	 * @return string $innencourtage
	 */
	public function getInnencourtage() {
		return $this->innencourtage;
	}

	/**
	 * Sets the innencourtage
	 *
	 * @param string $innencourtage
	 * @return void
	 */
	public function setInnencourtage($innencourtage) {
		$this->innencourtage = $innencourtage;
	}

	/**
	 * Returns the innencourtageMitMwst
	 *
	 * @return integer $innencourtageMitMwst
	 */
	public function getInnencourtageMitMwst() {
		return $this->innencourtageMitMwst;
	}

	/**
	 * Sets the innencourtageMitMwst
	 *
	 * @param integer $innencourtageMitMwst
	 * @return void
	 */
	public function setInnencourtageMitMwst($innencourtageMitMwst) {
		$this->innencourtageMitMwst = $innencourtageMitMwst;
	}

	/**
	 * Returns the aussencourtage
	 *
	 * @return string $aussencourtage
	 */
	public function getAussencourtage() {
		return $this->aussencourtage;
	}

	/**
	 * Sets the aussencourtage
	 *
	 * @param string $aussencourtage
	 * @return void
	 */
	public function setAussencourtage($aussencourtage) {
		$this->aussencourtage = $aussencourtage;
	}

	/**
	 * Returns the aussencourtageMitMwst
	 *
	 * @return integer $aussencourtageMitMwst
	 */
	public function getAussencourtageMitMwst() {
		return $this->aussencourtageMitMwst;
	}

	/**
	 * Sets the aussencourtageMitMwst
	 *
	 * @param integer $aussencourtageMitMwst
	 * @return void
	 */
	public function setAussencourtageMitMwst($aussencourtageMitMwst) {
		$this->aussencourtageMitMwst = $aussencourtageMitMwst;
	}

	/**
	 * Returns the courtageHinweis
	 *
	 * @return string $courtageHinweis
	 */
	public function getCourtageHinweis() {
		return $this->courtageHinweis;
	}

	/**
	 * Sets the courtageHinweis
	 *
	 * @param string $courtageHinweis
	 * @return void
	 */
	public function setCourtageHinweis($courtageHinweis) {
		$this->courtageHinweis = $courtageHinweis;
	}

	/**
	 * Returns the provisionNetto
	 *
	 * @return float $provisionNetto
	 */
	public function getProvisionNetto() {
		return $this->provisionNetto;
	}

	/**
	 * Sets the provisionNetto
	 *
	 * @param float $provisionNetto
	 * @return void
	 */
	public function setProvisionNetto($provisionNetto) {
		$this->provisionNetto = $provisionNetto;
	}

	/**
	 * Returns the provisionNettoUst
	 *
	 * @return float $provisionNettoUst
	 */
	public function getProvisionNettoUst() {
		return $this->provisionNettoUst;
	}

	/**
	 * Sets the provisionNettoUst
	 *
	 * @param float $provisionNettoUst
	 * @return void
	 */
	public function setProvisionNettoUst($provisionNettoUst) {
		$this->provisionNettoUst = $provisionNettoUst;
	}

	/**
	 * Returns the provisionBrutto
	 *
	 * @return float $provisionBrutto
	 */
	public function getProvisionBrutto() {
		return $this->provisionBrutto;
	}

	/**
	 * Sets the provisionBrutto
	 *
	 * @param float $provisionBrutto
	 * @return void
	 */
	public function setProvisionBrutto($provisionBrutto) {
		$this->provisionBrutto = $provisionBrutto;
	}

	/**
	 * Returns the mwstSatz
	 *
	 * @return float $mwstSatz
	 */
	public function getMwstSatz() {
		return $this->mwstSatz;
	}

	/**
	 * Sets the mwstSatz
	 *
	 * @param float $mwstSatz
	 * @return void
	 */
	public function setMwstSatz($mwstSatz) {
		$this->mwstSatz = $mwstSatz;
	}

	/**
	 * Returns the mwstGesamt
	 *
	 * @return float $mwstGesamt
	 */
	public function getMwstGesamt() {
		return $this->mwstGesamt;
	}

	/**
	 * Sets the mwstGesamt
	 *
	 * @param float $mwstGesamt
	 * @return void
	 */
	public function setMwstGesamt($mwstGesamt) {
		$this->mwstGesamt = $mwstGesamt;
	}

	/**
	 * Returns the freitextPreis
	 *
	 * @return string $freitextPreis
	 */
	public function getFreitextPreis() {
		return $this->freitextPreis;
	}

	/**
	 * Sets the freitextPreis
	 *
	 * @param string $freitextPreis
	 * @return void
	 */
	public function setFreitextPreis($freitextPreis) {
		$this->freitextPreis = $freitextPreis;
	}

	/**
	 * Returns the xfache
	 *
	 * @return string $xfache
	 */
	public function getXfache() {
		return $this->xfache;
	}

	/**
	 * Sets the xfache
	 *
	 * @param string $xfache
	 * @return void
	 */
	public function setXfache($xfache) {
		$this->xfache = $xfache;
	}

	/**
	 * Returns the nettorendite
	 *
	 * @return float $nettorendite
	 */
	public function getNettorendite() {
		return $this->nettorendite;
	}

	/**
	 * Sets the nettorendite
	 *
	 * @param float $nettorendite
	 * @return void
	 */
	public function setNettorendite($nettorendite) {
		$this->nettorendite = $nettorendite;
	}

	/**
	 * Returns the nettorenditeSoll
	 *
	 * @return float $nettorenditeSoll
	 */
	public function getNettorenditeSoll() {
		return $this->nettorenditeSoll;
	}

	/**
	 * Sets the nettorenditeSoll
	 *
	 * @param float $nettorenditeSoll
	 * @return void
	 */
	public function setNettorenditeSoll($nettorenditeSoll) {
		$this->nettorenditeSoll = $nettorenditeSoll;
	}

	/**
	 * Returns the nettorenditeIst
	 *
	 * @return float $nettorenditeIst
	 */
	public function getNettorenditeIst() {
		return $this->nettorenditeIst;
	}

	/**
	 * Sets the nettorenditeIst
	 *
	 * @param float $nettorenditeIst
	 * @return void
	 */
	public function setNettorenditeIst($nettorenditeIst) {
		$this->nettorenditeIst = $nettorenditeIst;
	}

	/**
	 * Returns the mieteinnahmenIst
	 *
	 * @return float $mieteinnahmenIst
	 */
	public function getMieteinnahmenIst() {
		return $this->mieteinnahmenIst;
	}

	/**
	 * Sets the mieteinnahmenIst
	 *
	 * @param float $mieteinnahmenIst
	 * @return void
	 */
	public function setMieteinnahmenIst($mieteinnahmenIst) {
		$this->mieteinnahmenIst = $mieteinnahmenIst;
	}

	/**
	 * Returns the mieteinnahmenSoll
	 *
	 * @return float $mieteinnahmenSoll
	 */
	public function getMieteinnahmenSoll() {
		return $this->mieteinnahmenSoll;
	}

	/**
	 * Sets the mieteinnahmenSoll
	 *
	 * @param float $mieteinnahmenSoll
	 * @return void
	 */
	public function setMieteinnahmenSoll($mieteinnahmenSoll) {
		$this->mieteinnahmenSoll = $mieteinnahmenSoll;
	}

	/**
	 * Returns the erschliessungskosten
	 *
	 * @return float $erschliessungskosten
	 */
	public function getErschliessungskosten() {
		return $this->erschliessungskosten;
	}

	/**
	 * Sets the erschliessungskosten
	 *
	 * @param float $erschliessungskosten
	 * @return void
	 */
	public function setErschliessungskosten($erschliessungskosten) {
		$this->erschliessungskosten = $erschliessungskosten;
	}

	/**
	 * Returns the kaution
	 *
	 * @return float $kaution
	 */
	public function getKaution() {
		return $this->kaution;
	}

	/**
	 * Sets the kaution
	 *
	 * @param float $kaution
	 * @return void
	 */
	public function setKaution($kaution) {
		$this->kaution = $kaution;
	}

	/**
	 * Returns the kautionText
	 *
	 * @return string $kautionText
	 */
	public function getKautionText() {
		return $this->kautionText;
	}

	/**
	 * Sets the kautionText
	 *
	 * @param string $kautionText
	 * @return void
	 */
	public function setKautionText($kautionText) {
		$this->kautionText = $kautionText;
	}

	/**
	 * Returns the geschaeftsguthaben
	 *
	 * @return float $geschaeftsguthaben
	 */
	public function getGeschaeftsguthaben() {
		return $this->geschaeftsguthaben;
	}

	/**
	 * Sets the geschaeftsguthaben
	 *
	 * @param float $geschaeftsguthaben
	 * @return void
	 */
	public function setGeschaeftsguthaben($geschaeftsguthaben) {
		$this->geschaeftsguthaben = $geschaeftsguthaben;
	}

  /**
   * @return float
   */
  public function getGenossenschaftsanteile()
  {
    return $this->genossenschaftsanteile;
  }

  /**
   * @param float $genossenschaftsanteile
   * @return $this
   */
  public function setGenossenschaftsanteile($genossenschaftsanteile)
  {
    $this->genossenschaftsanteile = $genossenschaftsanteile;
    return $this;
  }

  /**
   * @return float
   */
  public function getVertragsabschlussgebuehr()
  {
    return $this->vertragsabschlussgebuehr;
  }

  /**
   * @param float $vertragsabschlussgebuehr
   * @return $this
   */
  public function setVertragsabschlussgebuehr($vertragsabschlussgebuehr)
  {
    $this->vertragsabschlussgebuehr = $vertragsabschlussgebuehr;
    return $this;
  }

	/**
	 * Returns the stpCarport
	 *
	 * @return string $stpCarport
	 */
	public function getStpCarport() {
		return $this->stpCarport;
	}

	/**
	 * Sets the stpCarport
	 *
	 * @param string $stpCarport
	 * @return void
	 */
	public function setStpCarport($stpCarport) {
		$this->stpCarport = $stpCarport;
	}

	/**
	 * Returns the stpDuplex
	 *
	 * @return string $stpDuplex
	 */
	public function getStpDuplex() {
		return $this->stpDuplex;
	}

	/**
	 * Sets the stpDuplex
	 *
	 * @param string $stpDuplex
	 * @return void
	 */
	public function setStpDuplex($stpDuplex) {
		$this->stpDuplex = $stpDuplex;
	}

	/**
	 * Returns the stpFreiplatz
	 *
	 * @return string $stpFreiplatz
	 */
	public function getStpFreiplatz() {
		return $this->stpFreiplatz;
	}

	/**
	 * Sets the stpFreiplatz
	 *
	 * @param string $stpFreiplatz
	 * @return void
	 */
	public function setStpFreiplatz($stpFreiplatz) {
		$this->stpFreiplatz = $stpFreiplatz;
	}

	/**
	 * Returns the stpGarage
	 *
	 * @return string $stpGarage
	 */
	public function getStpGarage() {
		return $this->stpGarage;
	}

	/**
	 * Sets the stpGarage
	 *
	 * @param string $stpGarage
	 * @return void
	 */
	public function setStpGarage($stpGarage) {
		$this->stpGarage = $stpGarage;
	}

	/**
	 * Returns the stpParkhaus
	 *
	 * @return string $stpParkhaus
	 */
	public function getStpParkhaus() {
		return $this->stpParkhaus;
	}

	/**
	 * Sets the stpParkhaus
	 *
	 * @param string $stpParkhaus
	 * @return void
	 */
	public function setStpParkhaus($stpParkhaus) {
		$this->stpParkhaus = $stpParkhaus;
	}

	/**
	 * Returns the stpTiefgarage
	 *
	 * @return string $stpTiefgarage
	 */
	public function getStpTiefgarage() {
		return $this->stpTiefgarage;
	}

	/**
	 * Sets the stpTiefgarage
	 *
	 * @param string $stpTiefgarage
	 * @return void
	 */
	public function setStpTiefgarage($stpTiefgarage) {
		$this->stpTiefgarage = $stpTiefgarage;
	}

	/**
	 * Returns the richtpreis
	 *
	 * @return float $richtpreis
	 */
	public function getRichtpreis() {
		return $this->richtpreis;
	}

	/**
	 * Sets the richtpreis
	 *
	 * @param float $richtpreis
	 * @return void
	 */
	public function setRichtpreis($richtpreis) {
		$this->richtpreis = $richtpreis;
	}

	/**
	 * Returns the richtpreisProM2
	 *
	 * @return float $richtpreisProM2
	 */
	public function getRichtpreisProM2() {
		return $this->richtpreisProM2;
	}

	/**
	 * Sets the richtpreisProM2
	 *
	 * @param float $richtpreisProM2
	 * @return void
	 */
	public function setRichtpreisProM2($richtpreisProM2) {
		$this->richtpreisProM2 = $richtpreisProM2;
	}

	/**
	 * Returns the wohnflaeche
	 *
	 * @return float $wohnflaeche
	 */
	public function getWohnflaeche() {
		return $this->wohnflaeche;
	}

	/**
	 * Sets the wohnflaeche
	 *
	 * @param float $wohnflaeche
	 * @return void
	 */
	public function setWohnflaeche($wohnflaeche) {
		$this->wohnflaeche = $wohnflaeche;
	}

	/**
	 * Returns the nutzflaeche
	 *
	 * @return float $nutzflaeche
	 */
	public function getNutzflaeche() {
		return $this->nutzflaeche;
	}

	/**
	 * Sets the nutzflaeche
	 *
	 * @param float $nutzflaeche
	 * @return void
	 */
	public function setNutzflaeche($nutzflaeche) {
		$this->nutzflaeche = $nutzflaeche;
	}

	/**
	 * Returns the gesamtflaeche
	 *
	 * @return float $gesamtflaeche
	 */
	public function getGesamtflaeche() {
		return $this->gesamtflaeche;
	}

	/**
	 * Sets the gesamtflaeche
	 *
	 * @param float $gesamtflaeche
	 * @return void
	 */
	public function setGesamtflaeche($gesamtflaeche) {
		$this->gesamtflaeche = $gesamtflaeche;
	}

	/**
	 * Returns the ladenflaeche
	 *
	 * @return float $ladenflaeche
	 */
	public function getLadenflaeche() {
		return $this->ladenflaeche;
	}

	/**
	 * Sets the ladenflaeche
	 *
	 * @param float $ladenflaeche
	 * @return void
	 */
	public function setLadenflaeche($ladenflaeche) {
		$this->ladenflaeche = $ladenflaeche;
	}

	/**
	 * Returns the lagerflaeche
	 *
	 * @return float $lagerflaeche
	 */
	public function getLagerflaeche() {
		return $this->lagerflaeche;
	}

	/**
	 * Sets the lagerflaeche
	 *
	 * @param float $lagerflaeche
	 * @return void
	 */
	public function setLagerflaeche($lagerflaeche) {
		$this->lagerflaeche = $lagerflaeche;
	}

	/**
	 * Returns the verkaufsflaeche
	 *
	 * @return float $verkaufsflaeche
	 */
	public function getVerkaufsflaeche() {
		return $this->verkaufsflaeche;
	}

	/**
	 * Sets the verkaufsflaeche
	 *
	 * @param float $verkaufsflaeche
	 * @return void
	 */
	public function setVerkaufsflaeche($verkaufsflaeche) {
		$this->verkaufsflaeche = $verkaufsflaeche;
	}

	/**
	 * Returns the freiflaeche
	 *
	 * @return float $freiflaeche
	 */
	public function getFreiflaeche() {
		return $this->freiflaeche;
	}

	/**
	 * Sets the freiflaeche
	 *
	 * @param float $freiflaeche
	 * @return void
	 */
	public function setFreiflaeche($freiflaeche) {
		$this->freiflaeche = $freiflaeche;
	}

	/**
	 * Returns the bueroflaeche
	 *
	 * @return float $bueroflaeche
	 */
	public function getBueroflaeche() {
		return $this->bueroflaeche;
	}

	/**
	 * Sets the bueroflaeche
	 *
	 * @param float $bueroflaeche
	 * @return void
	 */
	public function setBueroflaeche($bueroflaeche) {
		$this->bueroflaeche = $bueroflaeche;
	}

	/**
	 * Returns the bueroteilflaeche
	 *
	 * @return float $bueroteilflaeche
	 */
	public function getBueroteilflaeche() {
		return $this->bueroteilflaeche;
	}

	/**
	 * Sets the bueroteilflaeche
	 *
	 * @param float $bueroteilflaeche
	 * @return void
	 */
	public function setBueroteilflaeche($bueroteilflaeche) {
		$this->bueroteilflaeche = $bueroteilflaeche;
	}

	/**
	 * Returns the fensterfront
	 *
	 * @return float $fensterfront
	 */
	public function getFensterfront() {
		return $this->fensterfront;
	}

	/**
	 * Sets the fensterfront
	 *
	 * @param float $fensterfront
	 * @return void
	 */
	public function setFensterfront($fensterfront) {
		$this->fensterfront = $fensterfront;
	}

	/**
	 * Returns the verwaltungsflaeche
	 *
	 * @return float $verwaltungsflaeche
	 */
	public function getVerwaltungsflaeche() {
		return $this->verwaltungsflaeche;
	}

	/**
	 * Sets the verwaltungsflaeche
	 *
	 * @param float $verwaltungsflaeche
	 * @return void
	 */
	public function setVerwaltungsflaeche($verwaltungsflaeche) {
		$this->verwaltungsflaeche = $verwaltungsflaeche;
	}

	/**
	 * Returns the gastroflaeche
	 *
	 * @return float $gastroflaeche
	 */
	public function getGastroflaeche() {
		return $this->gastroflaeche;
	}

	/**
	 * Sets the gastroflaeche
	 *
	 * @param float $gastroflaeche
	 * @return void
	 */
	public function setGastroflaeche($gastroflaeche) {
		$this->gastroflaeche = $gastroflaeche;
	}

	/**
	 * Returns the grundflaechenzahl
	 *
	 * @return string $grundflaechenzahl
	 */
	public function getGrundflaechenzahl() {
		return $this->grundflaechenzahl;
	}

	/**
	 * Sets the grundflaechenzahl
	 *
	 * @param string $grundflaechenzahl
	 * @return void
	 */
	public function setGrundflaechenzahl($grundflaechenzahl) {
		$this->grundflaechenzahl = $grundflaechenzahl;
	}

	/**
	 * Returns the geschossflaechenzahl
	 *
	 * @return string $geschossflaechenzahl
	 */
	public function getGeschossflaechenzahl() {
		return $this->geschossflaechenzahl;
	}

	/**
	 * Sets the geschossflaechenzahl
	 *
	 * @param string $geschossflaechenzahl
	 * @return void
	 */
	public function setGeschossflaechenzahl($geschossflaechenzahl) {
		$this->geschossflaechenzahl = $geschossflaechenzahl;
	}

	/**
	 * Returns the baumassenzahl
	 *
	 * @return string $baumassenzahl
	 */
	public function getBaumassenzahl() {
		return $this->baumassenzahl;
	}

	/**
	 * Sets the baumassenzahl
	 *
	 * @param string $baumassenzahl
	 * @return void
	 */
	public function setBaumassenzahl($baumassenzahl) {
		$this->baumassenzahl = $baumassenzahl;
	}

	/**
	 * Returns the bruttogeschossflaechenzahl
	 *
	 * @return float $bruttogeschossflaechenzahl
	 */
	public function getBruttogeschossflaechenzahl() {
		return $this->bruttogeschossflaechenzahl;
	}

	/**
	 * Sets the bruttogeschossflaechenzahl
	 *
	 * @param float $bruttogeschossflaechenzahl
	 * @return void
	 */
	public function setBruttogeschossflaechenzahl($bruttogeschossflaechenzahl) {
		$this->bruttogeschossflaechenzahl = $bruttogeschossflaechenzahl;
	}

	/**
	 * Returns the grundstuecksflaeche
	 *
	 * @return float $grundstuecksflaeche
	 */
	public function getGrundstuecksflaeche() {
		return $this->grundstuecksflaeche;
	}

	/**
	 * Sets the grundstuecksflaeche
	 *
	 * @param float $grundstuecksflaeche
	 * @return void
	 */
	public function setGrundstuecksflaeche($grundstuecksflaeche) {
		$this->grundstuecksflaeche = $grundstuecksflaeche;
	}

	/**
	 * Returns the sonstflaeche
	 *
	 * @return float $sonstflaeche
	 */
	public function getSonstflaeche() {
		return $this->sonstflaeche;
	}

	/**
	 * Sets the sonstflaeche
	 *
	 * @param float $sonstflaeche
	 * @return void
	 */
	public function setSonstflaeche($sonstflaeche) {
		$this->sonstflaeche = $sonstflaeche;
	}

	/**
	 * Returns the anzahlZimmer
	 *
	 * @return float $anzahlZimmer
	 */
	public function getAnzahlZimmer() {
		return $this->anzahlZimmer;
	}

	/**
	 * Sets the anzahlZimmer
	 *
	 * @param float $anzahlZimmer
	 * @return void
	 */
	public function setAnzahlZimmer($anzahlZimmer) {
		$this->anzahlZimmer = $anzahlZimmer;
	}

	/**
	 * Returns the anzahlSchlafzimmer
	 *
	 * @return float $anzahlSchlafzimmer
	 */
	public function getAnzahlSchlafzimmer() {
		return $this->anzahlSchlafzimmer;
	}

	/**
	 * Sets the anzahlSchlafzimmer
	 *
	 * @param float $anzahlSchlafzimmer
	 * @return void
	 */
	public function setAnzahlSchlafzimmer($anzahlSchlafzimmer) {
		$this->anzahlSchlafzimmer = $anzahlSchlafzimmer;
	}

	/**
	 * Returns the anzahlBadezimmer
	 *
	 * @return float $anzahlBadezimmer
	 */
	public function getAnzahlBadezimmer() {
		return $this->anzahlBadezimmer;
	}

	/**
	 * Sets the anzahlBadezimmer
	 *
	 * @param float $anzahlBadezimmer
	 * @return void
	 */
	public function setAnzahlBadezimmer($anzahlBadezimmer) {
		$this->anzahlBadezimmer = $anzahlBadezimmer;
	}

	/**
	 * Returns the anzahlSeparateWc
	 *
	 * @return float $anzahlSeparateWc
	 */
	public function getAnzahlSeparateWc() {
		return $this->anzahlSeparateWc;
	}

	/**
	 * Sets the anzahlSeparateWc
	 *
	 * @param float $anzahlSeparateWc
	 * @return void
	 */
	public function setAnzahlSeparateWc($anzahlSeparateWc) {
		$this->anzahlSeparateWc = $anzahlSeparateWc;
	}

	/**
	 * Returns the balkonTerasseFlaeche
	 *
	 * @return float $balkonTerasseFlaeche
	 */
	public function getBalkonTerasseFlaeche() {
		return $this->balkonTerasseFlaeche;
	}

	/**
	 * Sets the balkonTerasseFlaeche
	 *
	 * @param float $balkonTerasseFlaeche
	 * @return void
	 */
	public function setBalkonTerasseFlaeche($balkonTerasseFlaeche) {
		$this->balkonTerasseFlaeche = $balkonTerasseFlaeche;
	}

	/**
	 * Returns the anzahlWohnSchlafzimmer
	 *
	 * @return float $anzahlWohnSchlafzimmer
	 */
	public function getAnzahlWohnSchlafzimmer() {
		return $this->anzahlWohnSchlafzimmer;
	}

	/**
	 * Sets the anzahlWohnSchlafzimmer
	 *
	 * @param float $anzahlWohnSchlafzimmer
	 * @return void
	 */
	public function setAnzahlWohnSchlafzimmer($anzahlWohnSchlafzimmer) {
		$this->anzahlWohnSchlafzimmer = $anzahlWohnSchlafzimmer;
	}

	/**
	 * Returns the gartenflaeche
	 *
	 * @return float $gartenflaeche
	 */
	public function getGartenflaeche() {
		return $this->gartenflaeche;
	}

	/**
	 * Sets the gartenflaeche
	 *
	 * @param float $gartenflaeche
	 * @return void
	 */
	public function setGartenflaeche($gartenflaeche) {
		$this->gartenflaeche = $gartenflaeche;
	}

	/**
	 * Returns the anzahlBalkone
	 *
	 * @return float $anzahlBalkone
	 */
	public function getAnzahlBalkone() {
		return $this->anzahlBalkone;
	}

	/**
	 * Sets the anzahlBalkone
	 *
	 * @param float $anzahlBalkone
	 * @return void
	 */
	public function setAnzahlBalkone($anzahlBalkone) {
		$this->anzahlBalkone = $anzahlBalkone;
	}

	/**
	 * Returns the anzahlTerassen
	 *
	 * @return float $anzahlTerassen
	 */
	public function getAnzahlTerassen() {
		return $this->anzahlTerassen;
	}

	/**
	 * Sets the anzahlTerassen
	 *
	 * @param float $anzahlTerassen
	 * @return void
	 */
	public function setAnzahlTerassen($anzahlTerassen) {
		$this->anzahlTerassen = $anzahlTerassen;
	}

	/**
	 * Returns the anzahlLogia
	 *
	 * @return float $anzahlLogia
	 */
	public function getAnzahlLogia() {
		return $this->anzahlLogia;
	}

	/**
	 * Sets the anzahlLogia
	 *
	 * @param float $anzahlLogia
	 * @return void
	 */
	public function setAnzahlLogia($anzahlLogia) {
		$this->anzahlLogia = $anzahlLogia;
	}

	/**
	 * Returns the fensterfrontM2
	 *
	 * @return float $fensterfrontM2
	 */
	public function getFensterfrontM2() {
		return $this->fensterfrontM2;
	}

	/**
	 * Sets the fensterfrontM2
	 *
	 * @param float $fensterfrontM2
	 * @return void
	 */
	public function setFensterfrontM2($fensterfrontM2) {
		$this->fensterfrontM2 = $fensterfrontM2;
	}

	/**
	 * Returns the grundstuecksfront
	 *
	 * @return float $grundstuecksfront
	 */
	public function getGrundstuecksfront() {
		return $this->grundstuecksfront;
	}

	/**
	 * Sets the grundstuecksfront
	 *
	 * @param float $grundstuecksfront
	 * @return void
	 */
	public function setGrundstuecksfront($grundstuecksfront) {
		$this->grundstuecksfront = $grundstuecksfront;
	}

	/**
	 * Returns the dachbodenflaeche
	 *
	 * @return float $dachbodenflaeche
	 */
	public function getDachbodenflaeche() {
		return $this->dachbodenflaeche;
	}

	/**
	 * Sets the dachbodenflaeche
	 *
	 * @param float $dachbodenflaeche
	 * @return void
	 */
	public function setDachbodenflaeche($dachbodenflaeche) {
		$this->dachbodenflaeche = $dachbodenflaeche;
	}

	/**
	 * Returns the teilbarAb
	 *
	 * @return float $teilbarAb
	 */
	public function getTeilbarAb() {
		return $this->teilbarAb;
	}

	/**
	 * Sets the teilbarAb
	 *
	 * @param float $teilbarAb
	 * @return void
	 */
	public function setTeilbarAb($teilbarAb) {
		$this->teilbarAb = $teilbarAb;
	}

	/**
	 * Returns the kellerflaeche
	 *
	 * @return float $kellerflaeche
	 */
	public function getKellerflaeche() {
		return $this->kellerflaeche;
	}

	/**
	 * Sets the kellerflaeche
	 *
	 * @param float $kellerflaeche
	 * @return void
	 */
	public function setKellerflaeche($kellerflaeche) {
		$this->kellerflaeche = $kellerflaeche;
	}

	/**
	 * Returns the beheizbareFlaeche
	 *
	 * @return float $beheizbareFlaeche
	 */
	public function getBeheizbareFlaeche() {
		return $this->beheizbareFlaeche;
	}

	/**
	 * Sets the beheizbareFlaeche
	 *
	 * @param float $beheizbareFlaeche
	 * @return void
	 */
	public function setBeheizbareFlaeche($beheizbareFlaeche) {
		$this->beheizbareFlaeche = $beheizbareFlaeche;
	}

	/**
	 * Returns the anzahlStellplaetze
	 *
	 * @return float $anzahlStellplaetze
	 */
	public function getAnzahlStellplaetze() {
		return $this->anzahlStellplaetze;
	}

	/**
	 * Sets the anzahlStellplaetze
	 *
	 * @param float $anzahlStellplaetze
	 * @return void
	 */
	public function setAnzahlStellplaetze($anzahlStellplaetze) {
		$this->anzahlStellplaetze = $anzahlStellplaetze;
	}

	/**
	 * Returns the plaetzeGastraum
	 *
	 * @return float $plaetzeGastraum
	 */
	public function getPlaetzeGastraum() {
		return $this->plaetzeGastraum;
	}

	/**
	 * Sets the plaetzeGastraum
	 *
	 * @param float $plaetzeGastraum
	 * @return void
	 */
	public function setPlaetzeGastraum($plaetzeGastraum) {
		$this->plaetzeGastraum = $plaetzeGastraum;
	}

	/**
	 * Returns the anzahlBetten
	 *
	 * @return float $anzahlBetten
	 */
	public function getAnzahlBetten() {
		return $this->anzahlBetten;
	}

	/**
	 * Sets the anzahlBetten
	 *
	 * @param float $anzahlBetten
	 * @return void
	 */
	public function setAnzahlBetten($anzahlBetten) {
		$this->anzahlBetten = $anzahlBetten;
	}

	/**
	 * Returns the anzahlTagungsraeume
	 *
	 * @return float $anzahlTagungsraeume
	 */
	public function getAnzahlTagungsraeume() {
		return $this->anzahlTagungsraeume;
	}

	/**
	 * Sets the anzahlTagungsraeume
	 *
	 * @param float $anzahlTagungsraeume
	 * @return void
	 */
	public function setAnzahlTagungsraeume($anzahlTagungsraeume) {
		$this->anzahlTagungsraeume = $anzahlTagungsraeume;
	}

	/**
	 * Returns the vermietbareFlaeche
	 *
	 * @return float $vermietbareFlaeche
	 */
	public function getVermietbareFlaeche() {
		return $this->vermietbareFlaeche;
	}

	/**
	 * Sets the vermietbareFlaeche
	 *
	 * @param float $vermietbareFlaeche
	 * @return void
	 */
	public function setVermietbareFlaeche($vermietbareFlaeche) {
		$this->vermietbareFlaeche = $vermietbareFlaeche;
	}

	/**
	 * Returns the anzahlWohneinheiten
	 *
	 * @return float $anzahlWohneinheiten
	 */
	public function getAnzahlWohneinheiten() {
		return $this->anzahlWohneinheiten;
	}

	/**
	 * Sets the anzahlWohneinheiten
	 *
	 * @param float $anzahlWohneinheiten
	 * @return void
	 */
	public function setAnzahlWohneinheiten($anzahlWohneinheiten) {
		$this->anzahlWohneinheiten = $anzahlWohneinheiten;
	}

	/**
	 * Returns the anzahlGewerbeeinheiten
	 *
	 * @return float $anzahlGewerbeeinheiten
	 */
	public function getAnzahlGewerbeeinheiten() {
		return $this->anzahlGewerbeeinheiten;
	}

	/**
	 * Sets the anzahlGewerbeeinheiten
	 *
	 * @param float $anzahlGewerbeeinheiten
	 * @return void
	 */
	public function setAnzahlGewerbeeinheiten($anzahlGewerbeeinheiten) {
		$this->anzahlGewerbeeinheiten = $anzahlGewerbeeinheiten;
	}

	/**
	 * Returns the einliegerwohnung
	 *
	 * @return integer $einliegerwohnung
	 */
	public function getEinliegerwohnung() {
		return $this->einliegerwohnung;
	}

	/**
	 * Sets the einliegerwohnung
	 *
	 * @param integer $einliegerwohnung
	 * @return void
	 */
	public function setEinliegerwohnung($einliegerwohnung) {
		$this->einliegerwohnung = $einliegerwohnung;
	}

	/**
	 * Returns the kubatur
	 *
	 * @return float $kubatur
	 */
	public function getKubatur() {
		return $this->kubatur;
	}

	/**
	 * Sets the kubatur
	 *
	 * @param float $kubatur
	 * @return void
	 */
	public function setKubatur($kubatur) {
		$this->kubatur = $kubatur;
	}

	/**
	 * Returns the ausnuetzungsziffer
	 *
	 * @return float $ausnuetzungsziffer
	 */
	public function getAusnuetzungsziffer() {
		return $this->ausnuetzungsziffer;
	}

	/**
	 * Sets the ausnuetzungsziffer
	 *
	 * @param float $ausnuetzungsziffer
	 * @return void
	 */
	public function setAusnuetzungsziffer($ausnuetzungsziffer) {
		$this->ausnuetzungsziffer = $ausnuetzungsziffer;
	}

	/**
	 * Returns the flaechevon
	 *
	 * @return float $flaechevon
	 */
	public function getFlaechevon() {
		return $this->flaechevon;
	}

	/**
	 * Sets the flaechevon
	 *
	 * @param float $flaechevon
	 * @return void
	 */
	public function setFlaechevon($flaechevon) {
		$this->flaechevon = $flaechevon;
	}

	/**
	 * Returns the flaechebis
	 *
	 * @return float $flaechebis
	 */
	public function getFlaechebis() {
		return $this->flaechebis;
	}

	/**
	 * Sets the flaechebis
	 *
	 * @param float $flaechebis
	 * @return void
	 */
	public function setFlaechebis($flaechebis) {
		$this->flaechebis = $flaechebis;
	}

	/**
	 * Returns the wgGeeignet
	 *
	 * @return integer $wgGeeignet
	 */
	public function getWgGeeignet() {
		return $this->wgGeeignet;
	}

	/**
	 * Sets the wgGeeignet
	 *
	 * @param integer $wgGeeignet
	 * @return void
	 */
	public function setWgGeeignet($wgGeeignet) {
		$this->wgGeeignet = $wgGeeignet;
	}

	/**
	 * Returns the raeumeVeraenderbar
	 *
	 * @return integer $raeumeVeraenderbar
	 */
	public function getRaeumeVeraenderbar() {
		return $this->raeumeVeraenderbar;
	}

	/**
	 * Sets the raeumeVeraenderbar
	 *
	 * @param integer $raeumeVeraenderbar
	 * @return void
	 */
	public function setRaeumeVeraenderbar($raeumeVeraenderbar) {
		$this->raeumeVeraenderbar = $raeumeVeraenderbar;
	}

	/**
	 * Returns the kamin
	 *
	 * @return integer $kamin
	 */
	public function getKamin() {
		return $this->kamin;
	}

	/**
	 * Sets the kamin
	 *
	 * @param integer $kamin
	 * @return void
	 */
	public function setKamin($kamin) {
		$this->kamin = $kamin;
	}

	/**
	 * Returns the klimatisiert
	 *
	 * @return integer $klimatisiert
	 */
	public function getKlimatisiert() {
		return $this->klimatisiert;
	}

	/**
	 * Sets the klimatisiert
	 *
	 * @param integer $klimatisiert
	 * @return void
	 */
	public function setKlimatisiert($klimatisiert) {
		$this->klimatisiert = $klimatisiert;
	}

	/**
	 * Returns the aufzugPersonen
	 *
	 * @return integer $aufzugPersonen
	 */
	public function getAufzugPersonen() {
		return $this->aufzugPersonen;
	}

	/**
	 * Sets the aufzugPersonen
	 *
	 * @param integer $aufzugPersonen
	 * @return void
	 */
	public function setAufzugPersonen($aufzugPersonen) {
		$this->aufzugPersonen = $aufzugPersonen;
	}

	/**
	 * Returns the aufzugLasten
	 *
	 * @return integer $aufzugLasten
	 */
	public function getAufzugLasten() {
		return $this->aufzugLasten;
	}

	/**
	 * Sets the aufzugLasten
	 *
	 * @param integer $aufzugLasten
	 * @return void
	 */
	public function setAufzugLasten($aufzugLasten) {
		$this->aufzugLasten = $aufzugLasten;
	}

	/**
	 * Returns the gartennutzung
	 *
	 * @return integer $gartennutzung
	 */
	public function getGartennutzung() {
		return $this->gartennutzung;
	}

	/**
	 * Sets the gartennutzung
	 *
	 * @param integer $gartennutzung
	 * @return void
	 */
	public function setGartennutzung($gartennutzung) {
		$this->gartennutzung = $gartennutzung;
	}

	/**
	 * Returns the moebliert
	 *
	 * @return integer $moebliert
	 */
	public function getMoebliert() {
		return $this->moebliert;
	}

	/**
	 * Sets the moebliert
	 *
	 * @param integer $moebliert
	 * @return void
	 */
	public function setMoebliert($moebliert) {
		$this->moebliert = $moebliert;
	}

	/**
	 * Returns the rollstuhlgerecht
	 *
	 * @return integer $rollstuhlgerecht
	 */
	public function getRollstuhlgerecht() {
		return $this->rollstuhlgerecht;
	}

	/**
	 * Sets the rollstuhlgerecht
	 *
	 * @param integer $rollstuhlgerecht
	 * @return void
	 */
	public function setRollstuhlgerecht($rollstuhlgerecht) {
		$this->rollstuhlgerecht = $rollstuhlgerecht;
	}

	/**
	 * Returns the kabelSatTv
	 *
	 * @return integer $kabelSatTv
	 */
	public function getKabelSatTv() {
		return $this->kabelSatTv;
	}

	/**
	 * Sets the kabelSatTv
	 *
	 * @param integer $kabelSatTv
	 * @return void
	 */
	public function setKabelSatTv($kabelSatTv) {
		$this->kabelSatTv = $kabelSatTv;
	}

    /**
     * @return int
     */
    public function getKabelfernsehen()
    {
        return $this->kabelfernsehen;
    }

    /**
     * @param int $kabelfernsehen
     */
    public function setKabelfernsehen($kabelfernsehen)
    {
        $this->kabelfernsehen = $kabelfernsehen;
    }

    /**
     * @return int
     */
    public function getSatellitenfernsehen()
    {
        return $this->satellitenfernsehen;
    }

    /**
     * @param int $satellitenfernsehen
     */
    public function setSatellitenfernsehen($satellitenfernsehen)
    {
        $this->satellitenfernsehen = $satellitenfernsehen;
    }

	/**
	 * Returns the dvbt
	 *
	 * @return integer $dvbt
	 */
	public function getDvbt() {
		return $this->dvbt;
	}

	/**
	 * Sets the dvbt
	 *
	 * @param integer $dvbt
	 * @return void
	 */
	public function setDvbt($dvbt) {
		$this->dvbt = $dvbt;
	}

	/**
	 * Returns the barrierefrei
	 *
	 * @return integer $barrierefrei
	 */
	public function getBarrierefrei() {
		return $this->barrierefrei;
	}

	/**
	 * Sets the barrierefrei
	 *
	 * @param integer $barrierefrei
	 * @return void
	 */
	public function setBarrierefrei($barrierefrei) {
		$this->barrierefrei = $barrierefrei;
	}

	/**
	 * Returns the sauna
	 *
	 * @return integer $sauna
	 */
	public function getSauna() {
		return $this->sauna;
	}

	/**
	 * Sets the sauna
	 *
	 * @param integer $sauna
	 * @return void
	 */
	public function setSauna($sauna) {
		$this->sauna = $sauna;
	}

	/**
	 * Returns the swimmingpool
	 *
	 * @return integer $swimmingpool
	 */
	public function getSwimmingpool() {
		return $this->swimmingpool;
	}

	/**
	 * Sets the swimmingpool
	 *
	 * @param integer $swimmingpool
	 * @return void
	 */
	public function setSwimmingpool($swimmingpool) {
		$this->swimmingpool = $swimmingpool;
	}

	/**
	 * Returns the waschTrockenraum
	 *
	 * @return integer $waschTrockenraum
	 */
	public function getWaschTrockenraum() {
		return $this->waschTrockenraum;
	}

	/**
	 * Sets the waschTrockenraum
	 *
	 * @param integer $waschTrockenraum
	 * @return void
	 */
	public function setWaschTrockenraum($waschTrockenraum) {
		$this->waschTrockenraum = $waschTrockenraum;
	}

	/**
	 * Returns the wintergarten
	 *
	 * @return integer $wintergarten
	 */
	public function getWintergarten() {
		return $this->wintergarten;
	}

	/**
	 * Sets the wintergarten
	 *
	 * @param integer $wintergarten
	 * @return void
	 */
	public function setWintergarten($wintergarten) {
		$this->wintergarten = $wintergarten;
	}

	/**
	 * Returns the dvVerkabelung
	 *
	 * @return integer $dvVerkabelung
	 */
	public function getDvVerkabelung() {
		return $this->dvVerkabelung;
	}

	/**
	 * Sets the dvVerkabelung
	 *
	 * @param integer $dvVerkabelung
	 * @return void
	 */
	public function setDvVerkabelung($dvVerkabelung) {
		$this->dvVerkabelung = $dvVerkabelung;
	}

	/**
	 * Returns the rampe
	 *
	 * @return integer $rampe
	 */
	public function getRampe() {
		return $this->rampe;
	}

	/**
	 * Sets the rampe
	 *
	 * @param integer $rampe
	 * @return void
	 */
	public function setRampe($rampe) {
		$this->rampe = $rampe;
	}

	/**
	 * Returns the hebebuehne
	 *
	 * @return integer $hebebuehne
	 */
	public function getHebebuehne() {
		return $this->hebebuehne;
	}

	/**
	 * Sets the hebebuehne
	 *
	 * @param integer $hebebuehne
	 * @return void
	 */
	public function setHebebuehne($hebebuehne) {
		$this->hebebuehne = $hebebuehne;
	}

	/**
	 * Returns the kran
	 *
	 * @return integer $kran
	 */
	public function getKran() {
		return $this->kran;
	}

	/**
	 * Sets the kran
	 *
	 * @param integer $kran
	 * @return void
	 */
	public function setKran($kran) {
		$this->kran = $kran;
	}

	/**
	 * Returns the gastterrasse
	 *
	 * @return integer $gastterrasse
	 */
	public function getGastterrasse() {
		return $this->gastterrasse;
	}

	/**
	 * Sets the gastterrasse
	 *
	 * @param integer $gastterrasse
	 * @return void
	 */
	public function setGastterrasse($gastterrasse) {
		$this->gastterrasse = $gastterrasse;
	}

	/**
	 * Returns the stromanschlusswert
	 *
	 * @return float $stromanschlusswert
	 */
	public function getStromanschlusswert() {
		return $this->stromanschlusswert;
	}

	/**
	 * Sets the stromanschlusswert
	 *
	 * @param float $stromanschlusswert
	 * @return void
	 */
	public function setStromanschlusswert($stromanschlusswert) {
		$this->stromanschlusswert = $stromanschlusswert;
	}

	/**
	 * Returns the katineCafeteria
	 *
	 * @return integer $katineCafeteria
	 */
	public function getKatineCafeteria() {
		return $this->katineCafeteria;
	}

	/**
	 * Sets the katineCafeteria
	 *
	 * @param integer $katineCafeteria
	 * @return void
	 */
	public function setKatineCafeteria($katineCafeteria) {
		$this->katineCafeteria = $katineCafeteria;
	}

	/**
	 * Returns the teekueche
	 *
	 * @return integer $teekueche
	 */
	public function getTeekueche() {
		return $this->teekueche;
	}

	/**
	 * Sets the teekueche
	 *
	 * @param integer $teekueche
	 * @return void
	 */
	public function setTeekueche($teekueche) {
		$this->teekueche = $teekueche;
	}

	/**
	 * Returns the hallenhoehe
	 *
	 * @return float $hallenhoehe
	 */
	public function getHallenhoehe() {
		return $this->hallenhoehe;
	}

	/**
	 * Sets the hallenhoehe
	 *
	 * @param float $hallenhoehe
	 * @return void
	 */
	public function setHallenhoehe($hallenhoehe) {
		$this->hallenhoehe = $hallenhoehe;
	}

	/**
	 * Returns the hotelrestaurantAngeschlossen
	 *
	 * @return integer $hotelrestaurantAngeschlossen
	 */
	public function getHotelrestaurantAngeschlossen() {
		return $this->hotelrestaurantAngeschlossen;
	}

	/**
	 * Sets the hotelrestaurantAngeschlossen
	 *
	 * @param integer $hotelrestaurantAngeschlossen
	 * @return void
	 */
	public function setHotelrestaurantAngeschlossen($hotelrestaurantAngeschlossen) {
		$this->hotelrestaurantAngeschlossen = $hotelrestaurantAngeschlossen;
	}

	/**
	 * Returns the barAngeschlossen
	 *
	 * @return integer $barAngeschlossen
	 */
	public function getBarAngeschlossen() {
		return $this->barAngeschlossen;
	}

	/**
	 * Sets the barAngeschlossen
	 *
	 * @param integer $barAngeschlossen
	 * @return void
	 */
	public function setBarAngeschlossen($barAngeschlossen) {
		$this->barAngeschlossen = $barAngeschlossen;
	}

	/**
	 * Returns the brauereibindung
	 *
	 * @return integer $brauereibindung
	 */
	public function getBrauereibindung() {
		return $this->brauereibindung;
	}

	/**
	 * Sets the brauereibindung
	 *
	 * @param integer $brauereibindung
	 * @return void
	 */
	public function setBrauereibindung($brauereibindung) {
		$this->brauereibindung = $brauereibindung;
	}

	/**
	 * Returns the sporteinrichtungen
	 *
	 * @return integer $sporteinrichtungen
	 */
	public function getSporteinrichtungen() {
		return $this->sporteinrichtungen;
	}

	/**
	 * Sets the sporteinrichtungen
	 *
	 * @param integer $sporteinrichtungen
	 * @return void
	 */
	public function setSporteinrichtungen($sporteinrichtungen) {
		$this->sporteinrichtungen = $sporteinrichtungen;
	}

	/**
	 * Returns the wellnessbereich
	 *
	 * @return integer $wellnessbereich
	 */
	public function getWellnessbereich() {
		return $this->wellnessbereich;
	}

	/**
	 * Sets the wellnessbereich
	 *
	 * @param integer $wellnessbereich
	 * @return void
	 */
	public function setWellnessbereich($wellnessbereich) {
		$this->wellnessbereich = $wellnessbereich;
	}

	/**
	 * Returns the serviceBetreutesWohnen
	 *
	 * @return integer $serviceBetreutesWohnen
	 */
	public function getServiceBetreutesWohnen() {
		return $this->serviceBetreutesWohnen;
	}

	/**
	 * Sets the serviceBetreutesWohnen
	 *
	 * @param integer $serviceBetreutesWohnen
	 * @return void
	 */
	public function setServiceBetreutesWohnen($serviceBetreutesWohnen) {
		$this->serviceBetreutesWohnen = $serviceBetreutesWohnen;
	}

	/**
	 * Returns the serviceCatering
	 *
	 * @return integer $serviceCatering
	 */
	public function getServiceCatering() {
		return $this->serviceCatering;
	}

	/**
	 * Sets the serviceCatering
	 *
	 * @param integer $serviceCatering
	 * @return void
	 */
	public function setServiceCatering($serviceCatering) {
		$this->serviceCatering = $serviceCatering;
	}

	/**
	 * Returns the serviceReinigung
	 *
	 * @return integer $serviceReinigung
	 */
	public function getServiceReinigung() {
		return $this->serviceReinigung;
	}

	/**
	 * Sets the serviceReinigung
	 *
	 * @param integer $serviceReinigung
	 * @return void
	 */
	public function setServiceReinigung($serviceReinigung) {
		$this->serviceReinigung = $serviceReinigung;
	}

	/**
	 * Returns the serviceEinkauf
	 *
	 * @return integer $serviceEinkauf
	 */
	public function getServiceEinkauf() {
		return $this->serviceEinkauf;
	}

	/**
	 * Sets the serviceEinkauf
	 *
	 * @param integer $serviceEinkauf
	 * @return void
	 */
	public function setServiceEinkauf($serviceEinkauf) {
		$this->serviceEinkauf = $serviceEinkauf;
	}

	/**
	 * Returns the serviceWachdienst
	 *
	 * @return integer $serviceWachdienst
	 */
	public function getServiceWachdienst() {
		return $this->serviceWachdienst;
	}

	/**
	 * Sets the serviceWachdienst
	 *
	 * @param integer $serviceWachdienst
	 * @return void
	 */
	public function setServiceWachdienst($serviceWachdienst) {
		$this->serviceWachdienst = $serviceWachdienst;
	}

	/**
	 * Returns the telefonFerienimmobilie
	 *
	 * @return integer $telefonFerienimmobilie
	 */
	public function getTelefonFerienimmobilie() {
		return $this->telefonFerienimmobilie;
	}

	/**
	 * Sets the telefonFerienimmobilie
	 *
	 * @param integer $telefonFerienimmobilie
	 * @return void
	 */
	public function setTelefonFerienimmobilie($telefonFerienimmobilie) {
		$this->telefonFerienimmobilie = $telefonFerienimmobilie;
	}

	/**
	 * Returns the breitbandZugangArt
	 *
	 * @return string $breitbandZugangArt
	 */
	public function getBreitbandZugangArt() {
		return $this->breitbandZugangArt;
	}

	/**
	 * Sets the breitbandZugangArt
	 *
	 * @param string $breitbandZugangArt
	 * @return void
	 */
	public function setBreitbandZugangArt($breitbandZugangArt) {
		$this->breitbandZugangArt = $breitbandZugangArt;
	}

	/**
	 * Returns the breitbandZugangSpeed
	 *
	 * @return float $breitbandZugangSpeed
	 */
	public function getBreitbandZugangSpeed() {
		return $this->breitbandZugangSpeed;
	}

	/**
	 * Sets the breitbandZugangSpeed
	 *
	 * @param float $breitbandZugangSpeed
	 * @return void
	 */
	public function setBreitbandZugangSpeed($breitbandZugangSpeed) {
		$this->breitbandZugangSpeed = $breitbandZugangSpeed;
	}

	/**
	 * Returns the umtsEmpfang
	 *
	 * @return integer $umtsEmpfang
	 */
	public function getUmtsEmpfang() {
		return $this->umtsEmpfang;
	}

	/**
	 * Sets the umtsEmpfang
	 *
	 * @param integer $umtsEmpfang
	 * @return void
	 */
	public function setUmtsEmpfang($umtsEmpfang) {
		$this->umtsEmpfang = $umtsEmpfang;
	}

	/**
	 * Returns the sicherheitAlarmanlage
	 *
	 * @return integer $sicherheitAlarmanlage
	 */
	public function getSicherheitAlarmanlage() {
		return $this->sicherheitAlarmanlage;
	}

	/**
	 * Sets the sicherheitAlarmanlage
	 *
	 * @param integer $sicherheitAlarmanlage
	 * @return void
	 */
	public function setSicherheitAlarmanlage($sicherheitAlarmanlage) {
		$this->sicherheitAlarmanlage = $sicherheitAlarmanlage;
	}

	/**
	 * Returns the sicherheitKamera
	 *
	 * @return integer $sicherheitKamera
	 */
	public function getSicherheitKamera() {
		return $this->sicherheitKamera;
	}

	/**
	 * Sets the sicherheitKamera
	 *
	 * @param integer $sicherheitKamera
	 * @return void
	 */
	public function setSicherheitKamera($sicherheitKamera) {
		$this->sicherheitKamera = $sicherheitKamera;
	}

	/**
	 * Returns the sicherheitPolizeiruf
	 *
	 * @return integer $sicherheitPolizeiruf
	 */
	public function getSicherheitPolizeiruf() {
		return $this->sicherheitPolizeiruf;
	}

	/**
	 * Sets the sicherheitPolizeiruf
	 *
	 * @param integer $sicherheitPolizeiruf
	 * @return void
	 */
	public function setSicherheitPolizeiruf($sicherheitPolizeiruf) {
		$this->sicherheitPolizeiruf = $sicherheitPolizeiruf;
	}

	/**
	 * Returns the unterkellert
	 *
	 * @return integer $unterkellert
	 */
	public function getUnterkellert() {
		return $this->unterkellert;
	}

	/**
	 * Sets the unterkellert
	 *
	 * @param integer $unterkellert
	 * @return void
	 */
	public function setUnterkellert($unterkellert) {
		$this->unterkellert = $unterkellert;
	}

	/**
	 * Returns the abstellraum
	 *
	 * @return integer $abstellraum
	 */
	public function getAbstellraum() {
		return $this->abstellraum;
	}

	/**
	 * Sets the abstellraum
	 *
	 * @param integer $abstellraum
	 * @return void
	 */
	public function setAbstellraum($abstellraum) {
		$this->abstellraum = $abstellraum;
	}

	/**
	 * Returns the fahrradraum
	 *
	 * @return integer $fahrradraum
	 */
	public function getFahrradraum() {
		return $this->fahrradraum;
	}

	/**
	 * Sets the fahrradraum
	 *
	 * @param integer $fahrradraum
	 * @return void
	 */
	public function setFahrradraum($fahrradraum) {
		$this->fahrradraum = $fahrradraum;
	}

	/**
	 * Returns the rolladen
	 *
	 * @return integer $rolladen
	 */
	public function getRolladen() {
		return $this->rolladen;
	}

	/**
	 * Sets the rolladen
	 *
	 * @param integer $rolladen
	 * @return void
	 */
	public function setRolladen($rolladen) {
		$this->rolladen = $rolladen;
	}

	/**
	 * Returns the bibliothek
	 *
	 * @return integer $bibliothek
	 */
	public function getBibliothek() {
		return $this->bibliothek;
	}

	/**
	 * Sets the bibliothek
	 *
	 * @param integer $bibliothek
	 * @return void
	 */
	public function setBibliothek($bibliothek) {
		$this->bibliothek = $bibliothek;
	}

	/**
	 * Returns the dachboden
	 *
	 * @return integer $dachboden
	 */
	public function getDachboden() {
		return $this->dachboden;
	}

	/**
	 * Sets the dachboden
	 *
	 * @param integer $dachboden
	 * @return void
	 */
	public function setDachboden($dachboden) {
		$this->dachboden = $dachboden;
	}

	/**
	 * Returns the gaestewc
	 *
	 * @return integer $gaestewc
	 */
	public function getGaestewc() {
		return $this->gaestewc;
	}

	/**
	 * Sets the gaestewc
	 *
	 * @param integer $gaestewc
	 * @return void
	 */
	public function setGaestewc($gaestewc) {
		$this->gaestewc = $gaestewc;
	}

	/**
	 * Returns the kabelkanaele
	 *
	 * @return integer $kabelkanaele
	 */
	public function getKabelkanaele() {
		return $this->kabelkanaele;
	}

	/**
	 * Sets the kabelkanaele
	 *
	 * @param integer $kabelkanaele
	 * @return void
	 */
	public function setKabelkanaele($kabelkanaele) {
		$this->kabelkanaele = $kabelkanaele;
	}

	/**
	 * Returns the seniorengerecht
	 *
	 * @return integer $seniorengerecht
	 */
	public function getSeniorengerecht() {
		return $this->seniorengerecht;
	}

	/**
	 * Sets the seniorengerecht
	 *
	 * @param integer $seniorengerecht
	 * @return void
	 */
	public function setSeniorengerecht($seniorengerecht) {
		$this->seniorengerecht = $seniorengerecht;
	}

	/**
	 * Returns the baujahr
	 *
	 * @return string $baujahr
	 */
	public function getBaujahr() {
		return $this->baujahr;
	}

	/**
	 * Sets the baujahr
	 *
	 * @param string $baujahr
	 * @return void
	 */
	public function setBaujahr($baujahr) {
		$this->baujahr = $baujahr;
	}

	/**
	 * Returns the letztemodernisierung
	 *
	 * @return string $letztemodernisierung
	 */
	public function getLetztemodernisierung() {
		return $this->letztemodernisierung;
	}

	/**
	 * Sets the letztemodernisierung
	 *
	 * @param string $letztemodernisierung
	 * @return void
	 */
	public function setLetztemodernisierung($letztemodernisierung) {
		$this->letztemodernisierung = $letztemodernisierung;
	}

	/**
	 * Returns the altertyp
	 *
	 * @return integer $altertyp
	 */
	public function getAltertyp() {
		return $this->altertyp;
	}

	/**
	 * Sets the altertyp
	 *
	 * @param integer $altertyp
	 * @return void
	 */
	public function setAltertyp($altertyp) {
		$this->altertyp = $altertyp;
	}

	/**
	 * Returns the bauzone
	 *
	 * @return string $bauzone
	 */
	public function getBauzone() {
		return $this->bauzone;
	}

	/**
	 * Sets the bauzone
	 *
	 * @param string $bauzone
	 * @return void
	 */
	public function setBauzone($bauzone) {
		$this->bauzone = $bauzone;
	}

	/**
	 * Returns the altlasten
	 *
	 * @return string $altlasten
	 */
	public function getAltlasten() {
		return $this->altlasten;
	}

	/**
	 * Sets the altlasten
	 *
	 * @param string $altlasten
	 * @return void
	 */
	public function setAltlasten($altlasten) {
		$this->altlasten = $altlasten;
	}

    /**
     * @param \SG\SgEstateCore\Domain\Model\Energiepassart $energiepassArt
     */
    public function setEnergiepassArt($energiepassArt)
    {
        $this->energiepassArt = $energiepassArt;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Energiepassart
     */
    public function getEnergiepassArt()
    {
        return $this->energiepassArt;
    }



	/**
	 * Returns the energiepassGueltigBis
	 *
	 * @return string $energiepassGueltigBis
	 */
	public function getEnergiepassGueltigBis() {
		return $this->energiepassGueltigBis;
	}

	/**
	 * Sets the energiepassGueltigBis
	 *
	 * @param string $energiepassGueltigBis
	 * @return void
	 */
	public function setEnergiepassGueltigBis($energiepassGueltigBis) {
		$this->energiepassGueltigBis = $energiepassGueltigBis;
	}

	/**
	 * Returns the energiepassEnergieverbrauchkennwert
	 *
	 * @return string $energiepassEnergieverbrauchkennwert
	 */
	public function getEnergiepassEnergieverbrauchkennwert() {
		return $this->energiepassEnergieverbrauchkennwert;
	}

	/**
	 * Sets the energiepassEnergieverbrauchkennwert
	 *
	 * @param string $energiepassEnergieverbrauchkennwert
	 * @return void
	 */
	public function setEnergiepassEnergieverbrauchkennwert($energiepassEnergieverbrauchkennwert) {
		$this->energiepassEnergieverbrauchkennwert = $energiepassEnergieverbrauchkennwert;
	}

	/**
	 * Returns the energiepassMitwarmwasser
	 *
	 * @return integer $energiepassMitwarmwasser
	 */
	public function getEnergiepassMitwarmwasser() {
		return $this->energiepassMitwarmwasser;
	}

	/**
	 * Sets the energiepassMitwarmwasser
	 *
	 * @param integer $energiepassMitwarmwasser
	 * @return void
	 */
	public function setEnergiepassMitwarmwasser($energiepassMitwarmwasser) {
		$this->energiepassMitwarmwasser = $energiepassMitwarmwasser;
	}

	/**
	 * Returns the energiepassEndenergiebedarf
	 *
	 * @return string $energiepassEndenergiebedarf
	 */
	public function getEnergiepassEndenergiebedarf() {
		return $this->energiepassEndenergiebedarf;
	}

	/**
	 * Sets the energiepassEndenergiebedarf
	 *
	 * @param string $energiepassEndenergiebedarf
	 * @return void
	 */
	public function setEnergiepassEndenergiebedarf($energiepassEndenergiebedarf) {
		$this->energiepassEndenergiebedarf = $energiepassEndenergiebedarf;
	}

    /**
     * @param \DateTime $energiepassAusstelldatum
     */
    public function setEnergiepassAusstelldatum($energiepassAusstelldatum)
    {
        $this->energiepassAusstelldatum = $energiepassAusstelldatum;
    }

    /**
     * @return \DateTime
     */
    public function getEnergiepassAusstelldatum()
    {
        return $this->energiepassAusstelldatum;
    }

    /**
     * @param string $energiepassBaujahr
     */
    public function setEnergiepassBaujahr($energiepassBaujahr)
    {
        $this->energiepassBaujahr = $energiepassBaujahr;
    }

    /**
     * @return string
     */
    public function getEnergiepassBaujahr()
    {
        return $this->energiepassBaujahr;
    }

    /**
     * @param string $energiepassEpasstext
     */
    public function setEnergiepassEpasstext($energiepassEpasstext)
    {
        $this->energiepassEpasstext = $energiepassEpasstext;
    }

    /**
     * @return string
     */
    public function getEnergiepassEpasstext()
    {
        return $this->energiepassEpasstext;
    }

    /**
     * @param string $energiepassFgeeklasse
     */
    public function setEnergiepassFgeeklasse($energiepassFgeeklasse)
    {
        $this->energiepassFgeeklasse = $energiepassFgeeklasse;
    }

    /**
     * @return string
     */
    public function getEnergiepassFgeeklasse()
    {
        return $this->energiepassFgeeklasse;
    }

    /**
     * @param string $energiepassFgeewert
     */
    public function setEnergiepassFgeewert($energiepassFgeewert)
    {
        $this->energiepassFgeewert = $energiepassFgeewert;
    }

    /**
     * @return string
     */
    public function getEnergiepassFgeewert()
    {
        return $this->energiepassFgeewert;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart $energiepassGebaeudeart
     */
    public function setEnergiepassGebaeudeart($energiepassGebaeudeart)
    {
        $this->energiepassGebaeudeart = $energiepassGebaeudeart;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart
     */
    public function getEnergiepassGebaeudeart()
    {
        return $this->energiepassGebaeudeart;
    }

    /**
     * @param string $energiepassHwbklasse
     */
    public function setEnergiepassHwbklasse($energiepassHwbklasse)
    {
        $this->energiepassHwbklasse = $energiepassHwbklasse;
    }

    /**
     * @return string
     */
    public function getEnergiepassHwbklasse()
    {
        return $this->energiepassHwbklasse;
    }

    /**
     * @param string $energiepassHwbwert
     */
    public function setEnergiepassHwbwert($energiepassHwbwert)
    {
        $this->energiepassHwbwert = $energiepassHwbwert;
    }

    /**
     * @return string
     */
    public function getEnergiepassHwbwert()
    {
        return $this->energiepassHwbwert;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Energiepassjahrgang $energiepassJahrgang
     */
    public function setEnergiepassJahrgang($energiepassJahrgang)
    {
        $this->energiepassJahrgang = $energiepassJahrgang;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Energiepassjahrgang
     */
    public function getEnergiepassJahrgang()
    {
        return $this->energiepassJahrgang;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Befeuerungsart $energiepassPrimaerenergietraeger
     */
    public function setEnergiepassPrimaerenergietraeger($energiepassPrimaerenergietraeger)
    {
        $this->energiepassPrimaerenergietraeger = $energiepassPrimaerenergietraeger;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Befeuerungsart
     */
    public function getEnergiepassPrimaerenergietraeger()
    {
        return $this->energiepassPrimaerenergietraeger;
    }

    /**
     * @param string $energiepassStromwert
     */
    public function setEnergiepassStromwert($energiepassStromwert)
    {
        $this->energiepassStromwert = $energiepassStromwert;
    }

    /**
     * @return string
     */
    public function getEnergiepassStromwert()
    {
        return $this->energiepassStromwert;
    }

    /**
     * @param string $energiepassWaermewert
     */
    public function setEnergiepassWaermewert($energiepassWaermewert)
    {
        $this->energiepassWaermewert = $energiepassWaermewert;
    }

    /**
     * @return string
     */
    public function getEnergiepassWaermewert()
    {
        return $this->energiepassWaermewert;
    }

    /**
     * @param string $energiepassWertklasse
     */
    public function setEnergiepassWertklasse($energiepassWertklasse)
    {
        $this->energiepassWertklasse = $energiepassWertklasse;
    }

    /**
     * @return string
     */
    public function getEnergiepassWertklasse()
    {
        return $this->energiepassWertklasse;
    }



	/**
	 * Returns the verkaufstatus
	 *
	 * @return integer $verkaufstatus
	 */
	public function getVerkaufstatus() {
		return $this->verkaufstatus;
	}

	/**
	 * Sets the verkaufstatus
	 *
	 * @param integer $verkaufstatus
	 * @return void
	 */
	public function setVerkaufstatus($verkaufstatus) {
		$this->verkaufstatus = $verkaufstatus;
	}

	/**
	 * Returns the zulieferung
	 *
	 * @return integer $zulieferung
	 */
	public function getZulieferung() {
		return $this->zulieferung;
	}

	/**
	 * Sets the zulieferung
	 *
	 * @param integer $zulieferung
	 * @return void
	 */
	public function setZulieferung($zulieferung) {
		$this->zulieferung = $zulieferung;
	}

	/**
	 * Returns the ausblick
	 *
	 * @return integer $ausblick
	 */
	public function getAusblick() {
		return $this->ausblick;
	}

	/**
	 * Sets the ausblick
	 *
	 * @param integer $ausblick
	 * @return void
	 */
	public function setAusblick($ausblick) {
		$this->ausblick = $ausblick;
	}

	/**
	 * Returns the objekttitel
	 *
	 * @return string $objekttitel
	 */
	public function getObjekttitel() {
		return $this->objekttitel;
	}

	/**
	 * Sets the objekttitel
	 *
	 * @param string $objekttitel
	 * @return void
	 */
	public function setObjekttitel($objekttitel) {
		$this->objekttitel = $objekttitel;
	}

	/**
	 * Returns the kurzbeschreibung
	 *
	 * @return string $kurzbeschreibung
	 */
	public function getKurzbeschreibung() {
		return $this->kurzbeschreibung;
	}

	/**
	 * Sets the kurzbeschreibung
	 *
	 * @param string $kurzbeschreibung
	 * @return void
	 */
	public function setKurzbeschreibung($kurzbeschreibung) {
		$this->kurzbeschreibung = $kurzbeschreibung;
	}

	/**
	 * Returns the lage
	 *
	 * @return string $lage
	 */
	public function getLage() {
		return $this->lage;
	}

	/**
	 * Sets the lage
	 *
	 * @param string $lage
	 * @return void
	 */
	public function setLage($lage) {
		$this->lage = $lage;
	}

	/**
	 * Returns the austattungsbeschreibung
	 *
	 * @return string $austattungsbeschreibung
	 */
	public function getAustattungsbeschreibung() {
		return $this->austattungsbeschreibung;
	}

	/**
	 * Sets the austattungsbeschreibung
	 *
	 * @param string $austattungsbeschreibung
	 * @return void
	 */
	public function setAustattungsbeschreibung($austattungsbeschreibung) {
		$this->austattungsbeschreibung = $austattungsbeschreibung;
	}

	/**
	 * Returns the objektbeschreibung
	 *
	 * @return string $objektbeschreibung
	 */
	public function getObjektbeschreibung() {
		return $this->objektbeschreibung;
	}

	/**
	 * Sets the objektbeschreibung
	 *
	 * @param string $objektbeschreibung
	 * @return void
	 */
	public function setObjektbeschreibung($objektbeschreibung) {
		$this->objektbeschreibung = $objektbeschreibung;
	}

	/**
	 * Returns the sonstigeAngaben
	 *
	 * @return string $sonstigeAngaben
	 */
	public function getSonstigeAngaben() {
		return $this->sonstigeAngaben;
	}

	/**
	 * Sets the sonstigeAngaben
	 *
	 * @param string $sonstigeAngaben
	 * @return void
	 */
	public function setSonstigeAngaben($sonstigeAngaben) {
		$this->sonstigeAngaben = $sonstigeAngaben;
	}

	/**
	 * Returns the objektadresseFreigeben
	 *
	 * @return boolean $objektadresseFreigeben
	 */
	public function getObjektadresseFreigeben() {
		return $this->objektadresseFreigeben;
	}

	/**
	 * Sets the objektadresseFreigeben
	 *
	 * @param boolean $objektadresseFreigeben
	 * @return void
	 */
	public function setObjektadresseFreigeben($objektadresseFreigeben) {
		$this->objektadresseFreigeben = $objektadresseFreigeben;
	}

	/**
	 * Returns the boolean state of objektadresseFreigeben
	 *
	 * @return boolean
	 */
	public function isObjektadresseFreigeben() {
		return $this->objektadresseFreigeben;
	}

	/**
	 * Returns the verfuegbarAb
	 *
	 * @return string $verfuegbarAb
	 */
	public function getVerfuegbarAb() {
		return $this->verfuegbarAb;
	}

	/**
	 * Sets the verfuegbarAb
	 *
	 * @param string $verfuegbarAb
	 * @return void
	 */
	public function setVerfuegbarAb($verfuegbarAb) {
		$this->verfuegbarAb = $verfuegbarAb;
	}

	/**
	 * Returns the verfuegbarAbDatum
	 *
	 * @return \DateTime $verfuegbarAbDatum
	 */
	public function getVerfuegbarAbDatum() {
		return $this->verfuegbarAbDatum;
	}

	/**
	 * Sets the verfuegbarAbDatum
	 *
	 * @param \DateTime $verfuegbarAbDatum
	 * @return void
	 */
	public function setVerfuegbarAbDatum(\DateTime $verfuegbarAbDatum) {
		$this->verfuegbarAbDatum = $verfuegbarAbDatum;
	}

	/**
	 * Returns the verfuegbarBisDatum
	 *
	 * @return \DateTime $verfuegbarBisDatum
	 */
	public function getVerfuegbarBisDatum() {
		return $this->verfuegbarBisDatum;
	}

	/**
	 * Sets the verfuegbarBisDatum
	 *
	 * @param \DateTime $verfuegbarBisDatum
	 * @return void
	 */
	public function setVerfuegbarBisDatum(\DateTime $verfuegbarBisDatum) {
		$this->verfuegbarBisDatum = $verfuegbarBisDatum;
	}

	/**
	 * Returns the versteigerungstermin
	 *
	 * @return \DateTime $versteigerungstermin
	 */
	public function getVersteigerungstermin() {
		return $this->versteigerungstermin;
	}

	/**
	 * Sets the versteigerungstermin
	 *
	 * @param \DateTime $versteigerungstermin
	 * @return void
	 */
	public function setVersteigerungstermin(\DateTime $versteigerungstermin) {
		$this->versteigerungstermin = $versteigerungstermin;
	}

	/**
	 * Returns the wbsErforderlich
	 *
	 * @return integer $wbsErforderlich
	 */
	public function getWbsErforderlich() {
		return $this->wbsErforderlich;
	}

	/**
	 * Sets the wbsErforderlich
	 *
	 * @param integer $wbsErforderlich
	 * @return void
	 */
	public function setWbsErforderlich($wbsErforderlich) {
		$this->wbsErforderlich = $wbsErforderlich;
	}

	/**
	 * Returns the vermietet
	 *
	 * @return integer $vermietet
	 */
	public function getVermietet() {
		return $this->vermietet;
	}

	/**
	 * Sets the vermietet
	 *
	 * @param integer $vermietet
	 * @return void
	 */
	public function setVermietet($vermietet) {
		$this->vermietet = $vermietet;
	}

	/**
	 * Returns the gruppennummer
	 *
	 * @return string $gruppennummer
	 */
	public function getGruppennummer() {
		return $this->gruppennummer;
	}

	/**
	 * Sets the gruppennummer
	 *
	 * @param string $gruppennummer
	 * @return void
	 */
	public function setGruppennummer($gruppennummer) {
		$this->gruppennummer = $gruppennummer;
	}

	/**
	 * Returns the zugang
	 *
	 * @return string $zugang
	 */
	public function getZugang() {
		return $this->zugang;
	}

	/**
	 * Sets the zugang
	 *
	 * @param string $zugang
	 * @return void
	 */
	public function setZugang($zugang) {
		$this->zugang = $zugang;
	}

	/**
	 * Returns the laufzeit
	 *
	 * @return float $laufzeit
	 */
	public function getLaufzeit() {
		return $this->laufzeit;
	}

	/**
	 * Sets the laufzeit
	 *
	 * @param float $laufzeit
	 * @return void
	 */
	public function setLaufzeit($laufzeit) {
		$this->laufzeit = $laufzeit;
	}

	/**
	 * Returns the maximalePersonenanzahl
	 *
	 * @return integer $maximalePersonenanzahl
	 */
	public function getMaximalePersonenanzahl() {
		return $this->maximalePersonenanzahl;
	}

	/**
	 * Sets the maximalePersonenanzahl
	 *
	 * @param integer $maximalePersonenanzahl
	 * @return void
	 */
	public function setMaximalePersonenanzahl($maximalePersonenanzahl) {
		$this->maximalePersonenanzahl = $maximalePersonenanzahl;
	}

	/**
	 * Returns the nichtraucher
	 *
	 * @return integer $nichtraucher
	 */
	public function getNichtraucher() {
		return $this->nichtraucher;
	}

	/**
	 * Sets the nichtraucher
	 *
	 * @param integer $nichtraucher
	 * @return void
	 */
	public function setNichtraucher($nichtraucher) {
		$this->nichtraucher = $nichtraucher;
	}

	/**
	 * Returns the haustiere
	 *
	 * @return integer $haustiere
	 */
	public function getHaustiere() {
		return $this->haustiere;
	}

	/**
	 * Sets the haustiere
	 *
	 * @param integer $haustiere
	 * @return void
	 */
	public function setHaustiere($haustiere) {
		$this->haustiere = $haustiere;
	}

	/**
	 * Returns the geschlecht
	 *
	 * @return integer $geschlecht
	 */
	public function getGeschlecht() {
		return $this->geschlecht;
	}

	/**
	 * Sets the geschlecht
	 *
	 * @param integer $geschlecht
	 * @return void
	 */
	public function setGeschlecht($geschlecht) {
		$this->geschlecht = $geschlecht;
	}

	/**
	 * Returns the denkmalgeschuetzt
	 *
	 * @return integer $denkmalgeschuetzt
	 */
	public function getDenkmalgeschuetzt() {
		return $this->denkmalgeschuetzt;
	}

	/**
	 * Sets the denkmalgeschuetzt
	 *
	 * @param integer $denkmalgeschuetzt
	 * @return void
	 */
	public function setDenkmalgeschuetzt($denkmalgeschuetzt) {
		$this->denkmalgeschuetzt = $denkmalgeschuetzt;
	}

	/**
	 * Returns the alsFerien
	 *
	 * @return integer $alsFerien
	 */
	public function getAlsFerien() {
		return $this->alsFerien;
	}

	/**
	 * Sets the alsFerien
	 *
	 * @param integer $alsFerien
	 * @return void
	 */
	public function setAlsFerien($alsFerien) {
		$this->alsFerien = $alsFerien;
	}

	/**
	 * Returns the gewerblicheNutzung
	 *
	 * @return integer $gewerblicheNutzung
	 */
	public function getGewerblicheNutzung() {
		return $this->gewerblicheNutzung;
	}

	/**
	 * Sets the gewerblicheNutzung
	 *
	 * @param integer $gewerblicheNutzung
	 * @return void
	 */
	public function setGewerblicheNutzung($gewerblicheNutzung) {
		$this->gewerblicheNutzung = $gewerblicheNutzung;
	}

    /**
     * @param int $badModernisiert
     */
    public function setBadModernisiert($badModernisiert)
    {
        $this->badModernisiert = $badModernisiert;
    }

    /**
     * @return int
     */
    public function getBadModernisiert()
    {
        return $this->badModernisiert;
    }

	/**
	 * Returns the branchen
	 *
	 * @return string $branchen
	 */
	public function getBranchen() {
		return $this->branchen;
	}

	/**
	 * Sets the branchen
	 *
	 * @param string $branchen
	 * @return void
	 */
	public function setBranchen($branchen) {
		$this->branchen = $branchen;
	}

	/**
	 * Returns the hochhaus
	 *
	 * @return integer $hochhaus
	 */
	public function getHochhaus() {
		return $this->hochhaus;
	}

	/**
	 * Sets the hochhaus
	 *
	 * @param integer $hochhaus
	 * @return void
	 */
	public function setHochhaus($hochhaus) {
		$this->hochhaus = $hochhaus;
	}

	/**
	 * Returns the objektnrIntern
	 *
	 * @return string $objektnrIntern
	 */
	public function getObjektnrIntern() {
		return $this->objektnrIntern;
	}

	/**
	 * Sets the objektnrIntern
	 *
	 * @param string $objektnrIntern
	 * @return void
	 */
	public function setObjektnrIntern($objektnrIntern) {
		$this->objektnrIntern = $objektnrIntern;
	}

	/**
	 * Returns the objektnrExtern
	 *
	 * @return string $objektnrExtern
	 */
	public function getObjektnrExtern() {
		return $this->objektnrExtern;
	}

	/**
	 * @return mixed
	 */
	public function getUrlIdentifier(){
		return preg_replace(array('/\//','/\\\/'),'-',$this->getObjektnrExtern());
	}

	/**
	 * Sets the objektnrExtern
	 *
	 * @param string $objektnrExtern
	 * @return void
	 */
	public function setObjektnrExtern($objektnrExtern) {
		$this->objektnrExtern = $objektnrExtern;
	}

	/**
	 * Returns the anzeigeAb
	 *
	 * @return \DateTime $anzeigeAb
	 */
	public function getAnzeigeAb() {
		return $this->anzeigeAb;
	}

	/**
	 * Sets the anzeigeAb
	 *
	 * @param \DateTime $anzeigeAb
	 * @return void
	 */
	public function setAnzeigeAb(\DateTime $anzeigeAb) {
		$this->anzeigeAb = $anzeigeAb;
	}

	/**
	 * Returns the anzeigeBis
	 *
	 * @return \DateTime $anzeigeBis
	 */
	public function getAnzeigeBis() {
		return $this->anzeigeBis;
	}

	/**
	 * Sets the anzeigeBis
	 *
	 * @param \DateTime $anzeigeBis
	 * @return void
	 */
	public function setAnzeigeBis(\DateTime $anzeigeBis) {
		$this->anzeigeBis = $anzeigeBis;
	}

	/**
	 * Returns the openimmoObjid
	 *
	 * @return string $openimmoObjid
	 */
	public function getOpenimmoObjid() {
		return $this->openimmoObjid;
	}

	/**
	 * Sets the openimmoObjid
	 *
	 * @param string $openimmoObjid
	 * @return void
	 */
	public function setOpenimmoObjid($openimmoObjid) {
		$this->openimmoObjid = $openimmoObjid;
	}

	/**
	 * Returns the kennungUrsprung
	 *
	 * @return string $kennungUrsprung
	 */
	public function getKennungUrsprung() {
		return $this->kennungUrsprung;
	}

	/**
	 * Sets the kennungUrsprung
	 *
	 * @param string $kennungUrsprung
	 * @return void
	 */
	public function setKennungUrsprung($kennungUrsprung) {
		$this->kennungUrsprung = $kennungUrsprung;
	}

	/**
	 * Returns the standVom
	 *
	 * @return \DateTime $standVom
	 */
	public function getStandVom() {
		return $this->standVom;
	}

	/**
	 * Sets the standVom
	 *
	 * @param \DateTime $standVom
	 * @return void
	 */
	public function setStandVom(\DateTime $standVom) {
		$this->standVom = $standVom;
	}

	/**
	 * Returns the weitergabeGenerell
	 *
	 * @return boolean $weitergabeGenerell
	 */
	public function getWeitergabeGenerell() {
		return $this->weitergabeGenerell;
	}

	/**
	 * Sets the weitergabeGenerell
	 *
	 * @param boolean $weitergabeGenerell
	 * @return void
	 */
	public function setWeitergabeGenerell($weitergabeGenerell) {
		$this->weitergabeGenerell = $weitergabeGenerell;
	}

	/**
	 * Returns the boolean state of weitergabeGenerell
	 *
	 * @return boolean
	 */
	public function isWeitergabeGenerell() {
		return $this->weitergabeGenerell;
	}

	/**
	 * Returns the weitergabePositivliste
	 *
	 * @return string $weitergabePositivliste
	 */
	public function getWeitergabePositivliste() {
		return $this->weitergabePositivliste;
	}

	/**
	 * Sets the weitergabePositivliste
	 *
	 * @param string $weitergabePositivliste
	 * @return void
	 */
	public function setWeitergabePositivliste($weitergabePositivliste) {
		$this->weitergabePositivliste = $weitergabePositivliste;
	}

	/**
	 * Returns the weitergabeNegativliste
	 *
	 * @return string $weitergabeNegativliste
	 */
	public function getWeitergabeNegativliste() {
		return $this->weitergabeNegativliste;
	}

	/**
	 * Sets the weitergabeNegativliste
	 *
	 * @param string $weitergabeNegativliste
	 * @return void
	 */
	public function setWeitergabeNegativliste($weitergabeNegativliste) {
		$this->weitergabeNegativliste = $weitergabeNegativliste;
	}

	/**
	 * Returns the gruppenKennung
	 *
	 * @return string $gruppenKennung
	 */
	public function getGruppenKennung() {
		return $this->gruppenKennung;
	}

	/**
	 * Sets the gruppenKennung
	 *
	 * @param string $gruppenKennung
	 * @return void
	 */
	public function setGruppenKennung($gruppenKennung) {
		$this->gruppenKennung = $gruppenKennung;
	}

	/**
	 * Returns the masterObjekt
	 *
	 * @return string $masterObjekt
	 */
	public function getMasterObjekt() {
		return $this->masterObjekt;
	}

	/**
	 * Sets the masterObjekt
	 *
	 * @param string $masterObjekt
	 * @return void
	 */
	public function setMasterObjekt($masterObjekt) {
		$this->masterObjekt = $masterObjekt;
	}

	/**
	 * Returns the masterVisible
	 *
	 * @return boolean $masterVisible
	 */
	public function getMasterVisible() {
		return $this->masterVisible;
	}

	/**
	 * Sets the masterVisible
	 *
	 * @param boolean $masterVisible
	 * @return void
	 */
	public function setMasterVisible($masterVisible) {
		$this->masterVisible = $masterVisible;
	}

	/**
	 * Returns the boolean state of masterVisible
	 *
	 * @return boolean
	 */
	public function isMasterVisible() {
		return $this->masterVisible;
	}

	/**
	 * Returns the sprache
	 *
	 * @return string $sprache
	 */
	public function getSprache() {
		return $this->sprache;
	}

	/**
	 * Sets the sprache
	 *
	 * @param string $sprache
	 * @return void
	 */
	public function setSprache($sprache) {
		$this->sprache = $sprache;
	}

	/**
	 * Adds a Nutzungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Nutzungsart $nutzungsart
	 * @return void
	 */
	public function addNutzungsart(\SG\SgEstateCore\Domain\Model\Nutzungsart $nutzungsart) {
		$this->nutzungsart->attach($nutzungsart);
	}

	/**
	 * Removes a Nutzungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Nutzungsart $nutzungsartToRemove The Nutzungsart to be removed
	 * @return void
	 */
	public function removeNutzungsart(\SG\SgEstateCore\Domain\Model\Nutzungsart $nutzungsartToRemove) {
		$this->nutzungsart->detach($nutzungsartToRemove);
	}

	/**
	 * Returns the nutzungsart
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Nutzungsart> $nutzungsart
	 */
	public function getNutzungsart() {
		return $this->nutzungsart;
	}

	/**
	 * Sets the nutzungsart
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Nutzungsart> $nutzungsart
	 * @return void
	 */
	public function setNutzungsart(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $nutzungsart) {
		$this->nutzungsart = $nutzungsart;
	}

	/**
	 * Adds a Vermarktungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsart
	 * @return void
	 */
	public function addVermarktungsart(\SG\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsart) {
		$this->vermarktungsart->attach($vermarktungsart);
	}

	/**
	 * Removes a Vermarktungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsartToRemove The Vermarktungsart to be removed
	 * @return void
	 */
	public function removeVermarktungsart(\SG\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsartToRemove) {
		$this->vermarktungsart->detach($vermarktungsartToRemove);
	}

	/**
	 * Returns the vermarktungsart
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Vermarktungsart> $vermarktungsart
	 */
	public function getVermarktungsart() {
		return $this->vermarktungsart;
	}

	/**
	 * Sets the vermarktungsart
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Vermarktungsart> $vermarktungsart
	 * @return void
	 */
	public function setVermarktungsart(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $vermarktungsart) {
		$this->vermarktungsart = $vermarktungsart;
	}

	/**
	 * Returns the objektart
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Objektart $objektart
	 */
	public function getObjektart() {
		return $this->objektart;
	}

	/**
	 * Sets the objektart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Objektart $objektart
	 * @return void
	 */
	public function setObjektart(\SG\SgEstateCore\Domain\Model\Objektart $objektart) {
		$this->objektart = $objektart;
	}

	/**
	 * Returns the objektarttyp
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Objektarttyp $objektarttyp
	 */
	public function getObjektarttyp() {
		return $this->objektarttyp;
	}

	/**
	 * Sets the objektarttyp
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Objektarttyp $objektarttyp
	 * @return void
	 */
	public function setObjektarttyp(\SG\SgEstateCore\Domain\Model\Objektarttyp $objektarttyp) {
		$this->objektarttyp = $objektarttyp;
	}

	/**
	 * Returns the objektOrt
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Ort $objektOrt
	 */
	public function getObjektOrt() {
		return $this->objektOrt;
	}

	/**
	 * Sets the objektOrt
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Ort $objektOrt
	 * @return void
	 */
	public function setObjektOrt(\SG\SgEstateCore\Domain\Model\Ort $objektOrt) {
		$this->objektOrt = $objektOrt;
	}

	/**
	 * Returns the objektStadtteil
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Stadtteil $objektStadtteil
	 */
	public function getObjektStadtteil() {
		return $this->objektStadtteil;
	}

	/**
	 * Sets the objektStadtteil
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Stadtteil $objektStadtteil
	 * @return void
	 */
	public function setObjektStadtteil(\SG\SgEstateCore\Domain\Model\Stadtteil $objektStadtteil) {
		$this->objektStadtteil = $objektStadtteil;
	}

	/**
	 * Returns the objektLand
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Land $objektLand
	 */
	public function getObjektLand() {
		return $this->objektLand;
	}

	/**
	 * Sets the objektLand
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Land $objektLand
	 * @return void
	 */
	public function setObjektLand(\SG\SgEstateCore\Domain\Model\Land $objektLand) {
		$this->objektLand = $objektLand;
	}

	/**
	 * Returns the objektLage
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Lage $objektLage
	 */
	public function getObjektLage() {
		return $this->objektLage;
	}

	/**
	 * Sets the objektLage
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Lage $objektLage
	 * @return void
	 */
	public function setObjektLage(\SG\SgEstateCore\Domain\Model\Lage $objektLage) {
		$this->objektLage = $objektLage;
	}

	/**
	 * Returns the kontaktperson
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Kontaktperson $kontaktperson
	 */
	public function getKontaktperson() {
		return $this->kontaktperson;
	}

	/**
	 * Sets the kontaktperson
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Kontaktperson $kontaktperson
	 * @return void
	 */
	public function setKontaktperson(\SG\SgEstateCore\Domain\Model\Kontaktperson $kontaktperson) {
		$this->kontaktperson = $kontaktperson;
	}

	/**
	 * Adds a Kontaktperson
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Kontaktperson $weitereAdressen
	 * @return void
	 */
	public function addWeitereAdressen(\SG\SgEstateCore\Domain\Model\Kontaktperson $weitereAdressen) {
		$this->weitereAdressen->attach($weitereAdressen);
	}

	/**
	 * Removes a Kontaktperson
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Kontaktperson $weitereAdressenToRemove The Kontaktperson to be removed
	 * @return void
	 */
	public function removeWeitereAdressen(\SG\SgEstateCore\Domain\Model\Kontaktperson $weitereAdressenToRemove) {
		$this->weitereAdressen->detach($weitereAdressenToRemove);
	}

	/**
	 * Returns the weitereAdressen
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kontaktperson> $weitereAdressen
	 */
	public function getWeitereAdressen() {
		return $this->weitereAdressen;
	}

	/**
	 * Sets the weitereAdressen
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kontaktperson> $weitereAdressen
	 * @return void
	 */
	public function setWeitereAdressen(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $weitereAdressen) {
		$this->weitereAdressen = $weitereAdressen;
	}

	/**
	 * Returns the preisZeiteinheit
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Periode $preisZeiteinheit
	 */
	public function getPreisZeiteinheit() {
		return $this->preisZeiteinheit;
	}

	/**
	 * Sets the preisZeiteinheit
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Periode $preisZeiteinheit
	 * @return void
	 */
	public function setPreisZeiteinheit(\SG\SgEstateCore\Domain\Model\Periode $preisZeiteinheit) {
		$this->preisZeiteinheit = $preisZeiteinheit;
	}

	/**
	 * Returns the mieteinnahmenIstPeriode
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenIstPeriode
	 */
	public function getMieteinnahmenIstPeriode() {
		return $this->mieteinnahmenIstPeriode;
	}

	/**
	 * Sets the mieteinnahmenIstPeriode
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenIstPeriode
	 * @return void
	 */
	public function setMieteinnahmenIstPeriode(\SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenIstPeriode) {
		$this->mieteinnahmenIstPeriode = $mieteinnahmenIstPeriode;
	}

	/**
	 * Returns the mieteinnahmenSollPeriode
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenSollPeriode
	 */
	public function getMieteinnahmenSollPeriode() {
		return $this->mieteinnahmenSollPeriode;
	}

	/**
	 * Sets the mieteinnahmenSollPeriode
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenSollPeriode
	 * @return void
	 */
	public function setMieteinnahmenSollPeriode(\SG\SgEstateCore\Domain\Model\Periode $mieteinnahmenSollPeriode) {
		$this->mieteinnahmenSollPeriode = $mieteinnahmenSollPeriode;
	}

	/**
	 * Returns the waehrung
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Waehrung $waehrung
	 */
	public function getWaehrung() {
		return $this->waehrung;
	}

	/**
	 * Sets the waehrung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Waehrung $waehrung
	 * @return void
	 */
	public function setWaehrung(\SG\SgEstateCore\Domain\Model\Waehrung $waehrung) {
		$this->waehrung = $waehrung;
	}

	/**
	 * Returns the ausstattungsKategorie
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Austattungskategorie $ausstattungsKategorie
	 */
	public function getAusstattungsKategorie() {
		return $this->ausstattungsKategorie;
	}

	/**
	 * Sets the ausstattungsKategorie
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Austattungskategorie $ausstattungsKategorie
	 * @return void
	 */
	public function setAusstattungsKategorie(\SG\SgEstateCore\Domain\Model\Austattungskategorie $ausstattungsKategorie) {
		$this->ausstattungsKategorie = $ausstattungsKategorie;
	}

	/**
	 * Adds a Badausstattung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Badausstattung $ausstattungBad
	 * @return void
	 */
	public function addAusstattungBad(\SG\SgEstateCore\Domain\Model\Badausstattung $ausstattungBad) {
		$this->ausstattungBad->attach($ausstattungBad);
	}

	/**
	 * Removes a Badausstattung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Badausstattung $ausstattungBadToRemove The Badausstattung to be removed
	 * @return void
	 */
	public function removeAusstattungBad(\SG\SgEstateCore\Domain\Model\Badausstattung $ausstattungBadToRemove) {
		$this->ausstattungBad->detach($ausstattungBadToRemove);
	}

	/**
	 * Returns the ausstattungBad
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Badausstattung> $ausstattungBad
	 */
	public function getAusstattungBad() {
		return $this->ausstattungBad;
	}

	/**
	 * Sets the ausstattungBad
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Badausstattung> $ausstattungBad
	 * @return void
	 */
	public function setAusstattungBad(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $ausstattungBad) {
		$this->ausstattungBad = $ausstattungBad;
	}

	/**
	 * Adds a Kuechenausstattung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Kuechenausstattung $ausstattungKueche
	 * @return void
	 */
	public function addAusstattungKueche(\SG\SgEstateCore\Domain\Model\Kuechenausstattung $ausstattungKueche) {
		$this->ausstattungKueche->attach($ausstattungKueche);
	}

	/**
	 * Removes a Kuechenausstattung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Kuechenausstattung $ausstattungKuecheToRemove The Kuechenausstattung to be removed
	 * @return void
	 */
	public function removeAusstattungKueche(\SG\SgEstateCore\Domain\Model\Kuechenausstattung $ausstattungKuecheToRemove) {
		$this->ausstattungKueche->detach($ausstattungKuecheToRemove);
	}

	/**
	 * Returns the ausstattungKueche
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kuechenausstattung> $ausstattungKueche
	 */
	public function getAusstattungKueche() {
		return $this->ausstattungKueche;
	}

	/**
	 * Sets the ausstattungKueche
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Kuechenausstattung> $ausstattungKueche
	 * @return void
	 */
	public function setAusstattungKueche(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $ausstattungKueche) {
		$this->ausstattungKueche = $ausstattungKueche;
	}

	/**
	 * Adds a Bodenbelag
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Bodenbelag $ausstattungBoden
	 * @return void
	 */
	public function addAusstattungBoden(\SG\SgEstateCore\Domain\Model\Bodenbelag $ausstattungBoden) {
		$this->ausstattungBoden->attach($ausstattungBoden);
	}

	/**
	 * Removes a Bodenbelag
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Bodenbelag $ausstattungBodenToRemove The Bodenbelag to be removed
	 * @return void
	 */
	public function removeAusstattungBoden(\SG\SgEstateCore\Domain\Model\Bodenbelag $ausstattungBodenToRemove) {
		$this->ausstattungBoden->detach($ausstattungBodenToRemove);
	}

	/**
	 * Returns the ausstattungBoden
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bodenbelag> $ausstattungBoden
	 */
	public function getAusstattungBoden() {
		return $this->ausstattungBoden;
	}

	/**
	 * Sets the ausstattungBoden
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bodenbelag> $ausstattungBoden
	 * @return void
	 */
	public function setAusstattungBoden(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $ausstattungBoden) {
		$this->ausstattungBoden = $ausstattungBoden;
	}

	/**
	 * Adds a Heizungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Heizungsart $heizungsart
	 * @return void
	 */
	public function addHeizungsart(\SG\SgEstateCore\Domain\Model\Heizungsart $heizungsart) {
		$this->heizungsart->attach($heizungsart);
	}

	/**
	 * Removes a Heizungsart
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Heizungsart $heizungsartToRemove The Heizungsart to be removed
	 * @return void
	 */
	public function removeHeizungsart(\SG\SgEstateCore\Domain\Model\Heizungsart $heizungsartToRemove) {
		$this->heizungsart->detach($heizungsartToRemove);
	}

	/**
	 * Returns the heizungsart
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Heizungsart> $heizungsart
	 */
	public function getHeizungsart() {
		return $this->heizungsart;
	}

	/**
	 * Sets the heizungsart
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Heizungsart> $heizungsart
	 * @return void
	 */
	public function setHeizungsart(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $heizungsart) {
		$this->heizungsart = $heizungsart;
	}

    /**
     * Adds a Befeuerungsart
     *
     * @param \SG\SgEstateCore\Domain\Model\Befeuerungsart $befeuerungsart
     * @return void
     */
    public function addBefeuerungsart(\SG\SgEstateCore\Domain\Model\Befeuerungsart $befeuerungsart) {
        $this->befeuerungsart->attach($befeuerungsart);
    }

    /**
     * Removes a Befeuerungsart
     *
     * @param \SG\SgEstateCore\Domain\Model\Befeuerungsart $befeuerungsartToRemove The Befeuerungsart to be removed
     * @return void
     */
    public function removeBefeuerungsart(\SG\SgEstateCore\Domain\Model\Befeuerungsart $befeuerungsartToRemove) {
        $this->befeuerungsart->detach($befeuerungsartToRemove);
    }

    /**
     * Returns the befeuerungsart
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Befeuerungsart> $befeuerungsart
     */
    public function getBefeuerungsart() {
        return $this->befeuerungsart;
    }

    /**
     * Sets the befeuerungsart
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Befeuerungsart> $befeuerungsart
     * @return void
     */
    public function setBefeuerungsart(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $befeuerungsart) {
        $this->befeuerungsart = $befeuerungsart;
    }

	/**
	 * Adds a Himmelrichtung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Himmelrichtung $ausrichtBalkonTerasse
	 * @return void
	 */
	public function addAusrichtBalkonTerasse(\SG\SgEstateCore\Domain\Model\Himmelrichtung $ausrichtBalkonTerasse) {
		$this->ausrichtBalkonTerasse->attach($ausrichtBalkonTerasse);
	}

	/**
	 * Removes a Himmelrichtung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Himmelrichtung $ausrichtBalkonTerasseToRemove The Himmelrichtung to be removed
	 * @return void
	 */
	public function removeAusrichtBalkonTerasse(\SG\SgEstateCore\Domain\Model\Himmelrichtung $ausrichtBalkonTerasseToRemove) {
		$this->ausrichtBalkonTerasse->detach($ausrichtBalkonTerasseToRemove);
	}

	/**
	 * Returns the ausrichtBalkonTerasse
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Himmelrichtung> $ausrichtBalkonTerasse
	 */
	public function getAusrichtBalkonTerasse() {
		return $this->ausrichtBalkonTerasse;
	}

	/**
	 * Sets the ausrichtBalkonTerasse
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Himmelrichtung> $ausrichtBalkonTerasse
	 * @return void
	 */
	public function setAusrichtBalkonTerasse(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $ausrichtBalkonTerasse) {
		$this->ausrichtBalkonTerasse = $ausrichtBalkonTerasse;
	}

	/**
	 * Adds a Dachform
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Dachform $dachform
	 * @return void
	 */
	public function addDachform(\SG\SgEstateCore\Domain\Model\Dachform $dachform) {
		$this->dachform->attach($dachform);
	}

	/**
	 * Removes a Dachform
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Dachform $dachformToRemove The Dachform to be removed
	 * @return void
	 */
	public function removeDachform(\SG\SgEstateCore\Domain\Model\Dachform $dachformToRemove) {
		$this->dachform->detach($dachformToRemove);
	}

	/**
	 * Returns the dachform
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Dachform> $dachform
	 */
	public function getDachform() {
		return $this->dachform;
	}

	/**
	 * Sets the dachform
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Dachform> $dachform
	 * @return void
	 */
	public function setDachform(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $dachform) {
		$this->dachform = $dachform;
	}

	/**
	 * Adds a Bauweise
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Bauweise $bauweise
	 * @return void
	 */
	public function addBauweise(\SG\SgEstateCore\Domain\Model\Bauweise $bauweise) {
		$this->bauweise->attach($bauweise);
	}

	/**
	 * Removes a Bauweise
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Bauweise $bauweiseToRemove The Bauweise to be removed
	 * @return void
	 */
	public function removeBauweise(\SG\SgEstateCore\Domain\Model\Bauweise $bauweiseToRemove) {
		$this->bauweise->detach($bauweiseToRemove);
	}

	/**
	 * Returns the bauweise
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bauweise> $bauweise
	 */
	public function getBauweise() {
		return $this->bauweise;
	}

	/**
	 * Sets the bauweise
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Bauweise> $bauweise
	 * @return void
	 */
	public function setBauweise(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $bauweise) {
		$this->bauweise = $bauweise;
	}

	/**
	 * Adds a Ausbaustufe
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Ausbaustufe $ausbaustufe
	 * @return void
	 */
	public function addAusbaustufe(\SG\SgEstateCore\Domain\Model\Ausbaustufe $ausbaustufe) {
		$this->ausbaustufe->attach($ausbaustufe);
	}

	/**
	 * Removes a Ausbaustufe
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Ausbaustufe $ausbaustufeToRemove The Ausbaustufe to be removed
	 * @return void
	 */
	public function removeAusbaustufe(\SG\SgEstateCore\Domain\Model\Ausbaustufe $ausbaustufeToRemove) {
		$this->ausbaustufe->detach($ausbaustufeToRemove);
	}

	/**
	 * Returns the ausbaustufe
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ausbaustufe> $ausbaustufe
	 */
	public function getAusbaustufe() {
		return $this->ausbaustufe;
	}

	/**
	 * Sets the ausbaustufe
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ausbaustufe> $ausbaustufe
	 * @return void
	 */
	public function setAusbaustufe(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $ausbaustufe) {
		$this->ausbaustufe = $ausbaustufe;
	}

	/**
	 * Returns the energietyp
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Energietyp $energietyp
	 */
	public function getEnergietyp() {
		return $this->energietyp;
	}

	/**
	 * Sets the energietyp
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Energietyp $energietyp
	 * @return void
	 */
	public function setEnergietyp(\SG\SgEstateCore\Domain\Model\Energietyp $energietyp) {
		$this->energietyp = $energietyp;
	}

	/**
	 * Returns the zustand
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Zustand $zustand
	 */
	public function getZustand() {
		return $this->zustand;
	}

	/**
	 * Sets the zustand
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Zustand $zustand
	 * @return void
	 */
	public function setZustand(\SG\SgEstateCore\Domain\Model\Zustand $zustand) {
		$this->zustand = $zustand;
	}

	/**
	 * Returns the bebaubarNach
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Bebaubarnach $bebaubarNach
	 */
	public function getBebaubarNach() {
		return $this->bebaubarNach;
	}

	/**
	 * Sets the bebaubarNach
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Bebaubarnach $bebaubarNach
	 * @return void
	 */
	public function setBebaubarNach(\SG\SgEstateCore\Domain\Model\Bebaubarnach $bebaubarNach) {
		$this->bebaubarNach = $bebaubarNach;
	}

	/**
	 * Returns the erschliessung
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Erschliessung $erschliessung
	 */
	public function getErschliessung() {
		return $this->erschliessung;
	}

	/**
	 * Sets the erschliessung
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Erschliessung $erschliessung
	 * @return void
	 */
	public function setErschliessung(\SG\SgEstateCore\Domain\Model\Erschliessung $erschliessung) {
		$this->erschliessung = $erschliessung;
	}

	/**
	 * Adds a Erschliessungdetails
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Erschliessungdetails $erschliessungUmfang
	 * @return void
	 */
	public function addErschliessungUmfang(\SG\SgEstateCore\Domain\Model\Erschliessungdetails $erschliessungUmfang) {
		$this->erschliessungUmfang->attach($erschliessungUmfang);
	}

	/**
	 * Removes a Erschliessungdetails
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Erschliessungdetails $erschliessungUmfangToRemove The Erschliessungdetails to be removed
	 * @return void
	 */
	public function removeErschliessungUmfang(\SG\SgEstateCore\Domain\Model\Erschliessungdetails $erschliessungUmfangToRemove) {
		$this->erschliessungUmfang->detach($erschliessungUmfangToRemove);
	}

	/**
	 * Returns the erschliessungUmfang
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Erschliessungdetails> $erschliessungUmfang
	 */
	public function getErschliessungUmfang() {
		return $this->erschliessungUmfang;
	}

	/**
	 * Sets the erschliessungUmfang
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Erschliessungdetails> $erschliessungUmfang
	 * @return void
	 */
	public function setErschliessungUmfang(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $erschliessungUmfang) {
		$this->erschliessungUmfang = $erschliessungUmfang;
	}

	/**
	 * Adds a Anhang
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Anhang $anhaenge
	 * @return void
	 */
	public function addAnhaenge(\SG\SgEstateCore\Domain\Model\Anhang $anhaenge) {
		$this->anhaenge->attach($anhaenge);
	}

	/**
	 * Removes a Anhang
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Anhang $anhaengeToRemove The Anhang to be removed
	 * @return void
	 */
	public function removeAnhaenge(\SG\SgEstateCore\Domain\Model\Anhang $anhaengeToRemove) {
		$this->anhaenge->detach($anhaengeToRemove);
	}

	/**
	 * Returns the anhaenge
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Anhang> $anhaenge
	 */
	public function getAnhaenge() {
		return $this->anhaenge;
	}

	/**
	 * Sets the anhaenge
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Anhang> $anhaenge
	 * @return void
	 */
	public function setAnhaenge(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $anhaenge) {
		$this->anhaenge = $anhaenge;
	}

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getMedia(): ?\TYPO3\CMS\Extbase\Persistence\ObjectStorage
    {
        return $this->media;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $media
     */
    public function setMedia(?\TYPO3\CMS\Extbase\Persistence\ObjectStorage $media): void
    {
        $this->media = $media;
    }

	/**
	 * Returns the minimaleMietdauer
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Periode $minimaleMietdauer
	 */
	public function getMinimaleMietdauer() {
		return $this->minimaleMietdauer;
	}

	/**
	 * Sets the minimaleMietdauer
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Periode $minimaleMietdauer
	 * @return void
	 */
	public function setMinimaleMietdauer(\SG\SgEstateCore\Domain\Model\Periode $minimaleMietdauer) {
		$this->minimaleMietdauer = $minimaleMietdauer;
	}

	/**
	 * Returns the maximaleMietdauer
	 *
	 * @return \SG\SgEstateCore\Domain\Model\Periode $maximaleMietdauer
	 */
	public function getMaximaleMietdauer() {
		return $this->maximaleMietdauer;
	}

	/**
	 * Sets the maximaleMietdauer
	 *
	 * @param \SG\SgEstateCore\Domain\Model\Periode $maximaleMietdauer
	 * @return void
	 */
	public function setMaximaleMietdauer(\SG\SgEstateCore\Domain\Model\Periode $maximaleMietdauer) {
		$this->maximaleMietdauer = $maximaleMietdauer;
	}


    /**
     * @return Anhang|null
     */
    public function getTitelbild(){
        /**
         * @var \SG\SgEstateCore\Domain\Model\Anhang $anhang
         */
        $erstesBild = null;
        foreach ($this->getAnhaenge() as $anhang){

            if ($anhang->getTyp()->getKuerzel() == 'TITELBILD'){

                return $anhang;
            }elseif(($erstesBild == null)&&($anhang->getTyp()->getKuerzel() == 'BILD')){
                $erstesBild = $anhang;
            }
        }
        return $erstesBild;
    }

    public function getBilder(){
        $return = array();
        foreach ($this->getAnhaenge() as $anhang){

            if (($anhang->getTyp()->getKuerzel() == 'TITELBILD')||($anhang->getTyp()->getKuerzel() == 'BILD')){
                array_push($return, $anhang);
            }
        }
        return $return;
    }

    public function getGrundrisse(){
        $return = array();
        foreach ($this->getAnhaenge() as $anhang){

            if ($anhang->getTyp()->getKuerzel() == 'GRUNDRISS'){
                array_push($return, $anhang);
            }
        }
        return $return;

    }

    public function getDokumente(){
        $return = array();
        foreach ($this->getAnhaenge() as $anhang){

            if ($anhang->getTyp()->getKuerzel() == 'DOKUMENTE'){
                array_push($return, $anhang);
            }
        }
        return $return;
    }

    public function getPanoramen(){
        $return = array();
        foreach ($this->getAnhaenge() as $anhang){

            if ($anhang->getTyp()->getKuerzel() == 'PANORAMA'){
                array_push($return, $anhang);
            }
        }
        return $return;
    }

    public function getIsFavorit(){
        $favoriten = $this->sessionHandler->restoreFromSession('favoriten');
        if (is_array($favoriten)){
            if (in_array($this->uid, $favoriten)){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }

    }

    /**
     * Returns the gegensprechanlage
     *
     * @return integer $gegensprechanlage
     */
    public function getGegensprechanlage() {
        return $this->gegensprechanlage;
    }

    /**
     * Sets the gegensprechanlage
     *
     * @param integer $gegensprechanlage
     * @return void
     */
    public function setGegensprechanlage($gegensprechanlage) {
        $this->gegensprechanlage = $gegensprechanlage;
    }

    /**
     * Returns the leichtErreichbar
     *
     * @return integer $leichtErreichbar
     */
    public function getLeichtErreichbar() {
        return $this->leichtErreichbar;
    }

    /**
     * Sets the leichtErreichbar
     *
     * @param integer $leichtErreichbar
     * @return void
     */
    public function setLeichtErreichbar($leichtErreichbar) {
        $this->leichtErreichbar = $leichtErreichbar;
    }

	public function getHasGeocodes(){
		if (($this->getObjektLaengengrad() != 0)&&($this->getObjektBreitengrad() != 0)){
			return true;
		}else{
			return false;
		}
	}

	/**
	 * @return boolean
	 */
	public function isUpdatable()
	{
		return $this->updatable;
	}

	/**
	 * @return bool
	 */
	public function getUpdatable()
	{
		return $this->updatable;
	}

	/**
	 * @param boolean $updatable
	 * @return $this
	 */
	public function setUpdatable($updatable)
	{
		$this->updatable = $updatable;
		return $this;
	}


	public function getHasBathTub(){
    /**
     * @var $badAusstattung \SG\SgEstateCore\Domain\Model\Badausstattung
     */
	  foreach ($this->getAusstattungBad() as $badAusstattung){
	    if ($badAusstattung->getKuerzel() == 'WANNE'){
	      return true;
      }
      return false;
    }
  }

	public function getHasBathShower(){
    /**
     * @var $badAusstattung \SG\SgEstateCore\Domain\Model\Badausstattung
     */
    foreach ($this->getAusstattungBad() as $badAusstattung){
      if ($badAusstattung->getKuerzel() == 'DUSCHE'){
        return true;
      }
      return false;
    }
  }

	public function getHasBathWindow(){
    /**
     * @var $badAusstattung \SG\SgEstateCore\Domain\Model\Badausstattung
     */
    foreach ($this->getAusstattungBad() as $badAusstattung){
      if ($badAusstattung->getKuerzel() == 'FENSTER'){
        return true;
      }
      return false;
    }
  }

  /**
   * @return int
   */
  public function getImportNumber()
  {
    return $this->importNumber;
  }

  /**
   * @param int $importNumber
   * @return $this
   */
  public function setImportNumber($importNumber)
  {
    $this->importNumber = $importNumber;
    return $this;
  }

    public function getUniqueColorForImportNumber(): string
    {
        return '#' . substr(md5($this->getImportNumber()), 0, 6);
    }

}