<?php
namespace SG\SgEstateCore\Domain\Repository;

use SG\SgEstateCore\Domain\Model\Filter;
use SG\SgEstateCore\Domain\Model\Immobilie;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * The repository for Orts
 */
class OrtRepository extends \TYPO3\CMS\Extbase\Persistence\Repository {

    /**
     * @var ImmobilieRepository
     */
    private $immobilieRepository;

    /**
     * @param ImmobilieRepository $immobilieRepository
     */
    public function injectImmobilieRepository(ImmobilieRepository $immobilieRepository){
        $this->immobilieRepository = $immobilieRepository;
    }

    public function initializeObject() {
        /** @var $querySettings \TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    protected $defaultOrderings = array(
        'bezeichner' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    );


    public function getAllForFilter(array $arrayOfImportIds = null){
        /**
         * @var $item \SG\SgEstateCore\Domain\Model\Ort
         */

        if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){
            $affectedRealties = $this->immobilieRepository->findAllForImportIds($arrayOfImportIds);
            $result = new ObjectStorage();
            foreach ($affectedRealties as $realtyItem){
                /**
                 * @var $realtyItem Immobilie
                 */
                $result->attach($realtyItem->getObjektOrt());
            }
        }else{
            $query = $this->createQuery();
            $result = $query->execute();
        }
        foreach ($result as $item){
            if ($item instanceof \SG\SgEstateCore\Domain\Model\Ort){
                $return[$item->getUid()] = $item->getBezeichner();
            }
        }
        return $return;

    }

    public function getGroupedCitiesAndDistrictsForFilter(array $arrayOfImportIds = null)
    {
        /**
         * @var $item \SG\SgEstateCore\Domain\Model\Ort
         */

        if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){
            $affectedRealties = $this->immobilieRepository->findAllForImportIds($arrayOfImportIds);
            $cityStorage = new ObjectStorage();
            $districtStorage = new ObjectStorage();
            foreach ($affectedRealties as $realtyItem){
                /**
                 * @var $realtyItem Immobilie
                 */
                $cityStorage->attach($realtyItem->getObjektOrt());
                $districtStorage->attach($realtyItem->getObjektStadtteil());
            }

            $return = array();

            foreach ($cityStorage as $city)
            {
                if ($city instanceof \SG\SgEstateCore\Domain\Model\Ort &&
                    $city->isFuerSucheVerwenden() )
                {
                    $cityUid = $city->getUid();
                    // get districts
                    $districts = $city->getStadtteile();
                    if( is_object( $districts ) )
                    {
                        if( $districts->count() > 0 )
                        {
                            // districts, print city + district
                            foreach ($districts as $district)
                            {
                                if( $district instanceof \SG\SgEstateCore\Domain\Model\Stadtteil &&
                                    $district->isFuerSucheVerwenden() &&
                                    $districtStorage->contains($district)
                                )
                                {
                                    $districtUid = $district->getUid();
                                    $return["{$cityUid}_{$districtUid}"] = $city->getBezeichner().'-'.$district->getBezeichner();
                                }
                            }
                        }
                        else
                        {
                            // no districts, just print city
                            $return["{$cityUid}"] = $city->getBezeichner();
                        }
                    }
                }
            }
        }else{
            $query = $this->createQuery();
            $result = $query->execute();

            $return = array();
            // alle orte, die freigeschaltet sind
            foreach ($result as $city)
            {
                if ($city instanceof \SG\SgEstateCore\Domain\Model\Ort &&
                    $city->isFuerSucheVerwenden() )
                {
                    $cityUid = $city->getUid();
                    // get districts
                    $districts = $city->getStadtteile();
                    if( is_object( $districts ) )
                    {
                        if( $districts->count() > 0 )
                        {
                            // districts, print city + district
                            foreach ($districts as $district)
                            {
                                if( $district instanceof \SG\SgEstateCore\Domain\Model\Stadtteil &&
                                    $district->isFuerSucheVerwenden() )
                                {
                                    $districtUid = $district->getUid();
                                    $return["{$cityUid}_{$districtUid}"] = $city->getBezeichner().'-'.$district->getBezeichner();
                                }
                            }
                        }
                        else
                        {
                            // no districts, just print city
                            $return["{$cityUid}"] = $city->getBezeichner();
                        }
                    }
                }
            }
        }

        // sort return array alphabetically
        if( count( $return ) > 1 )
        {
            asort( $return, SORT_STRING );
        }

        return $return;
    }

}