<?php
/**
 * Date: 12/2020
 *
 * @author Jessica Schlierenkamp <mail@schlierenkamp.de>
 */

declare(strict_types = 1);
namespace SG\SgEstateCore\Api\Estate;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use SG\SgEstateCore\Domain\Model\Kampagne;
use SG\SgEstateCore\Domain\Repository\KampagneRepository;
use TYPO3\CMS\Core\Http\Response;
use TYPO3\CMS\Core\Http\Stream;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;

class Campaign implements MiddlewareInterface
{
    /**
     * @var KampagneRepository
     */
    private $kampagneRepository;

    public function __construct()
    {
        $objectManager = GeneralUtility::makeInstance(ObjectManager::class);
        $this->kampagneRepository = $objectManager->get(KampagneRepository::class);
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $normalizedParams = $request->getAttribute('normalizedParams');
        $uri = $normalizedParams->getRequestUri();
        $endpoint = '/api/estate/campaigns';

        if (strpos($uri, $endpoint) !== false) {
            $body = new Stream('php://temp', 'rw');
            $body->write($this->getCachedContent($endpoint));

            return (new Response())
                ->withHeader('content-type', 'application/json')
                ->withBody($body)
                ->withStatus(200);
        }

        return $handler->handle($request);
    }

    /**
     * @return array
     */
    private function getCampaigns(): array
    {
        $campaigns = $this->kampagneRepository->findAll();

        /** @var Kampagne $campaign */
        foreach ($campaigns as $campaign) {
            $json[] = $campaign->getDto();
        }

        return $json ?? [];
    }

    /**
     * @param string $endpoint
     *
     * @return false|mixed|string
     * @throws \TYPO3\CMS\Core\Cache\Exception\NoSuchCacheException
     */
    private function getCachedContent(string $endpoint)
    {
        $cache = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class)->getCache('sgestate_cache');
        $cacheIdentifier = sha1(serialize($endpoint));

        if (($data = $cache->get($cacheIdentifier)) === false) {
            $data = json_encode($this->getCampaigns(), JSON_UNESCAPED_UNICODE);
            $cache->set($cacheIdentifier, $data);
        }

        return $data;
    }
}
