<?php
namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Region extends AbstractEntity {

    /**
     * Bezeichner
     *
     * @var string
     */
    protected $bezeichner;

    /**
     * Orte
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ort>
     */
    protected $orte = null;

    /**
     * Region constructor.
     */
    public function __construct(){
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects() {
        $this->orte = new ObjectStorage();
    }

    /**
     * @return string
     */
    public function getBezeichner(): string
    {
        return $this->bezeichner;
    }

    /**
     * @param string $bezeichner
     */
    public function setBezeichner(string $bezeichner): void
    {
        $this->bezeichner = $bezeichner;
    }

    /**
     * @param Ort $ort
     */
    public function addOrt(Ort $ort){
        $this->orte->attach($ort);
    }

    /**
     * @param Ort $ort
     */
    public function removeOrt(Ort $ort){
        $this->orte->detach($ort);
    }

    /**
     * @return ObjectStorage
     */
    public function getOrte(): ObjectStorage
    {
        return $this->orte;
    }

    /**
     * @param ObjectStorage $orte
     */
    public function setOrte(ObjectStorage $orte): void
    {
        $this->orte = $orte;
    }


}