<?php
namespace SG\SgEstateCore\Domain\Repository;

/**
 * The repository for Immobilies
 */
class ImmobilieRepository extends \TYPO3\CMS\Extbase\Persistence\Repository {

    public function initializeObject() {
        /** @var $querySettings \TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }


    /**
     * @param \SG\SgEstateCore\Domain\Model\Filter $filter
     * @param null $limit
     * @param null $excludeUids
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     */
    public function findAllWithFilter(\SG\SgEstateCore\Domain\Model\Filter $filter, $limit = null, $excludeUids = null){
        $constraints = array();

        $query = $this->createQuery();

        if ($filter->getRaeumeAb() !== null){
            $constraints[] = $query->greaterThanOrEqual('anzahl_zimmer', $filter->getRaeumeAb());
        }
        if ($filter->getRaeumeBis() !== null){
            $constraints[] = $query->lessThanOrEqual('anzahl_zimmer', $filter->getRaeumeBis());
        }

        if ($filter->getFlaecheAb() !== null){
            $constraints[] = $query->greaterThanOrEqual('wohnflaeche', $filter->getFlaecheAb());
        }
        if ($filter->getFlaecheBis() !== null){
            $constraints[] = $query->lessThanOrEqual('wohnflaeche', $filter->getFlaecheBis());
        }

        if ($filter->getKaltmieteAb() !== null){
            $constraints[] = $query->greaterThanOrEqual('kaltmiete', $filter->getKaltmieteAb());
        }
        if ($filter->getKaltmieteBis() !== null){
            $constraints[] = $query->lessThanOrEqual('kaltmiete', $filter->getKaltmieteBis());
        }

        if ($filter->getOrte()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getOrte() as $ort){
                $subConstraints[] = $query->equals('objekt_ort', $ort);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }


        if ($filter->getStadtteile()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getStadtteile() as $stadtteil){
                $subConstraints[] = $query->equals('objekt_stadtteil',$stadtteil);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getObjektarten()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getObjektarten() as $objektart){
                $subConstraints[] = $query->equals('objektart', $objektart);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getObjektarttypen()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getObjektarttypen() as $objektarttyp){
                $subConstraints[] = $query->equals('objektarttyp', $objektarttyp);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getVermarktungsarten()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getVermarktungsarten() as $vermarktungsart){
                $subConstraints[] = $query->contains('vermarktungsart', $vermarktungsart);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getHeizungsarten()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getHeizungsarten() as $heizungsart){
                $subConstraints[] = $query->contains('heizungsart', $heizungsart);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getBefeuerungsarten()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getBefeuerungsarten() as $befeuerungsart){
                $subConstraints[] = $query->contains('befeuerungsart', $befeuerungsart);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getBodenbelaege()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getBodenbelaege() as $bodenbelag){
                $subConstraints[] = $query->contains('ausstattungBoden', $bodenbelag);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }

        if ($filter->getKampagnen()->count() > 0){
            $subConstraints = array();
            foreach ($filter->getKampagnen() as $kampagne){
                $subConstraints[] = $query->contains('kampagne', $kampagne);
            }
            if (count($subConstraints) > 0){
                $constraints[] = $query->logicalOr($subConstraints);
            }
        }


        if ($filter->getEinbaukueche() == 1){
            $kuechenausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\KuechenausstattungRepository');
            $constraints[] = $query->contains('ausstattungKueche',$kuechenausstattungRepository->findOneByKuerzel('EBK'));
        }elseif($filter->getEinbaukueche() == -1){
            $kuechenausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\KuechenausstattungRepository');
            $constraints[] = $query->logicalNot($query->contains('ausstattungKueche',$kuechenausstattungRepository->findOneByKuerzel('EBK')));
        }

        if ($filter->getBalkon() == 1){
            $constraints[] = $query->greaterThanOrEqual('anzahlBalkone',1);
        }elseif($filter->getBalkon() == -1){
            $constraints[] = $query->equals('anzahlBalkone',0);
        }

        if ($filter->getGarten() == 1){
            $constraints[] = $query->equals('gartennutzung',1);
        }elseif($filter->getGarten() == -1){
            $constraints[] = $query->equals('gartennutzung',-1);
        }

        if ($filter->getKeller() == 1){
            $constraints[] = $query->equals('unterkellert', 1);
        }elseif($filter->getKeller() == -1){
            $constraints[] = $query->equals('unterkellert', -1);
        }

        if ($filter->getBadMitWanne() == 1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('WANNE'));
        }elseif($filter->getBadMitWanne() == -1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->logicalNot($query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('WANNE')));
        }

        if ($filter->getBadMitDusche() == 1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('DUSCHE'));
        }elseif($filter->getBadMitDusche() == -1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->logicalNot($query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('DUSCHE')));
        }

        if ($filter->getBadMitFenster() == 1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('FENSTER'));
        }elseif($filter->getBadMitFenster() == -1){
            $badausstattungRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\BadausstattungRepository');
            $constraints[] = $query->logicalNot($query->contains('ausstattungBad',$badausstattungRepository->findOneByKuerzel('FENSTER')));
        }

        if ($filter->getGaestewc() == 1){
            $constraints[] = $query->greaterThanOrEqual('anzahlSeparateWc',1);
        }elseif($filter->getGaestewc() == -1){
            $constraints[] = $query->equals('anzahlSeparateWc',0);
        }

        if ($filter->getHaustiere() == 1){
            $constraints[] = $query->equals('haustiere', 1);
        }elseif($filter->getHaustiere() == -1){
            $constraints[] = $query->equals('haustiere', -1);
        }

        if ($filter->getWbs() == 1){
            $constraints[] = $query->equals('wbsErforderlich', 1);
        }elseif($filter->getWbs() == -1){
            $constraints[] = $query->equals('wbsErforderlich', -1);
        }

        if ($filter->getBarrierefrei() == 1){
            $constraints[] = $query->equals('barrierefrei', 1);
        }elseif($filter->getBarrierefrei() == -1){
            $constraints[] = $query->equals('barrierefrei', -1);
        }

        if ($filter->getLeichterZugang() == 1){
            $constraints[] = $query->equals('rollstuhlgerecht', 1);
        }elseif($filter->getLeichterZugang() == -1){
            $constraints[] = $query->equals('rollstuhlgerecht', -1);
        }

        if ($filter->getBadModernisiert() == 1){
            $constraints[] = $query->equals('badModernisiert', 1);
        }elseif($filter->getLeichterZugang() == -1){
            $constraints[] = $query->equals('badModernisiert', -1);
        }

        if ($filter->getAufzug() == 1){
            $constraints[] = $query->equals('aufzugPersonen', 1);
        }elseif($filter->getAufzug() == -1){
            $constraints[] = $query->equals('aufzugPersonen', -1);
        }


        if (is_array($excludeUids)&&count($excludeUids)>0){
            $constraints[] = $query->logicalNot($query->in('uid', $excludeUids));
        }

        if (is_array($filter->getUids())&&(count($filter->getUids()) > 0)){
            $query->matching($query->in('uid', $filter->getUids()));
        }else{
            if (count($constraints) > 0){
                $query->matching($query->logicalAnd($constraints));
            }
        }


        if ($limit != null){
            $query->setLimit($limit);
        }

        switch($filter->getSortierung()){
            case 0:
                // Kaltmiete (niedriegste zuerst)
                $query->setOrderings(array(
                    'kaltmiete' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
            case 1:
                // Kaltmiete (höchste zuerst)
                $query->setOrderings(array(
                    'kaltmiete' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING,
                ));
                break;
            case 2:
                // Fläche (niedriegste zuerst)
                $query->setOrderings(array(
                    'wohnflaeche' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
            case 3:
                // Fläche (höchste zuerst)
                $query->setOrderings(array(
                    'wohnflaeche' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING,
                ));
                break;
            case 4:
                // Zimmer (aufsteigend)
                $query->setOrderings(array(
                    'anzahlZimmer' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
            case 5:
                // Zimmer (absteigend)
                $query->setOrderings(array(
                    'anzahlZimmer' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING,
                ));
                break;
            case 6:
                // Stadtteil alphabetisch
                $query->setOrderings(array(
                    'objektStadtteil.bezeichner' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
            case 7:
                // Etage aufsteigend
                $query->setOrderings(array(
                    'objektEtage' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
            case 8:
                // Etage absteigend
                $query->setOrderings(array(
                    'objektEtage' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING,
                ));
                break;
            case 9:
                // Stadt
                $query->setOrderings(array(
                    'objektOrt.bezeichner' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                ));
                break;
        }

        return $query->execute();
    }

    public function findOneByUrlIdentifier($urlIdentifier){
        $query = $this->createQuery();
        $query->matching($query->equals('objektnrExtern', $urlIdentifier));
        $result = $query->execute();
        if ($result->count() == 0){
            $query = $this->createQuery();
            $query->matching($query->equals('objektnrExtern', preg_replace(array('/-/'),'/',$urlIdentifier)));
            $result = $query->execute();
            if ($result->count() > 0){
                return $result->getFirst();
            }else{
                return null;
            }
        }else{
            return $result->getFirst();
        }

    }
}