<?php

namespace Daho\SgEstateCore\Util;

class AddFields implements \TYPO3\CMS\Core\SingletonInterface {

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    protected $objectManager;


    public function __construct(){
        $pluginConfiguration = array(
            'vendorName' => 'Daho',
            'extensionName' => 'sgestatecore',
            'pluginName' => 'Pi1'
        );

        $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

    }

    /**
     *
     * Returns all activated KindOfObjects for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addKindOfObjects($config){
        /**
         * @var $objektart \Daho\SgEstateCore\Domain\Model\Objektart
         * @var $objektartRepository \Daho\SgEstateCore\Domain\Repository\ObjektartRepository
         */
        $objektartRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\ObjektartRepository');
        $optionList = array();

        foreach($objektartRepository->findAll() as $objektart){
            $optionList[] = array(
                0 => $objektart->getBezeichner(),
                1 => $objektart->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated KindOfObjectTypes for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addKindOfObjectTypes($config){
        /**
         * @var $objektart \Daho\SgEstateCore\Domain\Model\Objektart
         * @var $objektartTyp \Daho\SgEstateCore\Domain\Model\Objektarttyp
         * @var $objektartRepository \Daho\SgEstateCore\Domain\Repository\ObjektartRepository
         */
        $objektartRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\ObjektartRepository');
        $optionList = array();

        foreach($objektartRepository->findAll() as $objektart){
            foreach ($objektart->getObjektarttypen() as $objektartTyp){
                $optionList[] = array(
                    0 => $objektart->getBezeichner() . ' - ' . $objektartTyp->getBezeichner(),
                    1 => $objektartTyp->getUid()
                );
            }
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Marketing Types for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addMarketingTypes($config){
        /**
         * @var $marketingTypeRepository \Daho\SgEstateCore\Domain\Repository\VermarktungsartRepository
         * @var $marketingType \Daho\SgEstateCore\Domain\Model\Vermarktungsart
         */

        $marketingTypeRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\VermarktungsartRepository');
        $optionList = array();

        foreach($marketingTypeRepository->findAll() as $marketingType){
            $optionList[] = array(
                0 => $marketingType->getBezeichner(),
                1 => $marketingType->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Cities for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addCities($config){
        /**
         * @var $cityRepository \Daho\SgEstateCore\Domain\Repository\OrtRepository
         * @var $city \Daho\SgEstateCore\Domain\Model\Ort
         */

        $cityRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\OrtRepository');
        $optionList = array();

        foreach($cityRepository->findAll() as $city){
            $optionList[] = array(
                0 => $city->getBezeichner(),
                1 => $city->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Districts for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addDistricts($config){
        /**
         * @var $cityRepository \Daho\SgEstateCore\Domain\Repository\OrtRepository
         * @var $city \Daho\SgEstateCore\Domain\Model\Ort
         * @var $district \Daho\SgEstateCore\Domain\Model\Stadtteil
         */

        $cityRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\OrtRepository');
        $optionList = array();

        foreach($cityRepository->findAll() as $city){
            foreach ($city->getStadtteile() as $district){
                $optionList[] = array(
                    0 => $city->getBezeichner(). ' - '.$district->getBezeichner(),
                    1 => $district->getUid()
                );
            }

        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Heatingtypes for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addHeatingTypes($config){
        /**
         * @var $heatingTypeRepository \Daho\SgEstateCore\Domain\Repository\HeizungsartRepository
         * @var $heatingType \Daho\SgEstateCore\Domain\Model\Heizungsart
         */

        $heatingTypeRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\HeizungsartRepository');
        $optionList = array();

        foreach($heatingTypeRepository->findAll() as $heatingType){
            $optionList[] = array(
                0 => $heatingType->getBezeichner(),
                1 => $heatingType->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Beacoaningtypes for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addBeacoaningTypes($config){
        /**
         * @var $beacoaningTypeRepository \Daho\SgEstateCore\Domain\Repository\BefeuerungsartRepository
         * @var $beacoaningType \Daho\SgEstateCore\Domain\Model\Befeuerungsart
         */

        $beacoaningTypeRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\BefeuerungsartRepository');
        $optionList = array();

        foreach($beacoaningTypeRepository->findAll() as $beacoaningType){
            $optionList[] = array(
                0 => $beacoaningType->getBezeichner(),
                1 => $beacoaningType->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Floorings for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addFlooring($config){
        /**
         * @var $flooringRepository \Daho\SgEstateCore\Domain\Repository\BodenbelagRepository
         * @var $flooring \Daho\SgEstateCore\Domain\Model\Bodenbelag
         */

        $flooringRepository = $this->objectManager->get('Daho\SgEstateCore\Domain\Repository\BodenbelagRepository');
        $optionList = array();

        foreach($flooringRepository->findAll() as $flooring){
            $optionList[] = array(
                0 => $flooring->getBezeichner(),
                1 => $flooring->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }


    /**
     * Returns Template Layouts from TypoScript for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addTemplateLayouts($config){
        $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatelandingpage.']['layouts.']) && is_array($pagesTsConfig['tx_sgestatelandingpage.']['layouts.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatelandingpage.']['layouts.'];
        }else{
            $templateLayouts = array();
            $optionList = array();
        }
        foreach($templateLayouts as $key => $value){
            $optionList[] = array(
                0 => $value,
                1 => $key
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);

        return $config;
    }

}