<?php
namespace Daho\SgEstateCore\Domain\Model;

/**
 * Kontaktperson
 */
class Kontaktperson extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity {

	/**
	 * name
	 *
	 * @var string
	 */
	protected $name = '';

	/**
	 * vorname
	 *
	 * @var string
	 */
	protected $vorname = '';

	/**
	 * titel
	 *
	 * @var string
	 */
	protected $titel = '';

	/**
	 * anrede
	 *
	 * @var string
	 */
	protected $anrede = '';

	/**
	 * position
	 *
	 * @var string
	 */
	protected $position = '';

	/**
	 * anredeBrief
	 *
	 * @var string
	 */
	protected $anredeBrief = '';

	/**
	 * firma
	 *
	 * @var string
	 */
	protected $firma = '';

	/**
	 * zusatzfeld
	 *
	 * @var string
	 */
	protected $zusatzfeld = '';

	/**
	 * strasse
	 *
	 * @var string
	 */
	protected $strasse = '';

	/**
	 * hausnummer
	 *
	 * @var string
	 */
	protected $hausnummer = '';

	/**
	 * plz
	 *
	 * @var string
	 */
	protected $plz = '';

	/**
	 * postfach
	 *
	 * @var string
	 */
	protected $postfach = '';

	/**
	 * postfachPlz
	 *
	 * @var string
	 */
	protected $postfachPlz = '';

	/**
	 * emailZentrale
	 *
	 * @var string
	 */
	protected $emailZentrale = '';

	/**
	 * emailDirekt
	 *
	 * @var string
	 */
	protected $emailDirekt = '';

	/**
	 * emailPrivat
	 *
	 * @var string
	 */
	protected $emailPrivat = '';

	/**
	 * emailSonstige
	 *
	 * @var string
	 */
	protected $emailSonstige = '';

	/**
	 * emailFeedback
	 *
	 * @var string
	 */
	protected $emailFeedback = '';

	/**
	 * telefonZentrale
	 *
	 * @var string
	 */
	protected $telefonZentrale = '';

	/**
	 * telefonDurchwahl
	 *
	 * @var string
	 */
	protected $telefonDurchwahl = '';

	/**
	 * telefonFax
	 *
	 * @var string
	 */
	protected $telefonFax = '';

	/**
	 * telefonHandy
	 *
	 * @var string
	 */
	protected $telefonHandy = '';

	/**
	 * telefonPrivat
	 *
	 * @var string
	 */
	protected $telefonPrivat = '';

	/**
	 * telefonSonstige
	 *
	 * @var string
	 */
	protected $telefonSonstige = '';

	/**
	 * url
	 *
	 * @var string
	 */
	protected $url = '';

	/**
	 * adressfreigabe
	 *
	 * @var boolean
	 */
	protected $adressfreigabe = FALSE;

	/**
	 * personennummer
	 *
	 * @var string
	 */
	protected $personennummer = '';

	/**
	 * immobilientreuhaenderid
	 *
	 * @var string
	 */
	protected $immobilientreuhaenderid = '';

	/**
	 * foto
	 *
	 * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
	 */
	protected $foto = NULL;

	/**
	 * freitextfeld
	 *
	 * @var string
	 */
	protected $freitextfeld = '';

	/**
	 * ort
	 *
	 * @var string
	 */
	protected $ort = NULL;

	/**
	 * postfachOrt
	 *
	 * @var string
	 */
	protected $postfachOrt = NULL;

	/**
	 * land
	 *
	 * @var \Daho\SgEstateCore\Domain\Model\Land
	 */
	protected $land = NULL;

	/**
	 * Returns the name
	 *
	 * @return string $name
	 */
	public function getName() {
		return $this->name;
	}

	/**
	 * Sets the name
	 *
	 * @param string $name
	 * @return void
	 */
	public function setName($name) {
		$this->name = $name;
	}

	/**
	 * Returns the vorname
	 *
	 * @return string $vorname
	 */
	public function getVorname() {
		return $this->vorname;
	}

	/**
	 * Sets the vorname
	 *
	 * @param string $vorname
	 * @return void
	 */
	public function setVorname($vorname) {
		$this->vorname = $vorname;
	}

	/**
	 * Returns the titel
	 *
	 * @return string $titel
	 */
	public function getTitel() {
		return $this->titel;
	}

	/**
	 * Sets the titel
	 *
	 * @param string $titel
	 * @return void
	 */
	public function setTitel($titel) {
		$this->titel = $titel;
	}

	/**
	 * Returns the anrede
	 *
	 * @return string $anrede
	 */
	public function getAnrede() {
		return $this->anrede;
	}

	/**
	 * Sets the anrede
	 *
	 * @param string $anrede
	 * @return void
	 */
	public function setAnrede($anrede) {
		$this->anrede = $anrede;
	}

	/**
	 * Returns the position
	 *
	 * @return string $position
	 */
	public function getPosition() {
		return $this->position;
	}

	/**
	 * Sets the position
	 *
	 * @param string $position
	 * @return void
	 */
	public function setPosition($position) {
		$this->position = $position;
	}

	/**
	 * Returns the anredeBrief
	 *
	 * @return string $anredeBrief
	 */
	public function getAnredeBrief() {
		return $this->anredeBrief;
	}

	/**
	 * Sets the anredeBrief
	 *
	 * @param string $anredeBrief
	 * @return void
	 */
	public function setAnredeBrief($anredeBrief) {
		$this->anredeBrief = $anredeBrief;
	}

	/**
	 * Returns the firma
	 *
	 * @return string $firma
	 */
	public function getFirma() {
		return $this->firma;
	}

	/**
	 * Sets the firma
	 *
	 * @param string $firma
	 * @return void
	 */
	public function setFirma($firma) {
		$this->firma = $firma;
	}

	/**
	 * Returns the zusatzfeld
	 *
	 * @return string $zusatzfeld
	 */
	public function getZusatzfeld() {
		return $this->zusatzfeld;
	}

	/**
	 * Sets the zusatzfeld
	 *
	 * @param string $zusatzfeld
	 * @return void
	 */
	public function setZusatzfeld($zusatzfeld) {
		$this->zusatzfeld = $zusatzfeld;
	}

	/**
	 * Returns the strasse
	 *
	 * @return string $strasse
	 */
	public function getStrasse() {
		return $this->strasse;
	}

	/**
	 * Sets the strasse
	 *
	 * @param string $strasse
	 * @return void
	 */
	public function setStrasse($strasse) {
		$this->strasse = $strasse;
	}

	/**
	 * Returns the hausnummer
	 *
	 * @return string $hausnummer
	 */
	public function getHausnummer() {
		return $this->hausnummer;
	}

	/**
	 * Sets the hausnummer
	 *
	 * @param string $hausnummer
	 * @return void
	 */
	public function setHausnummer($hausnummer) {
		$this->hausnummer = $hausnummer;
	}

	/**
	 * Returns the plz
	 *
	 * @return string $plz
	 */
	public function getPlz() {
		return $this->plz;
	}

	/**
	 * Sets the plz
	 *
	 * @param string $plz
	 * @return void
	 */
	public function setPlz($plz) {
		$this->plz = $plz;
	}

	/**
	 * Returns the postfach
	 *
	 * @return string $postfach
	 */
	public function getPostfach() {
		return $this->postfach;
	}

	/**
	 * Sets the postfach
	 *
	 * @param string $postfach
	 * @return void
	 */
	public function setPostfach($postfach) {
		$this->postfach = $postfach;
	}

	/**
	 * Returns the postfachPlz
	 *
	 * @return string $postfachPlz
	 */
	public function getPostfachPlz() {
		return $this->postfachPlz;
	}

	/**
	 * Sets the postfachPlz
	 *
	 * @param string $postfachPlz
	 * @return void
	 */
	public function setPostfachPlz($postfachPlz) {
		$this->postfachPlz = $postfachPlz;
	}

	/**
	 * Returns the emailZentrale
	 *
	 * @return string $emailZentrale
	 */
	public function getEmailZentrale() {
		return $this->emailZentrale;
	}

	/**
	 * Sets the emailZentrale
	 *
	 * @param string $emailZentrale
	 * @return void
	 */
	public function setEmailZentrale($emailZentrale) {
		$this->emailZentrale = $emailZentrale;
	}

	/**
	 * Returns the emailDirekt
	 *
	 * @return string $emailDirekt
	 */
	public function getEmailDirekt() {
		return $this->emailDirekt;
	}

	/**
	 * Sets the emailDirekt
	 *
	 * @param string $emailDirekt
	 * @return void
	 */
	public function setEmailDirekt($emailDirekt) {
		$this->emailDirekt = $emailDirekt;
	}

	/**
	 * Returns the emailPrivat
	 *
	 * @return string $emailPrivat
	 */
	public function getEmailPrivat() {
		return $this->emailPrivat;
	}

	/**
	 * Sets the emailPrivat
	 *
	 * @param string $emailPrivat
	 * @return void
	 */
	public function setEmailPrivat($emailPrivat) {
		$this->emailPrivat = $emailPrivat;
	}

	/**
	 * Returns the emailSonstige
	 *
	 * @return string $emailSonstige
	 */
	public function getEmailSonstige() {
		return $this->emailSonstige;
	}

	/**
	 * Sets the emailSonstige
	 *
	 * @param string $emailSonstige
	 * @return void
	 */
	public function setEmailSonstige($emailSonstige) {
		$this->emailSonstige = $emailSonstige;
	}

	/**
	 * Returns the emailFeedback
	 *
	 * @return string $emailFeedback
	 */
	public function getEmailFeedback() {
		return $this->emailFeedback;
	}

	/**
	 * Sets the emailFeedback
	 *
	 * @param string $emailFeedback
	 * @return void
	 */
	public function setEmailFeedback($emailFeedback) {
		$this->emailFeedback = $emailFeedback;
	}

	/**
	 * Returns the telefonZentrale
	 *
	 * @return string $telefonZentrale
	 */
	public function getTelefonZentrale() {
		return $this->telefonZentrale;
	}

	/**
	 * Sets the telefonZentrale
	 *
	 * @param string $telefonZentrale
	 * @return void
	 */
	public function setTelefonZentrale($telefonZentrale) {
		$this->telefonZentrale = $telefonZentrale;
	}

	/**
	 * Returns the telefonDurchwahl
	 *
	 * @return string $telefonDurchwahl
	 */
	public function getTelefonDurchwahl() {
		return $this->telefonDurchwahl;
	}

	/**
	 * Sets the telefonDurchwahl
	 *
	 * @param string $telefonDurchwahl
	 * @return void
	 */
	public function setTelefonDurchwahl($telefonDurchwahl) {
		$this->telefonDurchwahl = $telefonDurchwahl;
	}

	/**
	 * Returns the telefonFax
	 *
	 * @return string $telefonFax
	 */
	public function getTelefonFax() {
		return $this->telefonFax;
	}

	/**
	 * Sets the telefonFax
	 *
	 * @param string $telefonFax
	 * @return void
	 */
	public function setTelefonFax($telefonFax) {
		$this->telefonFax = $telefonFax;
	}

	/**
	 * Returns the telefonHandy
	 *
	 * @return string $telefonHandy
	 */
	public function getTelefonHandy() {
		return $this->telefonHandy;
	}

	/**
	 * Sets the telefonHandy
	 *
	 * @param string $telefonHandy
	 * @return void
	 */
	public function setTelefonHandy($telefonHandy) {
		$this->telefonHandy = $telefonHandy;
	}

	/**
	 * Returns the telefonPrivat
	 *
	 * @return string $telefonPrivat
	 */
	public function getTelefonPrivat() {
		return $this->telefonPrivat;
	}

	/**
	 * Sets the telefonPrivat
	 *
	 * @param string $telefonPrivat
	 * @return void
	 */
	public function setTelefonPrivat($telefonPrivat) {
		$this->telefonPrivat = $telefonPrivat;
	}

	/**
	 * Returns the telefonSonstige
	 *
	 * @return string $telefonSonstige
	 */
	public function getTelefonSonstige() {
		return $this->telefonSonstige;
	}

	/**
	 * Sets the telefonSonstige
	 *
	 * @param string $telefonSonstige
	 * @return void
	 */
	public function setTelefonSonstige($telefonSonstige) {
		$this->telefonSonstige = $telefonSonstige;
	}

	/**
	 * Returns the url
	 *
	 * @return string $url
	 */
	public function getUrl() {
		return $this->url;
	}

	/**
	 * Sets the url
	 *
	 * @param string $url
	 * @return void
	 */
	public function setUrl($url) {
		$this->url = $url;
	}

	/**
	 * Returns the adressfreigabe
	 *
	 * @return boolean $adressfreigabe
	 */
	public function getAdressfreigabe() {
		return $this->adressfreigabe;
	}

	/**
	 * Sets the adressfreigabe
	 *
	 * @param boolean $adressfreigabe
	 * @return void
	 */
	public function setAdressfreigabe($adressfreigabe) {
		$this->adressfreigabe = $adressfreigabe;
	}

	/**
	 * Returns the boolean state of adressfreigabe
	 *
	 * @return boolean
	 */
	public function isAdressfreigabe() {
		return $this->adressfreigabe;
	}

	/**
	 * Returns the personennummer
	 *
	 * @return string $personennummer
	 */
	public function getPersonennummer() {
		return $this->personennummer;
	}

	/**
	 * Sets the personennummer
	 *
	 * @param string $personennummer
	 * @return void
	 */
	public function setPersonennummer($personennummer) {
		$this->personennummer = $personennummer;
	}

	/**
	 * Returns the immobilientreuhaenderid
	 *
	 * @return string $immobilientreuhaenderid
	 */
	public function getImmobilientreuhaenderid() {
		return $this->immobilientreuhaenderid;
	}

	/**
	 * Sets the immobilientreuhaenderid
	 *
	 * @param string $immobilientreuhaenderid
	 * @return void
	 */
	public function setImmobilientreuhaenderid($immobilientreuhaenderid) {
		$this->immobilientreuhaenderid = $immobilientreuhaenderid;
	}

	/**
	 * Returns the foto
	 *
	 * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $foto
	 */
	public function getFoto() {
		return $this->foto;
	}

	/**
	 * Sets the foto
	 *
	 * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $foto
	 * @return void
	 */
	public function setFoto(\TYPO3\CMS\Extbase\Domain\Model\FileReference $foto) {
		$this->foto = $foto;
	}

	/**
	 * Returns the freitextfeld
	 *
	 * @return string $freitextfeld
	 */
	public function getFreitextfeld() {
		return $this->freitextfeld;
	}

	/**
	 * Sets the freitextfeld
	 *
	 * @param string $freitextfeld
	 * @return void
	 */
	public function setFreitextfeld($freitextfeld) {
		$this->freitextfeld = $freitextfeld;
	}

	/**
	 * @return string
	 */
	public function getOrt() {
		return $this->ort;
	}

	/**
	 * @param $ort
	 */
	public function setOrt($ort) {
		$this->ort = $ort;
	}

	/**
	 * @return string
	 */
	public function getPostfachOrt() {
		return $this->postfachOrt;
	}

	/**
	 * @param $postfachOrt
	 */
	public function setPostfachOrt($postfachOrt) {
		$this->postfachOrt = $postfachOrt;
	}

	/**
	 * Returns the land
	 *
	 * @return \Daho\SgEstateCore\Domain\Model\Land $land
	 */
	public function getLand() {
		return $this->land;
	}

	/**
	 * Sets the land
	 *
	 * @param \Daho\SgEstateCore\Domain\Model\Land $land
	 * @return void
	 */
	public function setLand(\Daho\SgEstateCore\Domain\Model\Land $land) {
		$this->land = $land;
	}

    public function getEmailName(){
        $temp = explode('@', $this->getEmailZentrale());
        return $temp[0];
    }

    public function getEmailDomain(){
        $temp = explode('@', $this->getEmailZentrale());
        return $temp[1];
    }

}