<?php
namespace Daho\SgEstateCore\Util;

class SessionHandler {

    /**
     * @var string
     */
    private $prefixKey = 'sg_estate';

    /**
     * Returns the object stored in the user´s PHP session
     * @var $key string
     * @return Object the stored object
     */
    public function restoreFromSession($key) {
        $sessionData = $GLOBALS['TSFE']->fe_user->getKey('ses', $this->prefixKey . $key);
        return unserialize($sessionData);
    }

    /**
     * Writes an object into the PHP session
     * @param $object mixed serializable object to store into the session
     * @param $key string
     * @return $this
     */
    public function writeToSession($object, $key) {
        $sessionData = serialize($object);
        $GLOBALS['TSFE']->fe_user->setKey('ses', $this->prefixKey . $key, $sessionData);
        $GLOBALS['TSFE']->fe_user->storeSessionData();
        return $this;
    }

    /**
     * Cleans up the session: removes the stored object from the PHP session
     * @var $key string
     * @return $this
     */
    public function cleanUpSession($key) {
        $GLOBALS['TSFE']->fe_user->setKey('ses', $this->prefixKey . $key, NULL);
        $GLOBALS['TSFE']->fe_user->storeSessionData();
        return $this;
    }

    public function setPrefixKey($prefixKey) {
        $this->prefixKey = $prefixKey;
    }

}