<?php

namespace Daho\SgEstateCore\Domain\Model;


class Filter extends \TYPO3\CMS\Extbase\DomainObject\AbstractValueObject{

    /**
     * @var float
     */
    protected $raeumeAb;

    /**
     * @var float
     */
    protected $raeumeBis;

    /**
     * @var float
     */
    protected $flaecheAb;

    /**
     * @var float
     */
    protected $flaecheBis;

    /**
     * @var float
     */
    protected $kaltmieteAb;

    /**
     * @var float
     */
    protected $kaltmieteBis;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Ort>
     */
    protected $orte;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Stadtteil>
     */
    protected $stadtteile;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Objektart>
     */
    protected $objektarten;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Objektarttyp>
     */
    protected $objektarttypen;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Heizungsart>
     */
    protected $heizungsarten;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Befeuerungsart>
     */
    protected $befeuerungsarten;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Bodenbelag>
     */
    protected $bodenbelaege;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Kampagne>
     */
    protected $kampagnen;

    /**
     * @var integer
     */
    protected $einbaukueche;

    /**
     * @var integer
     */
    protected $balkon;

    /**
     * @var integer
     */
    protected $garten;

    /**
     * @var integer
     */
    protected $keller;

    /**
     * @var integer
     */
    protected $badMitWanne;

    /**
     * @var integer
     */
    protected $badMitDusche;

    /**
     * @var integer
     */
    protected $badMitFenster;

    /**
     * @var integer
     */
    protected $badModernisiert;

    /**
     * @var integer
     */
    protected $gaestewc;

    /**
     * @var integer
     */
    protected $haustiere;

    /**
     * @var integer
     */
    protected $wbs;

    /**
     * @var integer
     */
    protected $barrierefrei;

    /**
     * @var integer
     */
    protected $leichterZugang;

    /**
     * @var integer
     */
    protected $aufzug;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Daho\SgEstateCore\Domain\Model\Vermarktungsart>
     */
    protected $vermarktungsarten;

    /**
     * @var integer
     */
    protected $sortierung;

    /**
     * @var array
     */
    protected $uids;

    /**
     * @var array
     */
    protected $settings;

    public function __construct(){
        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $configurationManager = $objectManager->get('TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface');
        $frameworkConfiguration = $configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS);
        $this->settings = $frameworkConfiguration;
        $this->initStorageObjects();
    }

    protected function initStorageObjects() {
        $this->orte                 = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->stadtteile           = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->objektarten          = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->objektarttypen       = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->vermarktungsarten    = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->heizungsarten        = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->befeuerungsarten     = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->bodenbelaege         = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->kampagnen            = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * @param float $flaecheBis
     * @return $this
     */
    public function setFlaecheBis($flaecheBis)
    {
        $this->flaecheBis = $flaecheBis;
        return $this;
    }

    /**
     * @return float
     */
    public function getFlaecheBis()
    {
        if (($this->flaecheBis === null)&&(isset($this->settings['standards']['filter']['flaeche']['bis']))){
            return floatval($this->settings['standards']['filter']['flaeche']['bis']);
        }else{
            return $this->flaecheBis;
        }
    }

    /**
     * @param float $flaecheAb
     * @return $this
     */
    public function setFlaecheAb($flaecheAb)
    {
        $this->flaecheAb = $flaecheAb;
        return $this;
    }

    /**
     * @return float
     */
    public function getFlaecheAb()
    {
        if (($this->flaecheAb === null)&&(isset($this->settings['standards']['filter']['flaeche']['ab']))){
            return floatval($this->settings['standards']['filter']['flaeche']['ab']);
        }else{
            return $this->flaecheAb;
        }
    }

    /**
     * @param float $kaltmieteAb
     * @return $this
     */
    public function setKaltmieteAb($kaltmieteAb)
    {
        $this->kaltmieteAb = $kaltmieteAb;
        return $this;
    }

    /**
     * @return float
     */
    public function getKaltmieteAb()
    {
        if (($this->kaltmieteAb === null)&&(isset($this->settings['standards']['filter']['kaltmiete']['ab']))){
            return floatval($this->settings['standards']['filter']['kaltmiete']['ab']);
        }else{
            return $this->kaltmieteAb;
        }
    }

    /**
     * @param float $kaltmieteBis
     * @return $this
     */
    public function setKaltmieteBis($kaltmieteBis)
    {
        $this->kaltmieteBis = $kaltmieteBis;
        return $this;
    }

    /**
     * @return float
     */
    public function getKaltmieteBis()
    {
        if (($this->kaltmieteBis === null)&&(isset($this->settings['standards']['filter']['kaltmiete']['bis']))){
            return floatval($this->settings['standards']['filter']['kaltmiete']['bis']);
        }else{
            return $this->kaltmieteBis;
        }
    }

    /**
     * @param float $raeumeAb
     * @return $this
     */
    public function setRaeumeAb($raeumeAb)
    {
        $this->raeumeAb = $raeumeAb;
        return $this;
    }

    /**
     * @return float
     */
    public function getRaeumeAb()
    {
        if (($this->raeumeAb === null)&&(isset($this->settings['standards']['filter']['raeume']['ab']))){
            return floatval($this->settings['standards']['filter']['raeume']['ab']);
        }else{
            return $this->raeumeAb;
        }
    }

    /**
     * @param float $raeumeBis
     * @return $this
     */
    public function setRaeumeBis($raeumeBis)
    {
        $this->raeumeBis = $raeumeBis;
        return $this;
    }

    /**
     * @return float
     */
    public function getRaeumeBis()
    {
        if (($this->raeumeBis === null)&&(isset($this->settings['standards']['filter']['raeume']['bis']))){
            return floatval($this->settings['standards']['filter']['raeume']['bis']);
        }else{
            return $this->raeumeBis;
        }
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $orte
     * @return $this
     */
    public function setOrte(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $orte){
        $this->orte = $orte;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getOrte(){
        return $this->orte;
    }

    /**
     * @return \Daho\SgEstateCore\Domain\Model\Ort
     */
    public function getOrt(){
        $this->orte->rewind();
        return $this->orte->current();
    }

    /**
     * @param Ort $ort
     * @return $this
     */
    public function setOrt(\Daho\SgEstateCore\Domain\Model\Ort $ort){
        if ($this->orte->count() > 0){
            $this->orte->removeAll($this->orte);
        }

        $this->orte->attach($ort);
        return $this;
    }

    /**
     * @param Ort $ort
     * @return $this
     */
    public function addOrt(Ort $ort){
        $this->orte->attach($ort);
        return $this;
    }

    /**
     * @param Ort $ort
     * @return $this
     */
    public function removeOrt(Ort $ort){
        $this->orte->detach($ort);
        return $this;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $stadtteile
     * @return $this
     */
    public function setStadtteile(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $stadtteile){
        $this->stadtteile = $stadtteile;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getStadtteile(){
        return $this->stadtteile;
    }

    /**
     * @param Stadtteil $stadtteil
     * @return $this
     */
    public function addStadtteil(Stadtteil $stadtteil){
        $this->stadtteile->attach($stadtteil);
        return $this;
    }

    /**
     * @param Stadtteil $stadtteil
     * @return $this
     */
    public function removeStadtteil(Stadtteil $stadtteil){
        $this->stadtteile->detach($stadtteil);
        return $this;
    }

    public function getStadtteil(){
        if ($this->stadtteile->count() > 0){
            $this->stadtteile->rewind();
            return $this->stadtteile->current();
        }else{
            return null;
        }
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $objektarten
     * @return $this
     */
    public function setObjektarten(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $objektarten){
        $this->objektarten = $objektarten;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getObjektarten(){
        return $this->objektarten;
    }

    /**
     * @param Objektart $objektart
     * @return $this
     */
    public function addObjektart(\Daho\SgEstateCore\Domain\Model\Objektart $objektart){
        $this->objektarten->attach($objektart);
        return $this;
    }

    /**
     * @param Objektart $objektart
     * @return $this
     */
    public function removeObjektart(\Daho\SgEstateCore\Domain\Model\Objektart $objektart){
        $this->objektarten->detach($objektart);
        return $this;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $objektarttypen
     * @return $this
     */
    public function setObjektarttypen(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $objektarttypen){
        $this->objektarttypen = $objektarttypen;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getObjektarttypen(){
        return $this->objektarttypen;
    }

    /**
     * @param Objektarttyp $objektarttyp
     * @return $this
     */
    public function addObjektarttyp(Objektarttyp $objektarttyp){
        $this->objektarttypen->attach($objektarttyp);
        return $this;
    }

    /**
     * @param Objektarttyp $objektarttyp
     * @return $this
     */
    public function removeObjektarttyp(Objektarttyp $objektarttyp){
        $this->objektarttypen->detach($objektarttyp);
        return $this;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $heizungsarten
     * @return $this
     */
    public function setHeizungsarten(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $heizungsarten){
        $this->heizungsarten = $heizungsarten;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getHeizungsarten(){
        return $this->heizungsarten;
    }

    /**
     * @param Heizungsart $heizungsart
     * @return $this
     */
    public function addHeizungsart(Heizungsart $heizungsart){
        $this->heizungsarten->attach($heizungsart);
        return $this;
    }

    /**
     * @param Heizungsart $heizungsart
     * @return $this
     */
    public function removeHeizungsart(Heizungsart $heizungsart){
        $this->heizungsarten->detach($heizungsart);
        return $this;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $befeuerungsarten
     * @return $this
     */
    public function setBefeuerungsarten(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $befeuerungsarten){
        $this->befeuerungsarten = $befeuerungsarten;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getBefeuerungsarten(){
        return $this->befeuerungsarten;
    }

    /**
     * @param Befeuerungsart $befeuerungsart
     * @return $this
     */
    public function addBefeuerungsart(Befeuerungsart $befeuerungsart){
        $this->befeuerungsarten->attach($befeuerungsart);
        return $this;
    }

    /**
     * @param Befeuerungsart $befeuerungsart
     * @return $this
     */
    public function removeBefeuerungsart(Befeuerungsart $befeuerungsart){
        $this->befeuerungsarten->detach($befeuerungsart);
        return $this;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $bodenbelaege
     * @return $this
     */
    public function setBodenbelaege(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $bodenbelaege){
        $this->bodenbelaege = $bodenbelaege;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getBodenbelaege(){
        return $this->bodenbelaege;
    }

    /**
     * @param Bodenbelag $bodenbelag
     * @return $this
     */
    public function addBodenbelag(Bodenbelag $bodenbelag){
        $this->bodenbelaege->attach($bodenbelag);
        return $this;
    }

    /**
     * @param Bodenbelag $bodenbelag
     * @return $this
     */
    public function removeBodenbelag(Bodenbelag $bodenbelag){
        $this->bodenbelaege->detach($bodenbelag);
        return $this;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setEinbaukueche($value){
        $this->einbaukueche = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getEinbaukueche(){
        return $this->einbaukueche;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setBalkon($value){
        $this->balkon = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getBalkon(){
        return $this->balkon;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setGarten($value){
        $this->garten = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getGarten(){
        return $this->garten;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setKeller($value){
        $this->keller = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getKeller(){
        return $this->keller;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setBadMitWanne($value){
        $this->badMitWanne = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getBadMitWanne(){
        return $this->badMitWanne;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setBadMitDusche($value){
        $this->badMitDusche = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getBadMitDusche(){
        return $this->badMitDusche;
    }

    /**
     * @param $value
     */
    public function setBadMitFenster($value){
        $this->badMitFenster = $value;
    }

    /**
     * @return int
     */
    public function getBadMitFenster(){
        return $this->badMitFenster;
    }

    /**
     * @param int $badModernisiert
     */
    public function setBadModernisiert($badModernisiert)
    {
        $this->badModernisiert = $badModernisiert;
    }

    /**
     * @return int
     */
    public function getBadModernisiert()
    {
        return $this->badModernisiert;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setGaestewc($value){
        $this->gaestewc = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getGaestewc(){
        return $this->gaestewc;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setHaustiere($value){
        $this->haustiere = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getHaustiere(){
        return $this->haustiere;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setWbs($value){
        $this->wbs = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getWbs(){
        return $this->wbs;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setBarrierefrei($value){
        $this->barrierefrei = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getBarrierefrei(){
        return $this->barrierefrei;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setLeichterZugang($value){
        $this->leichterZugang = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getLeichterZugang(){
        return $this->leichterZugang;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setAufzug($value){
        $this->aufzug = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getAufzug(){
        return $this->aufzug;
    }

    /**
     * @param int $sortierung
     * @return $this
     */
    public function setSortierung($sortierung)
    {
        $this->sortierung = $sortierung;
        return $this;
    }

    /**
     * @return int
     */
    public function getSortierung()
    {
        return $this->sortierung;
    }

    /**
     * @param array $uids
     * @return $this
     */
    public function setUids($uids)
    {
        $this->uids = $uids;
        return $this;
    }

    /**
     * @return array
     */
    public function getUids()
    {
        return $this->uids;
    }

    public function getIstErweiterteSuche(){
        if (($this->getBalkon() > 0)||($this->getBadModernisiert()>0)||($this->getBarrierefrei()>0)||($this->getAufzug())){
            return true;
        }else{
            return false;
        }
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $kampagnen
     * @return $this
     */
    public function setKampagnen(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $kampagnen){
        $this->kampagnen = $kampagnen;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getKampagnen(){
        return $this->kampagnen;
    }

    /**
     * @param Kampagne $kampagne
     * @return $this
     */
    public function addKampagne(Kampagne $kampagne){
        $this->kampagnen->attach($kampagne);
        return $this;
    }

    /**
     * @param Kampagne $kampagne
     * @return $this
     */
    public function removeKampagne(Kampagne $kampagne){
        $this->kampagnen->detach($kampagne);
        return $this;
    }


    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $vermarktungsarten
     * @return $this
     */
    public function setVermarktungsarten(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $vermarktungsarten){
        $this->vermarktungsarten = $vermarktungsarten;
        return $this;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getVermarktungsarten(){
        return $this->vermarktungsarten;
    }

    /**
     * @param Vermarktungsart $vermarktungsart
     * @return $this
     */
    public function addVermarktungsart(\Daho\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsart){
        $this->vermarktungsarten->attach($vermarktungsart);
        return $this;
    }

    /**
     * @param Vermarktungsart $vermarktungsart
     * @return $this
     */
    public function removeVermarktungsart(\Daho\SgEstateCore\Domain\Model\Vermarktungsart $vermarktungsart){
        $this->vermarktungsarten->detach($vermarktungsart);
        return $this;
    }

    public function getSelectedObjektarttypen(){
        $return = array();
        foreach ($this->objektarttypen as $objektarttyp){
            $return[$objektarttyp->getKuerzel()] = 1;
        }
        return $return;
    }

    public function getSelectedHeizungsarten(){
        $return = array();
        foreach ($this->heizungsarten as $heizungsart){
            $return[$heizungsart->getKuerzel()] = 1;
        }
        return $return;
    }

    /**
     * @return string
     */
    public function getGroupedCitiesAndDistricts()
    {
        $r = "";
        $city = $this->getOrt();
        if( $city instanceof \Daho\SgEstateCore\Domain\Model\Ort )
        {
            $r = $city->getUid();
        }
        $district = $this->getStadtteil();
        if( $district instanceof \Daho\SgEstateCore\Domain\Model\Stadtteil )
        {
            $r .= '_'.$district->getUid();
        }
        return $r;
    }

}