<?php
namespace Daho\SgEstateCore\Util;

class Services{

  private $standardCountry = 'Germany';

  public function deleteAllRealties(){
    $result = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
      'uid,kontaktperson',
      'tx_sgestatecore_domain_model_immobilie',
      null
    );

    if (count($result) >= 1)
    {
      $this->deleteRealties($result);
    }
  }

  public function deleteAllUpdatableRealties($importNumber = null)
  {
    if ($importNumber == null){
      $result = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
        'uid,kontaktperson',
        'tx_sgestatecore_domain_model_immobilie',
        'updatable = 1'
      );
    }elseif (is_numeric($importNumber)){
      $result = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
        'uid,kontaktperson',
        'tx_sgestatecore_domain_model_immobilie',
        'updatable = 1 AND import_number = '.$importNumber
      );
    }

    if (count($result) >= 1)
    {
      $this->deleteRealties($result);

    }
  }

  public function deleteRealties($realties){
    foreach($realties as $row){
      // Kontaktperson löschen
      if (is_numeric($row['kontaktperson']))
      {
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_domain_model_kontaktperson',
          'uid = '.$row['kontaktperson']
        );
      }

      // Verknüpfungen löschen
      if (is_numeric($row['uid'])){
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_ausbaustufe_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_badausstattung_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_bauweise_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_bodenbelag_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_dachform_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_erschliessungdetails_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_heizungsart_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_befeuerungsart_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_himmelrichtung_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_kuechenausstattung_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_nutzungsart_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_vermarktungsart_mm',
          'uid_local = ' . $row['uid']
        );
        $GLOBALS['TYPO3_DB']->exec_DELETEquery(
          'tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm',
          'uid_local = ' . $row['uid']
        );
        //@todo: Delete User Simple, USer Extends, Kampagne
      }

      // Anhänge löschen

      $resultAnhaenge = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
        '*',
        'tx_sgestatecore_domain_model_anhang',
        'immobilie = '. $row['uid']
      );
      foreach ($resultAnhaenge as $anhang)
      {
        $resultSysFile = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
          'uid',
          'sys_file',
          'identifier LIKE "/uploads/tx_sgestatecore/media/'.$anhang['datei'].'"'
        );
        foreach($resultSysFile as $sysFile)
        {
          $resultProcessedFile = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
            'uid,identifier',
            'sys_file_processedfile',
            'original = '.$sysFile['uid']
          );


          foreach($resultProcessedFile as $processedFile){
            if ($processedFile['identifier'] != ''){
              @unlink(PATH_site.substr($processedFile['identifier'],1));

            }
            $GLOBALS['TYPO3_DB']->exec_DELETEquery(
              'sys_file_processedfile',
              'uid = ' . $processedFile['uid']
            );

          }
          $GLOBALS['TYPO3_DB']->exec_DELETEquery(
            'sys_file',
            'uid = ' . $sysFile['uid']
          );

        }
        if ($anhang['datei'] != '')
        {
          @unlink(PATH_site.'uploads/tx_sgestatecore/media/'. $anhang['datei']);
        }
      }

      $GLOBALS['TYPO3_DB']->exec_DELETEquery(
        'tx_sgestatecore_domain_model_anhang',
        'immobilie = ' . $row['uid']
      );

      // Immobiliendatensatz löschen
      $GLOBALS['TYPO3_DB']->exec_DELETEquery(
        'tx_sgestatecore_domain_model_immobilie',
        'uid = '.$row['uid']
      );


      // Cache löschen
      //@todo: Überprüfen
//                $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_realurl_urlencodecache');
//                $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_realurl_urldecodecache');
//                $GLOBALS['TYPO3_DB']->exec_TRUNCATEquery('tx_realurl_uniqalias');

      \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->flushCachesByTag('immobilie');
    }
  }

  public function geocodeRealties($renewAll = false){
    $where = '';
    if ($renewAll == false){
      $where = 'WHERE objekt_breitengrad = 0 OR objekt_laengengrad = 0';
    }

    $query = 'SELECT realty.uid,realty.objekt_plz as zip,realty.objekt_strasse as street,realty.objekt_hausnummer as housenumber,city.bezeichner as city,country.bezeichner as country 
                FROM tx_sgestatecore_domain_model_immobilie realty 
                LEFT JOIN tx_sgestatecore_domain_model_ort city ON city.uid=realty.objekt_ort 
                LEFT JOIN tx_sgestatecore_domain_model_land country ON country.uid=realty.objekt_land '. $where;
    $realtiesToGeocode = $GLOBALS['TYPO3_DB']->sql_query($query);
    if ($GLOBALS['TYPO3_DB']->sql_num_rows($realtiesToGeocode) > 0){
      while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($realtiesToGeocode)){
        $coordinates = $this->geocodeAddress($row['coutry'],$row['city'],$row['zip'],$row['street'],$row['housenumber']);

        if ($row['uid'] > 0 && $coordinates['longitude'] > 0 && $coordinates['latitude'] > 0){
          $updateArray = array(
            'objekt_laengengrad' => $coordinates['longitude'],
            'objekt_breitengrad' => $coordinates['latitude']
          );
          $GLOBALS['TYPO3_DB']->exec_UPDATEquery(
            'tx_sgestatecore_domain_model_immobilie',
            'uid = '.$row['uid'],
            $updateArray
          );
        }
      }
    }
  }

  private function geocodeAddress($country,$city,$zip,$street,$housenumber){
    if ($country == ''){
      $country = $this->standardCountry;
    }
    $result = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
      'longitude, latitude', // fields
      'tx_sgestatecore_geocode_cache', // from
      'zip="'.$zip.'" AND street="'.$street.'" AND housenumber="'.$housenumber.'" AND country="'.$country.'"' // where
    );
    if (count($result) > 0){
      $coordinates['longitude'] = $result[0]['longitude'];
      $coordinates['latitude'] = $result[0]['latitude'];

      return $coordinates;
    }

    $coordinates = null;
    $address =
      $this->convertMutation($country) . ', '. $zip . ' '.
      $this->convertMutation($city) . ', '.
      $this->convertMutation($street) . ' '.
      $housenumber;

    $delay = 0;
    $base_url = "http://maps.googleapis.com/maps/api/geocode/xml";

    $geocode_pending = true;

    while ($geocode_pending) {
      $request_url = $base_url . "?address=" . urlencode($address) . '&sensor=false';
      $xml = simplexml_load_file($request_url) or die("url not loading"); // @todo: Throw Error ??

      $status = $xml->status;
      if (strcmp($status, "OK") == 0) {
        // Successful geocode
        $geocode_pending = false;
        $coordinates = array(
          'latitude' => floatval($xml->result->geometry->location->lat),
          'longitude' => floatval($xml->result->geometry->location->lng)
        );
        $insertData = array(
          'zip'           => $zip,
          'street'        => $street,
          'housenumber'   => $housenumber,
          'country'       => $country,
          'longitude'     => floatval($xml->result->geometry->location->lng),
          'latitude'      => floatval($xml->result->geometry->location->lat),
        );
        $GLOBALS['TYPO3_DB']->exec_INSERTquery(
          'tx_sgestatecore_geocode_cache',
          $insertData
        );
      } else if (strcmp($status, "OVER_QUERY_LIMIT") == 0) {
        // sent geocodes too fast
        $delay += 100000;
      } else {
        // failure to geocode
        $geocode_pending = false;
      }
      usleep($delay);

    }
    return $coordinates;
  }

  /**
   * @param array $recipients
   * @param array $bcc
   * @param $sender
   * @param $subject
   * @param $templateRootPath
   * @param $templateName
   * @param array $variables
   * @param array $attachments
   * @param string $format
   * @return bool
   */
  public function sendTemplateEmail(array $recipients = array(), array $bcc = array(), $sender, $subject, $templateRootPath, $templateName, array $variables = array(), array $attachments = array(), $format = 'html') {
    /**
     * @var $emailView \TYPO3\CMS\Fluid\View\StandaloneView
     * @var $message \TYPO3\CMS\Core\Mail\MailMessage
     */
    $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

    if (strstr($templateRootPath,'EXT:')){
      $pathPart = strstr($templateRootPath,'/');
      $extensionKey = substr(strstr($templateRootPath,'/',true),4);

      if ($pathPart[0] == '/'){
        $pathPart = substr($pathPart,1);
      }
      $templateRootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($extensionKey).$pathPart;
    }
    $templatePathAndFilename = $templateRootPath . $templateName . '.' . $format;

    $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
    $emailView->setTemplatePathAndFilename($templatePathAndFilename);
    $emailView->setFormat($format);
    $emailView->assignMultiple($variables);

    $emailBody = $emailView->render();

    $message = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');

    if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)){
      $message->setFrom($sender);
    }else{
      return false;
    }

    // Add Recipients
    $recipients = array_filter($recipients);
    if (count($recipients) > 0){
      foreach ($recipients as $email){
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $message->addTo($email);
        }
      }
    }else{
      return false;
    }

    if (count($bcc) > 0){
      foreach ($bcc as $email){
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $message->addBcc($email);
        }
      }
    }

    if ($subject != ''){
      $message->setSubject($subject);
    }else{
      return false;
    }

    if ($format == 'text'){
      $mailFormat = 'text/text';
    }elseif ($format == 'html'){
      $mailFormat = 'text/html';
    }

    $message->setBody($emailBody, $mailFormat);

    if (count($attachments) > 0){
      foreach ($attachments as $attachment) {
        $message->attach(\Swift_Attachment::fromPath($attachment));
      }
    }

    $message->send();
    return $message->isSent();
  }

  /**
   * @param $value
   * @return mixed
   */
  private function convertMutation($value){
    $value = str_replace('ü','ue',$value);
    $value = str_replace('Ü','Ue',$value);
    $value = str_replace('ö','oe',$value);
    $value = str_replace('Ö','Oe',$value);
    $value = str_replace('ä','ae',$value);
    $value = str_replace('Ä','Ae',$value);
    $value = str_replace('ß','ss',$value);
    return $value;
  }

}