<?php

namespace SG\SgEstateCore\Util;

use Psr\Container\ContainerInterface;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Configuration\BackendConfigurationManager;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\VermarktungsartRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\BefeuerungsartRepository;
use SG\SgEstateCore\Domain\Repository\BodenbelagRepository;
use SG\SgEstateCore\Domain\Model\Objektart;
use SG\SgEstateCore\Domain\Model\Objektarttyp;
use SG\SgEstateCore\Domain\Model\Vermarktungsart;
use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use SG\SgEstateCore\Domain\Model\Heizungsart;
use SG\SgEstateCore\Domain\Model\Befeuerungsart;
use SG\SgEstateCore\Domain\Model\Bodenbelag;

class AddFields implements SingletonInterface
{
    /**
     * @var ContainerInterface
     */
    protected ContainerInterface $container;

    /**
     * Constructor
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * Returns all activated KindOfObjects for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addKindOfObjects(array $config): array
    {
        /** @var ObjektartRepository $objektartRepository */
        $objektartRepository = $this->container->get(ObjektartRepository::class);
        $optionList = [];

        foreach ($objektartRepository->findAll() as $objektart) {
            $optionList[] = [
                0 => $objektart->getBezeichner(),
                1 => $objektart->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated KindOfObjectTypes for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addKindOfObjectTypes(array $config): array
    {
        /** @var ObjektartRepository $objektartRepository */
        $objektartRepository = $this->container->get(ObjektartRepository::class);
        $optionList = [];

        foreach ($objektartRepository->findAll() as $objektart) {
            foreach ($objektart->getObjektarttypen() as $objektartTyp) {
                $optionList[] = [
                    0 => $objektart->getBezeichner() . ' - ' . $objektartTyp->getBezeichner(),
                    1 => $objektartTyp->getUid()
                ];
            }
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Marketing Types for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addMarketingTypes(array $config): array
    {
        /** @var VermarktungsartRepository $marketingTypeRepository */
        $marketingTypeRepository = $this->container->get(VermarktungsartRepository::class);
        $optionList = [];

        foreach ($marketingTypeRepository->findAll() as $marketingType) {
            $optionList[] = [
                0 => $marketingType->getBezeichner(),
                1 => $marketingType->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Cities for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addCities(array $config): array
    {
        /** @var OrtRepository $cityRepository */
        $cityRepository = $this->container->get(OrtRepository::class);
        $optionList = [];

        foreach ($cityRepository->findAll() as $city) {
            $optionList[] = [
                0 => $city->getBezeichner(),
                1 => $city->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Districts for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addDistricts(array $config): array
    {
        /** @var OrtRepository $cityRepository */
        $cityRepository = $this->container->get(OrtRepository::class);
        $optionList = [];

        foreach ($cityRepository->findAll() as $city) {
            foreach ($city->getStadtteile() as $district) {
                $optionList[] = [
                    0 => $city->getBezeichner() . ' - ' . $district->getBezeichner(),
                    1 => $district->getUid()
                ];
            }
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Heatingtypes for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addHeatingTypes(array $config): array
    {
        /** @var HeizungsartRepository $heatingTypeRepository */
        $heatingTypeRepository = $this->container->get(HeizungsartRepository::class);
        $optionList = [];

        foreach ($heatingTypeRepository->findAll() as $heatingType) {
            $optionList[] = [
                0 => $heatingType->getBezeichner(),
                1 => $heatingType->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Beacoaningtypes for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addBeacoaningTypes(array $config): array
    {
        /** @var BefeuerungsartRepository $beacoaningTypeRepository */
        $beacoaningTypeRepository = $this->container->get(BefeuerungsartRepository::class);
        $optionList = [];

        foreach ($beacoaningTypeRepository->findAll() as $beacoaningType) {
            $optionList[] = [
                0 => $beacoaningType->getBezeichner(),
                1 => $beacoaningType->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }

    /**
     * Returns all activated Floorings for use in Flexform
     *
     * @param array $config
     * @return array
     */
    public function addFlooring(array $config): array
    {
        /** @var BodenbelagRepository $flooringRepository */
        $flooringRepository = $this->container->get(BodenbelagRepository::class);
        $optionList = [];

        foreach ($flooringRepository->findAll() as $flooring) {
            $optionList[] = [
                0 => $flooring->getBezeichner(),
                1 => $flooring->getUid()
            ];
        }
        $config['items'] = array_merge($config['items'] ?? [], $optionList);
        return $config;
    }
}