<?php

namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Region extends AbstractEntity {

    protected string $bezeichner;
    /** @var ObjectStorage<Ort>|null  */
    protected ?ObjectStorage $orte = null;

    public function __construct(){
        $this->initStorageObjects();
    }

    protected function initStorageObjects(): void
    {
        $this->orte = new ObjectStorage();
    }

    public function getBezeichner(): string
    {
        return $this->bezeichner;
    }

    public function setBezeichner(string $bezeichner): void
    {
        $this->bezeichner = $bezeichner;
    }

    public function addOrt(Ort $ort): void{
        $this->orte->attach($ort);
    }

    public function removeOrt(Ort $ort): void{
        $this->orte->detach($ort);
    }

    public function getOrte(): ObjectStorage
    {
        return $this->orte;
    }

    public function setOrte(ObjectStorage $orte): void
    {
        $this->orte = $orte;
    }
}