<?php

namespace SG\SgEstateCore\Domain\Model;

use DateTime;
use SG\SgEstateCore\Enum\NullableBooleanEnum;
use SG\SgEstateCore\Util\SessionHandler;
use TYPO3\CMS\Core\Session\Backend\Exception\SessionNotCreatedException;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * Immobilie
 */
class Immobilie extends AbstractEntity
{

    protected SessionHandler          $sessionHandler;
    protected string                  $objektartZusatz                     = '';
    protected string                  $objektPlz                           = '';
    protected string                  $objektStrasse                       = '';
    protected string                  $objektHausnummer                    = '';
    protected string                  $objektBundesland                    = '';
    protected string                  $objektGemeindecode                  = '';
    protected string                  $objektFlur                          = '';
    protected string                  $objektFlurstueck                    = '';
    protected string                  $objektGemarkung                     = '';
    protected int                     $objektEtage                         = 0;
    protected int                     $objektAnzahlEtagen                  = 0;
    protected string                  $objektWohnungsnr                    = '';
    protected string                  $objektRegionalerZusatz              = '';
    protected int                     $objektKartenMakro                   = 0;
    protected int                     $objektKartenMikro                   = 0;
    protected int                     $objektVirtuelletour                 = 0;
    protected int                     $objektLuftbilder                    = 0;
    protected int                     $objektLageImBauLinks                = 0;
    protected int                     $objektLageImBauRechts               = 0;
    protected int                     $objektLageImBauVorne                = 0;
    protected int                     $objektLageImBauHinten               = 0;
    protected float                   $objektBreitengrad                   = 0.0;
    protected float                   $objektLaengengrad                   = 0.0;
    protected float                   $kaufpreis                           = 0.0;
    protected float                   $kaufpreisNetto                      = 0.0;
    protected float                   $kaufpreisNettoUst                   = 0.0;
    protected float                   $kaufpreisBrutto                     = 0.0;
    protected float                   $nettokaltmiete                      = 0.0;
    protected float                   $kaltmiete                           = 0.0;
    protected float                   $warmmiete                           = 0.0;
    protected float                   $nebenkosten                         = 0.0;
    protected NullableBooleanEnum                     $heizkostenEnthalten                 = NullableBooleanEnum::KEINE_AUSWAHL;
    protected float                   $heizkosten                          = 0.0;
    protected float                   $stellplatzMiete                     = 0.0;
    protected NullableBooleanEnum     $zzglMehrwertsteuer                  = NullableBooleanEnum::KEINE_AUSWAHL;
    protected float                   $mietzuschlaege                      = 0.0;
    protected float                   $hauptmietzinsNetto                  = 0.0;
    protected float                   $hauptmietzinsNettoUst               = 0.0;
    protected float                   $pauschalmiete                       = 0.0;
    protected float                   $betriebskostenNetto                 = 0.0;
    protected float                   $betriebskostenNettoUst              = 0.0;
    protected float                   $evbNetto                            = 0.0;
    protected float                   $evbNettoUst                         = 0.0;
    protected float                   $gesamtmieteNetto                    = 0.0;
    protected float                   $gesamtmieteNettoUst                 = 0.0;
    protected float                   $gesamtmieteBrutto                   = 0.0;
    protected float                   $gesamtbelastungNetto                = 0.0;
    protected float                   $gesamtbelastungNettoUst             = 0.0;
    protected float                   $gesamtbelastungBrutto               = 0.0;
    protected float                   $gesamtkostenProM2Von                = 0.0;
    protected float                   $gesamtkostenProM2Bis                = 0.0;
    protected float                   $heizkostenNetto                     = 0.0;
    protected float                   $heizkostenNettoUst                  = 0.0;
    protected float                   $monatlichekostenNetto               = 0.0;
    protected float                   $monatlichekostenNettoUst            = 0.0;
    protected float                   $monatlichekostenbrutto              = 0.0;
    protected float                   $nebenkostenProM2Von                 = 0.0;
    protected float                   $nebenkostenProM2Bis                 = 0.0;
    protected float                   $ruecklageNetto                      = 0.0;
    protected float                   $ruecklageNettoUst                   = 0.0;
    protected float                   $sonstigekostenNetto                 = 0.0;
    protected float                   $sonstigekostenNettoUst              = 0.0;
    protected float                   $sonstigemieteNetto                  = 0.0;
    protected float                   $sonstigemieteNettoUst               = 0.0;
    protected float                   $summemieteNetto                     = 0.0;
    protected float                   $summemieteNettoUst                  = 0.0;
    protected float                   $nettomieteProM2Von                  = 0.0;
    protected float                   $nettomieteProM2Bis                  = 0.0;
    protected float                   $pacht                               = 0.0;
    protected float                   $erbpacht                            = 0.0;
    protected float                   $hausgeld                            = 0.0;
    protected float                $abstand                  = 0.0;
    protected ?DateTime            $preisZeitraumVon         = null;
    protected ?DateTime            $preisZeitraumBis         = null;
    protected float                $mietpreisProM2           = 0.0;
    protected float                   $kaufpreisProM2                      = 0.0;
    protected NullableBooleanEnum                     $provisionspflichtig                 = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $innencourtage                       = '';
    protected int                     $innencourtageMitMwst                = 0;
    protected string                  $aussencourtage                      = '';
    protected int                     $aussencourtageMitMwst               = 0;
    protected string                  $courtageHinweis                     = '';
    protected float                   $provisionNetto                      = 0.0;
    protected float                   $provisionNettoUst                   = 0.0;
    protected float                   $provisionBrutto                     = 0.0;
    protected float                   $mwstSatz                            = 0.0;
    protected float                   $mwstGesamt                          = 0.0;
    protected string                  $freitextPreis                       = '';
    protected string                  $xfache                              = '';
    protected float                   $nettorendite                        = 0.0;
    protected float                   $nettorenditeSoll                    = 0.0;
    protected float                   $nettorenditeIst                     = 0.0;
    protected float                   $mieteinnahmenIst                    = 0.0;
    protected float                   $mieteinnahmenSoll                   = 0.0;
    protected float                   $erschliessungskosten                = 0.0;
    protected float                   $kaution                             = 0.0;
    protected string                  $kautionText                         = '';
    protected float                   $geschaeftsguthaben                  = 0.0;
    protected float                   $genossenschaftsanteile              = 0.0;
    protected float                   $vertragsabschlussgebuehr            = 0.0;
    protected string                  $stpCarport                          = '';
    protected string                  $stpDuplex                           = '';
    protected string                  $stpFreiplatz                        = '';
    protected string                  $stpGarage                           = '';
    protected string                  $stpParkhaus                         = '';
    protected string                  $stpTiefgarage                       = '';
    protected float                   $richtpreis                          = 0.0;
    protected float                   $richtpreisProM2                     = 0.0;
    protected float                   $wohnflaeche                         = 0.0;
    protected float                   $nutzflaeche                         = 0.0;
    protected float                   $gesamtflaeche                       = 0.0;
    protected float                   $ladenflaeche                        = 0.0;
    protected float                   $lagerflaeche                        = 0.0;
    protected float                   $verkaufsflaeche                     = 0.0;
    protected float                   $freiflaeche                         = 0.0;
    protected float                   $bueroflaeche                        = 0.0;
    protected float                   $bueroteilflaeche                    = 0.0;
    protected float                   $fensterfront                        = 0.0;
    protected float                   $verwaltungsflaeche                  = 0.0;
    protected float                   $gastroflaeche                       = 0.0;
    protected string                  $grundflaechenzahl                   = '';
    protected string                  $geschossflaechenzahl                = '';
    protected string                  $baumassenzahl                       = '';
    protected float                   $bruttogeschossflaechenzahl          = 0.0;
    protected float                   $grundstuecksflaeche                 = 0.0;
    protected float                   $sonstflaeche                        = 0.0;
    protected float                   $anzahlZimmer                        = 0.0;
    protected float                   $anzahlSchlafzimmer                  = 0.0;
    protected float                   $anzahlBadezimmer                    = 0.0;
    protected float                   $anzahlSeparateWc                    = 0.0;
    protected float                   $balkonTerasseFlaeche                = 0.0;
    protected float                   $anzahlWohnSchlafzimmer              = 0.0;
    protected float                   $gartenflaeche                       = 0.0;
    protected float                   $anzahlBalkone                       = 0.0;
    protected float                   $anzahlTerassen                      = 0.0;
    protected float                   $anzahlLogia                         = 0.0;
    protected float                   $fensterfrontM2                      = 0.0;
    protected float                   $grundstuecksfront                   = 0.0;
    protected float                   $dachbodenflaeche                    = 0.0;
    protected float                   $teilbarAb                           = 0.0;
    protected float                   $kellerflaeche                       = 0.0;
    protected float                   $beheizbareFlaeche                   = 0.0;
    protected float                   $anzahlStellplaetze                  = 0.0;
    protected float                   $plaetzeGastraum                     = 0.0;
    protected float                   $anzahlBetten                        = 0.0;
    protected float                   $anzahlBettenEinzel                  = 0.0;
    protected float                   $anzahlBettenDoppel                  = 0.0;
    protected float                   $anzahlBettenSchlafsofa              = 0.0;
    protected float                   $anzahlTagungsraeume                 = 0.0;
    protected float                   $vermietbareFlaeche                  = 0.0;
    protected float                   $anzahlWohneinheiten                 = 0.0;
    protected float                   $anzahlGewerbeeinheiten              = 0.0;
    protected int                     $einliegerwohnung                    = 0;
    protected float                   $kubatur                             = 0.0;
    protected float                   $ausnuetzungsziffer                  = 0.0;
    protected float                   $flaechevon                          = 0.0;
    protected float                   $flaechebis                          = 0.0;
    protected NullableBooleanEnum     $wgGeeignet                          = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $raeumeVeraenderbar                  = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $kamin                               = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $klimatisiert                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $aufzugPersonen                      = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $aufzugLasten                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $gartennutzung                       = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $moebliert                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $rollstuhlgerecht                    = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $kabelSatTv                          = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $kabelfernsehen                      = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $satellitenfernsehen                 = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $dvbt                                = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $barrierefrei                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $sauna                               = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $swimmingpool                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $waschTrockenraum                    = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $wintergarten                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $dvVerkabelung                       = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $rampe                               = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $hebebuehne                          = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $kran                                = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $gastterrasse                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected float                   $stromanschlusswert                  = 0.0;
    protected NullableBooleanEnum     $katineCafeteria                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $teekueche                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected float                   $hallenhoehe                         = 0.0;
    protected NullableBooleanEnum     $hotelrestaurantAngeschlossen        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $barAngeschlossen                    = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $brauereibindung                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $sporteinrichtungen                  = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $wellnessbereich                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $serviceBetreutesWohnen              = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $serviceCatering                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $serviceReinigung                    = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $serviceEinkauf                      = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $serviceWachdienst                   = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $telefonFerienimmobilie              = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $breitbandZugangArt                  = '';
    protected float                   $breitbandZugangSpeed                = 0.0;
    protected NullableBooleanEnum     $umtsEmpfang                         = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $sicherheitAlarmanlage               = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $sicherheitKamera                    = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $sicherheitPolizeiruf                = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $unterkellert                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $abstellraum                         = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $fahrradraum                         = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $rolladen                            = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $bibliothek                          = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $dachboden                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $gaestewc                            = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $kabelkanaele                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $seniorengerecht                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $baujahr                             = '';
    protected string                  $youtube                             = '';
    protected string                  $letztemodernisierung                = '';
    protected int                     $altertyp                            = 0;
    protected string                  $bauzone                             = '';
    protected string                  $altlasten                           = '';
    protected ?Energiepassart         $energiepassArt                      = null;
    protected string                  $energiepassGueltigBis               = '';
    protected string                  $energiepassEnergieverbrauchkennwert = '';
    protected int                     $energiepassMitwarmwasser            = 0;
    protected string                  $energiepassEndenergiebedarf         = '';
    protected ?Befeuerungsart         $energiepassPrimaerenergietraeger    = null;
    protected string                  $energiepassStromwert                = '';
    protected string                  $energiepassWaermewert               = '';
    protected string                  $energiepassWertklasse               = '';
    protected string               $energiepassBaujahr       = '';
    protected ?DateTime            $energiepassAusstelldatum = null;
    protected ?Energiepassjahrgang $energiepassJahrgang      = null;
    protected ?Energiepassgebaeudeart $energiepassGebaeudeart              = null;
    protected string                  $energiepassEpasstext                = '';
    protected string                  $energiepassHwbwert                  = '';
    protected string                  $energiepassHwbklasse                = '';
    protected string                  $energiepassFgeewert                 = '';
    protected string                  $energiepassFgeeklasse               = '';
    protected int                     $verkaufstatus                       = 0;
    protected int                     $zulieferung                         = 0;
    protected int                     $ausblick                            = 0;
    protected string                  $objekttitel                         = '';
    protected string                  $kurzbeschreibung                    = '';
    protected string                  $lage                                = '';
    protected string                  $austattungsbeschreibung             = '';
    protected string                  $objektbeschreibung                  = '';
    protected string                  $sonstigeAngaben                     = '';
    protected bool                    $objektadresseFreigeben              = false;
    protected string               $verfuegbarAb             = '';
    protected ?DateTime            $verfuegbarAbDatum        = null;
    protected ?DateTime            $verfuegbarBisDatum       = null;
    protected ?DateTime            $versteigerungstermin     = null;
    protected NullableBooleanEnum  $wbsErforderlich          = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $vermietet                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $gruppennummer                       = '';
    protected string                  $zugang                              = '';
    protected float                   $laufzeit                            = 0.0;
    protected int                     $minimalePersonenanzahl              = 0;
    protected int                     $maximalePersonenanzahl              = 0;
    protected NullableBooleanEnum     $nichtraucher                        = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $haustiere                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected int                     $geschlecht                          = 0;
    protected NullableBooleanEnum     $denkmalgeschuetzt                   = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $alsFerien                           = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $gewerblicheNutzung                  = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum     $badModernisiert                     = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $branchen                            = '';
    protected NullableBooleanEnum     $hochhaus                            = NullableBooleanEnum::KEINE_AUSWAHL;
    protected string                  $objektnrIntern                      = '';
    protected string               $objektnrExtern           = '';
    protected ?DateTime            $anzeigeAb                = null;
    protected ?DateTime            $anzeigeBis               = null;
    protected string               $openimmoObjid            = '';
    protected string               $kennungUrsprung          = '';
    protected ?DateTime            $standVom                 = null;
    protected bool                 $weitergabeGenerell       = false;
    protected string                  $weitergabePositivliste              = '';
    protected string                  $weitergabeNegativliste              = '';
    protected string                  $gruppenKennung                      = '';
    protected string                  $masterObjekt                        = '';
    protected bool                    $masterVisible                       = false;
    protected string                  $sprache                             = '';
    /** @var ObjectStorage<Nutzungsart>|null */
    protected ?ObjectStorage $nutzungsart = null;
    /** @var ObjectStorage<Vermarktungsart>|null */
    protected ?ObjectStorage $vermarktungsart        = null;
    protected ?Objektart     $objektart              = null;
    protected ?Objektarttyp  $objektarttyp           = null;
    protected ?Objektarttyp  $stellplatzObjektarttyp = null;
    protected ?Ort           $objektOrt              = null;
    protected ?Stadtteil     $objektStadtteil        = null;
    protected ?Land          $objektLand             = null;
    protected ?Lage          $objektLage             = null;
    protected ?Kontaktperson $kontaktperson          = null;
    /** @var ObjectStorage<Kontaktperson>|null */
    protected ?ObjectStorage        $weitereAdressen          = null;
    protected ?Periode              $preisZeiteinheit         = null;
    protected ?Periode              $mieteinnahmenIstPeriode  = null;
    protected ?Periode              $mieteinnahmenSollPeriode = null;
    protected ?Waehrung             $waehrung                 = null;
    protected ?Austattungskategorie $ausstattungsKategorie    = null;
    /** @var ObjectStorage<Badausstattung>|null */
    protected ?ObjectStorage $ausstattungBad = null;
    /** @var ObjectStorage<Kuechenausstattung>|null */
    protected ?ObjectStorage $ausstattungKueche = null;
    /** @var ObjectStorage<Bodenbelag>|null */
    protected ?ObjectStorage $ausstattungBoden = null;
    /** @var ObjectStorage<Heizungsart>|null */
    protected ?ObjectStorage $heizungsart = null;
    /** @var ObjectStorage<Befeuerungsart>|null */
    protected ?ObjectStorage $befeuerungsart = null;
    /** @var ObjectStorage<Himmelrichtung>|null */
    protected ?ObjectStorage $ausrichtBalkonTerasse = null;
    /** @var ObjectStorage<Dachform>|null */
    protected ?ObjectStorage $dachform = null;
    /** @var ObjectStorage<Bauweise>|null */
    protected ?ObjectStorage $bauweise = null;
    /** @var ObjectStorage<Ausbaustufe>|null */
    protected ?ObjectStorage $ausbaustufe   = null;
    protected ?Energietyp    $energietyp    = null;
    protected ?Zustand       $zustand       = null;
    protected ?Bebaubarnach  $bebaubarNach  = null;
    protected ?Erschliessung $erschliessung = null;
    /** @var ObjectStorage<Erschliessungdetails>|null */
    protected ?ObjectStorage $erschliessungUmfang = null;
    /** @var ObjectStorage<Anhang>|null */
    #[Cascade(['value' => 'remove'])]
    protected ?ObjectStorage      $anhaenge          = null;
    protected ?Periode            $minimaleMietdauer = null;
    protected ?Periode            $maximaleMietdauer = null;
    protected NullableBooleanEnum $gegensprechanlage = NullableBooleanEnum::KEINE_AUSWAHL;
    protected NullableBooleanEnum $leichtErreichbar  = NullableBooleanEnum::KEINE_AUSWAHL;
    protected bool                $updatable         = true;
    protected int                 $importNumber      = 0;
    protected string              $distance          = '';

    public function __construct(SessionHandler $sessionHandler)
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
        $this->sessionHandler = $sessionHandler;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects(): void
    {
        $this->nutzungsart = new ObjectStorage();
        $this->vermarktungsart = new ObjectStorage();
        $this->weitereAdressen = new ObjectStorage();
        $this->ausstattungBad = new ObjectStorage();
        $this->ausstattungKueche = new ObjectStorage();
        $this->ausstattungBoden = new ObjectStorage();
        $this->heizungsart = new ObjectStorage();
        $this->befeuerungsart = new ObjectStorage();
        $this->ausrichtBalkonTerasse = new ObjectStorage();
        $this->dachform = new ObjectStorage();
        $this->bauweise = new ObjectStorage();
        $this->ausbaustufe = new ObjectStorage();
        $this->erschliessung = new ObjectStorage();
        $this->erschliessungUmfang = new ObjectStorage();
        $this->anhaenge = new ObjectStorage();
    }

    
    public function getObjektartZusatz(): string
    {
        return $this->objektartZusatz;
    }

    
    public function setObjektartZusatz(string $objektartZusatz): Immobilie
    {
        $this->objektartZusatz = $objektartZusatz;
        return $this;
    }

    public function getObjektPlz(): string
    {
        return $this->objektPlz;
    }

    
    public function setObjektPlz(string $objektPlz): Immobilie
    {
        $this->objektPlz = $objektPlz;
        return $this;
    }

    public function getObjektStrasse(): string
    {
        return $this->objektStrasse;
    }

    public function setObjektStrasse(string $objektStrasse): Immobilie
    {
        $this->objektStrasse = $objektStrasse;
        return $this;
    }

    public function getObjektHausnummer(): string
    {
        return $this->objektHausnummer;
    }

    public function setObjektHausnummer(string $objektHausnummer): Immobilie
    {
        $this->objektHausnummer = $objektHausnummer;
        return $this;
    }

    public function getObjektBundesland(): string
    {
        return $this->objektBundesland;
    }

    public function setObjektBundesland(string $objektBundesland): Immobilie
    {
        $this->objektBundesland = $objektBundesland;
        return $this;
    }

    public function getObjektGemeindecode(): string
    {
        return $this->objektGemeindecode;
    }

    public function setObjektGemeindecode(string $objektGemeindecode): Immobilie
    {
        $this->objektGemeindecode = $objektGemeindecode;
        return $this;
    }

    public function getObjektFlur(): string
    {
        return $this->objektFlur;
    }

    public function setObjektFlur(string $objektFlur): Immobilie
    {
        $this->objektFlur = $objektFlur;
        return $this;
    }

    public function getObjektFlurstueck(): string
    {
        return $this->objektFlurstueck;
    }

    public function setObjektFlurstueck(string $objektFlurstueck): Immobilie
    {
        $this->objektFlurstueck = $objektFlurstueck;
        return $this;
    }

    public function getObjektGemarkung(): string
    {
        return $this->objektGemarkung;
    }

    public function setObjektGemarkung(string $objektGemarkung): Immobilie
    {
        $this->objektGemarkung = $objektGemarkung;
        return $this;
    }

    public function getObjektEtage(): int
    {
        return $this->objektEtage;
    }

    public function setObjektEtage(int $objektEtage): Immobilie
    {
        $this->objektEtage = $objektEtage;
        return $this;
    }

    public function getObjektAnzahlEtagen(): int
    {
        return $this->objektAnzahlEtagen;
    }

    public function setObjektAnzahlEtagen(int $objektAnzahlEtagen): Immobilie
    {
        $this->objektAnzahlEtagen = $objektAnzahlEtagen;
        return $this;
    }

    public function getObjektWohnungsnr(): string
    {
        return $this->objektWohnungsnr;
    }

    public function setObjektWohnungsnr(string $objektWohnungsnr): Immobilie
    {
        $this->objektWohnungsnr = $objektWohnungsnr;
        return $this;
    }

    public function getObjektRegionalerZusatz(): string
    {
        return $this->objektRegionalerZusatz;
    }

    public function setObjektRegionalerZusatz(string $objektRegionalerZusatz): Immobilie
    {
        $this->objektRegionalerZusatz = $objektRegionalerZusatz;
        return $this;
    }

    public function getObjektKartenMakro(): int
    {
        return $this->objektKartenMakro;
    }

    public function setObjektKartenMakro(int $objektKartenMakro): Immobilie
    {
        $this->objektKartenMakro = $objektKartenMakro;
        return $this;
    }

    public function getObjektKartenMikro(): int
    {
        return $this->objektKartenMikro;
    }

    public function setObjektKartenMikro(int $objektKartenMikro): Immobilie
    {
        $this->objektKartenMikro = $objektKartenMikro;
        return $this;
    }

    public function getObjektVirtuelletour(): int
    {
        return $this->objektVirtuelletour;
    }

    public function setObjektVirtuelletour(int $objektVirtuelletour): Immobilie
    {
        $this->objektVirtuelletour = $objektVirtuelletour;
        return $this;
    }

    public function getObjektLuftbilder(): int
    {
        return $this->objektLuftbilder;
    }

    public function setObjektLuftbilder(int $objektLuftbilder): Immobilie
    {
        $this->objektLuftbilder = $objektLuftbilder;
        return $this;
    }

    public function getObjektLageImBauLinks(): int
    {
        return $this->objektLageImBauLinks;
    }

    public function setObjektLageImBauLinks(int $objektLageImBauLinks): Immobilie
    {
        $this->objektLageImBauLinks = $objektLageImBauLinks;
        return $this;
    }

    public function getObjektLageImBauRechts(): int
    {
        return $this->objektLageImBauRechts;
    }

    public function setObjektLageImBauRechts(int $objektLageImBauRechts): Immobilie
    {
        $this->objektLageImBauRechts = $objektLageImBauRechts;
        return $this;
    }

    public function getObjektLageImBauVorne(): int
    {
        return $this->objektLageImBauVorne;
    }

    public function setObjektLageImBauVorne(int $objektLageImBauVorne): Immobilie
    {
        $this->objektLageImBauVorne = $objektLageImBauVorne;
        return $this;
    }

    public function getObjektLageImBauHinten(): int
    {
        return $this->objektLageImBauHinten;
    }

    public function setObjektLageImBauHinten(int $objektLageImBauHinten): Immobilie
    {
        $this->objektLageImBauHinten = $objektLageImBauHinten;
        return $this;
    }

    public function getKaufpreis(): float
    {
        return $this->kaufpreis;
    }

    public function setKaufpreis(float $kaufpreis): Immobilie
    {
        $this->kaufpreis = $kaufpreis;
        return $this;
    }

    public function getKaufpreisNetto(): float
    {
        return $this->kaufpreisNetto;
    }

    public function setKaufpreisNetto(float $kaufpreisNetto): Immobilie
    {
        $this->kaufpreisNetto = $kaufpreisNetto;
        return $this;
    }

    public function getKaufpreisNettoUst(): float
    {
        return $this->kaufpreisNettoUst;
    }

    public function setKaufpreisNettoUst(float $kaufpreisNettoUst): Immobilie
    {
        $this->kaufpreisNettoUst = $kaufpreisNettoUst;
        return $this;
    }

    public function getKaufpreisBrutto(): float
    {
        return $this->kaufpreisBrutto;
    }

    public function setKaufpreisBrutto($kaufpreisBrutto): Immobilie
    {
        $this->kaufpreisBrutto = $kaufpreisBrutto;
        return $this;
    }

    /**
     * Gets any kaltmiete that's attached to the object
     */
    public function getAnyKaltmiete(): float
    {
        if ($this->getKaltmiete() > 0) {
            return $this->getKaltmiete();
        }

        if ($this->getNettokaltmiete() > 0) {
            return $this->getNettokaltmiete();
        }
        return 0.0;
    }

    public function getKaltmiete(): float
    {
        return $this->kaltmiete;
    }

    public function setKaltmiete(float $kaltmiete): Immobilie
    {
        $this->kaltmiete = $kaltmiete;
        return $this;
    }

    public function getNettokaltmiete(): float
    {
        return $this->nettokaltmiete;
    }

    public function setNettokaltmiete(float $nettokaltmiete): Immobilie
    {
        $this->nettokaltmiete = $nettokaltmiete;
        return $this;
    }

    public function getWarmmiete(): float
    {
        return $this->warmmiete;
    }

    public function setWarmmiete(float $warmmiete): Immobilie
    {
        $this->warmmiete = $warmmiete;
        return $this;
    }

    public function getGesamtmiete(): float
    {
        return $this->kaltmiete + $this->nebenkosten + $this->heizkosten;
    }

    public function getStellplatzMiete(): float
    {
        return $this->stellplatzMiete;
    }

    public function setStellplatzMiete(float $stellplatzMiete): Immobilie
    {
        $this->stellplatzMiete = $stellplatzMiete;
        return $this;
    }

    public function getZzglMehrwertsteuer(): NullableBooleanEnum
    {
        return $this->zzglMehrwertsteuer;
    }

    public function setZzglMehrwertsteuer(NullableBooleanEnum $zzglMehrwertsteuer): Immobilie
    {
        $this->zzglMehrwertsteuer = $zzglMehrwertsteuer;
        return $this;
    }

    public function getMietzuschlaege(): float
    {
        return $this->mietzuschlaege;
    }

    public function setMietzuschlaege(float $mietzuschlaege): Immobilie
    {
        $this->mietzuschlaege = $mietzuschlaege;
        return $this;
    }

    public function getHauptmietzinsNetto(): float
    {
        return $this->hauptmietzinsNetto;
    }

    public function setHauptmietzinsNetto(float $hauptmietzinsNetto): Immobilie
    {
        $this->hauptmietzinsNetto = $hauptmietzinsNetto;
        return $this;
    }

    public function getHauptmietzinsNettoUst(): float
    {
        return $this->hauptmietzinsNettoUst;
    }

    public function setHauptmietzinsNettoUst(float $hauptmietzinsNettoUst): Immobilie
    {
        $this->hauptmietzinsNettoUst = $hauptmietzinsNettoUst;
        return $this;
    }

    public function getPauschalmiete(): float
    {
        return $this->pauschalmiete;
    }

    public function setPauschalmiete(float $pauschalmiete): Immobilie
    {
        $this->pauschalmiete = $pauschalmiete;
        return $this;
    }

    public function getBetriebskostenNetto(): float
    {
        return $this->betriebskostenNetto;
    }

    public function setBetriebskostenNetto(float $betriebskostenNetto): Immobilie
    {
        $this->betriebskostenNetto = $betriebskostenNetto;
        return $this;
    }

    public function getBetriebskostenNettoUst(): float
    {
        return $this->betriebskostenNettoUst;
    }

    public function setBetriebskostenNettoUst(float $betriebskostenNettoUst): Immobilie
    {
        $this->betriebskostenNettoUst = $betriebskostenNettoUst;
        return $this;
    }

    public function getEvbNetto(): float
    {
        return $this->evbNetto;
    }

    public function setEvbNetto(float $evbNetto): Immobilie
    {
        $this->evbNetto = $evbNetto;
        return $this;
    }

    public function getEvbNettoUst(): float
    {
        return $this->evbNettoUst;
    }

    public function setEvbNettoUst(float $evbNettoUst): Immobilie
    {
        $this->evbNettoUst = $evbNettoUst;
        return $this;
    }

    public function getGesamtmieteNetto(): float
    {
        return $this->gesamtmieteNetto;
    }

    public function setGesamtmieteNetto(float $gesamtmieteNetto): Immobilie
    {
        $this->gesamtmieteNetto = $gesamtmieteNetto;
        return $this;
    }

    public function getGesamtmieteNettoUst(): float
    {
        return $this->gesamtmieteNettoUst;
    }

    public function setGesamtmieteNettoUst(float $gesamtmieteNettoUst): Immobilie
    {
        $this->gesamtmieteNettoUst = $gesamtmieteNettoUst;
        return $this;
    }


    public function getGesamtmieteBrutto(): float
    {
        if ($this->gesamtmieteBrutto === 0.0) {
            $return = 0;
            if ($this->getKaltmiete() > 0) {
                $return += $this->getKaltmiete();
            } else {
                $return += $this->getNettokaltmiete();
            }
            $return += $this->getNebenkosten();
            if ($this->getHeizkostenEnthalten() === NullableBooleanEnum::POSITIVE_AUSWAHL) {
                $return += $this->getHeizkosten();
            }
            return $return;
        }

        return $this->gesamtmieteBrutto;
    }

    public function setGesamtmieteBrutto(float $gesamtmieteBrutto): Immobilie
    {
        $this->gesamtmieteBrutto = $gesamtmieteBrutto;
        return $this;
    }

    public function getNebenkosten(): float
    {
        return $this->nebenkosten;
    }

    public function setNebenkosten(float $nebenkosten): Immobilie
    {
        $this->nebenkosten = $nebenkosten;
        return $this;
    }

    public function getHeizkostenEnthalten(): NullableBooleanEnum
    {
        return $this->heizkostenEnthalten;
    }

    public function setHeizkostenEnthalten(NullableBooleanEnum $heizkostenEnthalten): Immobilie
    {
        $this->heizkostenEnthalten = $heizkostenEnthalten;
        return $this;
    }

    public function getHeizkosten(): float
    {
        return $this->heizkosten;
    }

    public function setHeizkosten(float $heizkosten): Immobilie
    {
        $this->heizkosten = $heizkosten;
        return $this;
    }

    public function getGesamtbelastungNetto(): float
    {
        return $this->gesamtbelastungNetto;
    }

    public function setGesamtbelastungNetto(float $gesamtbelastungNetto): Immobilie
    {
        $this->gesamtbelastungNetto = $gesamtbelastungNetto;
        return $this;
    }

    public function getGesamtbelastungNettoUst(): float
    {
        return $this->gesamtbelastungNettoUst;
    }

    public function setGesamtbelastungNettoUst(float $gesamtbelastungNettoUst): Immobilie
    {
        $this->gesamtbelastungNettoUst = $gesamtbelastungNettoUst;
        return $this;
    }

    public function getGesamtbelastungBrutto(): float
    {
        return $this->gesamtbelastungBrutto;
    }

    public function setGesamtbelastungBrutto(float $gesamtbelastungBrutto): Immobilie
    {
        $this->gesamtbelastungBrutto = $gesamtbelastungBrutto;
        return $this;
    }

    public function getGesamtkostenProM2Von(): float
    {
        return $this->gesamtkostenProM2Von;
    }

    public function setGesamtkostenProM2Von(float $gesamtkostenProM2Von): Immobilie
    {
        $this->gesamtkostenProM2Von = $gesamtkostenProM2Von;
        return $this;
    }

    public function getGesamtkostenProM2Bis(): float
    {
        return $this->gesamtkostenProM2Bis;
    }

    public function setGesamtkostenProM2Bis(float $gesamtkostenProM2Bis): Immobilie
    {
        $this->gesamtkostenProM2Bis = $gesamtkostenProM2Bis;
        return $this;
    }

    public function getHeizkostenNetto(): float
    {
        return $this->heizkostenNetto;
    }

    public function setHeizkostenNetto(float $heizkostenNetto): Immobilie
    {
        $this->heizkostenNetto = $heizkostenNetto;
        return $this;
    }

    public function getHeizkostenNettoUst(): float
    {
        return $this->heizkostenNettoUst;
    }

    public function setHeizkostenNettoUst(float $heizkostenNettoUst): Immobilie
    {
        $this->heizkostenNettoUst = $heizkostenNettoUst;
        return $this;
    }

    public function getMonatlichekostenNetto(): float
    {
        return $this->monatlichekostenNetto;
    }

    public function setMonatlichekostenNetto(float $monatlichekostenNetto): Immobilie
    {
        $this->monatlichekostenNetto = $monatlichekostenNetto;
        return $this;
    }

    public function getMonatlichekostenNettoUst(): float
    {
        return $this->monatlichekostenNettoUst;
    }

    public function setMonatlichekostenNettoUst(float $monatlichekostenNettoUst): Immobilie
    {
        $this->monatlichekostenNettoUst = $monatlichekostenNettoUst;
        return $this;
    }

    public function getMonatlichekostenbrutto(): float
    {
        return $this->monatlichekostenbrutto;
    }

    public function setMonatlichekostenbrutto(float $monatlichekostenbrutto): Immobilie
    {
        $this->monatlichekostenbrutto = $monatlichekostenbrutto;
        return $this;
    }

    public function getNebenkostenProM2Von(): float
    {
        return $this->nebenkostenProM2Von;
    }

    public function setNebenkostenProM2Von(float $nebenkostenProM2Von): Immobilie
    {
        $this->nebenkostenProM2Von = $nebenkostenProM2Von;
        return $this;
    }

    public function getNebenkostenProM2Bis(): float
    {
        return $this->nebenkostenProM2Bis;
    }

    public function setNebenkostenProM2Bis(float $nebenkostenProM2Bis): Immobilie
    {
        $this->nebenkostenProM2Bis = $nebenkostenProM2Bis;
        return $this;
    }

    public function getRuecklageNetto(): float
    {
        return $this->ruecklageNetto;
    }

    public function setRuecklageNetto(float $ruecklageNetto): Immobilie
    {
        $this->ruecklageNetto = $ruecklageNetto;
        return $this;
    }

    public function getRuecklageNettoUst(): float
    {
        return $this->ruecklageNettoUst;
    }

    public function setRuecklageNettoUst(float $ruecklageNettoUst): Immobilie
    {
        $this->ruecklageNettoUst = $ruecklageNettoUst;
        return $this;
    }

    public function getSonstigekostenNetto(): float
    {
        return $this->sonstigekostenNetto;
    }

    public function setSonstigekostenNetto($sonstigekostenNetto): Immobilie
    {
        $this->sonstigekostenNetto = $sonstigekostenNetto;
        return $this;
    }

    public function getSonstigekostenNettoUst(): float
    {
        return $this->sonstigekostenNettoUst;
    }

    public function setSonstigekostenNettoUst(float $sonstigekostenNettoUst): Immobilie
    {
        $this->sonstigekostenNettoUst = $sonstigekostenNettoUst;
        return $this;
    }

    public function getSonstigemieteNetto(): float
    {
        return $this->sonstigemieteNetto;
    }

    public function setSonstigemieteNetto(float $sonstigemieteNetto): Immobilie
    {
        $this->sonstigemieteNetto = $sonstigemieteNetto;
        return $this;
    }

    public function getSonstigemieteNettoUst(): float
    {
        return $this->sonstigemieteNettoUst;
    }

    public function setSonstigemieteNettoUst(float $sonstigemieteNettoUst): Immobilie
    {
        $this->sonstigemieteNettoUst = $sonstigemieteNettoUst;
        return $this;
    }

    public function getSummemieteNetto(): float
    {
        return $this->summemieteNetto;
    }

    public function setSummemieteNetto(float $summemieteNetto): Immobilie
    {
        $this->summemieteNetto = $summemieteNetto;
        return $this;
    }

    public function getSummemieteNettoUst(): float
    {
        return $this->summemieteNettoUst;
    }

    public function setSummemieteNettoUst(float $summemieteNettoUst): Immobilie
    {
        $this->summemieteNettoUst = $summemieteNettoUst;
        return $this;
    }

    public function getNettomieteProM2Von(): float
    {
        return $this->nettomieteProM2Von;
    }

    public function setNettomieteProM2Von(float $nettomieteProM2Von): Immobilie
    {
        $this->nettomieteProM2Von = $nettomieteProM2Von;
        return $this;
    }

    public function getNettomieteProM2Bis(): float
    {
        return $this->nettomieteProM2Bis;
    }

    public function setNettomieteProM2Bis(float $nettomieteProM2Bis): Immobilie
    {
        $this->nettomieteProM2Bis = $nettomieteProM2Bis;
        return $this;
    }

    public function getPacht(): float
    {
        return $this->pacht;
    }

    public function setPacht(float $pacht): Immobilie
    {
        $this->pacht = $pacht;
        return $this;
    }

    public function getErbpacht(): float
    {
        return $this->erbpacht;
    }

    public function setErbpacht(float $erbpacht): Immobilie
    {
        $this->erbpacht = $erbpacht;
        return $this;
    }

    public function getHausgeld(): float
    {
        return $this->hausgeld;
    }

    public function setHausgeld(float $hausgeld): Immobilie
    {
        $this->hausgeld = $hausgeld;
        return $this;
    }

    public function getAbstand(): float
    {
        return $this->abstand;
    }

    public function setAbstand(float $abstand): Immobilie
    {
        $this->abstand = $abstand;
        return $this;
    }

    public function getPreisZeitraumVon(): DateTime
    {
        return $this->preisZeitraumVon;
    }

    public function setPreisZeitraumVon(DateTime $preisZeitraumVon): Immobilie
    {
        $this->preisZeitraumVon = $preisZeitraumVon;
        return $this;
    }

    public function getPreisZeitraumBis(): DateTime
    {
        return $this->preisZeitraumBis;
    }

    public function setPreisZeitraumBis(DateTime $preisZeitraumBis): Immobilie
    {
        $this->preisZeitraumBis = $preisZeitraumBis;
        return $this;
    }

    public function getMietpreisProM2(): float
    {
        return $this->mietpreisProM2;
    }

    public function setMietpreisProM2(float $mietpreisProM2): Immobilie
    {
        $this->mietpreisProM2 = $mietpreisProM2;
        return $this;
    }

    public function getKaufpreisProM2(): float
    {
        return $this->kaufpreisProM2;
    }

    public function setKaufpreisProM2(float $kaufpreisProM2): Immobilie
    {
        $this->kaufpreisProM2 = $kaufpreisProM2;
        return $this;
    }

    public function getProvisionspflichtig(): NullableBooleanEnum
    {
        return $this->provisionspflichtig;
    }

    public function setProvisionspflichtig(NullableBooleanEnum $provisionspflichtig): Immobilie
    {
        $this->provisionspflichtig = $provisionspflichtig;
        return $this;
    }

    public function getInnencourtage(): string
    {
        return $this->innencourtage;
    }

    public function setInnencourtage(string $innencourtage): Immobilie
    {
        $this->innencourtage = $innencourtage;
        return $this;
    }

    public function getInnencourtageMitMwst(): int
    {
        return $this->innencourtageMitMwst;
    }

    public function setInnencourtageMitMwst(int $innencourtageMitMwst): Immobilie
    {
        $this->innencourtageMitMwst = $innencourtageMitMwst;
        return $this;
    }

    public function getAussencourtage(): string
    {
        return $this->aussencourtage;
    }

    public function setAussencourtage(string $aussencourtage): Immobilie
    {
        $this->aussencourtage = $aussencourtage;
        return $this;
    }

    public function getAussencourtageMitMwst(): int
    {
        return $this->aussencourtageMitMwst;
    }

    public function setAussencourtageMitMwst(int $aussencourtageMitMwst): Immobilie
    {
        $this->aussencourtageMitMwst = $aussencourtageMitMwst;
        return $this;
    }

    public function getCourtageHinweis(): string
    {
        return $this->courtageHinweis;
    }

    public function setCourtageHinweis(string $courtageHinweis): Immobilie
    {
        $this->courtageHinweis = $courtageHinweis;
        return $this;
    }

    public function getProvisionNetto(): float
    {
        return $this->provisionNetto;
    }

    public function setProvisionNetto(float $provisionNetto): Immobilie
    {
        $this->provisionNetto = $provisionNetto;
        return $this;
    }

    public function getProvisionNettoUst(): float
    {
        return $this->provisionNettoUst;
    }

    public function setProvisionNettoUst(float $provisionNettoUst): Immobilie
    {
        $this->provisionNettoUst = $provisionNettoUst;
        return $this;
    }

    public function getProvisionBrutto(): float
    {
        return $this->provisionBrutto;
    }

    public function setProvisionBrutto(float $provisionBrutto): Immobilie
    {
        $this->provisionBrutto = $provisionBrutto;
        return $this;
    }

    public function getMwstSatz(): float
    {
        return $this->mwstSatz;
    }

    public function setMwstSatz(float $mwstSatz): Immobilie
    {
        $this->mwstSatz = $mwstSatz;
        return $this;
    }

    public function getMwstGesamt(): float
    {
        return $this->mwstGesamt;
    }

    public function setMwstGesamt(float $mwstGesamt): Immobilie
    {
        $this->mwstGesamt = $mwstGesamt;
        return $this;
    }

    public function getFreitextPreis(): string
    {
        return $this->freitextPreis;
    }

    public function setFreitextPreis(string $freitextPreis): Immobilie
    {
        $this->freitextPreis = $freitextPreis;
        return $this;
    }

    public function getXfache(): string
    {
        return $this->xfache;
    }

    public function setXfache(string $xfache): Immobilie
    {
        $this->xfache = $xfache;
        return $this;
    }

    public function getNettorendite(): float
    {
        return $this->nettorendite;
    }

    public function setNettorendite(float $nettorendite): Immobilie
    {
        $this->nettorendite = $nettorendite;
        return $this;
    }

    public function getNettorenditeSoll(): float
    {
        return $this->nettorenditeSoll;
    }

    public function setNettorenditeSoll(float $nettorenditeSoll): Immobilie
    {
        $this->nettorenditeSoll = $nettorenditeSoll;
        return $this;
    }

    public function getNettorenditeIst(): float
    {
        return $this->nettorenditeIst;
    }

    public function setNettorenditeIst(float $nettorenditeIst): Immobilie
    {
        $this->nettorenditeIst = $nettorenditeIst;
        return $this;
    }

    public function getMieteinnahmenIst(): float
    {
        return $this->mieteinnahmenIst;
    }

    public function setMieteinnahmenIst(float $mieteinnahmenIst): Immobilie
    {
        $this->mieteinnahmenIst = $mieteinnahmenIst;
        return $this;
    }

    public function getMieteinnahmenSoll(): float
    {
        return $this->mieteinnahmenSoll;
    }

    public function setMieteinnahmenSoll(float $mieteinnahmenSoll): Immobilie
    {
        $this->mieteinnahmenSoll = $mieteinnahmenSoll;
        return $this;
    }

    public function getErschliessungskosten(): float
    {
        return $this->erschliessungskosten;
    }

    public function setErschliessungskosten(float $erschliessungskosten): Immobilie
    {
        $this->erschliessungskosten = $erschliessungskosten;
        return $this;
    }

    public function getKaution(): float
    {
        return $this->kaution;
    }

    public function setKaution(float $kaution): Immobilie
    {
        $this->kaution = $kaution;
        return $this;
    }

    public function getKautionText(): string
    {
        return $this->kautionText;
    }

    public function setKautionText(string $kautionText): Immobilie
    {
        $this->kautionText = $kautionText;
        return $this;
    }

    public function getGeschaeftsguthaben(): float
    {
        return $this->geschaeftsguthaben;
    }

    public function setGeschaeftsguthaben(float $geschaeftsguthaben): Immobilie
    {
        $this->geschaeftsguthaben = $geschaeftsguthaben;
        return $this;
    }

    public function getGenossenschaftsanteile(): float
    {
        return $this->genossenschaftsanteile;
    }

    public function setGenossenschaftsanteile(float $genossenschaftsanteile): Immobilie
    {
        $this->genossenschaftsanteile = $genossenschaftsanteile;
        return $this;
    }

    public function getVertragsabschlussgebuehr(): float
    {
        return $this->vertragsabschlussgebuehr;
    }

    public function setVertragsabschlussgebuehr(float $vertragsabschlussgebuehr): Immobilie
    {
        $this->vertragsabschlussgebuehr = $vertragsabschlussgebuehr;
        return $this;
    }

    public function getStpCarport(): string
    {
        return $this->stpCarport;
    }

    public function setStpCarport(string $stpCarport): void
    {
        $this->stpCarport = $stpCarport;
    }

    public function getStpDuplex(): string
    {
        return $this->stpDuplex;
    }

    public function setStpDuplex(string $stpDuplex): void
    {
        $this->stpDuplex = $stpDuplex;
    }

    public function getStpFreiplatz(): string
    {
        return $this->stpFreiplatz;
    }

    public function setStpFreiplatz(string $stpFreiplatz): void
    {
        $this->stpFreiplatz = $stpFreiplatz;
    }

    public function getStpGarage(): string
    {
        return $this->stpGarage;
    }

    public function setStpGarage(string $stpGarage): void
    {
        $this->stpGarage = $stpGarage;
    }

    public function getStpParkhaus(): string
    {
        return $this->stpParkhaus;
    }

    public function setStpParkhaus(string $stpParkhaus): void
    {
        $this->stpParkhaus = $stpParkhaus;
    }

    public function getStpTiefgarage(): string
    {
        return $this->stpTiefgarage;
    }

    public function setStpTiefgarage(string $stpTiefgarage): void
    {
        $this->stpTiefgarage = $stpTiefgarage;
    }

    public function getRichtpreis(): float
    {
        return $this->richtpreis;
    }

    public function setRichtpreis(float $richtpreis): void
    {
        $this->richtpreis = $richtpreis;
    }

    public function getRichtpreisProM2(): float
    {
        return $this->richtpreisProM2;
    }

    public function setRichtpreisProM2(float $richtpreisProM2): void
    {
        $this->richtpreisProM2 = $richtpreisProM2;
    }

    public function getAnyFlaeche(): float
    {
        if ($this->getWohnflaeche() > 0) {
            return $this->getWohnflaeche();
        }

        if ($this->getNutzflaeche() > 0) {
            return $this->getNutzflaeche();
        }

        if ($this->getGesamtflaeche() > 0) {
            return $this->getGesamtflaeche();
        }

        if ($this->getLadenflaeche() > 0) {
            return $this->getLadenflaeche();
        }

        if ($this->getLagerflaeche() > 0) {
            return $this->getLagerflaeche();
        }

        if ($this->getVerkaufsflaeche() > 0) {
            return $this->getVerkaufsflaeche();
        }

        if ($this->getBueroflaeche() > 0) {
            return $this->getBueroflaeche();
        }

        if ($this->getVerwaltungsflaeche() > 0) {
            return $this->getVerwaltungsflaeche();
        }

        if ($this->getGastroflaeche() > 0) {
            return $this->getGastroflaeche();
        }
        return 0.0;
    }

    public function getWohnflaeche(): float
    {
        return $this->wohnflaeche;
    }

    public function setWohnflaeche(float $wohnflaeche): void
    {
        $this->wohnflaeche = $wohnflaeche;
    }

    public function getNutzflaeche(): float
    {
        return $this->nutzflaeche;
    }

    public function setNutzflaeche(float $nutzflaeche): void
    {
        $this->nutzflaeche = $nutzflaeche;
    }

    public function getGesamtflaeche(): float
    {
        return $this->gesamtflaeche;
    }

    public function setGesamtflaeche(float $gesamtflaeche): void
    {
        $this->gesamtflaeche = $gesamtflaeche;
    }

    public function getLadenflaeche(): float
    {
        return $this->ladenflaeche;
    }

    public function setLadenflaeche(float $ladenflaeche): void
    {
        $this->ladenflaeche = $ladenflaeche;
    }

    public function getLagerflaeche(): float
    {
        return $this->lagerflaeche;
    }

    public function setLagerflaeche(float $lagerflaeche): void
    {
        $this->lagerflaeche = $lagerflaeche;
    }

    public function getVerkaufsflaeche(): float
    {
        return $this->verkaufsflaeche;
    }

    public function setVerkaufsflaeche(float $verkaufsflaeche): void
    {
        $this->verkaufsflaeche = $verkaufsflaeche;
    }

    public function getBueroflaeche(): float
    {
        return $this->bueroflaeche;
    }

    public function setBueroflaeche(float $bueroflaeche): void
    {
        $this->bueroflaeche = $bueroflaeche;
    }

    public function getVerwaltungsflaeche(): float
    {
        return $this->verwaltungsflaeche;
    }

    public function setVerwaltungsflaeche(float $verwaltungsflaeche): void
    {
        $this->verwaltungsflaeche = $verwaltungsflaeche;
    }

    public function getGastroflaeche(): float
    {
        return $this->gastroflaeche;
    }

    public function setGastroflaeche(float $gastroflaeche): void
    {
        $this->gastroflaeche = $gastroflaeche;
    }

    public function getFreiflaeche(): float
    {
        return $this->freiflaeche;
    }

    public function setFreiflaeche(float $freiflaeche): void
    {
        $this->freiflaeche = $freiflaeche;
    }

    public function getBueroteilflaeche(): float
    {
        return $this->bueroteilflaeche;
    }

    public function setBueroteilflaeche(float $bueroteilflaeche): void
    {
        $this->bueroteilflaeche = $bueroteilflaeche;
    }

    public function getFensterfront(): float
    {
        return $this->fensterfront;
    }

    public function setFensterfront(float $fensterfront): void
    {
        $this->fensterfront = $fensterfront;
    }

    public function getGrundflaechenzahl(): string
    {
        return $this->grundflaechenzahl;
    }

    public function setGrundflaechenzahl(string $grundflaechenzahl): void
    {
        $this->grundflaechenzahl = $grundflaechenzahl;
    }

    public function getGeschossflaechenzahl(): string
    {
        return $this->geschossflaechenzahl;
    }

    public function setGeschossflaechenzahl(string $geschossflaechenzahl): void
    {
        $this->geschossflaechenzahl = $geschossflaechenzahl;
    }

    public function getBaumassenzahl(): string
    {
        return $this->baumassenzahl;
    }

    public function setBaumassenzahl(string $baumassenzahl): void
    {
        $this->baumassenzahl = $baumassenzahl;
    }

    public function getBruttogeschossflaechenzahl(): float
    {
        return $this->bruttogeschossflaechenzahl;
    }

    public function setBruttogeschossflaechenzahl(float $bruttogeschossflaechenzahl): void
    {
        $this->bruttogeschossflaechenzahl = $bruttogeschossflaechenzahl;
    }

    public function getGrundstuecksflaeche(): float
    {
        return $this->grundstuecksflaeche;
    }

    public function setGrundstuecksflaeche(float $grundstuecksflaeche): void
    {
        $this->grundstuecksflaeche = $grundstuecksflaeche;
    }

    public function getSonstflaeche(): float
    {
        return $this->sonstflaeche;
    }

    public function setSonstflaeche(float $sonstflaeche): void
    {
        $this->sonstflaeche = $sonstflaeche;
    }

    public function getAnzahlZimmer(): float
    {
        return $this->anzahlZimmer;
    }

    public function setAnzahlZimmer(float $anzahlZimmer): void
    {
        $this->anzahlZimmer = $anzahlZimmer;
    }

    public function getAnzahlSchlafzimmer(): float
    {
        return $this->anzahlSchlafzimmer;
    }

    public function setAnzahlSchlafzimmer(float $anzahlSchlafzimmer): void
    {
        $this->anzahlSchlafzimmer = $anzahlSchlafzimmer;
    }

    public function getAnzahlBadezimmer(): float
    {
        return $this->anzahlBadezimmer;
    }

    public function setAnzahlBadezimmer(float $anzahlBadezimmer): void
    {
        $this->anzahlBadezimmer = $anzahlBadezimmer;
    }

    public function getAnzahlSeparateWc(): float
    {
        return $this->anzahlSeparateWc;
    }

    public function setAnzahlSeparateWc(float $anzahlSeparateWc): void
    {
        $this->anzahlSeparateWc = $anzahlSeparateWc;
    }

    public function getBalkonTerasseFlaeche(): float
    {
        return $this->balkonTerasseFlaeche;
    }

    public function setBalkonTerasseFlaeche(float $balkonTerasseFlaeche): void
    {
        $this->balkonTerasseFlaeche = $balkonTerasseFlaeche;
    }

    public function getAnzahlWohnSchlafzimmer(): float
    {
        return $this->anzahlWohnSchlafzimmer;
    }

    public function setAnzahlWohnSchlafzimmer(float $anzahlWohnSchlafzimmer): void
    {
        $this->anzahlWohnSchlafzimmer = $anzahlWohnSchlafzimmer;
    }

    public function getGartenflaeche(): float
    {
        return $this->gartenflaeche;
    }

    public function setGartenflaeche(float $gartenflaeche): void
    {
        $this->gartenflaeche = $gartenflaeche;
    }

    public function getAnzahlBalkone(): float
    {
        return $this->anzahlBalkone;
    }

    public function setAnzahlBalkone(float $anzahlBalkone): void
    {
        $this->anzahlBalkone = $anzahlBalkone;
    }

    public function getAnzahlTerassen(): float
    {
        return $this->anzahlTerassen;
    }

    public function setAnzahlTerassen(float $anzahlTerassen): void
    {
        $this->anzahlTerassen = $anzahlTerassen;
    }

    public function getAnzahlLogia(): float
    {
        return $this->anzahlLogia;
    }

    public function setAnzahlLogia(float $anzahlLogia): void
    {
        $this->anzahlLogia = $anzahlLogia;
    }

    public function getFensterfrontM2(): float
    {
        return $this->fensterfrontM2;
    }

    public function setFensterfrontM2(float $fensterfrontM2): void
    {
        $this->fensterfrontM2 = $fensterfrontM2;
    }

    public function getGrundstuecksfront(): float
    {
        return $this->grundstuecksfront;
    }

    public function setGrundstuecksfront(float $grundstuecksfront): void
    {
        $this->grundstuecksfront = $grundstuecksfront;
    }

    public function getDachbodenflaeche(): float
    {
        return $this->dachbodenflaeche;
    }

    public function setDachbodenflaeche(float $dachbodenflaeche): void
    {
        $this->dachbodenflaeche = $dachbodenflaeche;
    }

    public function getTeilbarAb(): float
    {
        return $this->teilbarAb;
    }

    public function setTeilbarAb(float $teilbarAb): void
    {
        $this->teilbarAb = $teilbarAb;
    }

    public function getKellerflaeche(): float
    {
        return $this->kellerflaeche;
    }

    public function setKellerflaeche(float $kellerflaeche): void
    {
        $this->kellerflaeche = $kellerflaeche;
    }

    public function getBeheizbareFlaeche(): float
    {
        return $this->beheizbareFlaeche;
    }

    public function setBeheizbareFlaeche(float $beheizbareFlaeche): void
    {
        $this->beheizbareFlaeche = $beheizbareFlaeche;
    }

    public function getAnzahlStellplaetze(): float
    {
        return $this->anzahlStellplaetze;
    }

    public function setAnzahlStellplaetze(float $anzahlStellplaetze): void
    {
        $this->anzahlStellplaetze = $anzahlStellplaetze;
    }

    public function getPlaetzeGastraum(): float
    {
        return $this->plaetzeGastraum;
    }

    public function setPlaetzeGastraum(float $plaetzeGastraum): void
    {
        $this->plaetzeGastraum = $plaetzeGastraum;
    }

    public function getAnzahlBetten(): float
    {
        return $this->anzahlBetten;
    }

    public function setAnzahlBetten(float $anzahlBetten): void
    {
        $this->anzahlBetten = $anzahlBetten;
    }

    public function getAnzahlBettenEinzel(): float
    {
        return $this->anzahlBettenEinzel;
    }

    public function setAnzahlBettenEinzel(float $anzahlBettenEinzel): void
    {
        $this->anzahlBettenEinzel = $anzahlBettenEinzel;
    }


    public function getAnzahlBettenDoppel(): float
    {
        return $this->anzahlBettenDoppel;
    }


    public function setAnzahlBettenDoppel(float $anzahlBettenDoppel): void
    {
        $this->anzahlBettenDoppel = $anzahlBettenDoppel;
    }


    public function getAnzahlBettenSchlafsofa(): float
    {
        return $this->anzahlBettenSchlafsofa;
    }


    public function setAnzahlBettenSchlafsofa(float $anzahlBettenSchlafsofa): void
    {
        $this->anzahlBettenSchlafsofa = $anzahlBettenSchlafsofa;
    }


    public function getAnzahlTagungsraeume(): float
    {
        return $this->anzahlTagungsraeume;
    }


    public function setAnzahlTagungsraeume(float $anzahlTagungsraeume): void
    {
        $this->anzahlTagungsraeume = $anzahlTagungsraeume;
    }


    public function getVermietbareFlaeche(): float
    {
        return $this->vermietbareFlaeche;
    }


    public function setVermietbareFlaeche(float $vermietbareFlaeche): void
    {
        $this->vermietbareFlaeche = $vermietbareFlaeche;
    }


    public function getAnzahlWohneinheiten(): float
    {
        return $this->anzahlWohneinheiten;
    }


    public function setAnzahlWohneinheiten(float $anzahlWohneinheiten): void
    {
        $this->anzahlWohneinheiten = $anzahlWohneinheiten;
    }


    public function getAnzahlGewerbeeinheiten(): float
    {
        return $this->anzahlGewerbeeinheiten;
    }


    public function setAnzahlGewerbeeinheiten(float $anzahlGewerbeeinheiten): void
    {
        $this->anzahlGewerbeeinheiten = $anzahlGewerbeeinheiten;
    }


    public function getEinliegerwohnung(): int
    {
        return $this->einliegerwohnung;
    }


    public function setEinliegerwohnung(int $einliegerwohnung): void
    {
        $this->einliegerwohnung = $einliegerwohnung;
    }


    public function getKubatur(): float
    {
        return $this->kubatur;
    }


    public function setKubatur(float $kubatur): void
    {
        $this->kubatur = $kubatur;
    }


    public function getAusnuetzungsziffer(): float
    {
        return $this->ausnuetzungsziffer;
    }


    public function setAusnuetzungsziffer(float $ausnuetzungsziffer): void
    {
        $this->ausnuetzungsziffer = $ausnuetzungsziffer;
    }


    public function getFlaechevon(): float
    {
        return $this->flaechevon;
    }


    public function setFlaechevon(float $flaechevon): void
    {
        $this->flaechevon = $flaechevon;
    }


    public function getFlaechebis(): float
    {
        return $this->flaechebis;
    }


    public function setFlaechebis(float $flaechebis): void
    {
        $this->flaechebis = $flaechebis;
    }

    public function getWgGeeignet(): NullableBooleanEnum
    {
        return $this->wgGeeignet;
    }

    public function setWgGeeignet(NullableBooleanEnum $wgGeeignet): Immobilie
    {
        $this->wgGeeignet = $wgGeeignet;
        return $this;
    }

    public function getRaeumeVeraenderbar(): NullableBooleanEnum
    {
        return $this->raeumeVeraenderbar;
    }

    public function setRaeumeVeraenderbar(NullableBooleanEnum $raeumeVeraenderbar): Immobilie
    {
        $this->raeumeVeraenderbar = $raeumeVeraenderbar;
        return $this;
    }

    public function getKamin(): NullableBooleanEnum
    {
        return $this->kamin;
    }

    public function setKamin(NullableBooleanEnum $kamin): Immobilie
    {
        $this->kamin = $kamin;
        return $this;
    }

    public function getKlimatisiert(): NullableBooleanEnum
    {
        return $this->klimatisiert;
    }

    public function setKlimatisiert(NullableBooleanEnum $klimatisiert): Immobilie
    {
        $this->klimatisiert = $klimatisiert;
        return $this;
    }

    public function getAufzugPersonen(): NullableBooleanEnum
    {
        return $this->aufzugPersonen;
    }

    public function setAufzugPersonen(NullableBooleanEnum $aufzugPersonen): Immobilie
    {
        $this->aufzugPersonen = $aufzugPersonen;
        return $this;
    }

    public function getAufzugLasten(): NullableBooleanEnum
    {
        return $this->aufzugLasten;
    }

    public function setAufzugLasten(NullableBooleanEnum $aufzugLasten): Immobilie
    {
        $this->aufzugLasten = $aufzugLasten;
        return $this;
    }

    public function getGartennutzung(): NullableBooleanEnum
    {
        return $this->gartennutzung;
    }

    public function setGartennutzung(NullableBooleanEnum $gartennutzung): Immobilie
    {
        $this->gartennutzung = $gartennutzung;
        return $this;
    }

    public function getMoebliert(): NullableBooleanEnum
    {
        return $this->moebliert;
    }

    public function setMoebliert(NullableBooleanEnum $moebliert): Immobilie
    {
        $this->moebliert = $moebliert;
        return $this;
    }

    public function getRollstuhlgerecht(): NullableBooleanEnum
    {
        return $this->rollstuhlgerecht;
    }

    public function setRollstuhlgerecht(NullableBooleanEnum $rollstuhlgerecht): Immobilie
    {
        $this->rollstuhlgerecht = $rollstuhlgerecht;
        return $this;
    }

    public function getKabelSatTv(): NullableBooleanEnum
    {
        return $this->kabelSatTv;
    }

    public function setKabelSatTv(NullableBooleanEnum $kabelSatTv): Immobilie
    {
        $this->kabelSatTv = $kabelSatTv;
        return $this;
    }

    public function getKabelfernsehen(): NullableBooleanEnum
    {
        return $this->kabelfernsehen;
    }

    public function setKabelfernsehen(NullableBooleanEnum $kabelfernsehen): Immobilie
    {
        $this->kabelfernsehen = $kabelfernsehen;
        return $this;
    }

    public function getSatellitenfernsehen(): NullableBooleanEnum
    {
        return $this->satellitenfernsehen;
    }

    public function setSatellitenfernsehen(NullableBooleanEnum $satellitenfernsehen): Immobilie
    {
        $this->satellitenfernsehen = $satellitenfernsehen;
        return $this;
    }

    public function getDvbt(): NullableBooleanEnum
    {
        return $this->dvbt;
    }

    public function setDvbt(NullableBooleanEnum $dvbt): Immobilie
    {
        $this->dvbt = $dvbt;
        return $this;
    }

    public function getBarrierefrei(): NullableBooleanEnum
    {
        return $this->barrierefrei;
    }

    public function setBarrierefrei(NullableBooleanEnum $barrierefrei): Immobilie
    {
        $this->barrierefrei = $barrierefrei;
        return $this;
    }

    public function getSauna(): NullableBooleanEnum
    {
        return $this->sauna;
    }

    public function setSauna(NullableBooleanEnum $sauna): Immobilie
    {
        $this->sauna = $sauna;
        return $this;
    }

    public function getSwimmingpool(): NullableBooleanEnum
    {
        return $this->swimmingpool;
    }

    public function setSwimmingpool(NullableBooleanEnum $swimmingpool): Immobilie
    {
        $this->swimmingpool = $swimmingpool;
        return $this;
    }

    public function getWaschTrockenraum(): NullableBooleanEnum
    {
        return $this->waschTrockenraum;
    }

    public function setWaschTrockenraum(NullableBooleanEnum $waschTrockenraum): Immobilie
    {
        $this->waschTrockenraum = $waschTrockenraum;
        return $this;
    }

    public function getWintergarten(): NullableBooleanEnum
    {
        return $this->wintergarten;
    }

    public function setWintergarten(NullableBooleanEnum $wintergarten): Immobilie
    {
        $this->wintergarten = $wintergarten;
        return $this;
    }

    public function getDvVerkabelung(): NullableBooleanEnum
    {
        return $this->dvVerkabelung;
    }

    public function setDvVerkabelung(NullableBooleanEnum $dvVerkabelung): Immobilie
    {
        $this->dvVerkabelung = $dvVerkabelung;
        return $this;
    }

    public function getRampe(): NullableBooleanEnum
    {
        return $this->rampe;
    }

    public function setRampe(NullableBooleanEnum $rampe): Immobilie
    {
        $this->rampe = $rampe;
        return $this;
    }

    public function getHebebuehne(): NullableBooleanEnum
    {
        return $this->hebebuehne;
    }

    public function setHebebuehne(NullableBooleanEnum $hebebuehne): Immobilie
    {
        $this->hebebuehne = $hebebuehne;
        return $this;
    }

    public function getKran(): NullableBooleanEnum
    {
        return $this->kran;
    }

    public function setKran(NullableBooleanEnum $kran): Immobilie
    {
        $this->kran = $kran;
        return $this;
    }

    public function getGastterrasse(): NullableBooleanEnum
    {
        return $this->gastterrasse;
    }

    public function setGastterrasse(NullableBooleanEnum $gastterrasse): Immobilie
    {
        $this->gastterrasse = $gastterrasse;
        return $this;
    }


    public function getStromanschlusswert(): float
    {
        return $this->stromanschlusswert;
    }


    public function setStromanschlusswert(float $stromanschlusswert): void
    {
        $this->stromanschlusswert = $stromanschlusswert;
    }

    public function getKatineCafeteria(): NullableBooleanEnum
    {
        return $this->katineCafeteria;
    }

    public function setKatineCafeteria(NullableBooleanEnum $katineCafeteria): Immobilie
    {
        $this->katineCafeteria = $katineCafeteria;
        return $this;
    }

    public function getTeekueche(): NullableBooleanEnum
    {
        return $this->teekueche;
    }

    public function setTeekueche(NullableBooleanEnum $teekueche): Immobilie
    {
        $this->teekueche = $teekueche;
        return $this;
    }


    public function getHallenhoehe(): float
    {
        return $this->hallenhoehe;
    }


    public function setHallenhoehe(float $hallenhoehe): void
    {
        $this->hallenhoehe = $hallenhoehe;
    }

    public function getHotelrestaurantAngeschlossen(): NullableBooleanEnum
    {
        return $this->hotelrestaurantAngeschlossen;
    }

    public function setHotelrestaurantAngeschlossen(NullableBooleanEnum $hotelrestaurantAngeschlossen): Immobilie
    {
        $this->hotelrestaurantAngeschlossen = $hotelrestaurantAngeschlossen;
        return $this;
    }

    public function getBarAngeschlossen(): NullableBooleanEnum
    {
        return $this->barAngeschlossen;
    }

    public function setBarAngeschlossen(NullableBooleanEnum $barAngeschlossen): Immobilie
    {
        $this->barAngeschlossen = $barAngeschlossen;
        return $this;
    }

    public function getBrauereibindung(): NullableBooleanEnum
    {
        return $this->brauereibindung;
    }

    public function setBrauereibindung(NullableBooleanEnum $brauereibindung): Immobilie
    {
        $this->brauereibindung = $brauereibindung;
        return $this;
    }

    public function getSporteinrichtungen(): NullableBooleanEnum
    {
        return $this->sporteinrichtungen;
    }

    public function setSporteinrichtungen(NullableBooleanEnum $sporteinrichtungen): Immobilie
    {
        $this->sporteinrichtungen = $sporteinrichtungen;
        return $this;
    }

    public function getWellnessbereich(): NullableBooleanEnum
    {
        return $this->wellnessbereich;
    }

    public function setWellnessbereich(NullableBooleanEnum $wellnessbereich): Immobilie
    {
        $this->wellnessbereich = $wellnessbereich;
        return $this;
    }

    public function getServiceBetreutesWohnen(): NullableBooleanEnum
    {
        return $this->serviceBetreutesWohnen;
    }

    public function setServiceBetreutesWohnen(NullableBooleanEnum $serviceBetreutesWohnen): Immobilie
    {
        $this->serviceBetreutesWohnen = $serviceBetreutesWohnen;
        return $this;
    }

    public function getServiceCatering(): NullableBooleanEnum
    {
        return $this->serviceCatering;
    }

    public function setServiceCatering(NullableBooleanEnum $serviceCatering): Immobilie
    {
        $this->serviceCatering = $serviceCatering;
        return $this;
    }

    public function getServiceReinigung(): NullableBooleanEnum
    {
        return $this->serviceReinigung;
    }

    public function setServiceReinigung(NullableBooleanEnum $serviceReinigung): Immobilie
    {
        $this->serviceReinigung = $serviceReinigung;
        return $this;
    }

    public function getServiceEinkauf(): NullableBooleanEnum
    {
        return $this->serviceEinkauf;
    }

    public function setServiceEinkauf(NullableBooleanEnum $serviceEinkauf): Immobilie
    {
        $this->serviceEinkauf = $serviceEinkauf;
        return $this;
    }

    public function getServiceWachdienst(): NullableBooleanEnum
    {
        return $this->serviceWachdienst;
    }

    public function setServiceWachdienst(NullableBooleanEnum $serviceWachdienst): Immobilie
    {
        $this->serviceWachdienst = $serviceWachdienst;
        return $this;
    }

    public function getTelefonFerienimmobilie(): NullableBooleanEnum
    {
        return $this->telefonFerienimmobilie;
    }

    public function setTelefonFerienimmobilie(NullableBooleanEnum $telefonFerienimmobilie): Immobilie
    {
        $this->telefonFerienimmobilie = $telefonFerienimmobilie;
        return $this;
    }


    public function getBreitbandZugangArt(): string
    {
        return $this->breitbandZugangArt;
    }


    public function setBreitbandZugangArt(string $breitbandZugangArt): void
    {
        $this->breitbandZugangArt = $breitbandZugangArt;
    }


    public function getBreitbandZugangSpeed(): float
    {
        return $this->breitbandZugangSpeed;
    }


    public function setBreitbandZugangSpeed(float $breitbandZugangSpeed): void
    {
        $this->breitbandZugangSpeed = $breitbandZugangSpeed;
    }

    public function getUmtsEmpfang(): NullableBooleanEnum
    {
        return $this->umtsEmpfang;
    }

    public function setUmtsEmpfang(NullableBooleanEnum $umtsEmpfang): Immobilie
    {
        $this->umtsEmpfang = $umtsEmpfang;
        return $this;
    }

    public function getSicherheitAlarmanlage(): NullableBooleanEnum
    {
        return $this->sicherheitAlarmanlage;
    }

    public function setSicherheitAlarmanlage(NullableBooleanEnum $sicherheitAlarmanlage): Immobilie
    {
        $this->sicherheitAlarmanlage = $sicherheitAlarmanlage;
        return $this;
    }

    public function getSicherheitKamera(): NullableBooleanEnum
    {
        return $this->sicherheitKamera;
    }

    public function setSicherheitKamera(NullableBooleanEnum $sicherheitKamera): Immobilie
    {
        $this->sicherheitKamera = $sicherheitKamera;
        return $this;
    }

    public function getSicherheitPolizeiruf(): NullableBooleanEnum
    {
        return $this->sicherheitPolizeiruf;
    }

    public function setSicherheitPolizeiruf(NullableBooleanEnum $sicherheitPolizeiruf): Immobilie
    {
        $this->sicherheitPolizeiruf = $sicherheitPolizeiruf;
        return $this;
    }

    public function getUnterkellert(): NullableBooleanEnum
    {
        return $this->unterkellert;
    }

    public function setUnterkellert(NullableBooleanEnum $unterkellert): Immobilie
    {
        $this->unterkellert = $unterkellert;
        return $this;
    }

    public function getAbstellraum(): NullableBooleanEnum
    {
        return $this->abstellraum;
    }

    public function setAbstellraum(NullableBooleanEnum $abstellraum): Immobilie
    {
        $this->abstellraum = $abstellraum;
        return $this;
    }

    public function getFahrradraum(): NullableBooleanEnum
    {
        return $this->fahrradraum;
    }

    public function setFahrradraum($fahrradraum): Immobilie
    {
        $this->fahrradraum = $fahrradraum;
        return $this;
    }

    public function getRolladen(): NullableBooleanEnum
    {
        return $this->rolladen;
    }

    public function setRolladen(NullableBooleanEnum $rolladen): Immobilie
    {
        $this->rolladen = $rolladen;
        return $this;
    }

    public function getBibliothek(): NullableBooleanEnum
    {
        return $this->bibliothek;
    }

    public function setBibliothek(NullableBooleanEnum $bibliothek): Immobilie
    {
        $this->bibliothek = $bibliothek;
        return $this;
    }

    public function getDachboden(): NullableBooleanEnum
    {
        return $this->dachboden;
    }

    public function setDachboden(NullableBooleanEnum $dachboden): Immobilie
    {
        $this->dachboden = $dachboden;
        return $this;
    }

    public function getGaestewc(): NullableBooleanEnum
    {
        return $this->gaestewc;
    }

    public function setGaestewc(NullableBooleanEnum $gaestewc): Immobilie
    {
        $this->gaestewc = $gaestewc;
        return $this;
    }

    public function getKabelkanaele(): NullableBooleanEnum
    {
        return $this->kabelkanaele;
    }

    public function setKabelkanaele($kabelkanaele): Immobilie
    {
        $this->kabelkanaele = $kabelkanaele;
        return $this;
    }

    public function getSeniorengerecht(): NullableBooleanEnum
    {
        return $this->seniorengerecht;
    }

    public function setSeniorengerecht(NullableBooleanEnum $seniorengerecht): Immobilie
    {
        $this->seniorengerecht = $seniorengerecht;
        return $this;
    }

    public function getBaujahr(): string
    {
        return $this->baujahr;
    }


    public function setBaujahr(string $baujahr): void
    {
        $this->baujahr = $baujahr;
    }


    public function getYoutube(): string
    {
        return $this->youtube;
    }


    public function setYoutube(string $youtube): void
    {
        $this->youtube = $youtube;
    }


    public function getLetztemodernisierung(): string
    {
        return $this->letztemodernisierung;
    }


    public function setLetztemodernisierung(string $letztemodernisierung): void
    {
        $this->letztemodernisierung = $letztemodernisierung;
    }


    public function getAltertyp(): int
    {
        return $this->altertyp;
    }


    public function setAltertyp(int $altertyp): void
    {
        $this->altertyp = $altertyp;
    }


    public function getBauzone(): string
    {
        return $this->bauzone;
    }


    public function setBauzone(string $bauzone): void
    {
        $this->bauzone = $bauzone;
    }


    public function getAltlasten(): string
    {
        return $this->altlasten;
    }


    public function setAltlasten(string $altlasten): void
    {
        $this->altlasten = $altlasten;
    }


    public function getEnergiepassArt(): ?Energiepassart
    {
        return $this->energiepassArt;
    }


    public function setEnergiepassArt(Energiepassart $energiepassArt): void
    {
        $this->energiepassArt = $energiepassArt;
    }


    public function getEnergiepassGueltigBis(): string
    {
        return $this->energiepassGueltigBis;
    }


    public function setEnergiepassGueltigBis(string $energiepassGueltigBis): void
    {
        $this->energiepassGueltigBis = $energiepassGueltigBis;
    }


    public function getEnergiepassEnergieverbrauchkennwert(): string
    {
        return $this->energiepassEnergieverbrauchkennwert;
    }


    public function setEnergiepassEnergieverbrauchkennwert(string $energiepassEnergieverbrauchkennwert): void
    {
        $this->energiepassEnergieverbrauchkennwert = $energiepassEnergieverbrauchkennwert;
    }


    public function getEnergiepassMitwarmwasser(): int
    {
        return $this->energiepassMitwarmwasser;
    }


    public function setEnergiepassMitwarmwasser(int $energiepassMitwarmwasser): void
    {
        $this->energiepassMitwarmwasser = $energiepassMitwarmwasser;
    }


    public function getEnergiepassEndenergiebedarf(): string
    {
        return $this->energiepassEndenergiebedarf;
    }


    public function setEnergiepassEndenergiebedarf(string $energiepassEndenergiebedarf): void
    {
        $this->energiepassEndenergiebedarf = $energiepassEndenergiebedarf;
    }


    public function getEnergiepassAusstelldatum(): ?DateTime
    {
        return $this->energiepassAusstelldatum;
    }


    public function setEnergiepassAusstelldatum(DateTime $energiepassAusstelldatum): void
    {
        $this->energiepassAusstelldatum = $energiepassAusstelldatum;
    }


    public function getEnergiepassBaujahr(): string
    {
        return $this->energiepassBaujahr;
    }


    public function setEnergiepassBaujahr(string $energiepassBaujahr): void
    {
        $this->energiepassBaujahr = $energiepassBaujahr;
    }


    public function getEnergiepassEpasstext(): string
    {
        return $this->energiepassEpasstext;
    }


    public function setEnergiepassEpasstext(string $energiepassEpasstext): void
    {
        $this->energiepassEpasstext = $energiepassEpasstext;
    }


    public function getEnergiepassFgeeklasse(): string
    {
        return $this->energiepassFgeeklasse;
    }


    public function setEnergiepassFgeeklasse(string $energiepassFgeeklasse): void
    {
        $this->energiepassFgeeklasse = $energiepassFgeeklasse;
    }


    public function getEnergiepassFgeewert(): string
    {
        return $this->energiepassFgeewert;
    }


    public function setEnergiepassFgeewert(string $energiepassFgeewert): void
    {
        $this->energiepassFgeewert = $energiepassFgeewert;
    }


    public function getEnergiepassGebaeudeart(): ?Energiepassgebaeudeart
    {
        return $this->energiepassGebaeudeart;
    }


    public function setEnergiepassGebaeudeart(Energiepassgebaeudeart $energiepassGebaeudeart): void
    {
        $this->energiepassGebaeudeart = $energiepassGebaeudeart;
    }


    public function getEnergiepassHwbklasse(): string
    {
        return $this->energiepassHwbklasse;
    }


    public function setEnergiepassHwbklasse(string $energiepassHwbklasse): void
    {
        $this->energiepassHwbklasse = $energiepassHwbklasse;
    }


    public function getEnergiepassHwbwert(): string
    {
        return $this->energiepassHwbwert;
    }


    public function setEnergiepassHwbwert(string $energiepassHwbwert): void
    {
        $this->energiepassHwbwert = $energiepassHwbwert;
    }


    public function getEnergiepassJahrgang(): ?Energiepassjahrgang
    {
        return $this->energiepassJahrgang;
    }


    public function setEnergiepassJahrgang(Energiepassjahrgang $energiepassJahrgang): void
    {
        $this->energiepassJahrgang = $energiepassJahrgang;
    }


    public function getEnergiepassPrimaerenergietraeger(): ?Befeuerungsart
    {
        return $this->energiepassPrimaerenergietraeger;
    }


    public function setEnergiepassPrimaerenergietraeger(Befeuerungsart $energiepassPrimaerenergietraeger): void
    {
        $this->energiepassPrimaerenergietraeger = $energiepassPrimaerenergietraeger;
    }


    public function getEnergiepassStromwert(): string
    {
        return $this->energiepassStromwert;
    }


    public function setEnergiepassStromwert(string $energiepassStromwert): void
    {
        $this->energiepassStromwert = $energiepassStromwert;
    }


    public function getEnergiepassWaermewert(): string
    {
        return $this->energiepassWaermewert;
    }


    public function setEnergiepassWaermewert(string $energiepassWaermewert): void
    {
        $this->energiepassWaermewert = $energiepassWaermewert;
    }


    public function getEnergiepassWertklasse(): string
    {
        return $this->energiepassWertklasse;
    }


    public function setEnergiepassWertklasse(string $energiepassWertklasse): void
    {
        $this->energiepassWertklasse = $energiepassWertklasse;
    }


    public function getVerkaufstatus(): int
    {
        return $this->verkaufstatus;
    }


    public function setVerkaufstatus(int $verkaufstatus): void
    {
        $this->verkaufstatus = $verkaufstatus;
    }


    public function getZulieferung(): int
    {
        return $this->zulieferung;
    }


    public function setZulieferung(int $zulieferung): void
    {
        $this->zulieferung = $zulieferung;
    }


    public function getAusblick(): int
    {
        return $this->ausblick;
    }


    public function setAusblick(int $ausblick): void
    {
        $this->ausblick = $ausblick;
    }


    public function getObjekttitel(): string
    {
        return $this->objekttitel;
    }


    public function setObjekttitel(string $objekttitel): void
    {
        $this->objekttitel = $objekttitel;
    }


    public function getKurzbeschreibung(): string
    {
        return $this->kurzbeschreibung;
    }


    public function setKurzbeschreibung(string $kurzbeschreibung): void
    {
        $this->kurzbeschreibung = $kurzbeschreibung;
    }


    public function getLage(): string
    {
        return $this->lage;
    }


    public function setLage(string $lage): void
    {
        $this->lage = $lage;
    }


    public function getAustattungsbeschreibung(): string
    {
        return $this->austattungsbeschreibung;
    }


    public function setAustattungsbeschreibung(string $austattungsbeschreibung): void
    {
        $this->austattungsbeschreibung = $austattungsbeschreibung;
    }


    public function getObjektbeschreibung(): string
    {
        return $this->objektbeschreibung;
    }


    public function setObjektbeschreibung(string $objektbeschreibung): void
    {
        $this->objektbeschreibung = $objektbeschreibung;
    }


    public function getSonstigeAngaben(): string
    {
        return $this->sonstigeAngaben;
    }


    public function setSonstigeAngaben(string $sonstigeAngaben): void
    {
        $this->sonstigeAngaben = $sonstigeAngaben;
    }


    public function getObjektadresseFreigeben(): bool
    {
        return $this->objektadresseFreigeben;
    }


    public function isObjektadresseFreigeben(): bool
    {
        return $this->objektadresseFreigeben;
    }


    public function setObjektadresseFreigeben(bool $objektadresseFreigeben): void
    {
        $this->objektadresseFreigeben = $objektadresseFreigeben;
    }


    public function getVerfuegbarAb(): string
    {
        return $this->verfuegbarAb;
    }


    public function setVerfuegbarAb(string $verfuegbarAb): void
    {
        $this->verfuegbarAb = $verfuegbarAb;
    }


    public function getVerfuegbarAbDatum(): ?DateTime
    {
        return $this->verfuegbarAbDatum;
    }


    public function setVerfuegbarAbDatum(DateTime $verfuegbarAbDatum): void
    {
        $this->verfuegbarAbDatum = $verfuegbarAbDatum;
    }


    public function getVerfuegbarBisDatum(): ?DateTime
    {
        return $this->verfuegbarBisDatum;
    }


    public function setVerfuegbarBisDatum(DateTime $verfuegbarBisDatum): void
    {
        $this->verfuegbarBisDatum = $verfuegbarBisDatum;
    }


    public function getVersteigerungstermin(): ?DateTime
    {
        return $this->versteigerungstermin;
    }


    public function setVersteigerungstermin(DateTime $versteigerungstermin): void
    {
        $this->versteigerungstermin = $versteigerungstermin;
    }

    public function getWbsErforderlich(): NullableBooleanEnum
    {
        return $this->wbsErforderlich;
    }

    public function setWbsErforderlich(NullableBooleanEnum $wbsErforderlich): Immobilie
    {
        $this->wbsErforderlich = $wbsErforderlich;
        return $this;
    }

    public function getVermietet(): NullableBooleanEnum
    {
        return $this->vermietet;
    }

    public function setVermietet(NullableBooleanEnum $vermietet): Immobilie
    {
        $this->vermietet = $vermietet;
        return $this;
    }


    public function getGruppennummer(): string
    {
        return $this->gruppennummer;
    }


    public function setGruppennummer(string $gruppennummer): void
    {
        $this->gruppennummer = $gruppennummer;
    }


    public function getZugang(): string
    {
        return $this->zugang;
    }


    public function setZugang(string $zugang): void
    {
        $this->zugang = $zugang;
    }


    public function getLaufzeit(): float
    {
        return $this->laufzeit;
    }


    public function setLaufzeit(float $laufzeit): void
    {
        $this->laufzeit = $laufzeit;
    }


    public function getMinimalePersonenanzahl(): int
    {
        return $this->minimalePersonenanzahl;
    }


    public function setMinimalePersonenanzahl(int $minimalePersonenanzahl): void
    {
        $this->minimalePersonenanzahl = $minimalePersonenanzahl;
    }


    public function getMaximalePersonenanzahl(): int
    {
        return $this->maximalePersonenanzahl;
    }


    public function setMaximalePersonenanzahl(int $maximalePersonenanzahl): void
    {
        $this->maximalePersonenanzahl = $maximalePersonenanzahl;
    }

    public function getNichtraucher(): NullableBooleanEnum
    {
        return $this->nichtraucher;
    }

    public function setNichtraucher(NullableBooleanEnum $nichtraucher): Immobilie
    {
        $this->nichtraucher = $nichtraucher;
        return $this;
    }

    public function getHaustiere(): NullableBooleanEnum
    {
        return $this->haustiere;
    }

    public function setHaustiere(NullableBooleanEnum $haustiere): Immobilie
    {
        $this->haustiere = $haustiere;
        return $this;
    }


    public function getGeschlecht(): int
    {
        return $this->geschlecht;
    }


    public function setGeschlecht(int $geschlecht): void
    {
        $this->geschlecht = $geschlecht;
    }

    public function getDenkmalgeschuetzt(): NullableBooleanEnum
    {
        return $this->denkmalgeschuetzt;
    }

    public function setDenkmalgeschuetzt(NullableBooleanEnum $denkmalgeschuetzt): Immobilie
    {
        $this->denkmalgeschuetzt = $denkmalgeschuetzt;
        return $this;
    }

    public function getAlsFerien(): NullableBooleanEnum
    {
        return $this->alsFerien;
    }

    public function setAlsFerien(NullableBooleanEnum $alsFerien): Immobilie
    {
        $this->alsFerien = $alsFerien;
        return $this;
    }

    public function getGewerblicheNutzung(): NullableBooleanEnum
    {
        return $this->gewerblicheNutzung;
    }

    public function setGewerblicheNutzung(NullableBooleanEnum $gewerblicheNutzung): Immobilie
    {
        $this->gewerblicheNutzung = $gewerblicheNutzung;
        return $this;
    }

    public function getBadModernisiert(): NullableBooleanEnum
    {
        return $this->badModernisiert;
    }

    public function setBadModernisiert(NullableBooleanEnum $badModernisiert): Immobilie
    {
        $this->badModernisiert = $badModernisiert;
        return $this;
    }


    public function getBranchen(): string
    {
        return $this->branchen;
    }


    public function setBranchen(string $branchen): void
    {
        $this->branchen = $branchen;
    }

    public function getHochhaus(): NullableBooleanEnum
    {
        return $this->hochhaus;
    }

    public function setHochhaus(NullableBooleanEnum $hochhaus): Immobilie
    {
        $this->hochhaus = $hochhaus;
        return $this;
    }


    public function getObjektnrIntern(): string
    {
        return $this->objektnrIntern;
    }


    public function setObjektnrIntern(string $objektnrIntern): void
    {
        $this->objektnrIntern = $objektnrIntern;
    }


    public function getUrlIdentifier(): array|string|null
    {
        return preg_replace(['/\//', '/\\\/'], '-', $this->getObjektnrExtern());
    }


    public function getObjektnrExtern(): string
    {
        return $this->objektnrExtern;
    }


    public function setObjektnrExtern(string $objektnrExtern): void
    {
        $this->objektnrExtern = $objektnrExtern;
    }


    public function getAnzeigeAb(): ?DateTime
    {
        return $this->anzeigeAb;
    }


    public function setAnzeigeAb(DateTime $anzeigeAb): void
    {
        $this->anzeigeAb = $anzeigeAb;
    }


    public function getAnzeigeBis(): ?DateTime
    {
        return $this->anzeigeBis;
    }


    public function setAnzeigeBis(DateTime $anzeigeBis): void
    {
        $this->anzeigeBis = $anzeigeBis;
    }


    public function getOpenimmoObjid(): string
    {
        return $this->openimmoObjid;
    }


    public function setOpenimmoObjid(string $openimmoObjid): void
    {
        $this->openimmoObjid = $openimmoObjid;
    }


    public function getKennungUrsprung(): string
    {
        return $this->kennungUrsprung;
    }


    public function setKennungUrsprung(string $kennungUrsprung): void
    {
        $this->kennungUrsprung = $kennungUrsprung;
    }


    public function getStandVom(): ?DateTime
    {
        return $this->standVom;
    }


    public function setStandVom(DateTime $standVom): void
    {
        $this->standVom = $standVom;
    }


    public function isWeitergabeGenerell(): bool
    {
        return $this->weitergabeGenerell;
    }


    public function getWeitergabeGenerell(): bool
    {
        return $this->weitergabeGenerell;
    }


    public function setWeitergabeGenerell(bool $weitergabeGenerell): void
    {
        $this->weitergabeGenerell = $weitergabeGenerell;
    }


    public function getWeitergabePositivliste(): string
    {
        return $this->weitergabePositivliste;
    }


    public function setWeitergabePositivliste(string $weitergabePositivliste): void
    {
        $this->weitergabePositivliste = $weitergabePositivliste;
    }


    public function getWeitergabeNegativliste(): string
    {
        return $this->weitergabeNegativliste;
    }


    public function setWeitergabeNegativliste(string $weitergabeNegativliste): void
    {
        $this->weitergabeNegativliste = $weitergabeNegativliste;
    }


    public function getGruppenKennung(): string
    {
        return $this->gruppenKennung;
    }


    public function setGruppenKennung(string $gruppenKennung): void
    {
        $this->gruppenKennung = $gruppenKennung;
    }


    public function getMasterObjekt(): string
    {
        return $this->masterObjekt;
    }


    public function setMasterObjekt(string $masterObjekt): void
    {
        $this->masterObjekt = $masterObjekt;
    }


    public function getMasterVisible(): bool
    {
        return $this->masterVisible;
    }


    public function isMasterVisible(): bool
    {
        return $this->masterVisible;
    }


    public function setMasterVisible(bool $masterVisible): void
    {
        $this->masterVisible = $masterVisible;
    }


    public function getSprache(): string
    {
        return $this->sprache;
    }


    public function setSprache(string $sprache): void
    {
        $this->sprache = $sprache;
    }


    public function addNutzungsart(Nutzungsart $nutzungsart): void
    {
        $this->nutzungsart->attach($nutzungsart);
    }


    public function removeNutzungsart(Nutzungsart $nutzungsartToRemove): void
    {
        $this->nutzungsart->detach($nutzungsartToRemove);
    }


    public function getNutzungsart(): ?ObjectStorage
    {
        return $this->nutzungsart;
    }


    public function setNutzungsart(ObjectStorage $nutzungsart): void
    {
        $this->nutzungsart = $nutzungsart;
    }


    public function addVermarktungsart(Vermarktungsart $vermarktungsart): void
    {
        $this->vermarktungsart->attach($vermarktungsart);
    }


    public function removeVermarktungsart(Vermarktungsart $vermarktungsartToRemove): void
    {
        $this->vermarktungsart->detach($vermarktungsartToRemove);
    }


    public function getVermarktungsart(): ?ObjectStorage
    {
        return $this->vermarktungsart;
    }


    public function setVermarktungsart(ObjectStorage $vermarktungsart): void
    {
        $this->vermarktungsart = $vermarktungsart;
    }


    public function getObjektart(): ?Objektart
    {
        return $this->objektart;
    }


    public function setObjektart(Objektart $objektart): void
    {
        $this->objektart = $objektart;
    }


    public function getObjektarttyp(): ?Objektarttyp
    {
        return $this->objektarttyp;
    }


    public function setObjektarttyp(Objektarttyp $objektarttyp): void
    {
        $this->objektarttyp = $objektarttyp;
    }


    public function getStellplatzObjektarttyp(): ?Objektarttyp
    {
        return $this->stellplatzObjektarttyp;
    }


    public function setStellplatzObjektarttyp(Objektarttyp $stellplatzObjektarttyp): void
    {
        $this->stellplatzObjektarttyp = $stellplatzObjektarttyp;
    }


    public function getObjektOrt(): Ort
    {
        return $this->objektOrt;
    }

    public function setObjektOrt(Ort $objektOrt): void
    {
        $this->objektOrt = $objektOrt;
    }


    public function getObjektStadtteil(): ?Stadtteil
    {
        return $this->objektStadtteil;
    }


    public function setObjektStadtteil(Stadtteil $objektStadtteil): void
    {
        $this->objektStadtteil = $objektStadtteil;
    }


    public function getObjektLand(): ?Land
    {
        return $this->objektLand;
    }


    public function setObjektLand(Land $objektLand): void
    {
        $this->objektLand = $objektLand;
    }


    public function getObjektLage(): ?Lage
    {
        return $this->objektLage;
    }


    public function setObjektLage(Lage $objektLage): void
    {
        $this->objektLage = $objektLage;
    }


    public function getKontaktperson(): ?Kontaktperson
    {
        return $this->kontaktperson;
    }


    public function setKontaktperson(Kontaktperson $kontaktperson): void
    {
        $this->kontaktperson = $kontaktperson;
    }


    public function addWeitereAdressen(Kontaktperson $weitereAdressen): void
    {
        $this->weitereAdressen->attach($weitereAdressen);
    }


    public function removeWeitereAdressen(Kontaktperson $weitereAdressenToRemove): void
    {
        $this->weitereAdressen->detach($weitereAdressenToRemove);
    }


    public function getWeitereAdressen(): ?ObjectStorage
    {
        return $this->weitereAdressen;
    }


    public function setWeitereAdressen(ObjectStorage $weitereAdressen): void
    {
        $this->weitereAdressen = $weitereAdressen;
    }


    public function getPreisZeiteinheit(): ?Periode
    {
        return $this->preisZeiteinheit;
    }

    public function setPreisZeiteinheit(Periode $preisZeiteinheit): void
    {
        $this->preisZeiteinheit = $preisZeiteinheit;
    }

    public function getMieteinnahmenIstPeriode(): ?Periode
    {
        return $this->mieteinnahmenIstPeriode;
    }

    public function setMieteinnahmenIstPeriode(Periode $mieteinnahmenIstPeriode): void
    {
        $this->mieteinnahmenIstPeriode = $mieteinnahmenIstPeriode;
    }


    public function getMieteinnahmenSollPeriode(): ?Periode
    {
        return $this->mieteinnahmenSollPeriode;
    }


    public function setMieteinnahmenSollPeriode(Periode $mieteinnahmenSollPeriode): void
    {
        $this->mieteinnahmenSollPeriode = $mieteinnahmenSollPeriode;
    }


    public function getWaehrung(): ?Waehrung
    {
        return $this->waehrung;
    }


    public function setWaehrung(Waehrung $waehrung): void
    {
        $this->waehrung = $waehrung;
    }


    public function getAusstattungsKategorie(): ?Austattungskategorie
    {
        return $this->ausstattungsKategorie;
    }


    public function setAusstattungsKategorie(Austattungskategorie $ausstattungsKategorie): void
    {
        $this->ausstattungsKategorie = $ausstattungsKategorie;
    }


    public function addAusstattungBad(Badausstattung $ausstattungBad): void
    {
        $this->ausstattungBad->attach($ausstattungBad);
    }


    public function removeAusstattungBad(Badausstattung $ausstattungBadToRemove): void
    {
        $this->ausstattungBad->detach($ausstattungBadToRemove);
    }


    public function addAusstattungKueche(Kuechenausstattung $ausstattungKueche): void
    {
        $this->ausstattungKueche->attach($ausstattungKueche);
    }


    public function removeAusstattungKueche(Kuechenausstattung $ausstattungKuecheToRemove): void
    {
        $this->ausstattungKueche->detach($ausstattungKuecheToRemove);
    }


    public function getAusstattungKueche(): ?ObjectStorage
    {
        return $this->ausstattungKueche;
    }


    public function setAusstattungKueche(ObjectStorage $ausstattungKueche): void
    {
        $this->ausstattungKueche = $ausstattungKueche;
    }


    public function addAusstattungBoden(Bodenbelag $ausstattungBoden): void
    {
        $this->ausstattungBoden->attach($ausstattungBoden);
    }


    public function removeAusstattungBoden(Bodenbelag $ausstattungBodenToRemove): void
    {
        $this->ausstattungBoden->detach($ausstattungBodenToRemove);
    }


    public function getAusstattungBoden(): ?ObjectStorage
    {
        return $this->ausstattungBoden;
    }


    public function setAusstattungBoden(ObjectStorage $ausstattungBoden): void
    {
        $this->ausstattungBoden = $ausstattungBoden;
    }


    public function addHeizungsart(Heizungsart $heizungsart): void
    {
        $this->heizungsart->attach($heizungsart);
    }


    public function removeHeizungsart(Heizungsart $heizungsartToRemove): void
    {
        $this->heizungsart->detach($heizungsartToRemove);
    }


    public function getHeizungsart(): ?ObjectStorage
    {
        return $this->heizungsart;
    }


    public function setHeizungsart(ObjectStorage $heizungsart): void
    {
        $this->heizungsart = $heizungsart;
    }


    public function addBefeuerungsart(Befeuerungsart $befeuerungsart): void
    {
        $this->befeuerungsart->attach($befeuerungsart);
    }


    public function removeBefeuerungsart(Befeuerungsart $befeuerungsartToRemove): void
    {
        $this->befeuerungsart->detach($befeuerungsartToRemove);
    }


    public function getBefeuerungsart(): ?ObjectStorage
    {
        return $this->befeuerungsart;
    }


    public function setBefeuerungsart(ObjectStorage $befeuerungsart): void
    {
        $this->befeuerungsart = $befeuerungsart;
    }


    public function addAusrichtBalkonTerasse(Himmelrichtung $ausrichtBalkonTerasse): void
    {
        $this->ausrichtBalkonTerasse->attach($ausrichtBalkonTerasse);
    }


    public function removeAusrichtBalkonTerasse(Himmelrichtung $ausrichtBalkonTerasseToRemove): void
    {
        $this->ausrichtBalkonTerasse->detach($ausrichtBalkonTerasseToRemove);
    }


    public function getAusrichtBalkonTerasse(): ?ObjectStorage
    {
        return $this->ausrichtBalkonTerasse;
    }


    public function setAusrichtBalkonTerasse(ObjectStorage $ausrichtBalkonTerasse): void
    {
        $this->ausrichtBalkonTerasse = $ausrichtBalkonTerasse;
    }


    public function addDachform(Dachform $dachform): void
    {
        $this->dachform->attach($dachform);
    }


    public function removeDachform(Dachform $dachformToRemove): void
    {
        $this->dachform->detach($dachformToRemove);
    }


    public function getDachform(): ?ObjectStorage
    {
        return $this->dachform;
    }


    public function setDachform(ObjectStorage $dachform): void
    {
        $this->dachform = $dachform;
    }


    public function addBauweise(Bauweise $bauweise): void
    {
        $this->bauweise->attach($bauweise);
    }


    public function removeBauweise(Bauweise $bauweiseToRemove): void
    {
        $this->bauweise->detach($bauweiseToRemove);
    }


    public function getBauweise(): ?ObjectStorage
    {
        return $this->bauweise;
    }


    public function setBauweise(ObjectStorage $bauweise): void
    {
        $this->bauweise = $bauweise;
    }


    public function addAusbaustufe(Ausbaustufe $ausbaustufe): void
    {
        $this->ausbaustufe->attach($ausbaustufe);
    }


    public function removeAusbaustufe(Ausbaustufe $ausbaustufeToRemove): void
    {
        $this->ausbaustufe->detach($ausbaustufeToRemove);
    }


    public function getAusbaustufe(): ?ObjectStorage
    {
        return $this->ausbaustufe;
    }


    public function setAusbaustufe(ObjectStorage $ausbaustufe): void
    {
        $this->ausbaustufe = $ausbaustufe;
    }


    public function getEnergietyp(): ?Energietyp
    {
        return $this->energietyp;
    }


    public function setEnergietyp(Energietyp $energietyp): void
    {
        $this->energietyp = $energietyp;
    }


    public function getZustand(): ?Zustand
    {
        return $this->zustand;
    }


    public function setZustand(Zustand $zustand): void
    {
        $this->zustand = $zustand;
    }


    public function getBebaubarNach(): ?Bebaubarnach
    {
        return $this->bebaubarNach;
    }


    public function setBebaubarNach(Bebaubarnach $bebaubarNach): void
    {
        $this->bebaubarNach = $bebaubarNach;
    }


    public function getErschliessung(): ?Erschliessung
    {
        return $this->erschliessung;
    }


    public function setErschliessung(Erschliessung $erschliessung): void
    {
        $this->erschliessung = $erschliessung;
    }


    public function addErschliessungUmfang(Erschliessungdetails $erschliessungUmfang): void
    {
        $this->erschliessungUmfang->attach($erschliessungUmfang);
    }


    public function removeErschliessungUmfang(Erschliessungdetails $erschliessungUmfangToRemove): void
    {
        $this->erschliessungUmfang->detach($erschliessungUmfangToRemove);
    }


    public function getErschliessungUmfang(): ?ObjectStorage
    {
        return $this->erschliessungUmfang;
    }


    public function setErschliessungUmfang(ObjectStorage $erschliessungUmfang): void
    {
        $this->erschliessungUmfang = $erschliessungUmfang;
    }


    public function addAnhaenge(Anhang $anhaenge): void
    {
        $this->anhaenge->attach($anhaenge);
    }


    public function removeAnhaenge(Anhang $anhaengeToRemove): void
    {
        $this->anhaenge->detach($anhaengeToRemove);
    }


    public function getMinimaleMietdauer(): ?Periode
    {
        return $this->minimaleMietdauer;
    }


    public function setMinimaleMietdauer(Periode $minimaleMietdauer): void
    {
        $this->minimaleMietdauer = $minimaleMietdauer;
    }


    public function getMaximaleMietdauer(): ?Periode
    {
        return $this->maximaleMietdauer;
    }


    public function setMaximaleMietdauer(Periode $maximaleMietdauer): void
    {
        $this->maximaleMietdauer = $maximaleMietdauer;
    }


    public function getTitelbild(): ?Anhang
    {
        /**
         * @var Anhang $anhang
         */
        $erstesBild = null;
        foreach ($this->getAnhaenge() as $anhang) {
            if ($anhang->getTyp()
                       ?->getKuerzel() === 'TITELBILD') {
                return $anhang;
            }

            if (($erstesBild === null) && ($anhang->getTyp()
                                                 ?->getKuerzel() === 'BILD')) {
                $erstesBild = $anhang;
            }
        }
        return $erstesBild;
    }

    public function getAnhaenge(): ?ObjectStorage
    {
        return $this->anhaenge;
    }


    public function setAnhaenge(ObjectStorage $anhaenge): void
    {
        $this->anhaenge = $anhaenge;
    }

    public function getBilder(): array
    {
        $return = [];
        foreach ($this->getAnhaenge() as $anhang) {
            if (in_array(
                $anhang->getTyp()
                       ->getKuerzel(), ['TITELBILD', 'BILD', 'AUSSENANSICHTEN', 'INNENANSICHTEN']
            )) {
                $return[] = $anhang;
            }
        }
        return $return;
    }

    public function getGrundrisse(): array
    {
        $return = [];
        foreach ($this->getAnhaenge() as $anhang) {
            if ($anhang->getTyp()
                       ->getKuerzel() === 'GRUNDRISS') {
                $return[] = $anhang;
            }
        }
        return $return;
    }

    public function getDokumente(): array
    {
        $return = [];
        foreach ($this->getAnhaenge() as $anhang) {
            if ($anhang->getTyp()
                       ->getKuerzel() === 'DOKUMENTE') {
                $return[] = $anhang;
            }
        }
        return $return;
    }

    public function getPanoramen(): array
    {
        $return = [];
        foreach ($this->getAnhaenge() as $anhang) {
            if ($anhang->getTyp()
                       ->getKuerzel() === 'PANORAMA') {
                $return[] = $anhang;
            }
        }
        return $return;
    }

    /**
     * @throws SessionNotCreatedException
     */
    public function getIsFavorit(): bool
    {
        $favoriten = $this->sessionHandler->restoreFromSession('favoriten');
        if (is_array($favoriten)) {
            if (in_array($this->uid, $favoriten, true)) {
                return true;
            }

            return false;
        }

        return false;
    }

    public function getGegensprechanlage(): NullableBooleanEnum
    {
        return $this->gegensprechanlage;
    }

    public function setGegensprechanlage(NullableBooleanEnum $gegensprechanlage): Immobilie
    {
        $this->gegensprechanlage = $gegensprechanlage;
        return $this;
    }

    public function getLeichtErreichbar(): NullableBooleanEnum
    {
        return $this->leichtErreichbar;
    }

    public function setLeichtErreichbar(NullableBooleanEnum $leichtErreichbar): Immobilie
    {
        $this->leichtErreichbar = $leichtErreichbar;
        return $this;
    }

    public function getHasGeocodes(): bool
    {
        return ($this->getObjektLaengengrad() !== 0.0) && ($this->getObjektBreitengrad() !== 0.0);
    }

    public function getObjektLaengengrad(): float
    {
        return $this->objektLaengengrad;
    }


    public function setObjektLaengengrad(float $objektLaengengrad): void
    {
        $this->objektLaengengrad = $objektLaengengrad;
    }


    public function getObjektBreitengrad(): float
    {
        return $this->objektBreitengrad;
    }


    public function setObjektBreitengrad(float $objektBreitengrad): void
    {
        $this->objektBreitengrad = $objektBreitengrad;
    }


    public function getUpdatable(): bool
    {
        return $this->updatable;
    }


    public function isUpdatable(): bool
    {
        return $this->updatable;
    }


    public function setUpdatable(bool $updatable): self
    {
        $this->updatable = $updatable;
        return $this;
    }

    public function getHasBathTub(): bool
    {
        /**
         * @var $badAusstattung Badausstattung
         */
        foreach ($this->getAusstattungBad() as $badAusstattung) {
            if ($badAusstattung->getKuerzel() === 'WANNE') {
                return true;
            }
        }
        return false;
    }

    public function getAusstattungBad(): ?ObjectStorage
    {
        return $this->ausstattungBad;
    }


    public function setAusstattungBad(ObjectStorage $ausstattungBad): void
    {
        $this->ausstattungBad = $ausstattungBad;
    }

    public function getHasBathShower(): bool
    {
        /**
         * @var $badAusstattung Badausstattung
         */
        foreach ($this->getAusstattungBad() as $badAusstattung) {
            if ($badAusstattung->getKuerzel() === 'DUSCHE') {
                return true;
            }
        }
        return false;
    }

    public function getHasBathWindow(): bool
    {
        /**
         * @var $badAusstattung Badausstattung
         */
        foreach ($this->getAusstattungBad() as $badAusstattung) {
            if ($badAusstattung->getKuerzel() === 'FENSTER') {
                return true;
            }
        }
        return false;
    }

    public function getUniqueColorForImportNumber(): string
    {
        return '#' . substr(md5($this->getImportNumber()), 0, 6);
    }

    public function getImportNumber(): int
    {
        return $this->importNumber;
    }


    public function setImportNumber(int $importNumber): self
    {
        $this->importNumber = $importNumber;
        return $this;
    }


    public function getDistance(): string
    {
        return $this->distance;
    }


    public function setDistance(string $distance): void
    {
        $this->distance = $distance;
    }
}
