<?php

namespace SG\SgEstateCore\Domain\Model;

use SG\SgEstateCore\Enum\SortingForFilterEnum;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\DomainObject\AbstractValueObject;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use SG\SgEstateCore\Enum\NullableBooleanEnum;

class Filter extends AbstractValueObject{

    protected ?float $raeumeAb = null;

    protected ?float $raeumeBis = null;

    protected ?float $flaecheAb = null;

    protected ?float $flaecheBis = null;

    protected ?float $kaltmieteAb = null;

    protected ?float $kaltmieteBis = null;

    /**
     * @var ObjectStorage<Region>|null
     */
    protected ?ObjectStorage $regionen = null;

    /**
     * @var ObjectStorage<Ort>|null
     */
    protected ?ObjectStorage $orte = null;

    /**
     * @var ObjectStorage<Stadtteil>|null
     */
    protected ?ObjectStorage $stadtteile = null;

    /**
     * @var ObjectStorage<Objektart>|null
     */
    protected ?ObjectStorage $objektarten = null;

    /**
     * @var ObjectStorage<Objektarttyp>|null
     */
    protected ?ObjectStorage $objektarttypen = null;

    /**
     * @var ObjectStorage<Heizungsart>|null
     */
    protected ?ObjectStorage $heizungsarten = null;

    /**
     * @var ObjectStorage<Befeuerungsart>|null
     */
    protected ?ObjectStorage $befeuerungsarten = null;

    /**
     * @var ObjectStorage<Bodenbelag>|null
     */
    protected ?ObjectStorage $bodenbelaege = null;

    /**
     * @var ObjectStorage<Kampagne>|null
     */
    protected ?ObjectStorage $kampagnen = null;

    protected NullableBooleanEnum $einbaukueche = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $balkon = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $garten = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $keller = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $badMitWanne = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $badMitDusche = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $badMitFenster = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $badModernisiert = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $gaestewc = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $haustiere = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $wbs = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $barrierefrei = NullableBooleanEnum::KEINE_AUSWAHL;

    protected NullableBooleanEnum $leichterZugang = NullableBooleanEnum::KEINE_AUSWAHL;

    /**
     * @var ObjectStorage<Vermarktungsart>
     */
    protected ObjectStorage $vermarktungsarten;

    protected NullableBooleanEnum $aufzug = NullableBooleanEnum::KEINE_AUSWAHL;

    protected SortingForFilterEnum $sortierung = SortingForFilterEnum::KALTMIETE_ASC;

    protected array $uids = [];

    protected array $settings = [];

    protected array $importIds = [];

    protected float $latitude = 0.0;

    protected float $longitude = 0.0;

    protected string $addressString = '';

    protected float $radius = 0.0;

    protected int $personsFrom = 0;

    protected string $personsString = '';

    protected int $personsTo = 0;

    public function __construct(){
        $configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        $this->settings = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS);
        $this->initStorageObjects();
    }

    protected function initStorageObjects(): void
    {
        $this->regionen             = new ObjectStorage();
        $this->orte                 = new ObjectStorage();
        $this->stadtteile           = new ObjectStorage();
        $this->objektarten          = new ObjectStorage();
        $this->objektarttypen       = new ObjectStorage();
        $this->vermarktungsarten    = new ObjectStorage();
        $this->heizungsarten        = new ObjectStorage();
        $this->befeuerungsarten     = new ObjectStorage();
        $this->bodenbelaege         = new ObjectStorage();
        $this->kampagnen            = new ObjectStorage();
    }

    public function setFlaecheBis(?float $flaecheBis): self
    {
        $this->flaecheBis = $flaecheBis;
        return $this;
    }

    public function getFlaecheBis(): ?float
    {
        if (($this->flaecheBis === null) && (isset($this->settings['standards']['filter']['flaeche']['bis']))){
            return (float)$this->settings['standards']['filter']['flaeche']['bis'];
        }

        return $this->flaecheBis;
    }

    public function setFlaecheAb(?float $flaecheAb): self
    {
        $this->flaecheAb = $flaecheAb;
        return $this;
    }

    public function getFlaecheAb(): ?float
    {
        if (($this->flaecheAb === null) && (isset($this->settings['standards']['filter']['flaeche']['ab']))){
            return (float)$this->settings['standards']['filter']['flaeche']['ab'];
        }

        return $this->flaecheAb;
    }

    public function setKaltmieteAb(?float $kaltmieteAb): self
    {
        $this->kaltmieteAb = $kaltmieteAb;
        return $this;
    }

    public function getKaltmieteAb(): ?float
    {
        if (($this->kaltmieteAb === null) && (isset($this->settings['standards']['filter']['kaltmiete']['ab']))){
            return (float)$this->settings['standards']['filter']['kaltmiete']['ab'];
        }

        return $this->kaltmieteAb;
    }

    public function setKaltmieteBis(?float $kaltmieteBis): self
    {
        $this->kaltmieteBis = $kaltmieteBis;
        return $this;
    }

    public function getKaltmieteBis(): ?float
    {
        if (($this->kaltmieteBis === null) && (isset($this->settings['standards']['filter']['kaltmiete']['bis']))){
            return (float)$this->settings['standards']['filter']['kaltmiete']['bis'];
        }

        return $this->kaltmieteBis;
    }

    public function setRaeumeAb(?float $raeumeAb): self
    {
        $this->raeumeAb = $raeumeAb;
        return $this;
    }

    public function getRaeumeAb(): ?float
    {
        if (($this->raeumeAb === null) && (isset($this->settings['standards']['filter']['raeume']['ab']))){
            return (float)$this->settings['standards']['filter']['raeume']['ab'];
        }

        return $this->raeumeAb;
    }

    public function setRaeumeBis(?float $raeumeBis): self
    {
        $this->raeumeBis = $raeumeBis;
        return $this;
    }

    public function getRaeumeBis(): ?float
    {
        if (($this->raeumeBis === null)&&(isset($this->settings['standards']['filter']['raeume']['bis']))){
            return (float)$this->settings['standards']['filter']['raeume']['bis'];
        }

        return $this->raeumeBis;
    }

    public function getRegionen(): ObjectStorage
    {
        return $this->regionen;
    }

    /** @noinspection PhpUnused */
    public function setRegionen(ObjectStorage $regionen): self
    {
        $this->regionen = $regionen;
        return $this;
    }

    public function addRegion(Region $region): self
    {
        $this->regionen->attach($region);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeRegion(Region $region): self
    {
        $this->regionen->detach($region);
        return $this;
    }

    public function setRegion(Region $region): self
    {
        foreach ($this->regionen as $tempRegion){
            $this->regionen->detach($tempRegion);
        }
        $this->regionen->attach($region);
        return $this;
    }

    public function getRegion(): ?Region
    {
        if ($this->regionen->count() > 0){
            $this->regionen->rewind();
            $region = $this->regionen->current();
            if ($region instanceof Region){
                return $region;
            }

            return null;
        }
        return null;
    }

    /** @noinspection PhpUnused */
    public function setOrte(ObjectStorage $orte): self
    {
        $this->orte = $orte;
        return $this;
    }

    public function getOrte(): ObjectStorage
    {
        return $this->orte;
    }

    public function getOrt(): ?Ort
    {
        if ($this->orte->count() > 0) {
            $this->orte->rewind();
            return $this->orte->current();
        }

        return null;
    }

    public function setOrt(Ort $ort): self
    {
        if ($this->orte->count() > 0){
            $this->orte->removeAll($this->orte);
        }

        $this->orte->attach($ort);
        return $this;
    }

    public function addOrt(Ort $ort): self
    {
        $this->orte->attach($ort);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeOrt(Ort $ort): self
    {
        $this->orte->detach($ort);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function setStadtteile(ObjectStorage $stadtteile): self
    {
        $this->stadtteile = $stadtteile;
        return $this;
    }

    public function getStadtteile(): ObjectStorage
    {
        return $this->stadtteile;
    }

    public function addStadtteil(Stadtteil $stadtteil): self
    {
        $this->stadtteile->attach($stadtteil);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeStadtteil(Stadtteil $stadtteil): self
    {
        $this->stadtteile->detach($stadtteil);
        return $this;
    }

    public function getStadtteil(){
        if ($this->stadtteile->count() > 0){
            $this->stadtteile->rewind();
            return $this->stadtteile->current();
        }

        return null;
    }

    public function setObjektarten(ObjectStorage $objektarten): self
    {
        $this->objektarten = $objektarten;
        return $this;
    }

    public function getObjektarten(): ObjectStorage
    {
        return $this->objektarten;
    }

    public function addObjektart(Objektart $objektart): self
    {
        $this->objektarten->attach($objektart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeObjektart(Objektart $objektart): self
    {
        $this->objektarten->detach($objektart);
        return $this;
    }

    public function setObjektarttypen(ObjectStorage $objektarttypen): self
    {
        $this->objektarttypen = $objektarttypen;
        return $this;
    }

    public function getObjektarttypen(): ObjectStorage
    {
        return $this->objektarttypen;
    }

    /** @noinspection PhpUnused */
    public function addObjektarttyp(Objektarttyp $objektarttyp): self
    {
        $this->objektarttypen->attach($objektarttyp);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeObjektarttyp(Objektarttyp $objektarttyp): self
    {
        $this->objektarttypen->detach($objektarttyp);
        return $this;
    }

    public function setHeizungsarten(ObjectStorage $heizungsarten): self
    {
        $this->heizungsarten = $heizungsarten;
        return $this;
    }

    public function getHeizungsarten(): ObjectStorage
    {
        return $this->heizungsarten;
    }

    /** @noinspection PhpUnused */
    public function addHeizungsart(Heizungsart $heizungsart): self
    {
        $this->heizungsarten->attach($heizungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeHeizungsart(Heizungsart $heizungsart): self
    {
        $this->heizungsarten->detach($heizungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function setBefeuerungsarten(ObjectStorage $befeuerungsarten): self
    {
        $this->befeuerungsarten = $befeuerungsarten;
        return $this;
    }

    public function getBefeuerungsarten(): ObjectStorage
    {
        return $this->befeuerungsarten;
    }

    /** @noinspection PhpUnused */
    public function addBefeuerungsart(Befeuerungsart $befeuerungsart): self
    {
        $this->befeuerungsarten->attach($befeuerungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeBefeuerungsart(Befeuerungsart $befeuerungsart): self
    {
        $this->befeuerungsarten->detach($befeuerungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function setBodenbelaege(ObjectStorage $bodenbelaege): self
    {
        $this->bodenbelaege = $bodenbelaege;
        return $this;
    }

    public function getBodenbelaege(): ObjectStorage
    {
        return $this->bodenbelaege;
    }

    /** @noinspection PhpUnused */
    public function addBodenbelag(Bodenbelag $bodenbelag): self
    {
        $this->bodenbelaege->attach($bodenbelag);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeBodenbelag(Bodenbelag $bodenbelag): self
    {
        $this->bodenbelaege->detach($bodenbelag);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function setEinbaukueche($value): self
    {
        $this->einbaukueche = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getEinbaukueche(): NullableBooleanEnum
    {
        return $this->einbaukueche;
    }

    /** @noinspection PhpUnused */
    public function setBalkon($value): self
    {
        $this->balkon = $value;
        return $this;
    }

    public function getBalkon(): NullableBooleanEnum
    {
        return $this->balkon;
    }

    /** @noinspection PhpUnused */
    public function setGarten($value): self
    {
        $this->garten = $value;
        return $this;
    }

    public function getGarten(): NullableBooleanEnum
    {
        return $this->garten;
    }

    /** @noinspection PhpUnused */
    public function setKeller($value): self
    {
        $this->keller = $value;
        return $this;
    }

    public function getKeller(): NullableBooleanEnum
    {
        return $this->keller;
    }

    /** @noinspection PhpUnused */
    public function setBadMitWanne($value): self
    {
        $this->badMitWanne = $value;
        return $this;
    }

    public function getBadMitWanne(): NullableBooleanEnum
    {
        return $this->badMitWanne;
    }

    /** @noinspection PhpUnused */
    public function setBadMitDusche($value): self
    {
        $this->badMitDusche = $value;
        return $this;
    }

    public function getBadMitDusche(): NullableBooleanEnum
    {
        return $this->badMitDusche;
    }

    /** @noinspection PhpUnused */
    public function setBadMitFenster($value): void{
        $this->badMitFenster = $value;
    }

    public function getBadMitFenster(): NullableBooleanEnum
    {
        return $this->badMitFenster;
    }

    /** @noinspection PhpUnused */
    public function setBadModernisiert($badModernisiert): void
    {
        $this->badModernisiert = $badModernisiert;
    }

    public function getBadModernisiert(): NullableBooleanEnum
    {
        return $this->badModernisiert;
    }

    /** @noinspection PhpUnused */
    public function setGaestewc(int $value): self
    {
        $this->gaestewc = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getGaestewc(): NullableBooleanEnum
    {
        return $this->gaestewc;
    }

    /** @noinspection PhpUnused */
    public function setHaustiere(int $value): self
    {
        $this->haustiere = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getHaustiere(): NullableBooleanEnum
    {
        return $this->haustiere;
    }

    /** @noinspection PhpUnused */
    public function setWbs(int $value): self
    {
        $this->wbs = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getWbs(): NullableBooleanEnum
    {
        return $this->wbs;
    }

    public function setBarrierefrei(int $value): self
    {
        $this->barrierefrei = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getBarrierefrei(): NullableBooleanEnum
    {
        return $this->barrierefrei;
    }

    /** @noinspection PhpUnused */
    public function setLeichterZugang(int $value): self
    {
        $this->leichterZugang = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getLeichterZugang(): NullableBooleanEnum
    {
        return $this->leichterZugang;
    }

    public function setAufzug(int $value): self
    {
        $this->aufzug = NullableBooleanEnum::from($value);
        return $this;
    }

    public function getAufzug(): NullableBooleanEnum
    {
        return $this->aufzug;
    }

    public function setSortierung(int $sortierung): self
    {
        $this->sortierung = SortingForFilterEnum::from($sortierung);
        return $this;
    }

    public function getSortierung(): SortingForFilterEnum
    {
        return $this->sortierung;
    }

    /** @noinspection PhpUnused */
    public function setUids(array $uids): self
    {
        $this->uids = $uids;
        return $this;
    }

    public function getUids(): array
    {
        return $this->uids;
    }

    /** @noinspection PhpUnused */
    public function getIstErweiterteSuche(): bool
    {
        return ($this->getBalkon() > 0) || ($this->getBadModernisiert() > 0) || ($this->getBarrierefrei() > 0) || ($this->getAufzug());
    }

    /** @noinspection PhpUnused */
    public function setKampagnen(ObjectStorage $kampagnen): self
    {
        $this->kampagnen = $kampagnen;
        return $this;
    }

    public function getKampagnen(): ObjectStorage
    {
        return $this->kampagnen;
    }

    /** @noinspection PhpUnused */
    public function addKampagne(Kampagne $kampagne): self
    {
        $this->kampagnen->attach($kampagne);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeKampagne(Kampagne $kampagne): self
    {
        $this->kampagnen->detach($kampagne);
        return $this;
    }


    /** @noinspection PhpUnused */
    public function setVermarktungsarten(ObjectStorage $vermarktungsarten): self
    {
        $this->vermarktungsarten = $vermarktungsarten;
        return $this;
    }

    public function getVermarktungsarten(): ObjectStorage
    {
        return $this->vermarktungsarten;
    }

    /** @noinspection PhpUnused */
    public function addVermarktungsart(Vermarktungsart $vermarktungsart): self
    {
        $this->vermarktungsarten->attach($vermarktungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function removeVermarktungsart(Vermarktungsart $vermarktungsart): self
    {
        $this->vermarktungsarten->detach($vermarktungsart);
        return $this;
    }

    /** @noinspection PhpUnused */
    public function getSelectedObjektarttypen(): array
    {
        $return = array();
        foreach ($this->objektarttypen as $objektarttyp){
            $return[$objektarttyp->getKuerzel()] = 1;
        }
        return $return;
    }

    /** @noinspection PhpUnused */
    public function getSelectedHeizungsarten(): array
    {
        $return = array();
        foreach ($this->heizungsarten as $heizungsart){
            $return[$heizungsart->getKuerzel()] = 1;
        }
        return $return;
    }

    /** @noinspection PhpUnused */
    public function getGroupedCitiesAndDistricts(): string
    {
        $r = "";
        $city = $this->getOrt();
        if( $city instanceof Ort)
        {
            $r = $city->getUid();
        }
        $district = $this->getStadtteil();
        if( $district instanceof Stadtteil)
        {
            $r .= '_'.$district->getUid();
        }
        return $r;
    }

    public function getCacheIdentifier(): string
    {
        return sha1(serialize($this));
    }

    public function getImportIds(): array
    {
        return $this->importIds;
    }

    public function setImportIds(array $importIds): void
    {
        $this->importIds = $importIds;
    }

    public function getLatitude(): float
    {
        return $this->latitude;
    }

    public function setLatitude(float $latitude): void
    {
        $this->latitude = $latitude;
    }

    public function getLongitude(): float
    {
        return $this->longitude;
    }

    public function setLongitude(float $longitude): void
    {
        $this->longitude = $longitude;
    }

    public function getRadius(): float
    {
        return $this->radius;
    }

    public function setRadius(float $radius): void
    {
        $this->radius = $radius;
    }

    public function getAddressString(): string
    {
        return $this->addressString;
    }

    public function setAddressString(string $addressString): void
    {
        $this->addressString = $addressString;
    }

    public function getPersonsFrom(): int
    {
        return $this->personsFrom;
    }

    public function setPersonsFrom(int $personsFrom): void
    {
        $this->personsFrom = $personsFrom;
    }

    public function getPersonsTo(): int
    {
        return $this->personsTo;
    }

    public function setPersonsTo(int $personsTo): void
    {
        $this->personsTo = $personsTo;
    }

    /** @noinspection PhpUnused */
    public function getPersonsString(): string
    {
        return $this->personsString;
    }

    public function setPersonsString(string $personsString): void
    {
        $this->personsString = $personsString;
    }
}