<?php
namespace SG\SgEstateCore\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Extbase\Service\ImageService;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RealtiesArrayToPlacesJsonViewHelper extends AbstractViewHelper
{
    /**
     * @var ImageService
     */
    protected $imageService;

    /**
     * @param ImageService $imageService
     */
    public function injectImageService(ImageService $imageService){
        $this->imageService = $imageService;
    }

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('realties', 'array', 'Array of Realties');
    }

    public function render(){
        $arrayToReturn = [];
        $processingInstructions = array(
            'width' => '150c',
            'height' => '112c',
        );
        foreach ($this->arguments['realties'] as $realty){
            /**
             * @var $realty Immobilie
             */

            $image = $this->imageService->getImage(Environment::getPublicPath().'/uploads/tx_sgestatecore/media/'.$realty->getTitelbild()->getDatei(),null,false);
            $processedImage = $this->imageService->applyProcessingInstructions($image, $processingInstructions);
            $district = array();
            if( $realty->getObjektStadtteil() instanceof Stadtteil )
            {
                $district = array(
                    'id' => $realty->getObjektStadtteil()->getUid(),
                    'name' => $realty->getObjektStadtteil()->getBezeichner()
                );
            }
            $arrayToReturn[] = [
                'show' => true,
                'highlighted' => false,
                'id' => $realty->getUid(),
                'data' => [
                    'title' => $realty->getObjekttitel(),
                    'street' => $realty->getObjektStrasse(),
                    'houseNumber' => $realty->getObjektHausnummer(),
                    'zip' => $realty->getObjektPlz(),
                    'size' => $realty->getWohnflaeche(),
                    'rooms' => $realty->getAnzahlZimmer(),
                    'rent' => $realty->getNettokaltmiete(),
                    'balcony' => $realty->getAnzahlBalkone() > 0 ? true : false,
                    'city' => array(
                        'id' => $realty->getObjektOrt()->getUid(),
                        'name' => $realty->getObjektOrt()->getBezeichner()
                    ),
                    'district' => $district,
                ],
                'media' => [
                    'preview' => $this->imageService->getImageUri($processedImage)
                ],
                'geometry' => [
                    'location' => [
                        'lat' => $realty->getObjektBreitengrad(),
                        'lng' => $realty->getObjektLaengengrad()
                    ]
                ]
            ];
        }

        return json_encode($arrayToReturn);
    }
}