<?php
namespace SG\SgEstateCore\Util;

use Doctrine\DBAL\FetchMode;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Fluid\View\StandaloneView;

class Services{

    /**
     * @var ConnectionPool
     */
    private $connectionPool;

    /**
     * @var string
     */
    private $standardCountry = 'Germany';

    /**
     * @var ConfigurationManager
     */
    protected $configurationManager;

    /**
     * @param ConfigurationManager $configurationManager
     */
    public function injectConfigurationManager(ConfigurationManager $configurationManager){
        $this->configurationManager = $configurationManager;
    }

    public function __construct()
    {
        $this->connectionPool = GeneralUtility::makeInstance(ConnectionPool::class);
    }

    public function deleteAllRealties(){
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $result = $queryBuilder
            ->select('uid','kontaktperson')
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->execute();

        if ($result->rowCount() >= 1)
        {
            $this->deleteRealties($result->fetchAll(FetchMode::ASSOCIATIVE));
        }
    }

    public function deleteAllUpdatableRealties($importNumber = null)
    {
        $result = null;
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        if ($importNumber == null){
            $result = $queryBuilder
                ->select('uid','kontaktperson')
                ->from('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder->expr()->eq('updatable', $queryBuilder->createNamedParameter(1)))
                ->execute();
        }elseif (is_numeric($importNumber)){
            $result = $queryBuilder
                ->select('uid','kontaktperson')
                ->from('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder->expr()->eq('updatable', $queryBuilder->createNamedParameter(1)))
                ->andWhere($queryBuilder->expr()->eq('import_number', $queryBuilder->createNamedParameter($importNumber)))
                ->execute();

        }

        if ($result != null && $result->rowCount() >= 1)
        {
            $this->deleteRealties($result->fetchAll(FetchMode::ASSOCIATIVE));
        }
    }

    public function deleteRealties($realties){
        foreach($realties as $row){
            // Deletec Contactperson
            if (is_numeric($row['kontaktperson']))
            {
                $queryBuilder__tx_sgestatecore_domain_model_kontaktperson = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_kontaktperson');
                $queryBuilder__tx_sgestatecore_domain_model_kontaktperson
                    ->delete('tx_sgestatecore_domain_model_kontaktperson')
                    ->where($queryBuilder__tx_sgestatecore_domain_model_kontaktperson->expr()->eq('uid', $queryBuilder__tx_sgestatecore_domain_model_kontaktperson->createNamedParameter($row['kontaktperson'])))
                    ->execute();
            }

            // Verknüpfungen löschen
            if (is_numeric($row['uid'])){
                $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_ausbaustufe_mm');
                $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->delete('tx_sgestatecore_immobilie_ausbaustufe_mm')->where($queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_badausstattung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->delete('tx_sgestatecore_immobilie_badausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bauweise_mm');
                $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->delete('tx_sgestatecore_immobilie_bauweise_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bodenbelag_mm');
                $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->delete('tx_sgestatecore_immobilie_bodenbelag_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_dachform_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_dachform_mm');
                $queryBuilder__tx_sgestatecore_immobilie_dachform_mm->delete('tx_sgestatecore_immobilie_dachform_mm')->where($queryBuilder__tx_sgestatecore_immobilie_dachform_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_dachform_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_erschliessungdetails_mm');
                $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->delete('tx_sgestatecore_immobilie_erschliessungdetails_mm')->where($queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_heizungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->delete('tx_sgestatecore_immobilie_heizungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_befeuerungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->delete('tx_sgestatecore_immobilie_befeuerungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_himmelrichtung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->delete('tx_sgestatecore_immobilie_himmelrichtung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_kuechenausstattung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->delete('tx_sgestatecore_immobilie_kuechenausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_nutzungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->delete('tx_sgestatecore_immobilie_nutzungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_vermarktungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->delete('tx_sgestatecore_immobilie_vermarktungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm');
                $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->delete('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->where($queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->createNamedParameter($row['uid'])))->execute();
                //@todo: Delete User Simple, USer Extends, Kampagne
            }

            // Anhänge löschen
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $resultAttachments = $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->select('*')
                ->from('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->eq('immobilie', $queryBuilder__tx_sgestatecore_domain_model_anhang->createNamedParameter($row['uid'])))
                ->execute();
            $rows = $resultAttachments->fetchAll(FetchMode::ASSOCIATIVE);

            foreach ($rows as $attachment)
            {
                $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
                $resultSysFile = $queryBuilder__sys_file
                    ->select('uid')
                    ->from('sys_file')
                    ->where($queryBuilder__sys_file->expr()->like('identifier', $queryBuilder__sys_file->createNamedParameter('/uploads/tx_sgestatecore/media/'.$attachment['datei'])))
                    ->execute();
                $rowsSysFile = $resultSysFile->fetchAll(FetchMode::ASSOCIATIVE);
                foreach($rowsSysFile as $sysFile)
                {
                    $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
                    $resultProcessedFile = $queryBuilder__sys_file_processedfile
                        ->select('uid','identifier')
                        ->from('sys_file_processedfile')
                        ->where($queryBuilder__sys_file_processedfile->expr()->eq('original', $queryBuilder__sys_file_processedfile->createNamedParameter($sysFile['uid'])))
                        ->execute();
                    $rowsProcessedFile = $resultProcessedFile->fetchAll(FetchMode::ASSOCIATIVE);
                    foreach($rowsProcessedFile as $processedFile){
                        if ($processedFile['identifier'] != ''){
                            @unlink(Environment::getPublicPath().$processedFile['identifier']);
                        }
                        $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
                        $queryBuilder__sys_file_processedfile
                            ->delete('sys_file_processedfile')
                            ->where($queryBuilder__sys_file_processedfile->expr()->eq('uid', $queryBuilder__sys_file_processedfile->createNamedParameter($processedFile['uid'])))
                            ->execute();
                    }
                    $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
                    $queryBuilder__sys_file
                        ->delete('sys_file')
                        ->where($queryBuilder__sys_file->expr()->eq('uid', $queryBuilder__sys_file->createNamedParameter($sysFile['uid'])))
                        ->execute();
                }
                if ($attachment['datei'] != '')
                {
                    @unlink(Environment::getPublicPath().'/uploads/tx_sgestatecore/media/'. $attachment['datei']);
                }
            }
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->delete('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->eq('immobilie', $queryBuilder__tx_sgestatecore_domain_model_anhang->createNamedParameter($row['uid'])))
                ->execute();

            // Immobiliendatensatz löschen
            $queryBuilder__tx_sgestatecore_domain_model_immobilie = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
            $queryBuilder__tx_sgestatecore_domain_model_immobilie
                ->delete('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder__tx_sgestatecore_domain_model_immobilie->expr()->eq('uid', $queryBuilder__tx_sgestatecore_domain_model_immobilie->createNamedParameter($row['uid'])))
                ->execute();

            // Cache löschen
            GeneralUtility::makeInstance(CacheManager::class)->flushCachesByTag('immobilie');
        }
    }

    public function geocodeRealties($renewAll = false){
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $queryBuilder
            ->select('tx_sgestatecore_domain_model_immobilie.uid','tx_sgestatecore_domain_model_immobilie.objekt_plz as zip','tx_sgestatecore_domain_model_immobilie.objekt_strasse as street','tx_sgestatecore_domain_model_immobilie.objekt_hausnummer as housenumber','city.bezeichner as city','country.bezeichner as country')
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_ort','city', $queryBuilder->expr()->eq('city.uid',$queryBuilder->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_ort')))
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_land', 'country', $queryBuilder->expr()->eq('country.uid',$queryBuilder->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_land')));
        if ($renewAll == false){
            $queryBuilder->orWhere($queryBuilder->expr()->eq('objekt_breitengrad', $queryBuilder->createNamedParameter(0)));
            $queryBuilder->orWhere($queryBuilder->expr()->eq('objekt_laengengrad', $queryBuilder->createNamedParameter(0)));
        }
        $result = $queryBuilder->execute();


        if ($result->rowCount() > 0){
            $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_immobilie');
            $rows = $result->fetchAll(FetchMode::ASSOCIATIVE);
            foreach ($rows as $row){
                $coordinates = $this->geocodeAddress($row['coutry'],$row['city'],$row['zip'],$row['street'],$row['housenumber']);
                if ($row['uid'] > 0 && $coordinates['longitude'] > 0 && $coordinates['latitude'] > 0){
                    $updateArray = array(
                        'objekt_laengengrad' => $coordinates['longitude'],
                        'objekt_breitengrad' => $coordinates['latitude']
                    );
                    $connection->update(
                        'tx_sgestatecore_domain_model_immobilie',
                        $updateArray,
                        ['uid' => $row['uid']]
                    );
                }
            }
        }
    }

    private function geocodeAddress($country,$city,$zip,$street,$housenumber){
        $configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        $configuration = $configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $settings = $configuration['module.']['tx_sgestatecore.']['settings.'];
        if ($country == ''){
            $country = $this->standardCountry;
        }
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_geocode_cache');
        $result = $queryBuilder
            ->select('longitude','latitude')
            ->from('tx_sgestatecore_geocode_cache')
            ->where($queryBuilder->expr()->eq('zip', $queryBuilder->createNamedParameter($zip)))
            ->andWhere($queryBuilder->expr()->eq('street', $queryBuilder->createNamedParameter($street)))
            ->andWhere($queryBuilder->expr()->eq('housenumber', $queryBuilder->createNamedParameter($housenumber)))
            ->andWhere($queryBuilder->expr()->eq('country', $queryBuilder->createNamedParameter($country)))
            ->execute();
        if ($result->rowCount() > 0){
            $resultItem = $result->fetch(FetchMode::ASSOCIATIVE);
            $coordinates['longitude'] = $resultItem['longitude'];
            $coordinates['latitude'] = $resultItem['latitude'];
            return $coordinates;
        }

        $coordinates = null;
        $address =
            $this->convertMutation($country) . ', '. $zip . ' '.
            $this->convertMutation($city) . ', '.
            $this->convertMutation($street) . ' '.
            $housenumber;

        $delay = 0;
        $base_url = "https://maps.googleapis.com/maps/api/geocode/xml";

        $geocode_pending = true;

        while ($geocode_pending) {
            $request_url = $base_url . "?address=" . urlencode($address) . '&key='.$settings['keys.']['googleapi'];
            $xml = simplexml_load_file($request_url) or die("url not loading"); // @todo: Throw Error ??
            $status = $xml->status;

            if (strcmp($status, "OK") == 0) {
                // Successful geocode
                $geocode_pending = false;
                $coordinates = array(
                    'latitude' => floatval($xml->result->geometry->location->lat),
                    'longitude' => floatval($xml->result->geometry->location->lng)
                );
                $insertData = array(
                    'zip'           => $zip,
                    'street'        => $street,
                    'housenumber'   => $housenumber,
                    'country'       => $country,
                    'longitude'     => floatval($xml->result->geometry->location->lng),
                    'latitude'      => floatval($xml->result->geometry->location->lat),
                );

                $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_geocode_cache');
                $connection->insert(
                    'tx_sgestatecore_geocode_cache',
                    $insertData
                );
            } else if (strcmp($status, "OVER_QUERY_LIMIT") == 0) {
                // sent geocodes too fast
                $delay += 100000;
            } else {
                // failure to geocode
                $geocode_pending = false;
            }
            usleep($delay);
        }
        return $coordinates;
    }

    /**
     * @param array $recipients
     * @param $sender
     * @param $subject
     * @param $templateName
     * @param array $bcc
     * @param array $variables
     * @param array $attachments
     *  [
     *      0 => [
     *          'type' => 'fromPath',
     *          'path' => '/path/to/attachment'
     *          'filename' => 'filenameInEmail.txt'
     *          ],
     *      1 => [
     *          'type' => 'content',
     *          'content' => 'iamthecontent'
     *          'filename' => 'filenameInEmail.txt'
     *          ]
     *  ]
     *
     * @param string $format
     * @return bool
     * @throws \Symfony\Component\Mailer\Exception\TransportExceptionInterface
     */
    public function sendTemplateEmail(array $recipients, $sender, $subject, $templateName, array $bcc = array(), array $variables = array(), array $attachments = array(), $format = 'html') {
        $message = GeneralUtility::makeInstance(FluidEmail::class);

        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)){
            $message->from($sender);
        }else{
            return false;
        }

        // Add Recipients
        $recipients = array_filter($recipients);
        if (count($recipients) > 0){
            foreach ($recipients as $email){
                if (GeneralUtility::validEmail($email)){
                    $message->addTo($email);
                }
            }
        }else{
            return false;
        }

        if (count($bcc) > 0){
            foreach ($bcc as $email){
                if (GeneralUtility::validEmail($email)){
                    $message->addBcc($email);
                }
            }
        }

        if ($subject != ''){
            $message->subject($subject);
        }else{
            return false;
        }

        if ($format == 'text'){
            $message->format('text');
        }elseif ($format == 'html'){
            $message->format('html');
        }

        $message->assignMultiple($variables);
        $message->setTemplate($templateName . '.'.$format);

        foreach ($attachments as $attachment){
            switch ($attachment['type']){
                case 'fromPath':
                    $message->attachFromPath($attachment['path'], $attachment['filename']);
                    break;
                case 'content':
                    $message->attach($attachment['content'],$attachment['filename']);
                    break;
            }
        }

        GeneralUtility::makeInstance(Mailer::class)->send($message);
        return true;
    }

    /**
     * @param $value
     * @return mixed
     */
    private function convertMutation($value){
        $value = str_replace('ü','ue',$value);
        $value = str_replace('Ü','Ue',$value);
        $value = str_replace('ö','oe',$value);
        $value = str_replace('Ö','Oe',$value);
        $value = str_replace('ä','ae',$value);
        $value = str_replace('Ä','Ae',$value);
        $value = str_replace('ß','ss',$value);
        return $value;
    }

}