<?php
namespace SG\SgEstateCore\Util;

use Doctrine\DBAL\FetchMode;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;

class Services
{

    /**
     * @var ConnectionPool
     */
    private $connectionPool;

    /**
     * @var string
     */
    private $standardCountry = 'Germany';

    /**
     * @var ConfigurationManager
     */
    protected $configurationManager;

    /**
     * @param ConfigurationManager $configurationManager
     */
    public function injectConfigurationManager(ConfigurationManager $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }

    /**
     * @var OrtRepository
     */
    protected $ortRepository;

    public function injectOrtRepository(OrtRepository $ortRepository)
    {
        $this->ortRepository = $ortRepository;
    }

    public function __construct()
    {
        $this->connectionPool = GeneralUtility::makeInstance(ConnectionPool::class);
    }

    public function deleteAllRealties()
    {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $result = $queryBuilder
            ->select('uid', 'kontaktperson')
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->execute();

        if ($result->rowCount() >= 1) {
            // $this->deleteRealties($result->fetchAll(FetchMode::ASSOCIATIVE));
            $this->deleteRealties2($result->fetchAll(FetchMode::ASSOCIATIVE));
        }
    }

    public function deleteAllUpdatableRealties($importNumber = null)
    {
        $result = null;
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        if (is_null($importNumber)) {
            $result = $queryBuilder
                ->select('uid', 'kontaktperson')
                ->from('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder->expr()->eq('updatable', $queryBuilder->createNamedParameter(1)))
                ->execute();
        } elseif (is_numeric($importNumber)) {
            $result = $queryBuilder
                ->select('uid', 'kontaktperson')
                ->from('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder->expr()->eq('updatable', $queryBuilder->createNamedParameter(1)))
                ->andWhere($queryBuilder->expr()->eq('import_number', $queryBuilder->createNamedParameter($importNumber)))
                ->execute();
        }

        if ($result != null && $result->rowCount() >= 1) {
            // $this->deleteRealties($result->fetchAll(FetchMode::ASSOCIATIVE));
            $this->deleteRealties2($result->fetchAll(FetchMode::ASSOCIATIVE));
        }
    }

    public function deleteRealties2($realties)
    {
        $log = [];
        $log['realtiesInputCount'] = count($realties);
        $result = array();
        foreach ($realties as $row) {
            $result[$row['uid']] = is_numeric($row['kontaktperson']) ? $row['kontaktperson'] : 0;
        }
        $log['realtiesInputData'] = $result;

        $log['realtiesTryToRemoveAllContactPersonsStart'] = 'OK';
        if(count(array_values($result)) >= 1) {
            $queryBuilder__tx_sgestatecore_domain_model_kontaktperson = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_kontaktperson');
            $queryBuilder__tx_sgestatecore_domain_model_kontaktperson
                ->delete('tx_sgestatecore_domain_model_kontaktperson')
                ->where($queryBuilder__tx_sgestatecore_domain_model_kontaktperson->expr()->in('uid', array_values($result)))
                ->execute();
            $log['realtiesTryToRemoveAllContactPersonsStop'] = 'OK';

            $log['realtiesTryToRemoveAllManyToManyStart'] = 'OK';
            $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_ausbaustufe_mm');
            $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->delete('tx_sgestatecore_immobilie_ausbaustufe_mm')->where($queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_badausstattung_mm');
            $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->delete('tx_sgestatecore_immobilie_badausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bauweise_mm');
            $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->delete('tx_sgestatecore_immobilie_bauweise_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bodenbelag_mm');
            $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->delete('tx_sgestatecore_immobilie_bodenbelag_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_dachform_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_dachform_mm');
            $queryBuilder__tx_sgestatecore_immobilie_dachform_mm->delete('tx_sgestatecore_immobilie_dachform_mm')->where($queryBuilder__tx_sgestatecore_immobilie_dachform_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_erschliessungdetails_mm');
            $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->delete('tx_sgestatecore_immobilie_erschliessungdetails_mm')->where($queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_heizungsart_mm');
            $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->delete('tx_sgestatecore_immobilie_heizungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_befeuerungsart_mm');
            $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->delete('tx_sgestatecore_immobilie_befeuerungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_himmelrichtung_mm');
            $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->delete('tx_sgestatecore_immobilie_himmelrichtung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_kuechenausstattung_mm');
            $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->delete('tx_sgestatecore_immobilie_kuechenausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_nutzungsart_mm');
            $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->delete('tx_sgestatecore_immobilie_nutzungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_vermarktungsart_mm');
            $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->delete('tx_sgestatecore_immobilie_vermarktungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->expr()->in('uid_local', array_keys($result)))->execute();

            $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm');
            $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->delete('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->where($queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->expr()->in('uid_local', array_keys($result)))->execute();
            $log['realtiesTryToRemoveAllManyToManyStop'] = 'OK';

            $log['realtiesGetAllBinariesForAllRealtiesFromInputStart'] = 'OK';
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $resultAttachments = $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->select('datei')
                ->from('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->in('immobilie', array_keys($result)))
                ->execute();
            $rows = $resultAttachments->fetchAll(FetchMode::ASSOCIATIVE);
            $log['realtiesGetAllBinariesForAllRealtiesFromInputStop'] = 'OK';

            $log['realtiesCollectAllBinariesIntoArrayIdPathStart'] = 'OK';
            $anhange = array();
            foreach ($rows as $attachment) {
                $anhange[$attachment['uid']] = '"/uploads/tx_sgestatecore/media/' .  $attachment['datei'] . '"';
            }
            $log['realtiesCollectAllBinariesIntoArrayIdPathStop'] = 'OK';

            $log['realtiesGetAllSysRelationsForBinariesStart'] = 'OK';
            $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
            $resultSysFile = $queryBuilder__sys_file
                ->select('uid')
                ->from('sys_file')
                ->where($queryBuilder__sys_file->expr()->in('identifier', array_values($anhange)))
                ->execute();
            $rowsSysFile = $resultSysFile->fetchAll(FetchMode::ASSOCIATIVE);
            $log['realtiesGetAllSysRelationsForBinariesStop'] = 'OK';
            $log['realtiesCollectAllSysRelationsIdsStart'] = 'OK';
            $syss = array();
            foreach($rowsSysFile as $sys) {
                $syss[] = $sys['uid'];
            }
            $log['realtiesCollectAllSysRelationsIdsStart'] = 'OK';
            $log['realtiesGetAllProcessedDataStart'] = 'OK';
            $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
            $resultProcessedFile = $queryBuilder__sys_file_processedfile
                ->select('uid', 'identifier')
                ->from('sys_file_processedfile')
                ->where($queryBuilder__sys_file_processedfile->expr()->in('original', empty($syss) ? array(0) : $syss))
                ->execute();
            $rowsProcessedFile = $resultProcessedFile->fetchAll(FetchMode::ASSOCIATIVE);
            $log['realtiesGetAllProcessedDataStop'] = 'OK';
            $log['realtiesDeleteAllProcessedFilesStart'] = 'OK';
            $procs = array();
            foreach ($rowsProcessedFile as $processedFile) {
                $procs[] = $processedFile['uid'];
                if ($processedFile['identifier'] != '') {
                    @unlink(Environment::getPublicPath() . $processedFile['identifier']);
                }
            }
            $log['realtiesDeleteAllProcessedFilesStop'] = 'OK';
            $log['realtiesDeleteAllSysFilesRelationsStart'] = 'OK';
            $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
            $queryBuilder__sys_file
                ->delete('sys_file')
                ->where($queryBuilder__sys_file->expr()->in('uid', empty($syss) ? array(0) : $syss))
                ->execute();
            $log['realtiesDeleteAllSysFilesRelationsStop'] = 'OK';
            $log['realtiesDeleteAllProcessedFilesRelationsStart'] = 'OK';
            $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
            $queryBuilder__sys_file_processedfile
                ->delete('sys_file_processedfile')
                ->where($queryBuilder__sys_file_processedfile->expr()->in('uid', empty($procs) ? array(0) : $procs))
                ->execute();
            $log['realtiesDeleteAllProcessedFilesRelationsStop'] = 'OK';
            $log['realtiesDeleteAllOriginalFilesStart'] = 'OK';
            foreach($anhange as $anhang) {
                if ($anhange != '/uploads/tx_sgestatecore/media/') {
                    @unlink(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/' . $anhang);
                }
            }
            $log['realtiesDeleteAllOriginalFilesStop'] = 'OK';
            $log['realtiesRmoveAllBinariesDataStart'] = 'OK';
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->delete('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->in('immobilie', array_keys($result)))
                ->execute();
            $log['realtiesRmoveAllBinariesDataStop'] = 'OK';
            $log['realtiesRmoveAllDataStart'] = 'OK';
            $queryBuilder__tx_sgestatecore_domain_model_immobilie = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
            $queryBuilder__tx_sgestatecore_domain_model_immobilie
                ->delete('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder__tx_sgestatecore_domain_model_immobilie->expr()->in('uid', array_keys($result)))
                ->execute();
            $log['realtiesRmoveAllDataStop'] = 'OK';
            $log['realtiesFlushCacheStart'] = 'OK';
            GeneralUtility::makeInstance(CacheManager::class)->flushCachesByTag('immobilie');
            $log['realtiesFlushCacheStop'] = 'OK';
        } else {
            $log['realtiesDelete'] = 'NOT OK';
            $log['realtiesTryToRemoveAllManyToManyStop'] = 'NOT OK';
        }
        return $log;
    }

    public function deleteRealties($realties)
    {
        foreach ($realties as $row) {
            // Deletec Contactperson
            if (is_numeric($row['kontaktperson'])) {
                $queryBuilder__tx_sgestatecore_domain_model_kontaktperson = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_kontaktperson');
                $queryBuilder__tx_sgestatecore_domain_model_kontaktperson
                    ->delete('tx_sgestatecore_domain_model_kontaktperson')
                    ->where($queryBuilder__tx_sgestatecore_domain_model_kontaktperson->expr()->eq('uid', $queryBuilder__tx_sgestatecore_domain_model_kontaktperson->createNamedParameter($row['kontaktperson'])))
                    ->execute();
            }

            // Verknüpfungen löschen
            if (is_numeric($row['uid'])) {
                $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_ausbaustufe_mm');
                $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->delete('tx_sgestatecore_immobilie_ausbaustufe_mm')->where($queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_ausbaustufe_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_badausstattung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->delete('tx_sgestatecore_immobilie_badausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_badausstattung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bauweise_mm');
                $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->delete('tx_sgestatecore_immobilie_bauweise_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_bauweise_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bodenbelag_mm');
                $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->delete('tx_sgestatecore_immobilie_bodenbelag_mm')->where($queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_bodenbelag_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_dachform_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_dachform_mm');
                $queryBuilder__tx_sgestatecore_immobilie_dachform_mm->delete('tx_sgestatecore_immobilie_dachform_mm')->where($queryBuilder__tx_sgestatecore_immobilie_dachform_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_dachform_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_erschliessungdetails_mm');
                $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->delete('tx_sgestatecore_immobilie_erschliessungdetails_mm')->where($queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_erschliessungdetails_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_heizungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->delete('tx_sgestatecore_immobilie_heizungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_heizungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_befeuerungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->delete('tx_sgestatecore_immobilie_befeuerungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_befeuerungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_himmelrichtung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->delete('tx_sgestatecore_immobilie_himmelrichtung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_himmelrichtung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_kuechenausstattung_mm');
                $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->delete('tx_sgestatecore_immobilie_kuechenausstattung_mm')->where($queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_kuechenausstattung_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_nutzungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->delete('tx_sgestatecore_immobilie_nutzungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_nutzungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_vermarktungsart_mm');
                $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->delete('tx_sgestatecore_immobilie_vermarktungsart_mm')->where($queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_vermarktungsart_mm->createNamedParameter($row['uid'])))->execute();

                $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm');
                $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->delete('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->where($queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->expr()->eq('uid_local', $queryBuilder__tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm->createNamedParameter($row['uid'])))->execute();
                //@todo: Delete User Simple, USer Extends, Kampagne
            }

            // Anhänge löschen
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $resultAttachments = $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->select('*')
                ->from('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->eq('immobilie', $queryBuilder__tx_sgestatecore_domain_model_anhang->createNamedParameter($row['uid'])))
                ->execute();
            $rows = $resultAttachments->fetchAll(FetchMode::ASSOCIATIVE);

            foreach ($rows as $attachment) {
                $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
                $resultSysFile = $queryBuilder__sys_file
                    ->select('uid')
                    ->from('sys_file')
                    ->where($queryBuilder__sys_file->expr()->like('identifier', $queryBuilder__sys_file->createNamedParameter('/uploads/tx_sgestatecore/media/' . $attachment['datei'])))
                    ->execute();
                $rowsSysFile = $resultSysFile->fetchAll(FetchMode::ASSOCIATIVE);
                foreach ($rowsSysFile as $sysFile) {
                    $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
                    $resultProcessedFile = $queryBuilder__sys_file_processedfile
                        ->select('uid', 'identifier')
                        ->from('sys_file_processedfile')
                        ->where($queryBuilder__sys_file_processedfile->expr()->eq('original', $queryBuilder__sys_file_processedfile->createNamedParameter($sysFile['uid'])))
                        ->execute();
                    $rowsProcessedFile = $resultProcessedFile->fetchAll(FetchMode::ASSOCIATIVE);
                    foreach ($rowsProcessedFile as $processedFile) {
                        if ($processedFile['identifier'] != '') {
                            @unlink(Environment::getPublicPath() . $processedFile['identifier']);
                        }
                        $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
                        $queryBuilder__sys_file_processedfile
                            ->delete('sys_file_processedfile')
                            ->where($queryBuilder__sys_file_processedfile->expr()->eq('uid', $queryBuilder__sys_file_processedfile->createNamedParameter($processedFile['uid'])))
                            ->execute();
                    }
                    $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
                    $queryBuilder__sys_file
                        ->delete('sys_file')
                        ->where($queryBuilder__sys_file->expr()->eq('uid', $queryBuilder__sys_file->createNamedParameter($sysFile['uid'])))
                        ->execute();
                }
                if ($attachment['datei'] != '') {
                    @unlink(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/' . $attachment['datei']);
                }
            }
            $queryBuilder__tx_sgestatecore_domain_model_anhang = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang');
            $queryBuilder__tx_sgestatecore_domain_model_anhang
                ->delete('tx_sgestatecore_domain_model_anhang')
                ->where($queryBuilder__tx_sgestatecore_domain_model_anhang->expr()->eq('immobilie', $queryBuilder__tx_sgestatecore_domain_model_anhang->createNamedParameter($row['uid'])))
                ->execute();

            // Immobiliendatensatz löschen
            $queryBuilder__tx_sgestatecore_domain_model_immobilie = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
            $queryBuilder__tx_sgestatecore_domain_model_immobilie
                ->delete('tx_sgestatecore_domain_model_immobilie')
                ->where($queryBuilder__tx_sgestatecore_domain_model_immobilie->expr()->eq('uid', $queryBuilder__tx_sgestatecore_domain_model_immobilie->createNamedParameter($row['uid'])))
                ->execute();

            // Cache löschen
            GeneralUtility::makeInstance(CacheManager::class)->flushCachesByTag('immobilie');
        }
    }

    public function deleteAllRealtiesFast()
    {
        // clear tx_sgestatecore_domain_model_kontaktperson table
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_kontaktperson')->delete('tx_sgestatecore_domain_model_kontaktperson')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_kontaktperson')->truncate('tx_sgestatecore_domain_model_kontaktperson');
        // eof clear tx_sgestatecore_domain_model_kontaktperson table
        // clear all mm tables
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_ausbaustufe_mm')->delete('tx_sgestatecore_immobilie_ausbaustufe_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_ausbaustufe_mm')->truncate('tx_sgestatecore_immobilie_ausbaustufe_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_badausstattung_mm')->delete('tx_sgestatecore_immobilie_badausstattung_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_badausstattung_mm')->truncate('tx_sgestatecore_immobilie_badausstattung_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bauweise_mm')->delete('tx_sgestatecore_immobilie_bauweise_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bauweise_mm')->truncate('tx_sgestatecore_immobilie_bauweise_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bodenbelag_mm')->delete('tx_sgestatecore_immobilie_bodenbelag_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_bodenbelag_mm')->truncate('tx_sgestatecore_immobilie_bodenbelag_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_dachform_mm')->delete('tx_sgestatecore_immobilie_dachform_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_dachform_mm')->truncate('tx_sgestatecore_immobilie_dachform_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_erschliessungdetails_mm')->delete('tx_sgestatecore_immobilie_erschliessungdetails_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_erschliessungdetails_mm')->truncate('tx_sgestatecore_immobilie_erschliessungdetails_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_heizungsart_mm')->delete('tx_sgestatecore_immobilie_heizungsart_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_heizungsart_mm')->truncate('tx_sgestatecore_immobilie_heizungsart_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_befeuerungsart_mm')->delete('tx_sgestatecore_immobilie_befeuerungsart_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_befeuerungsart_mm')->truncate('tx_sgestatecore_immobilie_befeuerungsart_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_himmelrichtung_mm')->delete('tx_sgestatecore_immobilie_himmelrichtung_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_himmelrichtung_mm')->truncate('tx_sgestatecore_immobilie_himmelrichtung_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_kuechenausstattung_mm')->delete('tx_sgestatecore_immobilie_kuechenausstattung_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_kuechenausstattung_mm')->truncate('tx_sgestatecore_immobilie_kuechenausstattung_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_nutzungsart_mm')->delete('tx_sgestatecore_immobilie_nutzungsart_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_nutzungsart_mm')->truncate('tx_sgestatecore_immobilie_nutzungsart_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_vermarktungsart_mm')->delete('tx_sgestatecore_immobilie_vermarktungsart_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_vermarktungsart_mm')->truncate('tx_sgestatecore_immobilie_vermarktungsart_mm');
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->delete('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm')->truncate('tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm');
        // eof clear all mm tables
        // get all service-images idz
        $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
        $resultSysFile = $queryBuilder__sys_file
            ->select('uid')
            ->from('sys_file')
            ->where($queryBuilder__sys_file->expr()->like('identifier', $queryBuilder__sys_file->createNamedParameter('/uploads/tx_sgestatecore/media/%')))
            ->execute();
        $sys_idz = array();
        foreach ($resultSysFile->fetchAll(FetchMode::ASSOCIATIVE) as $sysFile)
            $sys_idz[] = $sysFile['uid'];
        // eof get all service-images idz
        // get all processed images idz and remove all processed images
        $queryBuilder__sys_file_processedfile = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
        $resultProcessedFile = $queryBuilder__sys_file_processedfile
            ->select('uid', 'identifier')
            ->from('sys_file_processedfile')
            ->where($queryBuilder__sys_file_processedfile->expr()->in('original', $sys_idz))
            ->execute();
        $rowsProcessedFile = $resultProcessedFile->fetchAll(FetchMode::ASSOCIATIVE);
        $proc_idz = array();
        foreach ($rowsProcessedFile as $processedFile) {
            $proc_idz[] = $processedFile['uid'];
            if ($processedFile['identifier'] != '')
                @unlink(Environment::getPublicPath() . $processedFile['identifier']);
        }
        // eof get all processed images idz and remove all processed images
        // clear sys_file table restrict with sys_idz
        $queryBuilder__sys_file = $this->connectionPool->getQueryBuilderForTable('sys_file');
        $queryBuilder__sys_file->delete('sys_file')->where($queryBuilder__sys_file->expr()->in('uid', $sys_idz))->execute();
        // eof clear sys_file table restrict with sys_idz
        // clear sys_file_processedfile table restrict with proc_idz
        $queryBuilder__proc_file = $this->connectionPool->getQueryBuilderForTable('sys_file_processedfile');
        $queryBuilder__proc_file->delete('sys_file_processedfile')->where($queryBuilder__proc_file->expr()->in('uid', $proc_idz))->execute();
        // eof clear sys_file_processedfile table restrict with proc_idz
        // clear tx_sgestatecore_domain_model_anhang table
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang')->delete('tx_sgestatecore_domain_model_anhang')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_anhang')->truncate('tx_sgestatecore_domain_model_anhang');
        // eof clear tx_sgestatecore_domain_model_anhang table
        // clear tx_sgestatecore_domain_model_immobilie table
        // $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie')->delete('tx_sgestatecore_domain_model_immobilie')->execute();
        $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie')->truncate('tx_sgestatecore_domain_model_immobilie');
        // eof clear tx_sgestatecore_domain_model_immobilie table
        // remove all original binaries from FS
        @unlink(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/*');
        // eof remove all original binaries from FS
        // flush realty cache
        GeneralUtility::makeInstance(CacheManager::class)->flushCachesByTag('immobilie');
        // eof flush realty cache
    }

    public function geocodeRealties($renewAll = false)
    {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $queryBuilder
            ->select('tx_sgestatecore_domain_model_immobilie.uid', 'tx_sgestatecore_domain_model_immobilie.objekt_plz as zip', 'tx_sgestatecore_domain_model_immobilie.objekt_strasse as street', 'tx_sgestatecore_domain_model_immobilie.objekt_hausnummer as housenumber', 'city.bezeichner as city', 'country.bezeichner as country', 'tx_sgestatecore_domain_model_immobilie.objektnr_extern as objektnr_extern')
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_ort', 'city', $queryBuilder->expr()->eq('city.uid', $queryBuilder->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_ort')))
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_land', 'country', $queryBuilder->expr()->eq('country.uid', $queryBuilder->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_land')));
        if ($renewAll == false) {
            $queryBuilder->orWhere($queryBuilder->expr()->eq('objekt_breitengrad', $queryBuilder->createNamedParameter(0)));
            $queryBuilder->orWhere($queryBuilder->expr()->eq('objekt_laengengrad', $queryBuilder->createNamedParameter(0)));
        }
        $result = $queryBuilder->execute();

        $log = [];

        if ($result->rowCount() > 0) {
            $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_immobilie');
            $rows = $result->fetchAll(FetchMode::ASSOCIATIVE);
            foreach ($rows as $row) {
                $coordinates = $this->geocodeAddress($row['coutry'], $row['city'], $row['zip'], $row['street'], $row['housenumber'], $row['objektnr_extern'], $log);
                if ($row['uid'] > 0 && $coordinates['longitude'] > 0 && $coordinates['latitude'] > 0) {
                    $updateArray = [
                        'objekt_laengengrad' => $coordinates['longitude'],
                        'objekt_breitengrad' => $coordinates['latitude']
                    ];
                    $connection->update(
                        'tx_sgestatecore_domain_model_immobilie',
                        $updateArray,
                        ['uid' => $row['uid']]
                    );
                }
            }
        }

        $logFilename = Environment::getVarPath() . '/log/sg_estate_core_geocode.log';
        // keep log file smaller than 10mb
        if (file_exists($logFilename) && filesize($logFilename) > 10485760) {
            $logFileHandle = fopen($logFilename, 'w');
        } else {
            $logFileHandle = fopen($logFilename, 'a');
        }
        fwrite($logFileHandle, implode("\n", $log));
        fclose($logFileHandle);
    }

    private function geocodeAddress($country, $city, $zip, $street, $housenumber, $objectNumber, &$log)
    {
        $logDate = date('Y-m-d H:i:s', time()) . ' ';

        $configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        $configuration = $configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $backendConfiguration = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(ExtensionConfiguration::class)->get('sg_estate_core');
        $settings = $configuration['module.']['tx_sgestatecore.']['settings.'];
        if ($country == '') {
            $country = $this->standardCountry;
        }
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_geocode_cache');
        $result = $queryBuilder
            ->select('longitude', 'latitude')
            ->from('tx_sgestatecore_geocode_cache')
            ->where($queryBuilder->expr()->eq('zip', $queryBuilder->createNamedParameter($zip)))
            ->andWhere($queryBuilder->expr()->eq('street', $queryBuilder->createNamedParameter($street)))
            ->andWhere($queryBuilder->expr()->eq('housenumber', $queryBuilder->createNamedParameter($housenumber)))
            ->andWhere($queryBuilder->expr()->eq('country', $queryBuilder->createNamedParameter($country)))
            ->execute();
        if ($result->rowCount() > 0) {
            $resultItem = $result->fetch(FetchMode::ASSOCIATIVE);
            $coordinates['longitude'] = $resultItem['longitude'];
            $coordinates['latitude'] = $resultItem['latitude'];

            $log[] = $logDate . 'object "' . $objectNumber . '": found coordinates for ' . $zip . ', ' . $street . ', ' . $housenumber . ', ' . $country . ' in cache: ' . implode(', ', $coordinates);

            return $coordinates;
        }

        $coordinates = null;
        $address =
            $this->convertMutation($country) . ', ' . $zip . ' ' .
            $this->convertMutation($city) . ', ' .
            $this->convertMutation($street) . ' ' .
            $housenumber;

        $delay = 0;
        $base_url = 'https://maps.googleapis.com/maps/api/geocode/xml';

        $geocode_pending = true;

        $apikey = $backendConfiguration['geocodingApiKey'] != '' ? $backendConfiguration['geocodingApiKey'] : $settings['keys.']['googleapi'];

        while ($geocode_pending) {
            $request_url = $base_url . '?address=' . urlencode($address) . '&key=' . $apikey;
            $xml = simplexml_load_file($request_url) or die('url not loading'); // @todo: Throw Error ??
            $status = $xml->status;

            if (strcmp($status, 'OK') == 0) {
                // Successful geocode
                $geocode_pending = false;
                $coordinates = [
                    'latitude' => floatval($xml->result->geometry->location->lat),
                    'longitude' => floatval($xml->result->geometry->location->lng)
                ];
                $insertData = [
                    'zip'           => $zip,
                    'street'        => $street,
                    'housenumber'   => $housenumber,
                    'country'       => $country,
                    'longitude'     => floatval($xml->result->geometry->location->lng),
                    'latitude'      => floatval($xml->result->geometry->location->lat),
                ];

                $log[] = $logDate . 'object "' . $objectNumber . '": geocoded: ' . implode(', ', $insertData);

                $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_geocode_cache');
                $connection->insert(
                    'tx_sgestatecore_geocode_cache',
                    $insertData
                );
            } elseif (strcmp($status, 'OVER_QUERY_LIMIT') == 0) {
                // sent geocodes too fast
                $delay += 100000;

                $log[] = $logDate . '[WARNING] received over query limit... wait for ' . $delay . ' microseconds...';
            } else {

                // failure to geocode
                $geocode_pending = false;
                $log[] = $logDate . '[ERROR] object "' . $objectNumber . '": could not geocode: ' . $zip . ', ' . $street . ', ' . $housenumber . ', ' . $country;
            }
            usleep($delay);
        }
        return $coordinates;
    }

    /**
     * @param array $recipients
     * @param $sender
     * @param $subject
     * @param $templateName
     * @param array $bcc
     * @param array $variables
     * @param array $attachments
     *  [
     *      0 => [
     *          'type' => 'fromPath',
     *          'path' => '/path/to/attachment'
     *          'filename' => 'filenameInEmail.txt'
     *          ],
     *      1 => [
     *          'type' => 'content',
     *          'content' => 'iamthecontent'
     *          'filename' => 'filenameInEmail.txt'
     *          ]
     *  ]
     *
     * @param string $format
     * @return bool
     * @throws \Symfony\Component\Mailer\Exception\TransportExceptionInterface
     */
    public function sendTemplateEmail(array $recipients, $sender, $subject, $templateName, array $bcc = [], array $variables = [], array $attachments = [], $format = 'html')
    {
        $message = GeneralUtility::makeInstance(FluidEmail::class);

        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)) {
            $message->from($sender);
        } else {
            return false;
        }

        // Add Recipients
        $recipients = array_filter($recipients);
        if (count($recipients) > 0) {
            foreach ($recipients as $email) {
                if (GeneralUtility::validEmail($email)) {
                    $message->addTo($email);
                }
            }
        } else {
            return false;
        }

        if (count($bcc) > 0) {
            foreach ($bcc as $email) {
                if (GeneralUtility::validEmail($email)) {
                    $message->addBcc($email);
                }
            }
        }

        if ($subject != '') {
            $message->subject($subject);
        } else {
            return false;
        }

        // text/plain and text/html is legacy format from
        // constant editor sg_estate_base pre 10.11.2
        // may be removed in 11.0.0
        if (in_array($format, ['text', 'text/plain'])) {
            $message->format('plain');
        } elseif (in_array($format, ['html', 'text/html'])) {
            $message->format('html');
        }

        $message->assignMultiple($variables);
        $message->setTemplate($templateName . '.' . $format);

        foreach ($attachments as $attachment) {
            switch ($attachment['type']) {
                case 'fromPath':
                    $message->attachFromPath($attachment['path'], $attachment['filename']);
                    break;
                case 'content':
                    $message->attach($attachment['content'], $attachment['filename']);
                    break;
            }
        }

        GeneralUtility::makeInstance(Mailer::class)->send($message);
        return true;
    }

    public function countRealties()
    {

        // reset
        $connection = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_ort');
        $connection->update('tx_sgestatecore_domain_model_ort')->set('anzahl_immobilien', null)->execute();

        $connection = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_stadtteil');
        $connection->update('tx_sgestatecore_domain_model_stadtteil')->set('anzahl_immobilien', null)->execute();
        // eof reset

        $countsCities = [];
        $countsDistricts = [];

        $queryBuilderCities = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $queryBuilderCities
            ->select(
                'tx_sgestatecore_domain_model_immobilie.uid',
                'city.uid as city',
                'objektart.kuerzel as objektartkuerzel'
            )
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_ort', 'city', $queryBuilderCities->expr()->eq('city.uid', $queryBuilderCities->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_ort')))
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_objektart', 'objektart', $queryBuilderCities->expr()->eq('objektart.uid', $queryBuilderCities->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objektart')))
            ->where($queryBuilderCities->expr()->eq('tx_sgestatecore_domain_model_immobilie.deleted', $queryBuilderCities->createNamedParameter(0)))
            ->andWhere($queryBuilderCities->expr()->eq('tx_sgestatecore_domain_model_immobilie.hidden', $queryBuilderCities->createNamedParameter(0)))
        ;

        $resultCities = $queryBuilderCities->execute();
        if ($resultCities->rowCount() > 0) {
            $rows = $resultCities->fetchAll(FetchMode::ASSOCIATIVE);

            foreach ($rows as $row) {
                if (isset($countsCities[$row['city']][$row['objektartkuerzel']])) {
                    $countsCities[$row['city']][$row['objektartkuerzel']]++;
                } else {
                    $countsCities[$row['city']][$row['objektartkuerzel']] = 1;
                }

                if (isset($countsCities[$row['city']]['_GESAMT'])) {
                    $countsCities[$row['city']]['_GESAMT']++;
                } else {
                    $countsCities[$row['city']]['_GESAMT'] = 1;
                }
            }
        }

        $queryBuilderDistricts = $this->connectionPool->getQueryBuilderForTable('tx_sgestatecore_domain_model_immobilie');
        $queryBuilderDistricts
            ->select(
                'tx_sgestatecore_domain_model_immobilie.uid',
                'district.uid as district',
                'objektart.kuerzel as objektartkuerzel'
            )
            ->from('tx_sgestatecore_domain_model_immobilie')
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_stadtteil', 'district', $queryBuilderDistricts->expr()->eq('district.uid', $queryBuilderDistricts->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objekt_stadtteil')))
            ->leftJoin('tx_sgestatecore_domain_model_immobilie', 'tx_sgestatecore_domain_model_objektart', 'objektart', $queryBuilderDistricts->expr()->eq('objektart.uid', $queryBuilderDistricts->quoteIdentifier('tx_sgestatecore_domain_model_immobilie.objektart')))
            ->where($queryBuilderDistricts->expr()->eq('tx_sgestatecore_domain_model_immobilie.deleted', $queryBuilderDistricts->createNamedParameter(0)))
            ->andWhere($queryBuilderDistricts->expr()->eq('tx_sgestatecore_domain_model_immobilie.hidden', $queryBuilderDistricts->createNamedParameter(0)))
        ;

        $resultDistricts = $queryBuilderDistricts->execute();
        if ($resultDistricts->rowCount() > 0) {
            $rows = $resultDistricts->fetchAll(FetchMode::ASSOCIATIVE);
            foreach ($rows as $row) {
                if (isset($countsDistricts[$row['district']][$row['objektartkuerzel']])) {
                    $countsDistricts[$row['district']][$row['objektartkuerzel']]++;
                } else {
                    $countsDistricts[$row['district']][$row['objektartkuerzel']] = 1;
                }
                if (isset($countsDistricts[$row['district']]['_GESAMT'])) {
                    $countsDistricts[$row['district']]['_GESAMT']++;
                } else {
                    $countsDistricts[$row['district']]['_GESAMT'] = 1;
                }
            }
        }

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_ort');
        foreach ($countsCities as $cityUid => $countsCity) {
            $updateArray = [
                'anzahl_immobilien' => json_encode($countsCity)
            ];
            $connection->update(
                'tx_sgestatecore_domain_model_ort',
                $updateArray,
                ['uid' => $cityUid]
            );
        }

        $connection = $this->connectionPool->getConnectionForTable('tx_sgestatecore_domain_model_stadtteil');
        foreach ($countsDistricts as $districtUid => $countsDistrict) {
            $updateArray = [
                'anzahl_immobilien' => json_encode($countsDistrict)
            ];
            $connection->update(
                'tx_sgestatecore_domain_model_stadtteil',
                $updateArray,
                ['uid' => $districtUid]
            );
        }
        return true;
    }

    /**
     * @param $value
     * @return mixed
     */
    private function convertMutation($value)
    {
        $value = str_replace('ü', 'ue', $value);
        $value = str_replace('Ü', 'Ue', $value);
        $value = str_replace('ö', 'oe', $value);
        $value = str_replace('Ö', 'Oe', $value);
        $value = str_replace('ä', 'ae', $value);
        $value = str_replace('Ä', 'Ae', $value);
        $value = str_replace('ß', 'ss', $value);
        return $value;
    }
}
