<?php
namespace SG\SgEstateCore\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Extbase\Service\ImageService;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RealtiesArrayToPlacesJsonViewHelper extends AbstractViewHelper
{
    /**
     * @var ImageService
     */
    protected $imageService;

    /**
     * @param ImageService $imageService
     */
    public function injectImageService(ImageService $imageService){
        $this->imageService = $imageService;
    }

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    /**
     * @param UriBuilder $uriBuilder
     */
    public function injectUriBuilder(UriBuilder $uriBuilder){
        $this->uriBuilder = $uriBuilder;
    }

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('realties', 'array', 'Array of Realties');
        $this->registerArgument('settings', 'array', 'Settings');
        $this->registerArgument('overrideDetailPid', 'int', 'Override Detail PID');
    }

    public function render(){
        $arrayToReturn = [];
        $processingInstructions = array(
            'width' => '150c',
            'height' => '112c',
        );
        foreach ($this->arguments['realties'] as $realty){
            /**
             * @var $realty Immobilie
             */

            $image = $this->imageService->getImage(Environment::getPublicPath().'/uploads/tx_sgestatecore/media/'.$realty->getTitelbild()->getDatei(),null,false);
            $processedImage = $this->imageService->applyProcessingInstructions($image, $processingInstructions);
            $district = array();
            if( $realty->getObjektStadtteil() instanceof Stadtteil )
            {
                $district = array(
                    'id' => $realty->getObjektStadtteil()->getUid(),
                    'name' => $realty->getObjektStadtteil()->getBezeichner()
                );
            }
            $arrayToReturn[] = [
                'show' => true,
                'highlighted' => false,
                'id' => $realty->getUid(),
                'type' => $realty->getObjektart()->getKuerzel(),
                'arttype' => $realty->getObjektarttyp()->getBezeichner(),
                'data' => [
                    'objectNumberInternal' => $realty->getObjektnrIntern(),
                    'objectNumberExternal' => $realty->getObjektnrExtern(),
                    'openimmoObjid' => $realty->getOpenimmoObjid(),
                    'title' => $realty->getObjekttitel(),
                    'street' => $realty->getObjektStrasse(),
                    'houseNumber' => $realty->getObjektHausnummer(),
                    'zip' => $realty->getObjektPlz(),
                    'size' => $realty->getWohnflaeche(),
                    'rooms' => $realty->getAnzahlZimmer(),
                    'rent' => $realty->getNettokaltmiete(),
                    'balcony' => $realty->getAnzahlBalkone() > 0 ? true : false,
                    'city' => array(
                        'id' => $realty->getObjektOrt()->getUid(),
                        'name' => $realty->getObjektOrt()->getBezeichner()
                    ),
                    'district' => $district,
                    'url' => $this->uriBuilder->reset()->setTargetPageUid((isset($this->arguments['overrideDetailPid']) && $this->arguments['overrideDetailPid'] > 0) ? $this->arguments['overrideDetailPid'] : $this->arguments['settings']['pid']['detail'])->uriFor('detail', ['realty' => $realty->getUrlIdentifier()], 'Base', 'sgestatebase', 'pi1'),
                ],
                'media' => [
                    'preview' => $this->imageService->getImageUri($processedImage)
                ],
                'geometry' => [
                    'location' => [
                        'lat' => $realty->getObjektBreitengrad(),
                        'lng' => $realty->getObjektLaengengrad()
                    ]
                ],
                'parking' => [
                    'wallbox' => [
                        'is' => rand(0, 1),
                        'can' => rand(0, 1)
                    ],
                    'lock' => rand(0, 1)
                ],
            ];
        }

        return json_encode($arrayToReturn);
    }
}