<?php
namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;

/**
 * Ort
 */
class Ort extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity {

    /**
     * bezeichner
     *
     * @var string
     */
    protected $bezeichner = '';

    /**
     * anzahlImmobilien
     *
     * @var string
     */
    protected $anzahlImmobilien = '';

    /**
     * fuerSucheVerwenden
     *
     * @var boolean
     */
    protected $fuerSucheVerwenden = FALSE;

    /**
     * stadtteile
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil>
     * @Cascade("remove")
     */
    protected $stadtteile = NULL;

    /**
     * __construct
     */
    public function __construct() {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects() {
        $this->stadtteile = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the bezeichner
     *
     * @return string $bezeichner
     */
    public function getBezeichner() {
        return $this->bezeichner;
    }

    /**
     * Sets the bezeichner
     *
     * @param string $bezeichner
     * @return void
     */
    public function setBezeichner($bezeichner) {
        $this->bezeichner = $bezeichner;
    }

    /**
     * Returns the anzahlImmobilien
     *
     * @return string $anzahlImmobilien
     */
    public function getAnzahlImmobilien() {
        return $this->anzahlImmobilien;
    }

    /**
     * @return mixed
     */
    public function getAnzahlImmobilienArray() {
        return json_decode($this->anzahlImmobilien, true);
    }

    /**
     * Sets the anzahlImmobilien
     *
     * @param string $anzahlImmobilien
     * @return void
     */
    public function setAnzahlImmobilien($anzahlImmobilien) {
        $this->anzahlImmobilien = $anzahlImmobilien;
    }

    /**
     * Returns the fuerSucheVerwenden
     *
     * @return boolean $fuerSucheVerwenden
     */
    public function getFuerSucheVerwenden() {
        return $this->fuerSucheVerwenden;
    }

    /**
     * Sets the fuerSucheVerwenden
     *
     * @param boolean $fuerSucheVerwenden
     * @return void
     */
    public function setFuerSucheVerwenden($fuerSucheVerwenden) {
        $this->fuerSucheVerwenden = $fuerSucheVerwenden;
    }

    /**
     * Returns the boolean state of fuerSucheVerwenden
     *
     * @return boolean
     */
    public function isFuerSucheVerwenden() {
        return $this->fuerSucheVerwenden;
    }

    /**
     * Adds a Stadtteil
     *
     * @param \SG\SgEstateCore\Domain\Model\Stadtteil $stadtteile
     * @return void
     */
    public function addStadtteile(\SG\SgEstateCore\Domain\Model\Stadtteil $stadtteile) {
        $this->stadtteile->attach($stadtteile);
    }

    /**
     * Removes a Stadtteil
     *
     * @param \SG\SgEstateCore\Domain\Model\Stadtteil $stadtteileToRemove The Stadtteil to be removed
     * @return void
     */
    public function removeStadtteile(\SG\SgEstateCore\Domain\Model\Stadtteil $stadtteileToRemove) {
        $this->stadtteile->detach($stadtteileToRemove);
    }

    /**
     * Returns the stadtteile
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil> $stadtteile
     */
    public function getStadtteile() {
        return $this->stadtteile;
    }

    /**
     * Sets the stadtteile
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil> $stadtteile
     * @return void
     */
    public function setStadtteile(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $stadtteile) {
        $this->stadtteile = $stadtteile;
    }

    public function getDto(): array
    {
        return [
            'name' => $this->getBezeichner(),
        ];
    }

}