<?php

declare(strict_types = 1);
namespace SG\SgEstateCore\Api\Estate;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use SG\SgEstateCore\Domain\Model\Kampagne;
use SG\SgEstateCore\Domain\Repository\KampagneRepository;
use TYPO3\CMS\Core\Http\Response;
use TYPO3\CMS\Core\Http\Stream;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;

class Campaign implements MiddlewareInterface
{
    /**
     * @var KampagneRepository
     */
    private $kampagneRepository;

    public function __construct()
    {
        $objectManager = GeneralUtility::makeInstance(ObjectManager::class);
        $this->kampagneRepository = $objectManager->get(KampagneRepository::class);
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $normalizedParams = $request->getAttribute('normalizedParams');
        $uri = $normalizedParams->getRequestUri();

        if (strpos($uri, '/api/') !== false && strpos($uri, '/estate/campaigns') !== false) {
            $body = new Stream('php://temp', 'rw');
            $body->write(json_encode($this->getCampaigns(), JSON_UNESCAPED_UNICODE));

            return (new Response())
                ->withHeader('content-type', 'application/json')
                ->withBody($body)
                ->withStatus(200);
        }

        return $handler->handle($request);
    }

    /**
     * @return array
     */
    private function getCampaigns(): array
    {
        $campaigns = $this->kampagneRepository->findAll();

        /** @var Kampagne $campaign */
        foreach ($campaigns as $campaign) {
            $json[] = $campaign->getDto();
        }

        return $json ?? [];
    }
}
