<?php
namespace SG\SgEstateCore\Controller;

use SG\SgEstateCore\Domain\Repository\AltertypRepository;
use SG\SgEstateCore\Domain\Repository\AnhangtypRepository;
use SG\SgEstateCore\Domain\Repository\AusbaustufeRepository;
use SG\SgEstateCore\Domain\Repository\AusblickRepository;
use SG\SgEstateCore\Domain\Repository\AustattungskategorieRepository;
use SG\SgEstateCore\Domain\Repository\BadausstattungRepository;
use SG\SgEstateCore\Domain\Repository\BauweiseRepository;
use SG\SgEstateCore\Domain\Repository\BebaubarnachRepository;
use SG\SgEstateCore\Domain\Repository\BefeuerungsartRepository;
use SG\SgEstateCore\Domain\Repository\BodenbelagRepository;
use SG\SgEstateCore\Domain\Repository\DachformRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassartRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassgebaeudeartRepository;
use SG\SgEstateCore\Domain\Repository\EnergiepassjahrgangRepository;
use SG\SgEstateCore\Domain\Repository\EnergietypRepository;
use SG\SgEstateCore\Domain\Repository\ErschliessungdetailsRepository;
use SG\SgEstateCore\Domain\Repository\ErschliessungRepository;
use SG\SgEstateCore\Domain\Repository\GeschlechtRepository;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\HimmelrichtungRepository;
use SG\SgEstateCore\Domain\Repository\ImmobilieRepository;
use SG\SgEstateCore\Domain\Repository\KuechenausstattungRepository;
use SG\SgEstateCore\Domain\Repository\LageRepository;
use SG\SgEstateCore\Domain\Repository\LandRepository;
use SG\SgEstateCore\Domain\Repository\NutzungsartRepository;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\PeriodeRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use SG\SgEstateCore\Domain\Repository\VerkaufstatusRepository;
use SG\SgEstateCore\Domain\Repository\VermarktungsartRepository;
use SG\SgEstateCore\Domain\Repository\WaehrungRepository;
use SG\SgEstateCore\Domain\Repository\ZustandRepository;
use SG\SgEstateCore\Util\Services;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class ManagementController extends ActionController
{

    /**
     * @var AltertypRepository
     */
    protected $altertypRepository;

    /**
     * @param AltertypRepository $altertypRepository
     */
    public function injectAltertypRepository(AltertypRepository $altertypRepository)
    {
        $this->altertypRepository = $altertypRepository;
    }

    /**
     * @var AnhangtypRepository
     */
    protected $anhangtypRepository;

    /**
     * @param AnhangtypRepository $anhangtypRepository
     */
    public function injectAnhangtypRepository(AnhangtypRepository $anhangtypRepository)
    {
        $this->anhangtypRepository = $anhangtypRepository;
    }

    /**
     * @var AusbaustufeRepository
     */
    protected $ausbaustufeRepository;

    /**
     * @param AusbaustufeRepository $ausbaustufeRepository
     */
    public function injectAusbaustufeRepository(AusbaustufeRepository $ausbaustufeRepository)
    {
        $this->ausbaustufeRepository = $ausbaustufeRepository;
    }

    /**
     * @var AusblickRepository
     */
    protected $ausblickRepository;

    /**
     * @param AusblickRepository $ausblickRepository
     */
    public function injectAusblickRepository(AusblickRepository $ausblickRepository)
    {
        $this->ausblickRepository = $ausblickRepository;
    }

    /**
     * @var \SG\SgEstateCore\Domain\Repository\AustattungskategorieRepository
     */
    protected $austattungskategorieRepository;

    /**
     * @param AustattungskategorieRepository $austattungskategorieRepository
     */
    public function injectAustattungskategorieRepository(AustattungskategorieRepository $austattungskategorieRepository)
    {
        $this->austattungskategorieRepository = $austattungskategorieRepository;
    }

    /**
     * @var BadausstattungRepository
     */
    protected $badausstattungRepository = null;

    /**
     * @param BadausstattungRepository $badausstattungRepository
     */
    public function injectBadausstattungRepository(BadausstattungRepository $badausstattungRepository)
    {
        $this->badausstattungRepository = $badausstattungRepository;
    }

    /**
     * @var BauweiseRepository
     */
    protected $bauweiseRepository;

    /**
     * @param BauweiseRepository $bauweiseRepository
     */
    public function injectBausweiseRepository(BauweiseRepository $bauweiseRepository)
    {
        $this->bauweiseRepository = $bauweiseRepository;
    }

    /**
     * @var BebaubarnachRepository
     */
    protected $bebaubarnachRepository;

    /**
     * @param BebaubarnachRepository $bebaubarnachRepository
     */
    public function injectBebaubarnachRepository(BebaubarnachRepository $bebaubarnachRepository)
    {
        $this->bebaubarnachRepository = $bebaubarnachRepository;
    }

    /**
     * @var BefeuerungsartRepository
     */
    protected $befeuerungsartRepository;

    public function injectBefeuerungsartRepository(BefeuerungsartRepository $befeuerungsartRepository)
    {
        $this->befeuerungsartRepository = $befeuerungsartRepository;
    }

    /**
     * @var BodenbelagRepository
     */
    protected $bodenbelagRepository;

    /**
     * @param BodenbelagRepository $bodenbelagRepository
     */
    public function injectBodenbelagRepository(BodenbelagRepository $bodenbelagRepository)
    {
        $this->bodenbelagRepository = $bodenbelagRepository;
    }

    /**
     * @var DachformRepository
     */
    protected $dachformRepository;

    /**
     * @param DachformRepository $dachformRepository
     */
    public function injectDachformRepository(DachformRepository $dachformRepository)
    {
        $this->dachformRepository = $dachformRepository;
    }

    /**
     * @var EnergiepassartRepository
     */
    protected $energiepassartRepository;

    /**
     * @param EnergiepassartRepository $energiepassartRepository
     */
    public function injectEnergiepassartRepository(EnergiepassartRepository $energiepassartRepository)
    {
        $this->energiepassartRepository = $energiepassartRepository;
    }

    /**
     * @var EnergiepassjahrgangRepository
     */
    protected $energiepassjahrgangRepository;

    /**
     * @param EnergiepassjahrgangRepository $energiepassjahrgangRepository
     */
    public function injectEnergiepassjahrgangRepository(EnergiepassjahrgangRepository $energiepassjahrgangRepository)
    {
        $this->energiepassjahrgangRepository = $energiepassjahrgangRepository;
    }

    /**
     * @var EnergiepassgebaeudeartRepository
     */
    protected $energiepassgebaeudeartRepository;

    /**
     * @param EnergiepassgebaeudeartRepository $energiepassgebaeudeartRepository
     */
    public function injectEnergiepassgebaeudeartRepository(EnergiepassgebaeudeartRepository $energiepassgebaeudeartRepository)
    {
        $this->energiepassgebaeudeartRepository = $energiepassgebaeudeartRepository;
    }

    /**
     * @var EnergietypRepository
     */
    protected $energietypRepository;

    /**
     * @param EnergietypRepository $energietypRepository
     */
    public function injectEnergietypRepository(EnergietypRepository $energietypRepository)
    {
        $this->energietypRepository = $energietypRepository;
    }

    /**
     * @var ErschliessungRepository
     */
    protected $erschliessungRepository;

    /**
     * @param ErschliessungRepository $erschliessungRepository
     */
    public function injectErschliessungRepository(ErschliessungRepository $erschliessungRepository)
    {
        $this->erschliessungRepository = $erschliessungRepository;
    }

    /**
     * @var ErschliessungdetailsRepository
     */
    protected $erschliessungdetailsRepository;

    /**
     * @param ErschliessungdetailsRepository $erschliessungdetailsRepository
     */
    public function injectErschliessungdetailsRepository(ErschliessungdetailsRepository $erschliessungdetailsRepository)
    {
        $this->erschliessungdetailsRepository = $erschliessungdetailsRepository;
    }

    /**
     * @var GeschlechtRepository
     */
    protected $geschlechtRepository;

    /**
     * @param GeschlechtRepository $geschlechtRepository
     */
    public function injectGeschlechtRepository(GeschlechtRepository $geschlechtRepository)
    {
        $this->geschlechtRepository = $geschlechtRepository;
    }

    /**
     * @var HeizungsartRepository
     */
    protected $heizungsartRepository;

    /**
     * @param HeizungsartRepository $heizungsartRepository
     */
    public function injectHeizungsartRepository(HeizungsartRepository $heizungsartRepository)
    {
        $this->heizungsartRepository = $heizungsartRepository;
    }

    /**
     * @var HimmelrichtungRepository
     */
    protected $himmelrichtungRepository;

    /**
     * @param HimmelrichtungRepository $himmelrichtungRepository
     */
    public function injectHimmelrichtungRepository(HimmelrichtungRepository $himmelrichtungRepository)
    {
        $this->himmelrichtungRepository = $himmelrichtungRepository;
    }

    /**
     * @var KuechenausstattungRepository
     */
    protected $kuechenausstattungRepository;

    /**
     * @param KuechenausstattungRepository $kuechenausstattungRepository
     */
    public function injectKuechenausstattungRepository(KuechenausstattungRepository $kuechenausstattungRepository)
    {
        $this->kuechenausstattungRepository = $kuechenausstattungRepository;
    }

    /**
     * @var LageRepository
     */
    protected $lageRepository;

    /**
     * @param LageRepository $lageRepository
     */
    public function injectLageRepository(LageRepository $lageRepository)
    {
        $this->lageRepository = $lageRepository;
    }

    /**
     * @var LandRepository
     */
    protected $landRepository;

    /**
     * @param LandRepository $landRepository
     */
    public function injectLandRepository(LandRepository $landRepository)
    {
        $this->landRepository = $landRepository;
    }

    /**
     * @var NutzungsartRepository
     */
    protected $nutzungsartRepository;

    /**
     * @param NutzungsartRepository $nutzungsartRepository
     */
    public function injectNutzungsartRepository(NutzungsartRepository $nutzungsartRepository)
    {
        $this->nutzungsartRepository = $nutzungsartRepository;
    }

    /**
     * @var ObjektartRepository
     */
    protected $objektartRepository;

    /**
     * @param ObjektartRepository $objektartRepository
     */
    public function injectObjektartRepository(ObjektartRepository $objektartRepository)
    {
        $this->objektartRepository = $objektartRepository;
    }

    /**
     * @var PeriodeRepository
     */
    protected $periodeRepository;

    /**
     * @param PeriodeRepository $periodeRepository
     */
    public function injectPeriodeRepository(PeriodeRepository $periodeRepository)
    {
        $this->periodeRepository = $periodeRepository;
    }

    /**
     * @var VerkaufstatusRepository
     */
    protected $verkaufstatusRepository;

    /**
     * @param VerkaufstatusRepository $verkaufstatusRepository
     */
    public function injectVerkaufstatusRepository(VerkaufstatusRepository $verkaufstatusRepository)
    {
        $this->verkaufstatusRepository = $verkaufstatusRepository;
    }

    /**
     * @var VermarktungsartRepository
     */
    protected $vermarktungsartRepository;

    /**
     * @param VermarktungsartRepository $vermarktungsartRepository
     */
    public function injectVermarktungsartRepository(VermarktungsartRepository $vermarktungsartRepository)
    {
        $this->vermarktungsartRepository = $vermarktungsartRepository;
    }

    /**
     * @var WaehrungRepository
     */
    protected $waehrungRepository;

    /**
     * @param WaehrungRepository $waehrungRepository
     */
    public function injectWaehrungRepository(WaehrungRepository $waehrungRepository)
    {
        $this->waehrungRepository = $waehrungRepository;
    }

    /**
     * @var ZustandRepository
     */
    protected $zustandRepository;

    /**
     * @param ZustandRepository $zustandRepository
     */
    public function injectZustandRepository(ZustandRepository $zustandRepository)
    {
        $this->zustandRepository = $zustandRepository;
    }

    /**
     * @var ImmobilieRepository
     */
    protected $immobilieRepository;

    /**
     * @param ImmobilieRepository $immobilieRepository
     */
    public function injectImmobilieRepository(ImmobilieRepository $immobilieRepository)
    {
        $this->immobilieRepository = $immobilieRepository;
    }

    /**
     * @var OrtRepository
     */
    protected $ortRepository;

    /**
     * @param OrtRepository $ortRepository
     */
    public function injectOrtRepository(OrtRepository $ortRepository)
    {
        $this->ortRepository = $ortRepository;
    }

    /**
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * @param RegionRepository $regionRepository
     */
    public function injectRegionRepository(RegionRepository $regionRepository)
    {
        $this->regionRepository = $regionRepository;
    }

    public function indexAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
    }

    public function listAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $this->view->assign('realties', $this->immobilieRepository->findAll());
    }

    public function placesAction()
    {
        $this->view->assignMultiple([
            'regions' => $this->regionRepository->findAll(),
            'cities' => $this->ortRepository->findAll(),
        ]);
    }

    public function importstandardsAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        if ($this->request->hasArgument('doimport')) {
            //$resetData = ($this->request->hasArgument('resetData')&&$this->request->getArgument('resetData')==1) ? true : false;
            $resetData = true;

            $this->importAltertyp($resetData);
            $this->importAnhangtyp($resetData);
            $this->importAusbaustufe($resetData);
            $this->importAusblick($resetData);
            $this->importAusstattungskategorie($resetData);
            $this->importBadausstattung($resetData);
            $this->importBauweise($resetData);
            $this->importBebaubarnach($resetData);
            $this->importBefeuerungsart($resetData);
            $this->importBodenbelag($resetData);
            $this->importDachform($resetData);
            $this->importEnergiepassart($resetData);
            $this->importEnergiepassjahrgang($resetData);
            $this->importEnergiepassgebaeudeart($resetData);
            $this->importEnergietyp($resetData);
            $this->importErschliessung($resetData);
            $this->importErschliessungdetails($resetData);
            $this->importGeschlecht($resetData);
            $this->importHeizungsart($resetData);
            $this->importHimmelrichtung($resetData);
            $this->importKuechenausstattung($resetData);
            $this->importLage($resetData);
            $this->importLand($resetData);
            $this->importNutzungsart($resetData);
            $this->importObjektart($resetData);
            $this->importPeriode($resetData);
            $this->importVerkaufstatus($resetData);
            $this->importVermarktungsart($resetData);
            $this->importWaehrung($resetData);
            $this->importZustand($resetData);
        }
    }

    public function maintenanceAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        /**
         * @var $sgCoreServices \SG\SgEstateCore\Util\Services
         */
        if ($this->request->hasArgument('activity')) {
            switch ($this->request->getArgument('activity')) {
                case 'delete':
                    if ($this->request->hasArgument('object')) {
                        switch ($this->request->getArgument('object')) {
                            case 'realties':
                                if ($this->request->hasArgument('type')) {
                                    $sgCoreServices = $this->objectManager->get('SG\SgEstateCore\Util\Services');
                                    if ($this->request->getArgument('type') == 'all') {
                                        $sgCoreServices->deleteAllRealties();
                                        $this->view->assign('state', 'delete_object_all_success');
                                    } elseif ($this->request->getArgument('type') == 'updatable') {
                                        $sgCoreServices->deleteAllUpdatableRealties();
                                        $this->view->assign('state', 'delete_object_updatable_success');
                                    } elseif ($this->request->getArgument('type') == 'importNumber') {
                                        $importNumber = $this->request->getArgument('importNumber');
                                        if (is_numeric($importNumber)) {
                                            $sgCoreServices->deleteAllUpdatableRealties($importNumber);
                                            $this->view->assign('state', 'delete_object_importnumber_success');
                                        } else {
                                            $this->view->assign('state', 'delete_object_importnumber_failure');
                                        }
                                    }
                                }
                                break;
                            default:
                                break;
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    }

    public function cacheAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        /**
         * @var $cache FrontendInterface
         */
        if ($this->request->hasArgument('activity')) {
            $cache = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class)->getCache('sgestate_cache');
            switch ($this->request->getArgument('activity')) {
                case 'flush_cache':
                    $cache->flush();
                    $this->view->assign('state', 'flush_cache_done');
                    break;
                case 'collect_garbage':
                    $cache->collectGarbage();
                    $this->view->assign('state', 'collect_garbage_done');
                    break;
                default:
                    break;
            }
        }
    }

    public function systemInfoAction()
    {
        $this->view->assign('realtiesCount', $this->immobilieRepository->countAll());
        $this->view->assign('installedModules', $this->getInstalledEstateModules());
    }

    public function logAction()
    {
    }

    public function logGeocodeAction()
    {
        $logFilename = Environment::getVarPath() . '/log/sg_estate_core_geocode.log';
        $logLines = [];
        if (file_exists($logFilename)) {
            $logLines = $this->fileGetTail($logFilename, 1000);
        }
        $this->view->assignMultiple([
            'filename' => $logFilename,
            'log' => $logLines,
        ]);
    }

    public function fileGetTail($filename, $num_lines = 10)
    {
        $file = fopen($filename, 'r');

        fseek($file, -1, SEEK_END);

        for ($line = 0, $lines = []; $line < $num_lines && false !== ($char = fgetc($file));) {
            if ($char === "\n") {
                if (isset($lines[$line])) {
                    $lines[$line][] = $char;
                    $lines[$line] = implode('', array_reverse($lines[$line]));
                    $line++;
                }
            } else {
                $lines[$line][] = $char;
            }
            fseek($file, -2, SEEK_CUR);
        }
        fclose($file);

        if ($line < $num_lines) {
            $lines[$line] = implode('', array_reverse($lines[$line]));
        }

        return array_reverse($lines);
    }

    /**
     * @return array
     */
    private function getInstalledEstateModules()
    {
        $installedModules = [];
        if (ExtensionManagementUtility::isLoaded('sg_estate_core')) {
            $installedModules[] = [
                'key' => 'sg_estate_core',
                'title' => 'sg.estate - Core Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_core')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_base')) {
            $installedModules[] = [
                'key' => 'sg_estate_base',
                'title' => 'sg.estate - Base Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_base')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_landingpage')) {
            $installedModules[] = [
                'key' => 'sg_estate_landingpage',
                'title' => 'sg.estate - Landingpage Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_landingpage')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_immosolve')) {
            $installedModules[] = [
                'key' => 'sg_estate_immosolve',
                'title' => 'sg.estate - Immosolve Modul',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_immosolve')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_csv')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_csv',
                'title' => 'sg.estate - CSV-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_csv')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_is24')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_is24',
                'title' => 'sg.estate - Immobilienscout24-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_is24')
            ];
        }
        if (ExtensionManagementUtility::isLoaded('sg_estate_import_openimmo')) {
            $installedModules[] = [
                'key' => 'sg_estate_import_openimmo',
                'title' => 'sg.estate - Openimmo-Import',
                'version' => ExtensionManagementUtility::getExtensionVersion('sg_estate_import_openimmo')
            ];
        }
        return $installedModules;
    }

    /**
     * @param bool $resetData
     */
    private function importAltertyp($resetData = false)
    {
        $importData = [
            'Altbau' => 'ALTBAU',
            'Neubau' => 'NEUBAU',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_altertyp');
            $connection->truncate('tx_sgestatecore_domain_model_altertyp');
        }
        if ($this->altertypRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Altertyp
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Altertyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->altertypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAnhangtyp($resetData = false)
    {
        $importData = [
            'Titelbild' => 'TITELBILD',
            'Innenansichten' => 'INNENANSICHTEN',
            'Aussenansichten' => 'AUSSENANSICHTEN',
            'Grundriss' => 'GRUNDRISS',
            'Karten Lageplan' => 'KARTEN_LAGEPLAN',
            'Anbieterlogo' => 'ANBIETERLOGO',
            'Bild' => 'BILD',
            'Dokumente' => 'DOKUMENTE',
            'Links' => 'LINKS',
            'Panorama' => 'PANORAMA',
            'QR-Code' => 'QRCODE',
            'Film' => 'FILM',
            'Filmlink' => 'FILMLINK',
            'Energieausweis' => 'EPASS-SKALA',
            'URL' => 'ANBOBJURL',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_anhangtyp');
            $connection->truncate('tx_sgestatecore_domain_model_anhangtyp');
        }
        if ($this->anhangtypRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Anhangtyp
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Anhangtyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->anhangtypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusbaustufe($resetData = false)
    {
        $importData = [
            'Bausatzhaus' => 'BAUSATZHAUS',
            'Ausbauhaus' => 'AUSBAUHAUS',
            'Schlüsselfertig mit Keller' => 'SCHLUESSELFERTIGMITKELLER',
            'Schlüsselfertig ohne Bodenplatte' => 'SCHLUESSELFERTIGOHNEBODENPLATTE',
            'Schlüsselfertig mit Bodenplatte' => 'SCHLUESSELFERTIGMITBODENPLATTE',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_ausbaustufe');
            $connection->truncate('tx_sgestatecore_domain_model_ausbaustufe');
        }
        if ($this->ausbaustufeRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Ausbaustufe
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Ausbaustufe');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausbaustufeRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusblick($resetData = false)
    {
        $importData = [
            'Ferne' => 'FERNE',
            'See' => 'SEE',
            'Berge' => 'BERGE',
            'Meer' => 'MEER',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_ausblick');
            $connection->truncate('tx_sgestatecore_domain_model_ausblick');
        }
        if ($this->ausblickRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Ausblick
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Ausblick');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->ausblickRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importAusstattungskategorie($resetData = false)
    {
        $importData = [
            'Keine Angabe' => 'KEINE_ANGABE',
            'Einfach' => 'EINFACH',
            'Standard' => 'STANDARD',
            'Gehoben' => 'GEHOBEN',
            'Luxus' => 'LUXUS'
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_austattungskategorie');
            $connection->truncate('tx_sgestatecore_domain_model_austattungskategorie');
        }
        if ($this->austattungskategorieRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Austattungskategorie
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Austattungskategorie');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->austattungskategorieRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBadausstattung($resetData = false)
    {
        $importData = [
            'Dusche' => 'DUSCHE',
            'Wanne' => 'WANNE',
            'Fenster' => 'FENSTER',
            'Bidet' => 'BIDET',
            'Pissoir' => 'PISSOIR',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_badausstattung');
            $connection->truncate('tx_sgestatecore_domain_model_badausstattung');
        }
        if ($this->badausstattungRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Badausstattung
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Badausstattung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->badausstattungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBauweise($resetData = false)
    {
        $importData = [
            'Massiv' => 'MASSIV',
            'Fertigteile' => 'FERTIGTEILE',
            'Holz' => 'HOLZ',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_bauweise');
            $connection->truncate('tx_sgestatecore_domain_model_bauweise');
        }
        if ($this->bauweiseRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bauweise
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bauweise');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bauweiseRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBebaubarnach($resetData = false)
    {
        $importData = [
            '34 Nachbarschaft' => '34_NACHBARSCHAFT',
            '35 Aussengebiet' => '35_AUSSENGEBIET',
            'Bebauungsplan' => 'B_PLAN',
            'Kein Bauland' => 'KEIN BAULAND',
            'Bauerwartungsland' => 'BAUERWARTUNGSLAND',
            'Länderspezifisch' => 'LAENDERSPEZIFISCH',
            'Bauland ohne Bebauungsplan' => 'BAULAND_OHNE_B_PLAN',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_bebaubarnach');
            $connection->truncate('tx_sgestatecore_domain_model_bebaubarnach');
        }
        if ($this->bebaubarnachRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bebaubarnach
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bebaubarnach');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bebaubarnachRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBefeuerungsart($resetData = false)
    {
        $importData = [
            'Öl' => 'OEL',
            'Gas' => 'GAS',
            'Strom' => 'STROM',
            'Alternativ' => 'ALTERNATIV',
            'Solar' => 'SOLAR',
            'Erdwärme' => 'ERDWAERME',
            'Luft-Wärmepumpe' => 'LUFTWP',
            'Fernwärme' => 'FERNWAERME',
            'Blockheizkraftwerk' => 'BLOCK',
            'Wasser Elektro' => 'WASSER-ELEKTRO',
            'Pellets' => 'PELLET',
            'Kohle' => 'KOHLE',
            'Erdgas leicht' => 'ERDGAS_LEICHT',
            'Erdgas schwer' => 'ERDGAS_SCHWER',
            'Flüssiggas' => 'FLUESSIGGAS',
            'Fernwärme Dampf' => 'FERNWAERME_DAMPF',
            'Holz' => 'HOLZ',
            'Holz-Hackschnitzel' => 'HOLZ-HACKSCHNITZEL',
            'Kohle/Koks' => 'KOHLE_KOKS',
            'Nahwärme' => 'NAHWÄRME',
            'Wärmelieferung' => 'WÄRMELIEFERUNG',
            'BIO Energie' => 'BIO_ENERGIE',
            'Windenergie' => 'WINDENERGIE',
            'Wasserenergie' => 'WASSERENERGIE',
            'Umweltwärme' => 'UMWELTWAERME',
            'KWK fossil' => 'KWK_FOSSIL',
            'KWK erneuerbar' => 'KWK_ERNEUERBAR',
            'KWK regenerativ' => 'KWK_REGENERATIV',
            'KWK bio' => 'KWK_BIO',
            'Keine Angabe' => 'KEIN_ANGABE'
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_befeuerungsart');
            $connection->truncate('tx_sgestatecore_domain_model_befeuerungsart');
        }
        if ($this->befeuerungsartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Befeuerungsart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Befeuerungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->befeuerungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importBodenbelag($resetData = false)
    {
        $importData = [
            'Fliesen' => 'FLIESEN',
            'Stein' => 'STEIN',
            'Teppich' => 'TEPPICH',
            'Parkett' => 'PARKETT',
            'Fertigparkett' => 'FERTIGPARKETT',
            'Laminat' => 'LAMINAT',
            'Dielen' => 'DIELEN',
            'Kunststoff' => 'KUNSTSTOFF',
            'Estrich' => 'ESTRICH',
            'Doppelboden' => 'DOPPELBODEN',
            'Linoleum' => 'LINOLEUM',
            'Marmor' => 'MARMOR',
            'Terrakotta' => 'TERRAKOTTA',
            'Granit' => 'GRANIT',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_bodenbelag');
            $connection->truncate('tx_sgestatecore_domain_model_bodenbelag');
        }
        if ($this->bodenbelagRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Bodenbelag
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Bodenbelag');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->bodenbelagRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importDachform($resetData = false)
    {
        $importData = [
            'Krüppelwalmdach' => 'KRUEPPELWALMDACH',
            'Mansarddach' => 'MANSARDDACH',
            'Pultdach' => 'PULTDACH',
            'Satteldach' => 'SATTELDACH',
            'Walmdach' => 'WALMDACH',
            'Flachdach' => 'FLACHDACH',
            'Pyramidendach' => 'PYRAMIDENDACH',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_dachform');
            $connection->truncate('tx_sgestatecore_domain_model_dachform');
        }
        if ($this->dachformRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Dachform
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Dachform');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->dachformRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassart($resetData = false)
    {
        $importData = [
            'Bedarfsausweis' => 'BEDARF',
            'Verbrauchsausweis' => 'VERBRAUCH',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_energiepassart');
            $connection->truncate('tx_sgestatecore_domain_model_energiepassart');
        }
        if ($this->energiepassartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassjahrgang($resetData = false)
    {
        $importData = [
            'Vor 2014' => '2008',
            'Ab 1.5.2014' => '2014',
            'es liegt kein E-pass vor' => 'OHNE',
            'nicht notwendig' => 'NICHT_NOETIG',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_energiepassjahrgang');
            $connection->truncate('tx_sgestatecore_domain_model_energiepassjahrgang');
        }
        if ($this->energiepassjahrgangRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassjahrgang
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassjahrgang');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->energiepassjahrgangRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergiepassgebaeudeart($resetData = false)
    {
        $importData = [
            'Wohnimmobilie' => 'WOHN',
            'Gewerbe und Mischformen' => 'NICHTWOHN',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_energiepassgebaeudeart');
            $connection->truncate('tx_sgestatecore_domain_model_energiepassgebaeudeart');
        }
        if ($this->energiepassgebaeudeartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energiepassgebaeudeart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energiepassgebaeudeartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importEnergietyp($resetData = false)
    {
        $importData = [
            'Passivhaus' => 'PASSIVHAUS',
            'Niedrigenergie' => 'NIEDRIGENERGIE',
            'Neubaustandard' => 'NEUBAUSTANDARD',
            'Kfw 40' => 'KFW40',
            'Kfw 60' => 'KFW60',
            'Kfw 55' => 'KFW55',
            'Kfw 70' => 'KFW70',
            'Minergiebauweise' => 'MINERGIEBAUWEISE',
            'Minergie zertifiziert' => 'MINERGIE_ZERTIFIZIERT',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_energietyp');
            $connection->truncate('tx_sgestatecore_domain_model_energietyp');
        }
        if ($this->energietypRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Energietyp
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Energietyp');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->energietypRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importErschliessung($resetData = false)
    {
        $importData = [
            'Unerschlossen' => 'UNERSCHLOSSEN',
            'Teilerschlossen' => 'TEILERSCHLOSSEN',
            'Vollerschlossen' => 'VOLLERSCHLOSSEN',
            'Ortsüblich erschlossen' => 'ORTSUEBLICHERSCHLOSSEN',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_erschliessung');
            $connection->truncate('tx_sgestatecore_domain_model_erschliessung');
        }
        if ($this->erschliessungRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Erschliessung
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Erschliessung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importErschliessungdetails($resetData = false)
    {
        $importData = [
            'Gas' => 'GAS',
            'Wasser' => 'WASSER',
            'Strom' => 'STROM',
            'TK' => 'TK',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_erschliessungdetails');
            $connection->truncate('tx_sgestatecore_domain_model_erschliessungdetails');
        }
        if ($this->erschliessungdetailsRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Erschliessungdetails
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Erschliessungdetails');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->erschliessungdetailsRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importGeschlecht($resetData = false)
    {
        $importData = [
            'Egal' => 'EGAL',
            'nur Männer' => 'NUR_MANN',
            'nur Frauen' => 'NUR_FRAU',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_geschlecht');
            $connection->truncate('tx_sgestatecore_domain_model_geschlecht');
        }
        if ($this->geschlechtRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Geschlecht
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Geschlecht');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->geschlechtRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importHeizungsart($resetData = false)
    {
        $importData = [
            'Ofenheizung' => 'OFEN',
            'Etagenheizung' => 'ETAGEN',
            'Zentralheizung' => 'ZENTRAL',
            'Fernwärme' => 'FERN',
            'Fussbodenheizung' => 'FUSSBODEN',
            'Gas-Heizung' => 'GAS-HEIZUNG',
            'Holz-Pelletheizung' => 'HOLZ-PELLETHEIZUNG',
            'Nachtspeicherofen' => 'nachtspeicherofen',
            'Ölheizung' => 'ÖLHEIZUNG',
            'Solar-Heizung' => 'SOLAR-HEIZUNG',
            'Wärmepumpe' => 'WAERMEPUMPE',
            'Blockheizkraftwerk' => 'BLOCKHEIZKRAFTWERK',
            'Elektro-Heizung' => 'ELEKTRO-HEIZUNG',
            'Keine Angabe' => 'KEIN_ANGABE',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_heizungsart');
            $connection->truncate('tx_sgestatecore_domain_model_heizungsart');
        }
        if ($this->heizungsartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Heizungsart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Heizungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->heizungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importHimmelrichtung($resetData = false)
    {
        $importData = [
            'Nord' => 'NORD',
            'Ost' => 'OST',
            'Süd' => 'SUED',
            'West' => 'WEST',
            'Nordost' => 'NORDOST',
            'Nordwest' => 'NORDWEST',
            'Südost' => 'SUEDOST',
            'Südwest' => 'SUEDWEST',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_himmelrichtung');
            $connection->truncate('tx_sgestatecore_domain_model_himmelrichtung');
        }
        if ($this->himmelrichtungRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Himmelrichtung
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Himmelrichtung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->himmelrichtungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importKuechenausstattung($resetData = false)
    {
        $importData = [
            'Einbauküche' => 'EBK',
            'Offene Küche' => 'OFFEN',
            'Pantry' => 'PANTRY',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_kuechenausstattung');
            $connection->truncate('tx_sgestatecore_domain_model_kuechenausstattung');
        }
        if ($this->kuechenausstattungRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Kuechenausstattung
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Kuechenausstattung');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->kuechenausstattungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importLage($resetData = false)
    {
        $importData = [
            'Wohn' => 'WOHN',
            'Gewerbe' => 'GEWERBE',
            'Industrie' => 'INDUSTRIE',
            'Misch' => 'MISCH',
            'Neubau' => 'NEUBAU',
            'Ortslage' => 'ORTSLAGE',
            'Siedlung' => 'SIEDLUNG',
            'Stadtrand' => 'STADTRAND',
            'Stadtteil' => 'STADTTEIL',
            'Stadtzentrum' => 'STADTZENTRUM',
            'Nebenzentrum' => 'NEBENZENTRUM',
            '1A' => '1A',
            '1B' => '1B',
            'Einkaufszentrum' => 'EINKAUFSZENTRUM',
            'Keine Angabe' => 'KEINE_ANGABE'
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_lage');
            $connection->truncate('tx_sgestatecore_domain_model_lage');
        }
        if ($this->lageRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Lage
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Lage');

                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->lageRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importLand($resetData = false)
    {
        // @todo: Restliche Länder ergänzen
        $importData = [
            'Deutschland' => 'DEU'
        ];
        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_land');
            $connection->truncate('tx_sgestatecore_domain_model_land');
        }
        if ($this->landRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Land
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Land');
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $this->landRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importNutzungsart($resetData = false)
    {
        $importData = [
            'Wohnen' => 'WOHNEN',
            'Gewerbe' => 'GEWERBE',
            'Anlage' => 'ANLAGE',
            'Wohnen auf Zeit' => 'WAZ',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_nutzungsart');
            $connection->truncate('tx_sgestatecore_domain_model_nutzungsart');
        }
        if ($this->nutzungsartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Nutzungsart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Nutzungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->nutzungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importObjektart($resetData = false)
    {
        $importData = [
            'Zimmer' => [
                'kuerzel' => 'ZIMMER',
                'typen' => [
                    'Zimmer' => 'ZIMMER'
                ],
            ],
            'Wohnung' => [
                'kuerzel' => 'WOHNUNG',
                'typen' => [
                    'Dachgeschoss' => 'DACHGESCHOSS',
                    'Maisonette' => 'MAISONETTE',
                    'Loft Studio Atelier' => 'LOFT',
                    'Penthouse' => 'PENTHOUSE',
                    'Terrassen' => 'TERASSEN',
                    'Etage' => 'ETAGE',
                    'Erdgeschoss' => 'ERDGESCHOSS',
                    'Hochpaterre' => 'HOCHPATERRE',
                    'Souterrain' => 'SOUTERRAIN',
                    'Apartment' => 'APARTMENT',
                    'Ferienwohnung' => 'FERIENWOHNUNG',
                    'Galerie' => 'GALERIE',
                    'Rohdachboden' => 'ROHDACHBODEN',
                    'Attikawohnung' => 'ATTIKAWOHNUNG',
                    'Sonstiges' => 'SONSTIGE',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ],
            ],
            'Haus' => [
                'kuerzel' => 'HAUS',
                'typen' => [
                    'Reihenhaus' => 'REIHENHAUS',
                    'Reihenend' => 'REIHENEND',
                    'Reihenmittel' => 'REIHENMITTEL',
                    'Reiheneck' => 'REIHENECK',
                    'Doppelhaushaelfte' => 'DOPPELHAUSHAELFTE',
                    'Einfamilienhaus' => 'EINFAMILIENHAUS',
                    'Stadthaus' => 'STADTHAUS',
                    'Bungalow' => 'BUNGALOW',
                    'Villa' => 'VILLA',
                    'Resthof' => 'RESTHOF',
                    'Bauernhaus' => 'BAUERNHAUS',
                    'Landhaus' => 'LANDHAUS',
                    'Schloss' => 'SCHLOSS',
                    'Zweifamilienhaus' => 'ZWEIFAMILIENHAUS',
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Ferienhaus' => 'FERIENHAUS',
                    'Berghuette' => 'BERGHUETTE',
                    'Chalet' => 'CHALET',
                    'Strandhaus' => 'STRANDHAUS',
                    'laube-datsche-gartenhaus' => 'LAUBE-DATSCHE-GARTENHAUS',
                    'Apartmenthaus' => 'APARTMENTHAUS',
                    'Burg' => 'BURG',
                    'Herrenhaus' => 'HERRENHAUS',
                    'Finca' => 'FINCA',
                    'Rustico' => 'RUSTICO',
                    'Fertighaus' => 'FERTIGHAUS',
                    'Besondere Immobilie' => 'SPECIAL_REAL_ESTATE',
                    'Wohnimmobilie (sonstige)' => 'OTHER',
                    'Keine Angabe' => 'KEINE_ANGABE',
                ],
            ],
            'Grundstück' => [
                'kuerzel' => 'GRUNDSTUECK',
                'typen' => [
                    'Wohnen' => 'WOHNEN',
                    'Gewerbe' => 'GEWERBE',
                    'Industrie' => 'INDUSTRIE',
                    'Land Forstwirschaft' => 'LAND_FORSTWIRSCHAFT',
                    'Freizeit' => 'FREIZEIT',
                    'Gemischt' => 'GEMISCHT',
                    'Gewerbepark' => 'GEWERBEPARK',
                    'Sondernutzung' => 'SONDERNUTZUNG',
                    'Seeliegenschaft' => 'SEELIEGENSCHAFT',
                ],
            ],
            'Büro & Praxen' => [
                'kuerzel' => 'BUERO_PRAXEN',
                'typen' => [
                    'Bueroflaeche' => 'BUEROFLAECHE',
                    'Bueroetage' => 'OFFICE_FLOOR',
                    'Buerohaus' => 'BUEROHAUS',
                    'Buerozentrum' => 'BUEROZENTRUM',
                    'Buero und Lager Gebaeude' => 'OFFICE_STORAGE_BUILDING',
                    'Loft Atelier' => 'LOFT',
                    'Studio' => 'STUDIO',
                    'Praxis' => 'PRAXIS',
                    'Praxisetage' => 'SURGERY_FLOOR',
                    'Praxisflaeche' => 'PRAXISFLAECHE',
                    'Praxishaus' => 'PRAXISHAUS',
                    'Gewerbezentrum' => 'COMMERCIAL_CENTRE',
                    'Wohn und Geschaeftsgebaeude' => 'LIVING_AND_COMMERCIAL_BUILDING',
                    'Buero und Geschaeftsgebaeude' => 'OFFICE_AND_COMMERCIAL_BUILDING',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                    'Coworking' => 'COWORKING',
                    'Shared Office' => 'SHARED_OFFICE',
                ],
            ],
            'Einzelhandel' => [
                'kuerzel' => 'EINZELHANDEL',
                'typen' => [
                    'Ladenlokal' => 'LADENLOKAL',
                    'Einzelhandelsladen' => 'EINZELHANDELSLADEN',
                    'Verbrauchermarkt' => 'VERBRAUCHERMARKT',
                    'Einkaufszentrum' => 'EINKAUFSZENTRUM',
                    'Kaufhaus' => 'KAUFHAUS',
                    'Factory Outlet' => 'FACTORY_OUTLET',
                    'Kiosk' => 'KIOSK',
                    'Verkaufsflaeche' => 'VERKAUFSFLAECHE',
                    'Verkaufshalle' => 'VERKAUFSHALLE',
                    'Ausstellungsflaeche' => 'AUSSTELLUNGSFLAECHE',
                ],
            ],
            'Gastgewerbe' => [
                'kuerzel' => 'GASTGEWERBE',
                'typen' => [
                    'Gastronomie' => 'GASTRONOMIE',
                    'Gastronomie & Wohnung' => 'GASTRONOMIE_UND_WOHNUNG',
                    'Pensionen' => 'PENSIONEN',
                    'Hotels' => 'HOTELS',
                    'Weitere Beherbergungsbetriebe' => 'WEITERE_BEHERBERGUNGSBETRIEBE',
                    'Bar' => 'BAR',
                    'Cafe' => 'CAFE',
                    'Discothek' => 'DISCOTHEK',
                    'Restaurant' => 'RESTAURANT',
                    'Raucherlokal' => 'RAUCHERLOKAL',
                    'Einraumlokal' => 'EINRAUMLOKAL',
                ],
            ],
            'Hallen, Lager & Produktion' => [
                'kuerzel' => 'HALLEN_LAGER_PROD',
                'typen' => [
                    'Halle' => 'HALLE',
                    'Industriehalle' => 'INDUSTRIEHALLE',
                    'Lager' => 'LAGER',
                    'Lagerflaechen' => 'LAGERFLAECHEN',
                    'Lager mit Freiflaeche' => 'LAGER_MIT_FREIFLAECHE',
                    'Hochregallager' => 'HOCHREGALLAGER',
                    'Speditionslager' => 'SPEDITIONSLAGER',
                    'Produktion' => 'PRODUKTION',
                    'Werkstatt' => 'WERKSTATT',
                    'Service' => 'SERVICE',
                    'Freiflaechen' => 'FREIFLAECHEN',
                    'Kühlhaus' => 'KUEHLHAUS',
                ],
            ],
            'Land & Forstwirtschaft' => [
                'kuerzel' => 'LAND_UND_FORSTWIRTSCHAFT',
                'typen' => [
                    'Landwirtschaftliche_betriebe' => 'LANDWIRTSCHAFTLICHE_BETRIEBE',
                    'Bauernhof' => 'BAUERNHOF',
                    'Aussiedlerhof' => 'AUSSIEDLERHOF',
                    'Gartenbau' => 'GARTENBAU',
                    'Ackerbau' => 'ACKERBAU',
                    'Weinbau' => 'WEINBAU',
                    'Viehwirtschaft' => 'VIEHWIRTSCHAFT',
                    'Jagd & Forstwirtschaft' => 'JAGD_UND_FORSTWIRTSCHAFT',
                    'Teich & Fischwirtschaft' => 'TEICH_UND_FISCHWIRTSCHAFT',
                    'Scheunen' => 'SCHEUNEN',
                    'Reiterhoefe' => 'REITERHOEFE',
                    'Sonstige Landwirtschaftsimmobilien' => 'SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN',
                    'Anwesen' => 'ANWESEN',
                    'Jagdrevier' => 'JAGDREVIER',
                ],
            ],
            'Parken' => [
                'kuerzel' => 'PARKEN',
                'typen' => [
                    'Stellplatz' => 'STELLPLATZ',
                    'Carport' => ['CARPORT', 'CARPORT'],
                    'Doppelgarage' => 'DOPPELGARAGE',
                    'Duplex' => ['DUPLEX', 'DUPLEX'],
                    'Tiefgarage' => ['TIEFGARAGE', 'UNDERGROUND_GARAGE'],
                    'Bootsliegeplatz' => 'BOOTSLIEGEPLATZ',
                    'Einzelgarage' => 'EINZELGARAGE',
                    'Parkhaus' => ['PARKHAUS', 'CAR_PARK'],
                    'Tiefgaragenstellplatz' => 'TIEFGARAGENSTELLPLATZ',
                    'Parkplatz mit Strom' => 'PARKPLATZ_STROM',
                    'Garage' => ['GARAGE', 'GARAGE'],
                    'Außenstellplatz' => ['', 'OUTSIDE'],
                ],
            ],
            'Sonstige' => [
                'kuerzel' => 'SONSTIGE',
                'typen' => [
                    'Parkhaus' => 'PARKHAUS',
                    'Tankstelle' => 'TANKSTELLE',
                    'Krankenhaus' => 'KRANKENHAUS',
                    'Sonstige' => 'SONSTIGE',
                ],
            ],
            'Freizeitimmobilie gewerblich' => [
                'kuerzel' => 'FREIZEITIMMOBILIE_GEWERBLICH',
                'typen' => [
                    'Sportanlagen' => 'SPORTANLAGEN',
                    'Vergnuegungsparks & Center' => 'VERGNUEGUNGSPARKS_UND_CENTER',
                    'Freizeitanlage' => 'FREIZEITANLAGE',
                ],
            ],
            'Renditeobjekt' => [
                'kuerzel' => 'ZINSHAUS_RENDITEOBJEKT',
                'typen' => [
                    'Mehrfamilienhaus' => 'MEHRFAMILIENHAUS',
                    'Wohn- und Geschaeftshaus' => 'WOHN_UND_GESCHAEFTSHAUS',
                    'Geschaeftshaus' => 'GESCHAEFTSHAUS',
                    'Buerogebaeude' => 'BUEROGEBAEUDE',
                    'SB Märkte' => 'SB_MAERKTE',
                    'Einkaufscentren' => 'EINKAUFSCENTREN',
                    'Wohnanlagen' => 'WOHNANLAGEN',
                    'Verbrauchermärkte' => 'VERBRAUCHERMAERKTE',
                    'Industrieanlagen' => 'INDUSTRIEANLAGEN',
                    'Pflegeheim' => 'PFLEGEHEIM',
                    'Sanatorium' => 'SANATORIUM',
                    'Seniorenheim' => 'SENIORENHEIM',
                    'Betreutes Wohnen' => 'BETREUTES-WOHNEN',
                ],
            ],
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_objektart');
            $connection->truncate('tx_sgestatecore_domain_model_objektart');

            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_objektarttyp');
            $connection->truncate('tx_sgestatecore_domain_model_objektarttyp');

            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_objektart_objektarttyp_mm');
            $connection->truncate('tx_sgestatecore_objektart_objektarttyp_mm');
        }
        if ($this->nutzungsartRepository->countAll() == 0) {
            /**
             * @var $objektart \SG\SgEstateCore\Domain\Model\Objektart
             * @var $objektarttyp \SG\SgEstateCore\Domain\Model\Objektarttyp
             */
            foreach ($importData as $key => $data) {
                $objektart = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Objektart');
                $objektart->setBezeichner($key);
                $objektart->setKuerzel($data['kuerzel']);
                foreach ($data['typen'] as $typKey => $typValue) {
                    $objektarttyp = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Objektarttyp');
                    $objektarttyp->setBezeichner($typKey);

                    if (is_array($typValue)){
                        $objektarttyp->setKuerzel($typValue[0]);
                        $objektarttyp->setKuerzelis24($typValue[1]);;
                    }
                    else {
                        $objektarttyp->setKuerzel($typValue);
                    }
                    $objektart->addObjektarttyp($objektarttyp);

                }
                $this->objektartRepository->add($objektart);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importPeriode($resetData = false)
    {
        $importData = [
            'Tag' => 'TAG',
            'Woche' => 'WOCHE',
            'Monat' => 'MONAT',
            'Jahr' => 'JAHR',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_periode');
            $connection->truncate('tx_sgestatecore_domain_model_periode');
        }
        if ($this->periodeRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Periode
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Periode');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->periodeRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importVerkaufstatus($resetData = false)
    {
        $importData = [
            'Offen' => 'OFFEN',
            'Reserviert' => 'RESERVIERT',
            'Verkauft' => 'VERKAUFT',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_verkaufstatus');
            $connection->truncate('tx_sgestatecore_domain_model_verkaufstatus');
        }
        if ($this->verkaufstatusRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Verkaufstatus
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Verkaufstatus');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->verkaufstatusRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importVermarktungsart($resetData = false)
    {
        $importData = [
            'Kauf' => 'KAUF',
            'Miete Pacht' => 'MIETE_PACHT',
            'Erbpacht' => 'ERBPACHT',
            'Leasing' => 'LEASING',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_vermarktungsart');
            $connection->truncate('tx_sgestatecore_domain_model_vermarktungsart');
        }
        if ($this->vermarktungsartRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Vermarktungsart
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Vermarktungsart');
                $item->setBezeichner($key);
                $item->setKuerzel($value);
                $this->vermarktungsartRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importWaehrung($resetData = false)
    {
        // @todo: Restliche Währungen einpflegen
        $importData = [
            'Euro' => 'EUR',
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_waehrung');
            $connection->truncate('tx_sgestatecore_domain_model_waehrung');
        }
        if ($this->waehrungRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Waehrung
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Waehrung');
                $item->setBezeichner($key);
                $item->setIsoKennzeichen($value);
                $item->setSymbol($value);
                $this->waehrungRepository->add($item);
            }
        }
    }

    /**
     * @param bool $resetData
     */
    private function importZustand($resetData = false)
    {
        $importData = [
            'Erstbezug' => 'ERSTBEZUG',
            'Erstbezug nach Sanierung' => 'ERSTBEZUG_NACH_SANIERUNG',
            'Teil- Vollrenovierungsbed' => 'TEIL_VOLLRENOVIERUNGSBED',
            'Neuwertig' => 'NEUWERTIG',
            'Teil- Vollsaniert' => 'TEIL_VOLLSANIERT',
            'Teil- Vollrenoviert' => 'TEIL_VOLLRENOVIERT',
            'Teilsaniert' => 'TEIL_SANIERT',
            'Vollsaniert' => 'VOLL_SANIERT',
            'Sanierungsbeduerftig' => 'SANIERUNGSBEDUERFTIG',
            'Baufaellig' => 'BAUFAELLIG',
            'Nach Vereinbarung' => 'NACH_VEREINBARUNG',
            'Modernisiert' => 'MODERNISIERT',
            'Gepflegt' => 'GEPFLEGT',
            'Rohbau' => 'ROHBAU',
            'Entkernt' => 'ENTKERNT',
            'Abrissobjekt' => 'ABRISSOBJEKT',
            'Projektiert' => 'PROJEKTIERT',
            'Keine Angabe' => 'NO_INFORMATION'
        ];

        if ($resetData) {
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_sgestatecore_domain_model_zustand');
            $connection->truncate('tx_sgestatecore_domain_model_zustand');
        }
        if ($this->zustandRepository->countAll() == 0) {
            /**
             * @var $item \SG\SgEstateCore\Domain\Model\Zustand
             */
            foreach ($importData as $key => $value) {
                $item = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Zustand');
                $item->setBezeichner($key);
                $item->setKuerzel($value);

                $this->zustandRepository->add($item);
            }
        }
    }

    public function servicesAction()
    {
        if ($this->request->hasArgument('type')) {
            /**
             * @var $sgCoreServices Services
             */
            $sgCoreServices = $this->objectManager->get('SG\SgEstateCore\Util\Services');
            switch ($this->request->getArgument('type')) {
                case 'countRealties':
                    $sgCoreServices->countRealties();
                    $this->redirect('services', 'Management', 'sg_estate_core');
                    break;
            }
        }
    }
}
