<?php
namespace SG\SgEstateCore\Domain\Model;

/**
 * Kampagne
 */
class Kampagne extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity {

    /**
     * bezeichner
     *
     * @var string
     */
    protected $bezeichner = '';

    /**
     * kuerzel
     *
     * @var string
     */
    protected $kuerzel = '';

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ort>
     **/
    protected $orte;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil>
     **/
    protected $stadtteile;

    public function __construct()
    {
        $this->orte = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->stadtteile = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }


    /**
     * Returns the bezeichner
     *
     * @return string $bezeichner
     */
    public function getBezeichner() {
        return $this->bezeichner;
    }

    /**
     * Sets the bezeichner
     *
     * @param string $bezeichner
     * @return void
     */
    public function setBezeichner($bezeichner) {
        $this->bezeichner = $bezeichner;
    }

    /**
     * Returns the kuerzel
     *
     * @return string $kuerzel
     */
    public function getKuerzel() {
        return $this->kuerzel;
    }

    /**
     * Sets the kuerzel
     *
     * @param string $kuerzel
     * @return void
     */
    public function setKuerzel($kuerzel) {
        $this->kuerzel = $kuerzel;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getOrte(): ?\TYPO3\CMS\Extbase\Persistence\ObjectStorage
    {
        return $this->orte;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $orte
     */
    public function setOrte(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $orte): void
    {
        $this->orte = $orte;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Ort $ort
     */
    public function addOrt(\SG\SgEstateCore\Domain\Model\Ort $ort): void
    {
        $this->orte->attach($ort);
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Ort $ort
     */
    public function removeOrt(\SG\SgEstateCore\Domain\Model\Ort $ort): void
    {
        $this->orte->detach($ort);
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getStadtteile(): ?\TYPO3\CMS\Extbase\Persistence\ObjectStorage
    {
        return $this->stadtteile;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $stadtteile
     */
    public function setStadtteile(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $stadtteile): void
    {
        $this->stadtteile = $stadtteile;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Stadtteil $stadtteil
     */
    public function addStadtteil(\SG\SgEstateCore\Domain\Model\Stadtteil $stadtteil): void
    {
        $this->stadtteile->attach($stadtteil);
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Stadtteil $stadtteil
     */
    public function removeStadtteil(\SG\SgEstateCore\Domain\Model\Stadtteil $stadtteil): void
    {
        $this->stadtteile->detach($stadtteil);
    }


    public function getDto(): array
    {
        $cityDtos = [];
        /** @var Ort $city */
        foreach ($this->getOrte() as $city) {
            $cityDtos[] = $city->getDto();
        }

        $districtDtos = [];
        /** @var Stadtteil $district */
        foreach ($this->getStadtteile() as $district) {
            $districtDtos[] = $district->getDto();
        }

        return [
            'name' => $this->getBezeichner(),
            'identifier' => $this->getKuerzel(),
            'cities' => $cityDtos,
            'districts' => $districtDtos
        ];
    }
}