<?php
namespace SG\SgEstateCore\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Filter;
use SG\SgEstateCore\Domain\Model\Ort;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class SelectedCitiesForTypeaheadViewHelper extends AbstractViewHelper
{
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('filter', 'object', 'Filter');
    }

    public function render(){
        /**
         * @var $filter Filter
         */
        $filter = $this->arguments['filter'];
        $selectedCities = [];
        if ($filter instanceof Filter){
            foreach ($filter->getOrte() as $city){
                /**
                 * @var $city Ort
                 */
                $selectedCities[] = [
                    'id' => 'c-'.$city->getUid(),
                    'label' => $city->getBezeichner(),
                    'type' => 'city'
                ];
            }
        }
        return json_encode($selectedCities);
    }
}