<?php
namespace SG\SgEstateCore\Command;

use SG\SgEstateCore\Util\Services;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class CountCommand extends Command
{
    protected static $defaultName = 'sg.estate.core.count';

    /**
     * @var Services
     */
    private $sgEstateCoreServices;

    public function configure()
    {
        parent::configure();
        $this->setName('sg.estate.core.count');
        $this->setDescription('Zählen der Immobilien');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->startup();
        $this->sgEstateCoreServices->countRealties();
        return 0;
    }

    private function startup()
    {
        $this->sgEstateCoreServices = GeneralUtility::makeInstance(Services::class);
    }
}
