<?php
namespace SG\SgEstateCore\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RealtiesCountViewHelper extends AbstractViewHelper
{
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('city', 'object', 'City');
        $this->registerArgument('district', 'object', 'District');
        $this->registerArgument('kindsOfObject', 'array', 'Array of Kind of Object Tokens');
    }

    public function render(){
        $jsonWithAmounts = null;
        if ($this->arguments['district'] != null){
            $jsonWithAmounts = $this->arguments['district']->getAnzahlImmobilien();
        }elseif ($this->arguments['city'] != null){
            $jsonWithAmounts = $this->arguments['city']->getAnzahlImmobilien();
        }
        if ($jsonWithAmounts !== null){
            $arrayWithAmounts = json_decode($jsonWithAmounts, true);
            if (is_array($this->arguments['kindsOfObject']) && count($this->arguments['kindsOfObject'])>0){
                $sum = 0;
                foreach ($this->arguments['kindsOfObject'] as $kindOfObjectToken){
                    if (isset($arrayWithAmounts[$kindOfObjectToken])){
                        $sum += $arrayWithAmounts[$kindOfObjectToken];
                    }
                }
                return $sum;
            }else{
                return $arrayWithAmounts['_GESAMT'];
            }
        }else{
            return 0;
        }
    }
}