<?php
namespace SG\SgEstateCore\Command;

use SG\SgEstateCore\Util\Services;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;

class GeocodeCommand extends Command
{
    protected static $defaultName = 'sg.estate.core.geocode';

    /**
     * @var Services
     */
    private $sgEstateCoreServices;

    public function configure()
    {
        parent::configure();
        $this->setName('sg.estate.core.geocode');
        $this->setDescription('Geokodierung der einzelnen Immobilien via Google API');
        $this->addOption('renewAll', 'a', InputOption::VALUE_NONE, 'Renew all Coordinates');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->startup();
        $this->sgEstateCoreServices->geocodeRealties($input->getOption('renewAll'));
        return true;
    }

    private function startup()
    {
        $this->sgEstateCoreServices = GeneralUtility::makeInstance(Services::class);
    }
}