#
# Table structure for table 'tx_sgestatecore_domain_model_immobilie'
#
CREATE TABLE tx_sgestatecore_domain_model_immobilie (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

  updatable tinyint(4) unsigned DEFAULT '0' NOT NULL,
  import_number int(11) unsigned DEFAULT '0' NOT NULL,
	objektart_zusatz varchar(255) DEFAULT '' NOT NULL,
	objekt_plz varchar(255) DEFAULT '' NOT NULL,
	objekt_strasse varchar(255) DEFAULT '' NOT NULL,
	objekt_hausnummer varchar(255) DEFAULT '' NOT NULL,
	objekt_bundesland varchar(255) DEFAULT '' NOT NULL,
	objekt_gemeindecode varchar(255) DEFAULT '' NOT NULL,
	objekt_flur varchar(255) DEFAULT '' NOT NULL,
	objekt_flurstueck varchar(255) DEFAULT '' NOT NULL,
	objekt_gemarkung varchar(255) DEFAULT '' NOT NULL,
	objekt_etage int(11) DEFAULT '0' NOT NULL,
	objekt_anzahl_etagen int(11) DEFAULT '0' NOT NULL,
	objekt_wohnungsnr varchar(255) DEFAULT '' NOT NULL,
	objekt_regionaler_zusatz varchar(255) DEFAULT '' NOT NULL,
	objekt_karten_makro int(11) DEFAULT '0' NOT NULL,
	objekt_karten_mikro int(11) DEFAULT '0' NOT NULL,
	objekt_virtuelletour int(11) DEFAULT '0' NOT NULL,
	objekt_luftbilder int(11) DEFAULT '0' NOT NULL,
	objekt_lage_im_bau_links int(11) DEFAULT '0' NOT NULL,
	objekt_lage_im_bau_rechts int(11) DEFAULT '0' NOT NULL,
	objekt_lage_im_bau_vorne int(11) DEFAULT '0' NOT NULL,
	objekt_lage_im_bau_hinten int(11) DEFAULT '0' NOT NULL,
	objekt_breitengrad double(11,8) DEFAULT '0.00000000' NOT NULL,
	objekt_laengengrad double(11,8) DEFAULT '0.00000000' NOT NULL,
	kaufpreis double(11,2) DEFAULT '0.00' NOT NULL,
	kaufpreis_netto double(11,2) DEFAULT '0.00' NOT NULL,
	kaufpreis_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	kaufpreis_brutto double(11,2) DEFAULT '0.00' NOT NULL,
	nettokaltmiete double(11,2) DEFAULT '0.00' NOT NULL,
	kaltmiete double(11,2) DEFAULT '0.00' NOT NULL,
	warmmiete double(11,2) DEFAULT '0.00' NOT NULL,
	nebenkosten double(11,2) DEFAULT '0.00' NOT NULL,
	heizkosten_enthalten int(11) DEFAULT '0' NOT NULL,
	heizkosten double(11,2) DEFAULT '0.00' NOT NULL,
	zzgl_mehrwertsteuer int(11) DEFAULT '0' NOT NULL,
	mietzuschlaege double(11,2) DEFAULT '0.00' NOT NULL,
	hauptmietzins_netto double(11,2) DEFAULT '0.00' NOT NULL,
	hauptmietzins_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	pauschalmiete double(11,2) DEFAULT '0.00' NOT NULL,
	betriebskosten_netto double(11,2) DEFAULT '0.00' NOT NULL,
	betriebskosten_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	evb_netto double(11,2) DEFAULT '0.00' NOT NULL,
	evb_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtmiete_netto double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtmiete_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtmiete_brutto double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtbelastung_netto double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtbelastung_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtbelastung_brutto double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtkosten_pro_m2_von double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtkosten_pro_m2_bis double(11,2) DEFAULT '0.00' NOT NULL,
	heizkosten_netto double(11,2) DEFAULT '0.00' NOT NULL,
	heizkosten_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	monatlichekosten_netto double(11,2) DEFAULT '0.00' NOT NULL,
	monatlichekosten_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	monatlichekostenbrutto double(11,2) DEFAULT '0.00' NOT NULL,
	nebenkosten_pro_m2_von double(11,2) DEFAULT '0.00' NOT NULL,
	nebenkosten_pro_m2_bis double(11,2) DEFAULT '0.00' NOT NULL,
	ruecklage_netto double(11,2) DEFAULT '0.00' NOT NULL,
	ruecklage_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	sonstigekosten_netto double(11,2) DEFAULT '0.00' NOT NULL,
	sonstigekosten_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	sonstigemiete_netto double(11,2) DEFAULT '0.00' NOT NULL,
	sonstigemiete_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	summemiete_netto double(11,2) DEFAULT '0.00' NOT NULL,
	summemiete_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	nettomiete_pro_m2_von double(11,2) DEFAULT '0.00' NOT NULL,
	nettomiete_pro_m2_bis double(11,2) DEFAULT '0.00' NOT NULL,
	pacht double(11,2) DEFAULT '0.00' NOT NULL,
	erbpacht double(11,2) DEFAULT '0.00' NOT NULL,
	hausgeld double(11,2) DEFAULT '0.00' NOT NULL,
	abstand double(11,2) DEFAULT '0.00' NOT NULL,
	preis_zeitraum_von int(11) DEFAULT '0' NOT NULL,
	preis_zeitraum_bis int(11) DEFAULT '0' NOT NULL,
	mietpreis_pro_m2 double(11,2) DEFAULT '0.00' NOT NULL,
	kaufpreis_pro_m2 double(11,2) DEFAULT '0.00' NOT NULL,
	provisionspflichtig int(11) DEFAULT '0' NOT NULL,
	innencourtage varchar(255) DEFAULT '' NOT NULL,
	innencourtage_mit_mwst int(11) DEFAULT '0' NOT NULL,
	aussencourtage varchar(255) DEFAULT '' NOT NULL,
	aussencourtage_mit_mwst int(11) DEFAULT '0' NOT NULL,
	courtage_hinweis text DEFAULT NULL,
	provision_netto double(11,2) DEFAULT '0.00' NOT NULL,
	provision_netto_ust double(11,2) DEFAULT '0.00' NOT NULL,
	provision_brutto double(11,2) DEFAULT '0.00' NOT NULL,
	mwst_satz double(11,2) DEFAULT '0.00' NOT NULL,
	mwst_gesamt double(11,2) DEFAULT '0.00' NOT NULL,
	freitext_preis text DEFAULT NULL,
	xfache varchar(255) DEFAULT '' NOT NULL,
	nettorendite double(11,2) DEFAULT '0.00' NOT NULL,
	nettorendite_soll double(11,2) DEFAULT '0.00' NOT NULL,
	nettorendite_ist double(11,2) DEFAULT '0.00' NOT NULL,
	mieteinnahmen_ist double(11,2) DEFAULT '0.00' NOT NULL,
	mieteinnahmen_soll double(11,2) DEFAULT '0.00' NOT NULL,
	erschliessungskosten double(11,2) DEFAULT '0.00' NOT NULL,
	kaution double(11,2) DEFAULT '0.00' NOT NULL,
	kaution_text text DEFAULT NULL,
	geschaeftsguthaben double(11,2) DEFAULT '0.00' NOT NULL,
	genossenschaftsanteile double(11,2) DEFAULT '0.00' NOT NULL,
	vertragsabschlussgebuehr double(11,2) DEFAULT '0.00' NOT NULL,
	stp_carport varchar(255) DEFAULT '' NOT NULL,
	stp_duplex varchar(255) DEFAULT '' NOT NULL,
	stp_freiplatz varchar(255) DEFAULT '' NOT NULL,
	stp_garage varchar(255) DEFAULT '' NOT NULL,
	stp_parkhaus varchar(255) DEFAULT '' NOT NULL,
	stp_tiefgarage varchar(255) DEFAULT '' NOT NULL,
	richtpreis double(11,2) DEFAULT '0.00' NOT NULL,
	richtpreis_pro_m2 double(11,2) DEFAULT '0.00' NOT NULL,
	wohnflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	nutzflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	gesamtflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	ladenflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	lagerflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	verkaufsflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	freiflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	bueroflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	bueroteilflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	fensterfront double(11,2) DEFAULT '0.00' NOT NULL,
	verwaltungsflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	gastroflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	grundflaechenzahl varchar(255) DEFAULT '' NOT NULL,
	geschossflaechenzahl varchar(255) DEFAULT '' NOT NULL,
	baumassenzahl varchar(255) DEFAULT '' NOT NULL,
	bruttogeschossflaechenzahl double(11,2) DEFAULT '0.00' NOT NULL,
	grundstuecksflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	sonstflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_zimmer double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_schlafzimmer double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_badezimmer double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_separate_wc double(11,2) DEFAULT '0.00' NOT NULL,
	balkon_terasse_flaeche double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_wohn_schlafzimmer double(11,2) DEFAULT '0.00' NOT NULL,
	gartenflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_balkone double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_terassen double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_logia double(11,2) DEFAULT '0.00' NOT NULL,
	fensterfront_m2 double(11,2) DEFAULT '0.00' NOT NULL,
	grundstuecksfront double(11,2) DEFAULT '0.00' NOT NULL,
	dachbodenflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	teilbar_ab double(11,2) DEFAULT '0.00' NOT NULL,
	kellerflaeche double(11,2) DEFAULT '0.00' NOT NULL,
	beheizbare_flaeche double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_stellplaetze double(11,2) DEFAULT '0.00' NOT NULL,
	plaetze_gastraum double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_betten double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_betten_einzel double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_betten_doppel double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_betten_schlafsofa double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_tagungsraeume double(11,2) DEFAULT '0.00' NOT NULL,
	vermietbare_flaeche double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_wohneinheiten double(11,2) DEFAULT '0.00' NOT NULL,
	anzahl_gewerbeeinheiten double(11,2) DEFAULT '0.00' NOT NULL,
	einliegerwohnung int(11) DEFAULT '0' NOT NULL,
	kubatur double(11,2) DEFAULT '0.00' NOT NULL,
	ausnuetzungsziffer double(11,2) DEFAULT '0.00' NOT NULL,
	flaechevon double(11,2) DEFAULT '0.00' NOT NULL,
	flaechebis double(11,2) DEFAULT '0.00' NOT NULL,
	wg_geeignet int(11) DEFAULT '0' NOT NULL,
	raeume_veraenderbar int(11) DEFAULT '0' NOT NULL,
	kamin int(11) DEFAULT '0' NOT NULL,
	klimatisiert int(11) DEFAULT '0' NOT NULL,
	aufzug_personen int(11) DEFAULT '0' NOT NULL,
	aufzug_lasten int(11) DEFAULT '0' NOT NULL,
	gartennutzung int(11) DEFAULT '0' NOT NULL,
	moebliert int(11) DEFAULT '0' NOT NULL,
	rollstuhlgerecht int(11) DEFAULT '0' NOT NULL,
	kabel_sat_tv int(11) DEFAULT '0' NOT NULL,
	kabelfernsehen int(11) DEFAULT '0' NOT NULL,
	satellitenfernsehen int(11) DEFAULT '0' NOT NULL,
	dvbt int(11) DEFAULT '0' NOT NULL,
	barrierefrei int(11) DEFAULT '0' NOT NULL,
	sauna int(11) DEFAULT '0' NOT NULL,
	swimmingpool int(11) DEFAULT '0' NOT NULL,
	wasch_trockenraum int(11) DEFAULT '0' NOT NULL,
	wintergarten int(11) DEFAULT '0' NOT NULL,
	dv_verkabelung int(11) DEFAULT '0' NOT NULL,
	rampe int(11) DEFAULT '0' NOT NULL,
	hebebuehne int(11) DEFAULT '0' NOT NULL,
	kran int(11) DEFAULT '0' NOT NULL,
	gastterrasse int(11) DEFAULT '0' NOT NULL,
	stromanschlusswert double(11,2) DEFAULT '0.00' NOT NULL,
	katine_cafeteria int(11) DEFAULT '0' NOT NULL,
	teekueche int(11) DEFAULT '0' NOT NULL,
	hallenhoehe double(11,2) DEFAULT '0.00' NOT NULL,
	hotelrestaurant_angeschlossen int(11) DEFAULT '0' NOT NULL,
	bar_angeschlossen int(11) DEFAULT '0' NOT NULL,
	brauereibindung int(11) DEFAULT '0' NOT NULL,
	sporteinrichtungen int(11) DEFAULT '0' NOT NULL,
	wellnessbereich int(11) DEFAULT '0' NOT NULL,
	service_betreutes_wohnen int(11) DEFAULT '0' NOT NULL,
	service_catering int(11) DEFAULT '0' NOT NULL,
	service_reinigung int(11) DEFAULT '0' NOT NULL,
	service_einkauf int(11) DEFAULT '0' NOT NULL,
	service_wachdienst int(11) DEFAULT '0' NOT NULL,
	telefon_ferienimmobilie int(11) DEFAULT '0' NOT NULL,
	breitband_zugang_art varchar(255) DEFAULT '' NOT NULL,
	breitband_zugang_speed double(11,2) DEFAULT '0.00' NOT NULL,
	umts_empfang int(11) DEFAULT '0' NOT NULL,
	sicherheit_alarmanlage int(11) DEFAULT '0' NOT NULL,
	sicherheit_kamera int(11) DEFAULT '0' NOT NULL,
	sicherheit_polizeiruf int(11) DEFAULT '0' NOT NULL,
	unterkellert int(11) DEFAULT '0' NOT NULL,
	gegensprechanlage int(11) DEFAULT '0' NOT NULL,
	leicht_erreichbar int(11) DEFAULT '0' NOT NULL,
	abstellraum int(11) DEFAULT '0' NOT NULL,
	fahrradraum int(11) DEFAULT '0' NOT NULL,
	rolladen int(11) DEFAULT '0' NOT NULL,
	bibliothek int(11) DEFAULT '0' NOT NULL,
	dachboden int(11) DEFAULT '0' NOT NULL,
	gaestewc int(11) DEFAULT '0' NOT NULL,
	kabelkanaele int(11) DEFAULT '0' NOT NULL,
	seniorengerecht int(11) DEFAULT '0' NOT NULL,
	baujahr varchar(255) DEFAULT '' NOT NULL,
	letztemodernisierung varchar(255) DEFAULT '' NOT NULL,
	altertyp int(11) unsigned DEFAULT '0',
	bauzone varchar(255) DEFAULT '' NOT NULL,
	altlasten varchar(255) DEFAULT '' NOT NULL,
	energiepass_art int(11) unsigned DEFAULT '0',
	energiepass_gueltig_bis varchar(255) DEFAULT '' NOT NULL,
	energiepass_energieverbrauchkennwert varchar(255) DEFAULT '' NOT NULL,
	energiepass_mitwarmwasser int(11) DEFAULT '0' NOT NULL,
	energiepass_endenergiebedarf varchar(255) DEFAULT '' NOT NULL,
  energiepass_primaerenergietraeger int(11) unsigned DEFAULT '0',
  energiepass_stromwert  varchar(255) DEFAULT '' NOT NULL,
  energiepass_waermewert  varchar(255) DEFAULT '' NOT NULL,
  energiepass_wertklasse  varchar(255) DEFAULT '' NOT NULL,
  energiepass_baujahr  varchar(255) DEFAULT '' NOT NULL,
  energiepass_ausstelldatum int(11) unsigned DEFAULT '0',
  energiepass_jahrgang int(11) unsigned DEFAULT '0',
  energiepass_gebaeudeart int(11) unsigned DEFAULT '0',
  energiepass_epasstext varchar(255) DEFAULT '' NOT NULL,
  energiepass_hwbwert varchar(255) DEFAULT '' NOT NULL,
  energiepass_hwbklasse varchar(255) DEFAULT '' NOT NULL,
  energiepass_fgeewert varchar(255) DEFAULT '' NOT NULL,
  energiepass_fgeeklasse varchar(255) DEFAULT '' NOT NULL,
	verkaufstatus int(11) unsigned DEFAULT '0',
	zulieferung int(11) DEFAULT '0' NOT NULL,
	ausblick int(11) unsigned DEFAULT '0',
	objekttitel text DEFAULT NULL,
	kurzbeschreibung text DEFAULT NULL,
	lage text DEFAULT NULL,
	austattungsbeschreibung text DEFAULT NULL,
	objektbeschreibung text DEFAULT NULL,
	sonstige_angaben text DEFAULT NULL,
	objektadresse_freigeben int(11) DEFAULT '0' NOT NULL,
	verfuegbar_ab varchar(255) DEFAULT '' NOT NULL,
	verfuegbar_ab_datum int(11) DEFAULT '0' NOT NULL,
	verfuegbar_bis_datum int(11) DEFAULT '0' NOT NULL,
	versteigerungstermin int(11) DEFAULT '0' NOT NULL,
	wbs_erforderlich int(11) DEFAULT '0' NOT NULL,
	vermietet int(11) DEFAULT '0' NOT NULL,
	gruppennummer varchar(255) DEFAULT '' NOT NULL,
	zugang text DEFAULT NULL,
	laufzeit double(11,2) DEFAULT '0.00' NOT NULL,
	minimale_personenanzahl int(11) DEFAULT '0' NOT NULL,
	maximale_personenanzahl int(11) DEFAULT '0' NOT NULL,
	nichtraucher int(11) DEFAULT '0' NOT NULL,
	haustiere int(11) DEFAULT '0' NOT NULL,
	geschlecht int(11) unsigned DEFAULT '0',
	denkmalgeschuetzt int(11) DEFAULT '0' NOT NULL,
	als_ferien int(11) DEFAULT '0' NOT NULL,
	gewerbliche_nutzung int(11) DEFAULT '0' NOT NULL,
	bad_modernisiert int(11) DEFAULT '0' NOT NULL,
	branchen varchar(255) DEFAULT '' NOT NULL,
	hochhaus int(11) DEFAULT '0' NOT NULL,
	objektnr_intern varchar(255) DEFAULT '' NOT NULL,
	objektnr_extern varchar(255) DEFAULT '' NOT NULL,
	anzeige_ab int(11) DEFAULT '0' NOT NULL,
	anzeige_bis int(11) DEFAULT '0' NOT NULL,
	openimmo_objid varchar(255) DEFAULT '' NOT NULL,
	kennung_ursprung varchar(255) DEFAULT '' NOT NULL,
	stand_vom int(11) DEFAULT '0' NOT NULL,
	weitergabe_generell int(11) DEFAULT '0' NOT NULL,
	weitergabe_positivliste text DEFAULT NULL,
	weitergabe_negativliste text DEFAULT NULL,
	gruppen_kennung text DEFAULT NULL,
	master_objekt text DEFAULT NULL,
	master_visible int(11) DEFAULT '0' NOT NULL,
	sprache varchar(255) DEFAULT '' NOT NULL,
	nutzungsart int(11) unsigned DEFAULT '0' NOT NULL,
	vermarktungsart int(11) unsigned DEFAULT '0' NOT NULL,
	objektart int(11) unsigned DEFAULT '0',
	objektarttyp int(11) unsigned DEFAULT '0',
	objekt_ort int(11) unsigned DEFAULT '0',
	objekt_stadtteil int(11) unsigned DEFAULT '0',
	objekt_land int(11) unsigned DEFAULT '0',
	objekt_lage int(11) unsigned DEFAULT '0',
	kontaktperson int(11) unsigned DEFAULT '0',
	weitere_adressen int(11) unsigned DEFAULT '0' NOT NULL,
	preis_zeiteinheit int(11) unsigned DEFAULT '0',
	mieteinnahmen_ist_periode int(11) unsigned DEFAULT '0',
	mieteinnahmen_soll_periode int(11) unsigned DEFAULT '0',
	waehrung int(11) unsigned DEFAULT '0',
	ausstattungs_kategorie int(11) unsigned DEFAULT '0',
	ausstattung_bad int(11) unsigned DEFAULT '0' NOT NULL,
	ausstattung_kueche int(11) unsigned DEFAULT '0' NOT NULL,
	ausstattung_boden int(11) unsigned DEFAULT '0' NOT NULL,
	heizungsart int(11) unsigned DEFAULT '0' NOT NULL,
	befeuerungsart int(11) unsigned DEFAULT '0' NOT NULL,
	ausricht_balkon_terasse int(11) unsigned DEFAULT '0' NOT NULL,
	dachform int(11) unsigned DEFAULT '0' NOT NULL,
	bauweise int(11) unsigned DEFAULT '0' NOT NULL,
	ausbaustufe int(11) unsigned DEFAULT '0' NOT NULL,
	energietyp int(11) unsigned DEFAULT '0',
	zustand int(11) unsigned DEFAULT '0',
	bebaubar_nach int(11) unsigned DEFAULT '0',
	erschliessung int(11) unsigned DEFAULT '0',
	erschliessung_umfang int(11) unsigned DEFAULT '0' NOT NULL,
	anhaenge int(11) unsigned DEFAULT '0' NOT NULL,
	minimale_mietdauer int(11) unsigned DEFAULT '0',
	maximale_mietdauer int(11) unsigned DEFAULT '0',
	user_defined_simple int(11) unsigned DEFAULT '0' NOT NULL,
	user_defined_extend int(11) unsigned DEFAULT '0' NOT NULL,
	kampagne int(11) unsigned DEFAULT '0' NOT NULL,
	distance double(11,2) DEFAULT '0.00' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_nutzungsart'
#
CREATE TABLE tx_sgestatecore_domain_model_nutzungsart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_vermarktungsart'
#
CREATE TABLE tx_sgestatecore_domain_model_vermarktungsart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_objektart'
#
CREATE TABLE tx_sgestatecore_domain_model_objektart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,
	objektarttypen int(11) unsigned DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_objektarttyp'
#
CREATE TABLE tx_sgestatecore_domain_model_objektarttyp (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_ort'
#
CREATE TABLE tx_sgestatecore_domain_model_ort (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	anzahl_immobilien text DEFAULT NULL,
	fuer_suche_verwenden tinyint(1) unsigned DEFAULT '0' NOT NULL,
	stadtteile int(11) unsigned DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_stadtteil'
#
CREATE TABLE tx_sgestatecore_domain_model_stadtteil (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	ort int(11) unsigned DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	anzahl_immobilien text DEFAULT NULL,
	fuer_suche_verwenden tinyint(1) unsigned DEFAULT '0' NOT NULL,
	nachbar_stadtteile int(11) unsigned DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_land'
#
CREATE TABLE tx_sgestatecore_domain_model_land (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	iso_kennzeichen varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_lage'
#
CREATE TABLE tx_sgestatecore_domain_model_lage (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_kontaktperson'
#
CREATE TABLE tx_sgestatecore_domain_model_kontaktperson (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	name varchar(255) DEFAULT '' NOT NULL,
	vorname varchar(255) DEFAULT '' NOT NULL,
	titel varchar(255) DEFAULT '' NOT NULL,
	anrede varchar(255) DEFAULT '' NOT NULL,
	position varchar(255) DEFAULT '' NOT NULL,
	anrede_brief varchar(255) DEFAULT '' NOT NULL,
	firma varchar(255) DEFAULT '' NOT NULL,
	zusatzfeld varchar(255) DEFAULT '' NOT NULL,
	strasse varchar(255) DEFAULT '' NOT NULL,
	hausnummer varchar(255) DEFAULT '' NOT NULL,
	plz varchar(255) DEFAULT '' NOT NULL,
	postfach varchar(255) DEFAULT '' NOT NULL,
	postfach_plz varchar(255) DEFAULT '' NOT NULL,
	email_zentrale varchar(255) DEFAULT '' NOT NULL,
	email_direkt varchar(255) DEFAULT '' NOT NULL,
	email_privat varchar(255) DEFAULT '' NOT NULL,
	email_sonstige varchar(255) DEFAULT '' NOT NULL,
	email_feedback varchar(255) DEFAULT '' NOT NULL,
	telefon_zentrale varchar(255) DEFAULT '' NOT NULL,
	telefon_durchwahl varchar(255) DEFAULT '' NOT NULL,
	telefon_fax varchar(255) DEFAULT '' NOT NULL,
	telefon_handy varchar(255) DEFAULT '' NOT NULL,
	telefon_privat varchar(255) DEFAULT '' NOT NULL,
	telefon_sonstige varchar(255) DEFAULT '' NOT NULL,
	url varchar(255) DEFAULT '' NOT NULL,
	adressfreigabe tinyint(1) unsigned DEFAULT '0' NOT NULL,
	personennummer varchar(255) DEFAULT '' NOT NULL,
	immobilientreuhaenderid varchar(255) DEFAULT '' NOT NULL,
	foto int(11) unsigned NOT NULL default '0',
	freitextfeld text DEFAULT NULL,
	ort varchar(255) DEFAULT '',
	postfach_ort varchar(255) DEFAULT '' NOT NULL,
	land int(11) unsigned DEFAULT '0',

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_kontaktpersonbild'
#
CREATE TABLE tx_sgestatecore_domain_model_kontaktpersonbild (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	foto int(11) unsigned NOT NULL default '0',
	token varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_panorama'
#
CREATE TABLE tx_sgestatecore_domain_model_panorama (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	ordner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_periode'
#
CREATE TABLE tx_sgestatecore_domain_model_periode (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_waehrung'
#
CREATE TABLE tx_sgestatecore_domain_model_waehrung (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	iso_kennzeichen varchar(255) DEFAULT '' NOT NULL,
	symbol varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_austattungskategorie'
#
CREATE TABLE tx_sgestatecore_domain_model_austattungskategorie (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_badausstattung'
#
CREATE TABLE tx_sgestatecore_domain_model_badausstattung (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_kuechenausstattung'
#
CREATE TABLE tx_sgestatecore_domain_model_kuechenausstattung (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_bodenbelag'
#
CREATE TABLE tx_sgestatecore_domain_model_bodenbelag (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_heizungsart'
#
CREATE TABLE tx_sgestatecore_domain_model_heizungsart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_befeuerungsart'
#
CREATE TABLE tx_sgestatecore_domain_model_befeuerungsart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_himmelrichtung'
#
CREATE TABLE tx_sgestatecore_domain_model_himmelrichtung (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_dachform'
#
CREATE TABLE tx_sgestatecore_domain_model_dachform (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_bauweise'
#
CREATE TABLE tx_sgestatecore_domain_model_bauweise (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_ausbaustufe'
#
CREATE TABLE tx_sgestatecore_domain_model_ausbaustufe (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_energietyp'
#
CREATE TABLE tx_sgestatecore_domain_model_energietyp (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_zustand'
#
CREATE TABLE tx_sgestatecore_domain_model_zustand (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_bebaubarnach'
#
CREATE TABLE tx_sgestatecore_domain_model_bebaubarnach (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_erschliessung'
#
CREATE TABLE tx_sgestatecore_domain_model_erschliessung (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_erschliessungdetails'
#
CREATE TABLE tx_sgestatecore_domain_model_erschliessungdetails (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_anhangtyp'
#
CREATE TABLE tx_sgestatecore_domain_model_anhangtyp (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_anhang'
#
CREATE TABLE tx_sgestatecore_domain_model_anhang (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	immobilie int(11) unsigned DEFAULT '0' NOT NULL,

	titel varchar(255) DEFAULT '' NOT NULL,
	format varchar(255) DEFAULT '' NOT NULL,
	datei varchar(255) DEFAULT '' NOT NULL,
	typ int(11) unsigned DEFAULT '0',

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_usersimple'
#
CREATE TABLE tx_sgestatecore_domain_model_usersimple (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	immobilie int(11) unsigned DEFAULT '0' NOT NULL,

	feldname varchar(255) DEFAULT '' NOT NULL,
	wert text DEFAULT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_userextend'
#
CREATE TABLE tx_sgestatecore_domain_model_userextend (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	immobilie int(11) unsigned DEFAULT '0' NOT NULL,

	name varchar(255) DEFAULT '' NOT NULL,
	wert varchar(255) DEFAULT '' NOT NULL,
	typ varchar(255) DEFAULT '' NOT NULL,
	modus varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_kampagne'
#
CREATE TABLE tx_sgestatecore_domain_model_kampagne (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_anhang'
#
CREATE TABLE tx_sgestatecore_domain_model_anhang (

	immobilie  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_sgestatecore_domain_model_usersimple'
#
CREATE TABLE tx_sgestatecore_domain_model_usersimple (

	immobilie  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_sgestatecore_domain_model_userextend'
#
CREATE TABLE tx_sgestatecore_domain_model_userextend (

	immobilie  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_sgestatecore_immobilie_nutzungsart_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_nutzungsart_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_vermarktungsart_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_vermarktungsart_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_weitereadressen_kontaktperson_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_badausstattung_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_badausstattung_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_kuechenausstattung_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_kuechenausstattung_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_bodenbelag_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_bodenbelag_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_heizungsart_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_heizungsart_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_befeuerungsart_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_befeuerungsart_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_himmelrichtung_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_himmelrichtung_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_dachform_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_dachform_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_bauweise_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_bauweise_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_ausbaustufe_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_ausbaustufe_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_erschliessungdetails_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_erschliessungdetails_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_domain_model_stadtteil'
#
CREATE TABLE tx_sgestatecore_domain_model_stadtteil (

	ort  int(11) unsigned DEFAULT '0' NOT NULL,

);


#
# Table structure for table 'tx_sgestatecore_objektart_objektarttyp_mm'
#
CREATE TABLE tx_sgestatecore_objektart_objektarttyp_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_immobilie_kampagne_mm'
#
CREATE TABLE tx_sgestatecore_immobilie_kampagne_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_domain_model_altertyp'
#
CREATE TABLE tx_sgestatecore_domain_model_altertyp (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_energiepassart'
#
CREATE TABLE tx_sgestatecore_domain_model_energiepassart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_energiepassjahrgang'
#
CREATE TABLE tx_sgestatecore_domain_model_energiepassjahrgang (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_energiepassgebaeudeart'
#
CREATE TABLE tx_sgestatecore_domain_model_energiepassgebaeudeart (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_ausblick'
#
CREATE TABLE tx_sgestatecore_domain_model_ausblick (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_geschlecht'
#
CREATE TABLE tx_sgestatecore_domain_model_geschlecht (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_domain_model_verkaufstatus'
#
CREATE TABLE tx_sgestatecore_domain_model_verkaufstatus (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	kuerzel varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

#
# Table structure for table 'tx_sgestatecore_stadtteil_stadtteil_mm'
#
CREATE TABLE tx_sgestatecore_stadtteil_stadtteil_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE tx_sgestatecore_domain_model_karte (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	image text DEFAULT NULL,
	eintraege int(11) unsigned DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

CREATE TABLE tx_sgestatecore_domain_model_karteeintrag (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

  karte int(11) unsigned DEFAULT '0',
  position_x double(11,2) DEFAULT '0.00' NOT NULL,
  position_y double(11,2) DEFAULT '0.00' NOT NULL,
	bezeichner varchar(255) DEFAULT '' NOT NULL,
	image text DEFAULT NULL,
	content text DEFAULT NULL,
	additional_content tinyint(4) unsigned DEFAULT '0' NOT NULL,
	darstellung varchar(255) DEFAULT '' NOT NULL,
	landing_page varchar(255) DEFAULT '' NOT NULL,
	target_page varchar(255) DEFAULT '' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
 KEY language (l10n_parent,sys_language_uid)

);

CREATE TABLE tx_sgestatecore_geocode_cache (
  country varchar(255) DEFAULT '' NOT NULL,
  zip varchar(255) DEFAULT '' NOT NULL,
  street varchar(255) DEFAULT '' NOT NULL,
  housenumber varchar(255) DEFAULT '' NOT NULL,
  longitude double(11,8) DEFAULT '0.00000000' NOT NULL,
  latitude double(11,8) DEFAULT '0.00000000' NOT NULL,
);

#
# Table structure for table 'tx_sgestatecore_domain_model_region'
#
CREATE TABLE tx_sgestatecore_domain_model_region (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	bezeichner varchar(255) DEFAULT '' NOT NULL,
	orte int(11) unsigned DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
    KEY language (l10n_parent,sys_language_uid)
);

#
# Table structure for table 'tx_sgestatecore_region_ort_mm'
#
CREATE TABLE tx_sgestatecore_region_ort_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_domain_model_contentblock'
#
CREATE TABLE tx_sgestatecore_domain_model_contentblock (

	uid int(11) NOT NULL auto_increment,
	pid int(11) DEFAULT '0' NOT NULL,

	internal_identifier varchar(255) DEFAULT '' NOT NULL,
	headline varchar(255) DEFAULT '' NOT NULL,
	body mediumtext DEFAULT '' NULL,
	image_main varchar(255) DEFAULT '' NOT NULL,
	image_optional varchar(255) DEFAULT '' NOT NULL,
	link_caption varchar(255) DEFAULT '' NOT NULL,
	link varchar(255) DEFAULT '' NOT NULL,
	block_type varchar(255) DEFAULT '' NOT NULL,
	districts int(11) DEFAULT '0' NOT NULL,
	cities int(11) DEFAULT '0' NOT NULL,
	regions int(11) DEFAULT '0' NOT NULL,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
	hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,

	t3ver_oid int(11) DEFAULT '0' NOT NULL,
	t3ver_id int(11) DEFAULT '0' NOT NULL,
	t3ver_wsid int(11) DEFAULT '0' NOT NULL,
	t3ver_label varchar(255) DEFAULT '' NOT NULL,
	t3ver_state tinyint(4) DEFAULT '0' NOT NULL,
	t3ver_stage int(11) DEFAULT '0' NOT NULL,
	t3ver_count int(11) DEFAULT '0' NOT NULL,
	t3ver_tstamp int(11) DEFAULT '0' NOT NULL,
	t3ver_move_id int(11) DEFAULT '0' NOT NULL,

	sys_language_uid int(11) DEFAULT '0' NOT NULL,
	l10n_parent int(11) DEFAULT '0' NOT NULL,
	l10n_diffsource mediumblob,

	PRIMARY KEY (uid),
	KEY parent (pid),
	KEY t3ver_oid (t3ver_oid,t3ver_wsid),
    KEY language (l10n_parent,sys_language_uid)
);

#
# Table structure for table 'tx_sgestatecore_contentblock_stadtteil_mm'
#
CREATE TABLE tx_sgestatecore_contentblock_stadtteil_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_contentblock_ort_mm'
#
CREATE TABLE tx_sgestatecore_contentblock_ort_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_sgestatecore_contentblock_region_mm'
#
CREATE TABLE tx_sgestatecore_contentblock_region_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);
