<?php
namespace SG\SgEstateCore\Domain\Model;

/**
 * Stadtteil
 */
class Stadtteil extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity {

	/**
	 * bezeichner
	 *
	 * @var string
	 */
	protected $bezeichner = '';

	/**
	 * fuerSucheVerwenden
	 *
	 * @var boolean
	 */
	protected $fuerSucheVerwenden = FALSE;

    /**
     * @var \SG\SgEstateCore\Domain\Model\Ort
     */
    protected $ort;

    /**
     * nachbarStadtteile
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil>
     */
    protected $nachbarStadtteile;

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects() {
        $this->nachbarStadtteile = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

	/**
	 * Returns the bezeichner
	 *
	 * @return string $bezeichner
	 */
	public function getBezeichner() {
		return $this->bezeichner;
	}

	/**
	 * Sets the bezeichner
	 *
	 * @param string $bezeichner
	 * @return void
	 */
	public function setBezeichner($bezeichner) {
		$this->bezeichner = $bezeichner;
	}

	/**
	 * Returns the fuerSucheVerwenden
	 *
	 * @return boolean $fuerSucheVerwenden
	 */
	public function getFuerSucheVerwenden() {
		return $this->fuerSucheVerwenden;
	}

	/**
	 * Sets the fuerSucheVerwenden
	 *
	 * @param boolean $fuerSucheVerwenden
	 * @return void
	 */
	public function setFuerSucheVerwenden($fuerSucheVerwenden) {
		$this->fuerSucheVerwenden = $fuerSucheVerwenden;
	}

	/**
	 * Returns the boolean state of fuerSucheVerwenden
	 *
	 * @return boolean
	 */
	public function isFuerSucheVerwenden() {
		return $this->fuerSucheVerwenden;
	}

    public function getOrt(){
        return $this->ort;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage $nachbarStadtteile
     */
    public function setNachbarStadtteile($nachbarStadtteile)
    {
        $this->nachbarStadtteile = $nachbarStadtteile;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage
     */
    public function getNachbarStadtteile()
    {
        return $this->nachbarStadtteile;
    }



}