<?php
namespace SG\SgEstateBase\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Region;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RegionsForCityViewHelper extends AbstractViewHelper
{
    /**
     * @var RegionRepository
     */
    private $regionRepository;

    public function __construct(\SG\SgEstateCore\Domain\Repository\RegionRepository $regionRepository, \SG\SgEstateCore\Domain\Repository\OrtRepository $ortRepository)
    {
        $this->regionRepository = $regionRepository;
        $this->ortRepository = $ortRepository;
    }

    /**
     * @var OrtRepository
     */
    private $ortRepository;

    public function initializeArguments(): void
    {
        parent::initializeArguments(); // TODO: Change the autogenerated stub
        $this->registerArgument('cityUid', 'int', 'UID of City');
        $this->registerArgument('prestring', 'string', 'Identifier for classname');
    }

    public function render()
    {
        $classes = [];
        $city = $this->ortRepository->findByUid($this->arguments['cityUid']);
        if ($city instanceof Ort) {
            $regions = $this->regionRepository->findRegionsForCity($city);
            foreach ($regions as $region) {
                /**
                 * @var Region $region
                 */
                $classes[] = $this->arguments['prestring'] . '-' . $region->getUid();
            }
        }

        return implode(' ', $classes);
    }
}
