<?php

declare(strict_types=1);

namespace SG\SgEstateBase\Updates;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Install\Attribute\UpgradeWizard;
use TYPO3\CMS\Install\Updates\UpgradeWizardInterface;

#[UpgradeWizard('sgestatebase_invalidListTypeUpgradeWizard')]
final class InvalidListTypeUpgradeWizard implements UpgradeWizardInterface
{

    public function __construct(
        private readonly ConnectionPool $connectionPool
    )
    {}

    public function getTitle(): string
    {
        return 'Find invalid list_types.';
    }

    public function getDescription(): string
    {
        return 'The "SG SgEstateBase" plugin Landingpage from Base Extension is not longer provided by base extension, please install sg.estate.landingpage or delete the entries from tt_content';
    }

    public function executeUpdate(): bool
    {
        return false;
    }

    public function updateNecessary(): bool
    {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('tt_content');
        $result = $queryBuilder
            ->select('uid', 'pid')
            ->from('tt_content')
            ->where(
                $queryBuilder->expr()->eq('list_type', $queryBuilder->createNamedParameter('sgestatebase_pi2'))
            )
            ->executeQuery();
        if ($result->rowCount() >= 1) {
            return true;
        }
        return false;
    }

    public function getPrerequisites(): array
    {
        return [];
    }
}