<?php

declare(strict_types=1);

namespace SG\SgEstateBase\Backend\EventListener;

use TYPO3\CMS\Backend\View\Event\PageContentPreviewRenderingEvent;
use TYPO3\CMS\Core\Attribute\AsEventListener;

#[AsEventListener(
    identifier: 'sg-estate-base/page-layout-preview-rendering',
)]
final readonly class PageLayoutViewListener
{
    const REPLACEMAKER = '###REPLACEME###';
    const PREVIEW_CONTENT_TEMPLATE = '<b>sg.estate.base - ###REPLACEME###</b><br>';

    public function __invoke(PageContentPreviewRenderingEvent $event): void
    {
        if ($event->getTable() !== 'tt_content') {
            return;
        }

        switch ($event->getRecordType()) {
            case 'SgEstateBaseSearch':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Suchbox'));
                break;
            case 'SgEstateBaseContact':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Anfrage'));
                break;
            case 'SgEstateBaseList':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Suchergebnis'));
                break;
            case 'SgEstateBaseDetail':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Exposee'));
                break;
            case 'SgEstateBaseSearchbox':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Suchbox (klein)'));
                break;
            case 'SgEstateBaseLandingpage':
                $event->setPreviewContent(str_replace(self::REPLACEMAKER, self::PREVIEW_CONTENT_TEMPLATE, 'Landingpage'));
                break;
        }
    }
}