<?php

namespace SG\SgEstateBase\Util;

use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\SingletonInterface;

/** @noinspection PhpUnused */
class AddFields implements SingletonInterface
{

    /**
     * Adds Template Layouts from PageTS to Flexform of Search Plugin
     *
     * @noinspection PhpUnused
     */
    public function addSearchTemplateLayouts(array $config): array
    {
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);

        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['search.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['search.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['search.'];
        } else {
            return $config;
        }

        $optionList = [];
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
                0 => $value,
                1 => $key
            ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of List Plugin
     *
     * @noinspection PhpUnused
     */
    public function addListTemplateLayouts(array $config): array
    {
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['list.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['list.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['list.'];
        } else {
            return $config;
        }

        $optionList = [];
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
                0 => $value,
                1 => $key
            ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Detail Plugin
     *
     * @noinspection PhpUnused
     */
    public function addDetailTemplateLayouts(array $config): array
    {
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.'];
        } else {
            return $config;

        }

        $optionList = [];
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
                0 => $value,
                1 => $key
            ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Detail Plugin
     *
     * @noinspection PhpUnused
     */
    public function addContactTemplateLayouts(array $config): array
    {
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.'];
        } else {
            return $config;
        }

        $optionList = [];
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
                0 => $value,
                1 => $key
            ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

}
