<?php
namespace SG\SgEstateBase\Controller;

use SG\SgEstateCore\Domain\Model\Badausstattung;
use SG\SgEstateCore\Domain\Model\Filter;
use SG\SgEstateCore\Domain\Model\Heizungsart;
use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Kontaktperson;
use SG\SgEstateCore\Domain\Model\Objektart;
use SG\SgEstateCore\Domain\Model\Objektarttyp;
use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Region;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\ImmobilieRepository;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\ObjektarttypRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use SG\SgEstateCore\Domain\Repository\StadtteilRepository;
use SG\SgEstateCore\Util\Services;
use SG\SgEstateCore\Util\SessionHandler;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Mvc\Exception\StopActionException;
use TYPO3\CMS\Extbase\Mvc\Exception\UnsupportedRequestTypeException;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Service\ImageService;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;
use TYPO3\CMS\Frontend\Controller\ErrorController;
use TYPO3\CMS\Core\Http\ImmediateResponseException;

class BaseController extends ActionController
{

    /**
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * @param RegionRepository $regionRepository
     */
    public function injectRegionRepository(RegionRepository $regionRepository)
    {
        $this->regionRepository = $regionRepository;
    }

    /**
     * @var OrtRepository
     */
    protected $ortRepository;

    /**
     * @param OrtRepository $ortRepository
     */
    public function injectOrtRepository(OrtRepository $ortRepository)
    {
        $this->ortRepository = $ortRepository;
    }

    /**
     * @var StadtteilRepository
     */
    protected $stadtteilRepository;

    /**
     * @param StadtteilRepository $stadtteilRepository
     */
    public function injectStadtteilRepository(StadtteilRepository $stadtteilRepository)
    {
        $this->stadtteilRepository = $stadtteilRepository;
    }

    /**
     * @var ImmobilieRepository
     */
    protected $immobilieRepository;

    /**
     * @param ImmobilieRepository $immobilieRepository
     */
    public function injectImmobilieRepository(ImmobilieRepository $immobilieRepository)
    {
        $this->immobilieRepository = $immobilieRepository;
    }

    /**
     * @var ObjektartRepository
     */
    protected $objektartRepository;

    /**
     * @param ObjektartRepository $objektartRepository
     */
    public function injectObjektArtRepository(ObjektartRepository $objektartRepository)
    {
        $this->objektartRepository = $objektartRepository;
    }

    /**
     * @var ObjektarttypRepository
     */
    protected $objektarttypRepository;

    /**
     * @param ObjektarttypRepository $objektarttypRepository
     */
    public function injectObjektarttypRepository(ObjektarttypRepository $objektarttypRepository)
    {
        $this->objektarttypRepository = $objektarttypRepository;
    }

    /**
     * @var HeizungsartRepository
     */
    protected $heizungsartRepository;

    /**
     * @param HeizungsartRepository $heizungsartRepository
     */
    public function injectHeizungsartRepository(HeizungsartRepository $heizungsartRepository)
    {
        $this->heizungsartRepository = $heizungsartRepository;
    }

    /**
     * @var SessionHandler
     */
    protected $sessionHandler;

    /**
     * @param SessionHandler $sessionHandler
     */
    public function injectSessionHandler(SessionHandler $sessionHandler)
    {
        $this->sessionHandler = $sessionHandler;
    }

    /**
     * @var Services
     */
    protected $sgEstateCoreServices;

    /**
     * @param Services $services
     */
    public function injectSgEstateCoreServices(Services $services)
    {
        $this->sgEstateCoreServices = $services;
    }

    /**
     * @var ImageService
     */
    protected $imageService;

    /**
     * @param ImageService $imageService
     */
    public function injectImageService(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    /**
     * @param UriBuilder $uriBuilder
     */
    public function injectUriBuilder(UriBuilder $uriBuilder)
    {
        $this->uriBuilder = $uriBuilder;
    }

    /**
     * @var Filter
     */
    protected $filter;

    /**
     * @var FrontendInterface
     */
    protected $cache;

    /**
     * @var bool
     */
    protected $noSearchParameters = false;

    public function __construct(FrontendInterface $cache)
    {
        $this->cache = $cache;
    }

    /**
     * Initializing is called before every Action
     *
     * @throws NoSuchArgumentException
     */
    public function initializeAction()
    {
        $this->setFilter();
    }

    /********************************************
     * Actions for MVC
     *********************************************/

    /**
     * Action for Standard Search
     */
    public function searchAction()
    {

        $shows = '0';
        if($this->settings['show']) {
            if (is_array($this->settings['show']))
                $shows = implode('', $this->settings['show']);
            if (is_string($this->settings['show']))
                $shows = $this->settings['show'];
            if (is_int($this->settings['show']))
                $shows = (string)$this->settings['show'];
        }
        $cacheIdentifier = 'search_' . $this->settings['search']['layout'] . '_' . $shows . '_' . $this->settings['search']['layout'] . '_L' . $this->getLanguageUid();

        if (($entry = $this->cache->get($cacheIdentifier)) === false) {
            if ($this->settings['preset']['search']['filterData'] != 0) {
                $kindOfObjectUids = explode(',', $this->settings['search']['kindOfObjects']);
                foreach ($kindOfObjectUids as $kindOfObjectUid) {
                    $kindOfObject = $this->objektartRepository->findByUid($kindOfObjectUid);
                    if ($kindOfObject instanceof Objektart) {
                        $this->filter->addObjektart($kindOfObject);
                    }
                }

                if (isset($this->settings['importids']) && $this->settings['importids'] != '') {
                    $arrayOfImportIds = explode(',', $this->settings['importids']);
                    if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1) {
                        $this->filter->setImportIds($arrayOfImportIds);
                    } else {
                        $this->filter->setImportIds([]);
                    }
                } else {
                    $arrayOfImportIds = null;
                }

                if ($this->settings['preset']['search']['useSlider'] == 1) {
                    // BEGIN: Assign Values for Slider-Configuration to View
                    $this->view->assign('sizeSliderData', $this->getSizeSliderData());
                    $this->view->assign('roomSliderData', $this->getRoomSliderData());
                    $this->view->assign('amountSliderData', $this->getAmountSliderData());
                    // END: Assign Values for Slider-Configuration to View
                }

                $this->view->assign('regionOptions', $this->regionRepository->getAllForFilter($arrayOfImportIds));
                $this->view->assign('districtOptions', $this->stadtteilRepository->getAllForFilter($this->settings['preset']['search']['districtFormat'], $arrayOfImportIds));
                $this->view->assign('cityOptions', $this->ortRepository->getAllForFilter($arrayOfImportIds));
                $this->view->assign('groupedCitiesAndDistricts', $this->ortRepository->getGroupedCitiesAndDistrictsForFilter($arrayOfImportIds));
                $this->view->assign('filter', $this->filter);
                $this->view->assign('cities', $this->ortRepository->findAll());


                $this->view->assign('aggregatedFilterData', json_encode($this->getAggregatedFilterData()));
                $this->view->assign('citiesAndDistrictsForFilter', json_encode($this->generateCityAndDistrictStructureForFilter()));

                if ($this->settings['preset']['search']['simpleRealtyData'] == 1){
                    $returnArray = $this->immobilieRepository->findAllWithFilterData();
                    if ($this->settings['search']['useStructuredCitiesAndDistricts'] == 1){
                        $cities = $this->ortRepository->getStructuredCitiesAndDistricts();
                        $this->view->assign('places', $cities);
                    }
                    else {
                        //$realtiesModifited = $returnArray['realties'];
                        //$this->view->assign('places', $returnArray['cities']);

                        $result = $this->immobilieRepository->findAll();
                        $cities = [];
                        foreach ($result as $realty) {
                            /**
                             * Identifiy those cities and districts that lead to valid results (take all realties locations)
                             * @var $realty Immobilie
                             */
                            $cities[$realty->getObjektOrt()->getUid()]['bezeichner'] = $realty->getObjektOrt()->getBezeichner();
                            if (is_object($realty->getObjektStadtteil()) && ($realty->getAnzahlZimmer() >= 1)) {
                                $cities[$realty->getObjektOrt()->getUid()]['districts'][$realty->getObjektStadtteil()->getUid()] = [
                                    'uid' => $realty->getObjektStadtteil()->getUid(),
                                    'bezeichner' => $realty->getObjektStadtteil()->getBezeichner()
                                ];
                            }
                        }
                        $realtiesModifited = $returnArray['realties'];

                        $this->view->assign('places', $returnArray['cities']);
                        //$this->view->assign('places', $cities);



                    }
                }
                else {
                    $realties = $this->immobilieRepository->findAllWithFilter($this->filter);
                    $this->view->assign('presets', $this->generateFilterPresetsFromResult($realties));

                    $this->view->assign('realties', $realties);
                    $realtiesModifited = array();
                    foreach ($realties as $k => $v) {
                        $realtiesModifited[$k]['anzahlZimmer'] = $v->getAnzahlZimmer();
                        $realtiesModifited[$k]['vermietbareFlaeche'] = $v->getVermietbareFlaeche();
                        $realtiesModifited[$k]['kaltmiete'] = $v->getKaltmiete();
                        $realtiesModifited[$k]['objektOrt'] = is_null($v->getObjektOrt()) ? '' : 'region-' . $v->getObjektOrt()->getUid();
                        $realtiesModifited[$k]['objektStadtteil'] = is_null($v->getObjektStadtteil()) ? '' : 'district-' . $v->getObjektStadtteil()->getUid();
                    }
                }
                $this->view->assign('realtiesModifited', $realtiesModifited);
            }

            $entry = $this->view->render();

            $tags = ['search'];
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
    }

    /**
     * Action for Standard Searchbox
     */
    public function searchboxAction()
    {
        $kindOfObjectUids = explode(',', $this->settings['search']['kindOfObjects']);
        foreach ($kindOfObjectUids as $kindOfObjectUid) {
            $kindOfObject = $this->objektartRepository->findByUid($kindOfObjectUid);
            if ($kindOfObject instanceof Objektart) {
                $this->filter->addObjektart($kindOfObject);
            }
        }
        if (isset($this->settings['importids']) && $this->settings['importids'] != '') {
            $arrayOfImportIds = explode(',', $this->settings['importids']);
            if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1) {
                $this->filter->setImportIds($arrayOfImportIds);
            } else {
                $this->filter->setImportIds([]);
            }
        } else {
            $arrayOfImportIds = null;
        }
        $this->view->assign('regionOptions', $this->regionRepository->getAllForFilter($arrayOfImportIds));
        $this->view->assign('districtOptions', $this->stadtteilRepository->getAllForFilter($this->settings['preset']['search']['districtFormat'], $arrayOfImportIds));
        $this->view->assign('cityOptions', $this->ortRepository->getAllForFilter($arrayOfImportIds));
        $this->view->assign('groupedCitiesAndDistricts', $this->ortRepository->getGroupedCitiesAndDistrictsForFilter($arrayOfImportIds));
        $this->view->assign('filter', $this->filter);
        $this->view->assign('cities', $this->ortRepository->findAll());
        return $this->view->render();
    }

    /**
     * Action for Standard List View
     */
    public function listAction()
    {
        /**
         * @var $filter Filter
         */
        if (isset($this->settings['importids']) && $this->settings['importids'] != '') {
            $arrayOfImportIds = explode(',', $this->settings['importids']);
            if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1) {
                $this->filter->setImportIds($arrayOfImportIds);
            } else {
                $this->filter->setImportIds([]);
            }
        } else {
            $arrayOfImportIds = null;
        }

        if (isset($this->settings['list']['layout']) && $this->settings['list']['layout'] == 'LiveSearch') {
            $filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');

            // add city to this filte
            $ort = $this->filter->getOrt();
            if ($ort instanceof Ort) {
                $filter->addOrt($ort);
            }
            if (isset($this->settings['importids']) && $this->settings['importids'] != '') {
                $filter->setImportIds($this->filter->getImportIds());
            }

            $filterToUse = $filter;
            $cacheIdentifier = 'list_' . $this->filter->getCacheIdentifier() . '_L' . $this->getLanguageUid();
        } else {
            $filterToUse = $this->filter;
            $cacheIdentifier = 'list_' . $filterToUse->getCacheIdentifier() . '_L' . $this->getLanguageUid();
        }

        if ($this->noSearchParameters && $this->settings['list']['noParametersNoResults'] !== '0') {
            if (($entry = $this->cache->get('sg_estate_base_empty_result' . '_L' . $this->getLanguageUid())) === false) {
                $this->view->assign('realties', []);
                $this->view->assign('aggregatedFilterData', json_encode([]));
                $this->view->assign('citiesAndDistrictsForFilter', json_encode($this->generateCityAndDistrictStructureForFilter()));

                $this->view->assign('presets', $this->generateFilterPresetsFromResult([]));

                $entry = $this->view->render();

                $tags = ['listing', 'searchresult'];
                $lifetime = $this->settings['defaultCacheLifetime'];

                // Save value in cache
                $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
            }
            return $entry;
        } else {
            if (($entry = $this->cache->get($cacheIdentifier)) === false) {
                $realties = $this->immobilieRepository->findAllWithFilter($filterToUse);

                // Sorting data by current city
                if ($this->settings['preset']['search']['sortByCurrentCity'] == 1) {
                    $cityName = explode(',', $filterToUse->getAddressString());
                    $sortingData1 = [];
                    $sortingData2 = [];
                    foreach ($realties as $key => $realty) {
                        if ($cityName[0] == $realty->getObjektOrt()->getBezeichner()) {
                            $sortingData1[$key] = $realty;
                        } else {
                            $sortingData2[$key] = $realty;
                        }
                    }
                    $realties = array_merge($sortingData1, $sortingData2);
                }

                if ($this->settings['preset']['search']['swoppenExt'] == 1 && count($realties) > 0) {
                    $lastimportRepository = $this->objectManager->get('SG\SgEstateImportSwoppen\Domain\Repository\LastimportRepository');
                    $lastImport = $lastimportRepository->findLastTstempByImportId(array($realties[0]->getImportNumber()));
                    $this->view->assign('lastImport', $lastImport);
                }

                if ($this->settings['preset']['search']['useSlider'] == 1) {
                    // BEGIN: Assign Values for Slider-Configuration to View
                    $this->view->assign('sizeSliderData', $this->getSizeSliderData());
                    $this->view->assign('roomSliderData', $this->getRoomSliderData());
                    $this->view->assign('amountSliderData', $this->getAmountSliderData());
                    // END: Assign Values for Slider-Configuration to View
                }
                $this->view->assign('realties', $realties);
                $this->view->assign('instantFilter', $this->generateInstantFilterPresetsFromResult($realties));
                $this->view->assign('districtOptions', $this->stadtteilRepository->getAllForFilter($this->settings['preset']['search']['districtFormat'], $arrayOfImportIds));
                $this->view->assign('cityOptions', $this->ortRepository->getAllForFilter($arrayOfImportIds));
                $this->view->assign('groupedCitiesAndDistricts', $this->ortRepository->getGroupedCitiesAndDistrictsForFilter($arrayOfImportIds));
                $this->view->assign('filter', $this->filter);
                $this->view->assign('aggregatedFilterData', json_encode($this->getAggregatedFilterData()));
                $this->view->assign('citiesAndDistrictsForFilter', json_encode($this->generateCityAndDistrictStructureForFilter()));

                $this->view->assign('presets', $this->generateFilterPresetsFromResult($realties));

                $entry = $this->view->render();

                $tags = ['listing', 'searchresult'];
                $lifetime = $this->settings['defaultCacheLifetime'];

                // Save value in cache
                $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
            }
            return $entry;
        }
    }

    /**
     * @param string $realty Without any route enhancer the urlIdentifier (externalId) will be passed.
     *                       With route enhancer the uid of the estate item will be passed.
     *                       You can also always pass the uid of the element.
     *
     * @return string|null
     * @throws NoSuchArgumentException
     * @throws StopActionException
     */
    public function detailAction(string $realty='')
    {
        $entry      = null;
        $noCache    = isset($this->settings['detail']['cache'])
            ? $this->settings['detail']['cache'] : 0;

        /**
         * @var $filter Filter
         */
        if (isset($this->settings['importids']) && $this->settings['importids'] != '') {
            $arrayOfImportIds = explode(',', $this->settings['importids']);
            if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1) {
            } else {
                $arrayOfImportIds = [];
            }
        }
        else {
            $arrayOfImportIds = [];
        }

        if(!empty($realty)) {
            if($noCache != 1) {
                $cacheIdentifier = 'detail_' . sha1($realty.$this->settings['importids']) . '_L' . $this->getLanguageUid();
                if(($entry = $this->cache->get($cacheIdentifier)) === false) {
                    if ((int) $realty > 0) {
                        $estateItem = $this->immobilieRepository->findByUid((int)$realty, $arrayOfImportIds);
                    }

                    if (!($estateItem instanceof Immobilie)) {
                        $estateItem = $this->immobilieRepository->findOneByUrlIdentifier($realty, $arrayOfImportIds);
                    }
                    if (!$estateItem instanceof Immobilie){
                        $response = GeneralUtility::makeInstance(ErrorController::class)->pageNotFoundAction(
                            $GLOBALS['TYPO3_REQUEST'],
                            'your 404 message'
                        );
                        throw new ImmediateResponseException($response);
                    }
                    $this->view->assign('realty', $estateItem);
                    $this->view->assign('filter', $this->filter);
                    $entry = $this->view->render();
                    $tags = ['detail'];
                    $lifetime = $this->settings['defaultCacheLifetime'];
                    $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                }
            } else {
                if((int) $realty > 0)
                    $estateItem = $this->immobilieRepository->findByUid((int)$realty, $arrayOfImportIds);
                if(!$estateItem instanceof Immobilie)
                    $estateItem = $this->immobilieRepository->findOneByUrlIdentifier($realty, $arrayOfImportIds);
                if (!$estateItem instanceof Immobilie){
                    $response = GeneralUtility::makeInstance(ErrorController::class)->pageNotFoundAction(
                        $GLOBALS['TYPO3_REQUEST'],
                        'your 404 message'
                    );
                    throw new ImmediateResponseException($response);
                }
                $this->view->assign('realty', $estateItem);
                $this->view->assign('filter', $this->filter);
                $entry = $this->view->render();
            }
        } else
            $this->redirectToUri('/');
        return $entry;
    }

    /**
     * Action for Standard Contact Form & Process
     *
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    public function contactAction()
    {
        $this->pregenerateContactForm();
        if ($this->request->hasArgument('realty')) {
            $realty = $this->immobilieRepository->findOneByUrlIdentifier($this->request->getArgument('realty'));
            $this->view->assign('realty', $realty);
        } elseif ($this->request->hasArgument('formValues')) {
            $this->processContactForm();
        } else {
            $this->redirectToUri('/');
        }
    }

    /**
     * Action for Mapinfo Called via AJAX
     */
    public function mapinfoAction()
    {
        if (isset($_REQUEST['uid'])&&is_numeric($_REQUEST['uid'])) {
            $cacheIdentifier = 'mapinfo_' . sha1($_REQUEST['uid']);

            if (($entry = $this->cache->get($cacheIdentifier)) === false) {
                $immobilie = $this->immobilieRepository->findByUid($_REQUEST['uid']);
                if ($immobilie instanceof \SG\SgEstateCore\Domain\Model\Immobilie) {
                    $this->view->assign('realty', $immobilie);
                    $entry = $this->view->render();

                    $tags = ['mapinfo'];
                    $lifetime = $this->settings['defaultCacheLifetime'];

                    // Save value in cache
                    $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                } else {
                    $entry = '';
                }
            }
            return $entry;
        } else {
            return '';
        }
    }

    protected function generateCityAndDistrictStructureForFilter()
    {
        $cityAndDistrictStructure = [];

        foreach ($this->ortRepository->findAll() as $city) {
            /**
             * @var $city Ort
             */
            $city_qtys = is_null($city->getAnzahlImmobilienArray()) ? array() : $city->getAnzahlImmobilienArray();
            $city_qty = in_array('WOHNUNG', array_keys($city_qtys)) ? $city_qtys['WOHNUNG'] : 0;
            $newCity = [
                'caption' => $city->getBezeichner(),
                'uid' => $city->getUid(),
                'qty' => $city_qty
            ];
            if (count($city->getStadtteile()) > 0) {
                $newDistricts = [];
                foreach ($city->getStadtteile() as $district) {
                    /**
                     * @var $district Stadtteil
                     */
                    $district_qtys = is_null($city->getAnzahlImmobilienArray()) ? array() : $city->getAnzahlImmobilienArray();
                    $district_qty = in_array('WOHNUNG', array_keys($district_qtys)) ? $district_qtys['WOHNUNG'] : 0;
                    $newDistrict = [
                        'caption' => $district->getBezeichner(),
                        'uid' => $district->getUid(),
                        'qty' => $district_qty
                    ];
                    $newDistricts[] = $newDistrict;
                }
                $newCity['districts'] = $newDistricts;
            }
            $cityAndDistrictStructure[] = $newCity;
        }
        return $cityAndDistrictStructure;
    }

    /**
     * Action used for several AJAX Calls
     *
     * ViewHelper for URI Function "allRealties" <f:uri.action action='ajax' controller='Base' arguments='{function:"allRealties"}' additionalParams='{type: 1403693888}' noCacheHash='true' />
     *
     * @return mixed|string
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    public function ajaxAction()
    {
        if ($this->request->hasArgument('function')) {
            $function = $this->request->getArgument('function');
            $this->view->assign('function', ucfirst($function));
            switch ($function) {

//                case 'realtiesForReactApplication':
//                    //$cacheIdentifier = 'ajax_realtiesForReactApplication';
//                    //if (($entry = $this->cache->get($cacheIdentifier)) === false) {
//                        $allRealties = $this->immobilieRepository->findAll();
//                        $arrayReturn = [
//                            'realties' => []
//                        ];
//                        $processingInstructions = [
//                            'width' => '150c',
//                            'height' => '112c',
//                        ];
//                        foreach ($allRealties as $realty) {
//                            /**
//                             * @var $realty Immobilie
//                             */
//                            $district = [];
//                            if ($realty->getObjektStadtteil() instanceof Stadtteil) {
//                                $district = [
//                                    'id' => $realty->getObjektStadtteil()->getUid(),
//                                    'name' => $realty->getObjektStadtteil()->getBezeichner()
//                                ];
//                            }
//                            $image = $this->imageService->getImage(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/' . $realty->getTitelbild()->getDatei(), null, false);
//                            $processedImage = $this->imageService->applyProcessingInstructions($image, $processingInstructions);
//
//                            array_push($arrayReturn['realties'], [
//                                'show' => false,
//                                'highlighted' => false,
//                                'id' => $realty->getUid(),
//                                'type' => $realty->getObjektart()->getKuerzel(),
//                                'data' => [
//                                    'objectNumberInternal' => $realty->getObjektnrIntern(),
//                                    'objectNumberExternal' => $realty->getObjektnrExtern(),
//                                    'openimmoObjid' => $realty->getOpenimmoObjid(),
//                                    'title' => $realty->getObjekttitel(),
//                                    'street' => $realty->getObjektStrasse(),
//                                    'houseNumber' => $realty->getObjektHausnummer(),
//                                    'zip' => $realty->getObjektPlz(),
//                                    'size' => $realty->getWohnflaeche(),
//                                    'rooms' => $realty->getAnzahlZimmer(),
//                                    'rent' => $realty->getNettokaltmiete(),
//                                    'balcony' => $realty->getAnzahlBalkone() > 0 ? true : false,
//                                    'city' => [
//                                        'id' => $realty->getObjektOrt()->getUid(),
//                                        'name' => $realty->getObjektOrt()->getBezeichner()
//                                    ],
//                                    'district' => $district,
//                                    'url' => $this->uriBuilder->reset()->setTargetPageUid($this->settings['pid']['detail'])->uriFor('detail', ['realty' => $realty->getUrlIdentifier()], 'Base', 'sgestatebase', 'pi1')
//                                ],
//                                'media' => [
//                                    'preview' => $this->imageService->getImageUri($processedImage)
//                                ],
//                                'geometry' => [
//                                    'location' => [
//                                        'lat' => $realty->getObjektBreitengrad(),
//                                        'lng' => $realty->getObjektLaengengrad()
//                                    ]
//                                ],
//                            ]);
//                        }
//                        $this->view->assign('jsonReturn', json_encode($arrayReturn));
//
//                        $entry = $this->view->render();
//
//                        $tags = ['ajax_realtiesForReactApplication'];
//                        //$lifetime = $this->settings['defaultCacheLifetime'];
//
//                        // Save value in cache
//                        //$this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
//                    //}
//                    return $entry;
//                    break;


                case 'realtiesForReactApplication':
                    $cw = '150';
                    $ch = '112';
                    $sql = "a.uid AS id, 
                            a.objektnr_intern AS objectNumberInternal,
                            a.objektnr_extern AS objectNumberExternal,
                            a.openimmo_objid AS openimmoObjId,
                            a.objekttitel AS title,
                            a.objekt_strasse AS street,
                            a.objekt_hausnummer AS houseNumber,
                            a.objekt_plz AS zip, 
                            a.wohnflaeche AS size, 
                            a.anzahl_zimmer AS rooms,
                            a.nettokaltmiete AS rent,
                            IF(a.anzahl_balkone > 0, 'true', 'false') as balcony,
                            a.objekt_breitengrad AS lat,
                            a.objekt_laengengrad AS lng,
                            a.objekt_stadtteil AS district_id,
                            IFNULL(b.bezeichner, '') AS district_name,
                            c.kuerzel AS object_art,
                            a.objekt_ort AS city_id,
                            d.bezeichner AS city_name,
                            e.datei AS image, 
                            f.identifier
                        FROM tx_sgestatecore_domain_model_immobilie AS a
                        LEFT JOIN tx_sgestatecore_domain_model_stadtteil AS b ON a.objekt_stadtteil = b.uid 
                        LEFT JOIN tx_sgestatecore_domain_model_objektart AS c ON a.objektart = c.uid
                        LEFT JOIN tx_sgestatecore_domain_model_ort AS d ON a.objekt_ort = d.uid 
                        LEFT JOIN (
                            SELECT immobilie, datei, typ 
                            FROM tx_sgestatecore_domain_model_anhang 
                            WHERE typ IN (1, 7) 
                            GROUP BY immobilie 
                            ORDER BY typ ASC, uid ASC
                        ) AS e ON a.uid = e.immobilie  
                        LEFT JOIN sys_file AS s ON s.name = e.datei
                        LEFT JOIN sys_file_processedfile AS f ON 
                            s.uid = f.original 
                            AND task_type = 'Image.CropScaleMask' 
                            AND width = " . $cw . "
                            AND height = " .$ch;

                    $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');
                    $allRealties = $connection->createQueryBuilder()->addSelectLiteral($sql)->execute()->fetchAll();
                    $arrayReturn = ['realties' => []];
                    $processingInstructions = ['width' => $cw .'c', 'height' => $ch . 'c',];
                    foreach ($allRealties as $realty) {
                        if(!is_null($realty['identifier'])) {
                            $imageUrl = $realty['identifier'];
                        } else {
                            $image = $this->imageService->getImage(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/' . $realty['image'], null, false);
                            $imageUrl = $this->imageService->getImageUri($this->imageService->applyProcessingInstructions($image, $processingInstructions));
                        }
                        $itemUrl = $this->uriBuilder->reset()->setTargetPageUid($this->settings['pid']['detail'])->uriFor('detail', ['realty' => preg_replace(array('/\//','/\\\/'),'-',$realty['objectNumberExternal'])], 'Base', 'sgestatebase', 'pi1');
                        array_push($arrayReturn['realties'], [
                            'show' => false,
                            'highlighted' => false,
                            'id' => $realty['id'],
                            'type' => $realty['object_art'],
                            'data' => [
                                'objectNumberInternal' => $realty['objectNumberInternal'],
                                'objectNumberExternal' => $realty['objectNumberExternal'],
                                'openimmoObjid' => $realty['openimmoObjId'],
                                'title' => $realty['title'],
                                'street' => $realty['street'],
                                'houseNumber' => $realty['houseNumber'],
                                'zip' => $realty['zip'],
                                'size' => $realty['size'],
                                'rooms' => $realty['rooms'],
                                'rent' => $realty['rent'],
                                'balcony' => $realty['balcony'],
                                'city' => [
                                    'id' => $realty['city_id'],
                                    'name' => $realty['city_name']
                                ],
                                'district' => [
                                    'id' => $realty['district_id'],
                                    'name' => $realty['district_name']
                                ],
                                'url' => $itemUrl
                            ],
                            'media' => [
                                'preview' => $imageUrl
                            ],
                            'geometry' => [
                                'location' => [
                                    'lat' => $realty['lat'],
                                    'lng' => $realty['lng']
                                ]
                            ],
                        ]);
                    }
                    $this->view->assign('jsonReturn', json_encode($arrayReturn));
                    $entry = $this->view->render();
                    return $entry;
                    break;

                case 'allRealties':
                    $cacheIdentifier = 'ajax_allRealties';

                    if (($entry = $this->cache->get($cacheIdentifier)) === false) {
                        $allRealties = $this->immobilieRepository->findAll();
                        $arrayReturn = [
                            'realties' => [],
                            'cities' => [],
                            'size' => ['min' => 0, 'max' => 0 ],
                            'rooms' => ['min' => 0, 'max' => 0 ],
                            'rent' => ['min' => 0, 'max' => 0 ]
                        ];

                        // make list of cities and districts
                        // and find min and max values for slider fields
                        $cities = [];
                        foreach ($allRealties as $realty) {
                            // see whether this realty has higher or lower limes values
                            // size
                            if ($realty->getGesamtflaeche() > $arrayReturn['size']['max']) {
                                $arrayReturn['size']['max'] = $realty->getGesamtflaeche();
                            }
                            if ($realty->getGesamtflaeche() < $arrayReturn['size']['min'] ||  $arrayReturn['size']['min'] == 0) {
                                $arrayReturn['size']['min'] = $realty->getGesamtflaeche();
                            }
                            // rooms
                            if ($realty->getAnzahlZimmer() > $arrayReturn['rooms']['max']) {
                                $arrayReturn['rooms']['max'] = $realty->getAnzahlZimmer();
                            }
                            if ($realty->getAnzahlZimmer() < $arrayReturn['rooms']['min'] || $arrayReturn['rooms']['min'] == 0) {
                                $arrayReturn['rooms']['min'] = $realty->getAnzahlZimmer();
                            }
                            // rent
                            if ($realty->getNettokaltmiete() > $arrayReturn['rent']['max']) {
                                $arrayReturn['rent']['max'] = $realty->getNettokaltmiete();
                            }
                            if ($realty->getNettokaltmiete() < $arrayReturn['rent']['min'] || $arrayReturn['rent']['min'] == 0) {
                                $arrayReturn['rent']['min'] = $realty->getNettokaltmiete();
                            }

                            // find city in cities
                            $cityMatched = false;
                            $citiesCount = count($cities);
                            for ($i = 0; $i < $citiesCount; $i++) {
                                if ($cities[$i]['id'] == $realty->getObjektOrt()->getUid()) {
                                    // found match. we have this city
                                    $cityMatched = true;
                                    // take all districts and walk through all districts to find out
                                    // whether we also have this district
                                    $districtMatched = false;
                                    $countDistricts = count($cities[$i]['districts']);
                                    if ($realty->getObjektStadtteil() instanceof Stadtteil) {
                                        for ($k = 0; $k < $countDistricts; $k++) {
                                            if ($cities[$i]['districts'][$k]['id'] == $realty->getObjektStadtteil()->getUid()) {
                                                // this district exists
                                                $districtMatched = true;
                                            }
                                        }
                                        if ($districtMatched === false) {
                                            // add district to this city
                                            $thisDistrict = [
                                                'id' => $realty->getObjektStadtteil()->getUid(),
                                                'name' => $realty->getObjektStadtteil()->getBezeichner()
                                            ];
                                            $cities[$i]['districts'][] = $thisDistrict;
                                        }
                                    }
                                }
                            }
                            if ($cityMatched === false) {
                                // add city to city stack
                                // add district to new city stack
                                $districts = [];
                                if ($realty->getObjektStadtteil() instanceof Stadtteil) {
                                    $districts = [
                                        [
                                            'id' => $realty->getObjektStadtteil()->getUid(),
                                            'name' => $realty->getObjektStadtteil()->getBezeichner()
                                        ]
                                    ];
                                }
                                $thisCity = [
                                    'id' => $realty->getObjektOrt()->getUid(),
                                    'name' => $realty->getObjektOrt()->getBezeichner(),
                                    'districts' => $districts
                                ];
                                $cities[] = $thisCity;
                            }
                        }
                        $arrayReturn['cities'] = $cities;

                        $tempRegions = [];

                        foreach ($cities as $city) {
                            $regionsForCity = $this->regionRepository->findRegionsForCity($this->ortRepository->findByUid($city['id']));
                            foreach ($regionsForCity as $region) {
                                /**
                                 * @var Region $region
                                 */
                                $tempRegions[$region->getBezeichner()] = [
                                    'id' => $region->getUid(),
                                    'name' => $region->getBezeichner()
                                ];
                            }
                        }
                        ksort($tempRegions);
                        $tempRegions = array_values($tempRegions);

                        $arrayReturn['regions'] = $tempRegions;

                        foreach ($allRealties as $realty) {
                            /**
                             * @var $realty Immobilie
                             */
                            $district = [];
                            if ($realty->getObjektStadtteil() instanceof Stadtteil) {
                                $district = [
                                    'id' => $realty->getObjektStadtteil()->getUid(),
                                    'name' => $realty->getObjektStadtteil()->getBezeichner()
                                ];
                            }
                            array_push($arrayReturn['realties'], [
                                'uid' => $realty->getUid(),
                                'city' => [
                                    'id' => $realty->getObjektOrt()->getUid(),
                                    'name' => $realty->getObjektOrt()->getBezeichner()
                                ],
                                'district' => $district,
                                'rooms' => $realty->getAnzahlZimmer(),
                                'size' => $realty->getWohnflaeche(),
                                'rent' => $realty->getNettokaltmiete(),
                            ]);
                        }

                        $this->view->assign('jsonReturn', json_encode($arrayReturn));

                        $entry = $this->view->render();

                        $tags = ['ajax_allRealties'];
                        $lifetime = $this->settings['defaultCacheLifetime'];

                        // Save value in cache
                        $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                    }
                    return $entry;
                    break;
                case 'contactForm':
                    $this->pregenerateContactForm();
                    if ($this->request->hasArgument('realtyUid')) {
                        $realtyUid = $this->request->getArgument('realtyUid');
                        $objektTitel = '';
                        if ($this->request->hasArgument('objektTitel'))
                            $objektTitel = $this->request->getArgument('objektTitel');
                        $objektnrExtern = '';
                        if ($this->request->hasArgument('objektnrExtern'))
                            $objektnrExtern = $this->request->getArgument('objektnrExtern');
                        $this->view->assign('realty', [
                            'uid' => $realtyUid,
                            'objektTitel' => $objektTitel,
                            'objektnrExtern' => $objektnrExtern
                        ]);
                    }
                    if ($this->request->hasArgument('formValues')) {
                        $this->processContactForm();
                    }
                    break;
                case 'getDistance':
                    if ($this->request->hasArgument('realtyUid')) {
                        $realty = $this->immobilieRepository->findOneByUid($this->request->getArgument('realtyUid'));
                        if ($realty instanceof Immobilie) {
                            $lat = $this->filter->getLatitude() > 0
                                ? $this->filter->getLatitude()
                                : ($this->request->hasArgument('lat')
                                    ? $this->request->getArgument('lat')
                                    : 0);
                            $lon = $this->filter->getLongitude() > 0
                                ? $this->filter->getLongitude()
                                : ($this->request->hasArgument('lon')
                                    ? $this->request->getArgument('lon')
                                    : 0);
                            $this->view->assign('distance', $this->calcDistance($realty->getObjektBreitengrad(), $realty->getObjektLaengengrad(), $lat, $lon));
                            //$this->view->assign('distance', $this->calcDistance($realty->getObjektBreitengrad(), $realty->getObjektLaengengrad(), $this->filter->getLatitude(), $this->filter->getLongitude()));
                        }
                    }
                    break;
                case 'getCityAndDistricts':
                    $cacheIdentifier = 'ajax_getCityAndDistricts';
                    if (($entry = $this->cache->get($cacheIdentifier)) === false) {
                        $cityAndDistrictStructure = $this->generateCityAndDistrictStructureForFilter();

                        $this->view->assign('jsonReturn', $cityAndDistrictStructure);

                        $entry = $this->view->render();

                        $tags = ['ajax_getCityAndDistricts'];
                        $lifetime = $this->settings['defaultCacheLifetime'];

                        // Save value in cache
                        $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                    }
                    return $entry;
                    break;
                case 'getRealtiesByUids':
                    $uidData = json_decode(GeneralUtility::_POST('uids'));
                    if (is_array($uidData)) {
                        $arrayReturn = [];
                        $processingInstructions = [
                            'width' => '400c',
                            'height' => '300c',
                        ];
                        foreach ($uidData as $uid) {
                            $realty = $this->immobilieRepository->findOneByUrlIdentifier($uid);
                            if ($realty instanceof Immobilie) {
                                /**
                                 * @var $realty Immobilie
                                 */
                                $district = [];
                                if ($realty->getObjektStadtteil() instanceof Stadtteil) {
                                    $district = [
                                        'id' => $realty->getObjektStadtteil()->getUid(),
                                        'name' => $realty->getObjektStadtteil()->getBezeichner()
                                    ];
                                }
                                $image = $this->imageService->getImage(Environment::getPublicPath() . '/uploads/tx_sgestatecore/media/' . $realty->getTitelbild()->getDatei(), null, false);
                                $processedImage = $this->imageService->applyProcessingInstructions($image, $processingInstructions);
                                array_push($arrayReturn, [
                                    'id' => $realty->getUid(),
                                    'data' => [
                                        'objectNumberInternal' => $realty->getObjektnrIntern(),
                                        'objectNumberExternal' => $realty->getObjektnrExtern(),
                                        'openimmoObjid' => $realty->getOpenimmoObjid(),
                                        'title' => $realty->getObjekttitel(),
                                        'street' => $realty->getObjektStrasse(),
                                        'houseNumber' => $realty->getObjektHausnummer(),
                                        'zip' => $realty->getObjektPlz(),
                                        'size' => $realty->getWohnflaeche(),
                                        'rooms' => $realty->getAnzahlZimmer(),
                                        'rent' => $realty->getNettokaltmiete(),
                                        'balcony' => $realty->getAnzahlBalkone() > 0 ? true : false,
                                        'city' => [
                                            'id' => $realty->getObjektOrt()->getUid(),
                                            'name' => $realty->getObjektOrt()->getBezeichner()
                                        ],
                                        'district' => $district,
                                        'url' => $this->uriBuilder->reset()->setTargetPageUid($this->settings['pid']['detail'])->uriFor('detail', ['realty' => $realty->getUrlIdentifier()], 'Base', 'sgestatebase', 'pi1')
                                    ],
                                    'media' => [
                                        'preview' => $this->imageService->getImageUri($processedImage)
                                    ],
                                    'geometry' => [
                                        'location' => [
                                            'lat' => $realty->getObjektBreitengrad(),
                                            'lng' => $realty->getObjektLaengengrad()
                                        ]
                                    ],
                                ]);
                            }
                        }
                        $this->view->assign('jsonReturn', json_encode($arrayReturn));
                    } else {
                        $this->view->assign('jsonReturn', json_encode([]));
                    }
                    $entry = $this->view->render();
                    return $entry;
                    break;
                default:
                    break;
            }
        } else {
            die('');
        }
    }

    /********************************************
     * Internal & Helper Functions
     *********************************************/

    protected function calcDistance($latitudePoint1, $longitudePoint1, $latitudePoint2, $longitudePoint2)
    {
        $pi80 = M_PI / 180;
        $latitudePoint1 *= $pi80;
        $longitudePoint1 *= $pi80;
        $latitudePoint2 *= $pi80;
        $longitudePoint2 *= $pi80;
        $r = 6372.797; // mean radius of Earth in km
        $dlat = $latitudePoint2 - $latitudePoint1;
        $dlon = $longitudePoint2 - $longitudePoint1;
        $a = sin($dlat / 2) * sin($dlat / 2) + cos($latitudePoint1) * cos($latitudePoint2) * sin($dlon / 2) * sin($dlon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $km = $r * $c;
        return $km;
    }

    protected function pregenerateContactForm()
    {
        ksort($this->settings['contact']['fields']);
        $this->view->assign('settings', $this->settings);
        $this->view->assign('salutationOptions', $this->getSalutationOptions());
    }

    protected function transformFieldConfiguration()
    {
        $transformedConfiguration = [];
        foreach ($this->settings['contact']['fields'] as $fieldConfiguration) {
            $transformedConfiguration[$fieldConfiguration['name']] = $fieldConfiguration;
        }
        return $transformedConfiguration;
    }

    /**
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    protected function processContactForm()
    {
        /**
         * @var $formValues array
         * @var $realty Immobilie
         */
        $formValues = $this->request->getArgument('formValues');

        $processedFormValues = [];
        $errors = [];
        foreach ($this->settings['contact']['fields'] as $fieldConfiguration) {
            if ($fieldConfiguration['required'] == 1 && (!isset($formValues[$fieldConfiguration['name']]) || $formValues[$fieldConfiguration['name']] == '')) {
                $errors[$fieldConfiguration['name']][] = 'required';
            } else {
                $processedFormValues[$fieldConfiguration['name']] = isset($formValues[$fieldConfiguration['name']]) ? $formValues[$fieldConfiguration['name']] : '';
            }
        }

        $realty = $this->immobilieRepository->findByUid($formValues['realty']);

        if (count($errors) == 0) {
            $valid = true;
        } else {
            $valid = false;
        }

        if ($valid) {
            // Generate Receivers
            if ($this->settings['contact']['useRealtyContactAsReceiver'] == 1) {
                if ($realty->getKontaktperson() instanceof Kontaktperson) {
                    $emailDirekt = $realty->getKontaktperson()->getEmailDirekt();
                    $emailZentrale = $realty->getKontaktperson()->getEmailZentrale();
                    $emailSonstige = $realty->getKontaktperson()->getEmailSonstige();
                    if (GeneralUtility::validEmail($emailDirekt)) {
                        $receivers = [$emailDirekt];
                    } elseif (GeneralUtility::validEmail($emailZentrale)) {
                        $receivers = [$emailZentrale];
                    } elseif (GeneralUtility::validEmail($emailSonstige)) {
                        $receivers = [$emailSonstige];
                    } else {
                        $receivers = explode(',', $this->settings['contact']['receivers']);
                    }
                } else {
                    $receivers = explode(',', $this->settings['contact']['receivers']);
                }
            } else {
                $receivers = explode(',', $this->settings['contact']['receivers']);
            }

            if ($this->settings['contact']['addFeedbackAttachment']) {
                $attachmentContent = $this->generateFeedbackAttachment('Email/FeedbackAttachment', ['processedFormValues' => $processedFormValues, 'settings' => $this->settings, 'realty' => $realty], 'xml');
                $attachment = [
                    'type' => 'content',
                    'content' => $attachmentContent,
                    'filename' => 'feedback.xml'
                ];
                $attachments = [$attachment];
            } else {
                $attachments = [];
            }

            $success = $this->sgEstateCoreServices->sendTemplateEmail($receivers, $this->settings['contact']['sender'],
                $this->settings['contact']['subject'],
                'SgEstateBaseContact',
                [],
                ['realty' => $realty, 'formValues' => $processedFormValues, 'settings' => $this->settings],
                $attachments, $this->settings['contact']['mailformat'],
                $this->settings['contact']['senderHeader']);


            if ($success && intval($this->settings['contact']['redirectPidSuccess'])>0) {
                $uriBuilder = $this->controllerContext->getUriBuilder();
                $uriBuilder->reset();
                $uriBuilder->setTargetPageUid(intval($this->settings['contact']['redirectPidSuccess']));
                $uri = $uriBuilder->build();
                $this->redirectToUri($uri);
            } elseif (!$success && intval($this->settings['contact']['redirectPidFailure'])>0) {
                $uriBuilder = $this->controllerContext->getUriBuilder();
                $uriBuilder->reset();
                $uriBuilder->setTargetPageUid(intval($this->settings['contact']['redirectPidFailure']));
                $uri = $uriBuilder->build();
                $this->redirectToUri($uri);
            } elseif ($success && intval($this->settings['contact']['redirectPidSuccess']) == 0) {
                $this->view->assign('showResult', true);
                $this->view->assign('success', true);
            } elseif (!$success && intval($this->settings['contact']['redirectPidFailure']) == 0) {
                $this->view->assign('showResult', true);
                $this->view->assign('success', false);
            }
        } else {
            $this->view->assign('formValues', $formValues);
            if (is_array($formValues['channel'])) {
                $this->view->assign('channelValues', array_fill_keys(array_keys(array_flip($formValues['channel'])), 1));
            }
            if (is_array($formValues['wish'])) {
                $this->view->assign('wishValues', array_fill_keys(array_keys(array_flip($formValues['wish'])), 1));
            }
            $this->view->assign('errors', $errors);
        }
        $this->view->assign('realty', $realty);
    }

    /**
     * Get Salutation for Contact Form
     *
     * @return array
     */
    protected function getSalutationOptions()
    {
        return [
            'mr' => LocalizationUtility::translate('template.contact.salutation.mr', 'sg_estate_base'),
            'mrs' => LocalizationUtility::translate('template.contact.salutation.mrs', 'sg_estate_base'),
        ];
    }

    /**
     * Sets Property Filter from Request Arguments
     *
     * @throws NoSuchArgumentException
     */
    protected function setFilter()
    {
        if ($this->request->hasArgument('filter')) {
            /**
             * @var $filterValues array
             */
            $this->filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');

            $filterValues = $this->request->getArgument('filter');

            // extract city and districts from groupedCitiesAndDistricts if set
            // and override filter value city and add filter values district
            if (isset($filterValues['groupedCitiesAndDistricts']) && $filterValues['groupedCitiesAndDistricts'] != '') {
                $split = explode('_', $filterValues['groupedCitiesAndDistricts']);
                if (isset($split[0]) && is_numeric($split[0])) {
                    $filterValues['city'] = $split[0];
                }
                if (isset($split[1]) && is_numeric($split[1])) {
                    $filterValues['district'][] = $split[1];
                }
            }

            if (isset($filterValues['regions']) && is_array($filterValues['regions']) && count($filterValues['regions']) > 0) {
                foreach ($filterValues['regions'] as $regionUid) {
                    $region = $this->regionRepository->findByUid($regionUid);
                    if ($region instanceof Region) {
                        $this->filter->addRegion($region);
                    }
                }
            }
            if (isset($filterValues['region']) && is_numeric($filterValues['region'])) {
                $region = $this->regionRepository->findByUid($filterValues['region']);
                if ($region instanceof Region) {
                    $this->filter->setRegion($region);
                }
            }

            if (is_numeric($filterValues['city'])) {
                $ort = $this->ortRepository->findByUid($filterValues['city']);
                if ($ort instanceof \SG\SgEstateCore\Domain\Model\Ort) {
                    $this->filter->setOrt($ort);
                }
            }
            if (isset($filterValues['cities']) && is_array($filterValues['cities']) && count($filterValues['cities']) > 0) {
                foreach ($filterValues['cities'] as $cityUid) {
                    $city = $this->ortRepository->findByUid($cityUid);
                    if ($city instanceof Ort) {
                        $this->filter->addOrt($city);
                    }
                }
            }

            if (is_numeric($filterValues['district'])) {
                $stadtteil = $this->stadtteilRepository->findByUid($filterValues['district']);
                if ($stadtteil instanceof \SG\SgEstateCore\Domain\Model\Stadtteil) {
                    $this->filter->addStadtteil($stadtteil);
                }
            } elseif (is_array($filterValues['district'])) {
                foreach ($filterValues['district'] as $stadtteilUid) {
                    $stadtteil = $this->stadtteilRepository->findByUid($stadtteilUid);
                    if ($stadtteil instanceof \SG\SgEstateCore\Domain\Model\Stadtteil) {
                        $this->filter->addStadtteil($stadtteil);
                    }
                }
            }

            $this->filter->setRaeumeAb(is_numeric($filterValues['roomMin']) ? floatval($filterValues['roomMin']) : null);
            $this->filter->setRaeumeBis(is_numeric($filterValues['roomMax']) ? floatval($filterValues['roomMax']) : null);

            $this->filter->setFlaecheAb(is_numeric($filterValues['sizeMin']) ? floatval($filterValues['sizeMin']) : null);
            $this->filter->setFlaecheBis(is_numeric($filterValues['sizeMax']) ? floatval($filterValues['sizeMax']) : null);

            $this->filter->setKaltmieteAb(is_numeric($filterValues['rentMin']) ? floatval($filterValues['rentMin']) : null);
            $this->filter->setKaltmieteBis(is_numeric($filterValues['rentMax']) ? floatval($filterValues['rentMax']) : null);

            if (isset($filterValues['kindOfObjects'])) {
                $objektarten = new ObjectStorage();
                foreach ($filterValues['kindOfObjects'] as $uid) {
                    $objektart = $this->objektartRepository->findByUid($uid);
                    if ($objektart instanceof Objektart) {
                        $objektarten->attach($objektart);
                    }
                }
                if ($objektarten->count() > 0) {
                    $this->filter->setObjektarten($objektarten);
                }
            }

            if (isset($filterValues['objektartTypen'])&&is_array($filterValues['objektartTypen'])) {
                $objektartTypen = new ObjectStorage();
                foreach ($filterValues['objektartTypen'] as $item) {
                    $objektartTyp = $this->objektarttypRepository->findOneByKuerzel($item);
                    if ($objektartTyp instanceof Objektarttyp) {
                        $objektartTypen->attach($objektartTyp);
                    }
                }
                if ($objektartTypen->count() > 0) {
                    $this->filter->setObjektarttypen($objektartTypen);
                }
            }

            if (isset($filterValues['heizungsarten'])&&is_array($filterValues['heizungsarten'])) {
                $heizungsarten = new ObjectStorage();
                foreach ($filterValues['heizungsarten'] as $item) {
                    $heizungsart = $this->heizungsartRepository->findOneByKuerzel($item);
                    if ($heizungsart instanceof Heizungsart) {
                        $heizungsarten->attach($heizungsart);
                    }
                }
                if ($heizungsarten->count() > 0) {
                    $this->filter->setHeizungsarten($heizungsarten);
                }
            }
            $this->filter->setAufzug(is_numeric($filterValues['aufzug']) ? intval($filterValues['aufzug']) : null);
            $this->filter->setBarrierefrei(is_numeric($filterValues['barrierefrei']) ? intval($filterValues['barrierefrei']) : null);

            if (isset($filterValues['latitude']) && isset($filterValues['longitude']) && is_numeric($filterValues['latitude']) && is_numeric($filterValues['longitude']) && $filterValues['latitude'] != 0 && $filterValues['longitude'] != 0) {
                $this->filter->setLatitude($filterValues['latitude']);
                $this->filter->setLongitude($filterValues['longitude']);
                if (isset($filterValues['radius']) && is_numeric($filterValues['radius']) && $filterValues['radius'] > 0) {
                    $this->filter->setRadius($filterValues['radius']);
                } else {
                    $this->filter->setRadius($this->settings['preset']['search']['radius']);
                }
            }
            if (isset($filterValues['addressString']) && $filterValues['addressString'] != '') {
                $this->filter->setAddressString($filterValues['addressString']);
            } else {
                $this->filter->setAddressString('');
            }

            if (isset($filterValues['personsFrom']) && is_numeric($filterValues['personsFrom']) && $filterValues['personsFrom'] > 0) {
                $this->filter->setPersonsFrom($filterValues['personsFrom']);
            } else {
                if($this->settings['preset']['search']['persons'] > 0){
                    $this->filter->setPersonsFrom($this->settings['preset']['search']['persons']);
                }else{
                    $this->filter->setPersonsFrom(0);
                }
            }
            if (isset($filterValues['personsTo']) && is_numeric($filterValues['personsTo']) && $filterValues['personsTo'] > 0) {
                $this->filter->setPersonsTo($filterValues['personsTo']);
            } else {
                $this->filter->setPersonsTo(0);
            }
            if (isset($filterValues['persons']) && $filterValues['persons'] != '') {
                $this->filter->setPersonsString($filterValues['persons']);

                $tempPersonsArray = explode('-', $filterValues['persons']);
                if (isset($tempPersonsArray[0]) && is_numeric($tempPersonsArray[0]) && $tempPersonsArray[0] > 0) {
                    $this->filter->setPersonsFrom($tempPersonsArray[0]);
                } else {
                    $this->filter->setPersonsFrom(0);
                }
                if (isset($tempPersonsArray[1]) && is_numeric($tempPersonsArray[1]) && $tempPersonsArray[1] > 0) {
                    $this->filter->setPersonsTo($tempPersonsArray[1]);
                } else {
                    $this->filter->setPersonsTo(0);
                }
            }else{
                if($this->settings['preset']['search']['persons'] > 0){
                    $this->filter->setPersonsString($this->settings['preset']['search']['persons']);
                }
            }
        } else {
            // No Data for Filter in Request
            $filter = $this->sessionHandler->restoreFromSession('filter');
            if ($filter instanceof Filter) {
                $this->filter = $filter;
            } else {
                $this->filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');
            }
            $this->noSearchParameters = true;
        }

        $this->sessionHandler->writeToSession($this->filter, 'filter');
    }

    /**
     * Generate Array with Slider Data for the Size Slider
     * @todo: Read from Config
     *
     * @return array
     */
    protected function getSizeSliderData()
    {
        return [
            'range' => $this->settings['preset']['slider']['size']['range'],
            'min'   => $this->settings['preset']['slider']['size']['min'],
            'max'   => $this->settings['preset']['slider']['size']['max'],
            'value' => $this->settings['preset']['slider']['size']['value']
        ];
    }

    /**
     * Generate Array with Slider Data for the Room Slider
     * @todo: Read from Config
     *
     * @return array
     */
    protected function getRoomSliderData()
    {
        return [
            'range' => $this->settings['preset']['slider']['room']['range'],
            'min'   => $this->settings['preset']['slider']['room']['min'],
            'max'   => $this->settings['preset']['slider']['room']['max'],
            'value' => $this->settings['preset']['slider']['room']['value']
        ];
    }

    /**
     * Generate Array with Slider Data for the Amount Slider
     * @todo: Read from Config
     *
     * @return array
     */
    protected function getAmountSliderData()
    {
        return [
            'range' => $this->settings['preset']['slider']['amount']['range'],
            'min'   => $this->settings['preset']['slider']['amount']['min'],
            'max'   => $this->settings['preset']['slider']['amount']['max'],
            'value' => $this->settings['preset']['slider']['amount']['value']
        ];
    }

    /**
     * @param $result
     * @return array
     */
    protected function generateInstantFilterPresetsFromResult($result)
    {
        $presets = [];

        // Initialize
        $cities = [];
        $balcony = false;
        $lift = false;
        $wbs = false;
        $bathShower = false;
        $bathTub = false;
        $bathWindow = false;

        foreach ($result as $realty) {
            /**
             * @var $realty Immobilie
             */
            // City & Distric
            $cities[$realty->getObjektOrt()->getUid()]['bezeichner'] = $realty->getObjektOrt()->getBezeichner();
            if (is_object($realty->getObjektStadtteil())) {
                $cities[$realty->getObjektOrt()->getUid()]['districts'][$realty->getObjektStadtteil()->getUid()] = [
                    'uid' => $realty->getObjektStadtteil()->getUid(),
                    'bezeichner' => $realty->getObjektStadtteil()->getBezeichner()
                ];
            }

            // Balcony
            if ($realty->getAnzahlBalkone() > 0) {
                $balcony = true;
            }

            // Lift
            if ($realty->getAufzugPersonen() == 1) {
                $lift = true;
            }

            // WBS
            if ($realty->getWbsErforderlich() == 1) {
                $wbs = true;
            }

            // Bath
            /**
             * @var $badAusstattung Badausstattung
             */
            foreach ($realty->getAusstattungBad() as $badAusstattung) {
                if ($badAusstattung->getKuerzel() == 'WANNE') {
                    $bathTub = true;
                }
                if ($badAusstattung->getKuerzel() == 'DUSCHE') {
                    $bathShower = true;
                }
                if ($badAusstattung->getKuerzel() == 'FENSTER') {
                    $bathWindow = true;
                }
            }
        }

        $regions = [];

        foreach ($cities as $key => $value) {
            $regionsForCity = $this->regionRepository->findRegionsForCity($this->ortRepository->findByUid($key));
            foreach ($regionsForCity as $region) {
                /**
                 * @var Region $region
                 */
                $regions[$region->getBezeichner()] = [
                    'id' => $region->getUid(),
                    'name' => $region->getBezeichner()
                ];
            }
        }

        ksort($regions);
        $regions = array_values($regions);

        // Build Return Variable
        $presets['regions'] = $regions;
        $presets['cities'] = $cities;
        $presets['balcony'] = $balcony;
        $presets['lift'] = $lift;
        $presets['wbs'] = $wbs;
        $presets['bathShower'] = $bathShower;
        $presets['bathTub'] = $bathTub;
        $presets['bathWindow'] = $bathWindow;

        return $presets;
    }

    protected function generateFeedbackAttachment($templateName, array $variables = [], $format = 'xml')
    {
        /**
         * @var $standaloneView StandaloneView
         */
        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);

        $standaloneView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
        $standaloneView->setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $standaloneView->setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $standaloneView->setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $standaloneView->setTemplate($templateName);

        $standaloneView->setFormat($format);
        $standaloneView->assignMultiple($variables);

        $fileContent = $standaloneView->render();

        return $fileContent;
    }

    /**
     * Sends Mail via configured TYPO3 Mailer System with Fluid Standalone Template
     *
     * @todo: Use Function from Core
     *
     * @param array $recipients
     * @param array $bcc
     * @param $sender
     * @param $subject
     * @param $templateName
     * @param array $variables
     * @param string $format
     * @return bool
     */
    protected function sendTemplateEmail(array $recipients = [], array $bcc = [], $sender, $subject, $templateName, array $variables = [], $format = 'text/plain', $attachments = [])
    {
        /**
         * @var $emailView StandaloneView
         * @var $message MailMessage
         */
        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);

        $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
        $emailView->setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $emailView->setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $emailView->setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $emailView->setTemplate($templateName);

        $emailView->setFormat('html');
        $emailView->assignMultiple($variables);

        $emailBody = $emailView->render();

        $message = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');

        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)) {
            $message->setFrom($sender);
        } else {
            return false;
        }

        // Add Recipients
        $recipients = array_filter($recipients);
        if (count($recipients) > 0) {
            foreach ($recipients as $email) {
                if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)) {
                    $message->addTo($email);
                }
            }
        } else {
            return false;
        }

        if (count($bcc) > 0) {
            foreach ($bcc as $email) {
                if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)) {
                    $message->addBcc($email);
                }
            }
        }

        if ($subject != '') {
            $message->setSubject($subject);
        } else {
            return false;
        }

        if (count($attachments) > 0) {
            foreach ($attachments as $attachment) {
                $message->attach($attachment);
            }
        }

        $message->setBody($emailBody, $format);

        $message->send();
        return $message->isSent();
    }

    /**
     * Get the current language
     */
    protected function getLanguageUid()
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $sysLanguageUid = $context->getPropertyFromAspect('language', 'id');
        if (is_numeric($sysLanguageUid)) {
            return $sysLanguageUid;
        } else {
            return 0;
        }
    }

    protected function getAggregatedFilterData()
    {
        return [
            'size' => !$this->filter->getFlaecheAb() ? $this->getSizeSliderData()['value'] : $this->filter->getFlaecheAb(),
            'rooms' => !$this->filter->getRaeumeAb() ? $this->getRoomSliderData()['value'] : $this->filter->getRaeumeAb(),
            'rent' => !$this->filter->getKaltmieteBis() ? $this->getAmountSliderData()['value'] : $this->filter->getKaltmieteBis()
        ];
    }

    /**
     * Sort a given district array that was optimized for preset use in template
     * in ascending order (bezeichner field)
     * @param  array &$districts Array to sort
     */
    protected function sortDistrictsPresetArray( &$districts )
    {
        $sorted = false;
        $districtsCount = count( $districts )-1;
        while( $sorted === false )
        {
            $changes = 0;
            for( $i = 0; $i < $districtsCount; $i++ )
            {
                if( $districts[$i]['bezeichner'] > $districts[$i+1]['bezeichner'] )
                {
                    // change position and increment counter
                    $h = $districts[$i];
                    $districts[$i] = $districts[$i+1];
                    $districts[$i+1] = $h;
                    $changes++;
                }
            }
            if( $changes == 0 )
            {
                $sorted = true;
            }
        }
    }

    /**
     * @param $result
     * @return array
     */
    protected function generateFilterPresetsFromResult($result){
        $presets = array();

        // Initialize
        $cities = array();
        $balcony = false;
        $lift = false;
        $wbs = false;
        $bathShower = false;
        $bathTub = false;
        $bathWindow = false;

        foreach ($result as $realty){
            /**
             * Identifiy those cities and districts that lead to valid results (take all realties locations)
             * @var $realty \SG\SgEstateCore\Domain\Model\Immobilie
             */
            $cities[$realty->getObjektOrt()->getUid()]['bezeichner'] = $realty->getObjektOrt()->getBezeichner();
            if (is_object($realty->getObjektStadtteil())){
                $cities[$realty->getObjektOrt()->getUid()]['districts'][$realty->getObjektStadtteil()->getUid()] = array(
                    'uid' => $realty->getObjektStadtteil()->getUid(),
                    'bezeichner' => $realty->getObjektStadtteil()->getBezeichner()
                );
            }

            /**
             * Identify all cities and districts and create hierarchical tree
             */
            $allCities = array();
            $tempAllCities = $this->ortRepository->findAll();
            $presets['tempAllCities'] = $tempAllCities;
            foreach( $tempAllCities as $tempCity )
            {
                if( $tempCity instanceof \SG\SgEstateCore\Domain\Model\Ort )
                {
                    if( $tempCity->getFuerSucheVerwenden() === true )
                    {
                        $tempDistricts = $tempCity->getStadtteile();
                        $tempDistrictsCount = $tempDistricts->count();
                        if( $tempDistrictsCount > 0 )
                        {
                            // now inspect all disricts and identify those we want to add to the presets
                            $districtsArray = array();
                            foreach( $tempDistricts as $tempDistrict )
                            {
                                if( $tempDistrict instanceof \SG\SgEstateCore\Domain\Model\Stadtteil )
                                {
                                    if( $tempDistrict->getFuerSucheVerwenden() === true )
                                    {
                                        // choose this districts
                                        $districtsArray[] = array(
                                            'uid' => $tempDistrict->getUid(),
                                            'bezeichner' => $tempDistrict->getBezeichner()
                                        );
                                    }
                                }
                            }
                            // valid city and districts combination found, add to "all cities array"
                            //// sort districts, pass reference
                            $this->sortDistrictsPresetArray( $districtsArray );
                            // append array
                            $allCities[ $tempCity->getUid() ] = array(
                                'bezeichner' => $tempCity->getBezeichner(),
                                'districts' => $districtsArray
                            );
                        }
                        else {
                            $allCities[ $tempCity->getUid() ] = array(
                                'bezeichner' => $tempCity->getBezeichner(),
                                'districts' => []
                            );
                        }
                    }
                }
            }

            // Balcony
            if ($realty->getAnzahlBalkone() > 0){$balcony = true;}

            // Lift
            if ($realty->getAufzugPersonen() == 1){$lift = true;}

            // WBS
            if ($realty->getWbsErforderlich() == 1){$wbs = true;}

            // Bath
            /**
             * @var $badAusstattung \SG\SgEstateCore\Domain\Model\Badausstattung
             */
            foreach ($realty->getAusstattungBad() as $badAusstattung){
                if ($badAusstattung->getKuerzel() == 'WANNE'){$bathTub = true;}
                if ($badAusstattung->getKuerzel() == 'DUSCHE'){$bathShower = true;}
                if ($badAusstattung->getKuerzel() == 'FENSTER'){$bathWindow = true;}
            }

        }

        // Build Return Variable
        $presets['cities'] = $cities;
        $presets['allCities'] = $allCities;
        $presets['allRegions'] = $this->regionRepository->findAll();
        $presets['balcony'] = $balcony;
        $presets['lift'] = $lift;
        $presets['wbs'] = $wbs;
        $presets['bathShower'] = $bathShower;
        $presets['bathTub'] = $bathTub;
        $presets['bathWindow'] = $bathWindow;

        return $presets;
    }

    public function presetsAction() {
        $this->view->assign('cities', $this->ortRepository->findAll());
        $entry = $this->view->render();
        return $entry;
    }

}