<?php

namespace SG\SgEstateBase\Form\Element;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2011 Xavier Perseguers <xavier@causal.ch>, Causal
 *  (c) 2015 Marc Hirdes <hirdes@clicsktorm.de>, clickstorm GmbH
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

use TYPO3\CMS\Backend\Form\Element\AbstractFormElement;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/**
 * Google map.
 *
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License, version 3 or later
 */
class GomapsextMapElement extends AbstractFormElement
{

    /**
     * Renders the Google map.
     *
     * @return array
     */
    public function render()
    {
        $resultArray = $this->initializeResultArray();
        $pluginSettings = static::getSettings();
        $googleMapsLibrary = $pluginSettings['googleMapsLibrary'] ?? ' //maps.google.com/maps/api/js?v=weekly';

        if ($pluginSettings['keys.']['googleapi']) {
            $googleMapsLibrary .= '&key=' . $pluginSettings['keys.']['googleapi'];
        }

        $out = [];

        $flexformValue = $this->data['databaseRow']['pi_flexform']['data']['sDEF']['lDEF'];
        $latitude = $flexformValue['settings.filter.latitude']['vDEF'];
        $longitude = $flexformValue['settings.filter.longitude']['vDEF'];

        if(empty($latitude) && empty($longitude)){
            $latitude = 0;
            $longitude = 0;
        }

        $baseElementId = isset($this->data['databaseRow']['uid']) ? $this->data['databaseRow']['uid'] : $this->data['tableName'] . '_map';

        $mapId = $baseElementId . '_map';



        $latitudeField = 'data[tt_content]['.$this->data['databaseRow']['uid'].'][pi_flexform][data][sDEF][lDEF][settings.filter.latitude][vDEF]';
        $longitudeField = 'data[tt_content]['.$this->data['databaseRow']['uid'].'][pi_flexform][data][sDEF][lDEF][settings.filter.longitude][vDEF]';
        $cityFieldName = 'data[tt_content]['.$this->data['databaseRow']['uid'].'][pi_flexform][data][sDEF][lDEF][settings.filter.ort][vDEF]';


        $updateJs = "TBE_EDITOR.fieldChanged('%s','%s','%s','%s');";
        $updateLatitudeJs = sprintf(
            $updateJs,
            $this->data['tableName'],
            $this->data['databaseRow']['uid'],
            $this->data['parameterArray']['fieldConf']['config']['parameters']['latitude'],
            $latitudeField
        );
        $updateLongitudeJs = sprintf(
            $updateJs,
            $this->data['tableName'],
            $this->data['databaseRow']['uid'],
            $this->data['parameterArray']['fieldConf']['config']['parameters']['longitude'],
            $longitudeField
        );

        $out[] = '<script type="text/javascript" src="' . $googleMapsLibrary . '"></script>';
        $out[] = '<script type="text/javascript">';
        $out[] = <<<EOT
if (typeof TxClimbingSites == 'undefined') TxClimbingSites = {};

String.prototype.trim = function() { return this.replace(/^\s+|\s+$/g, ''); } 

TxClimbingSites.init = function() {
	TxClimbingSites.origin = new google.maps.LatLng({$latitude}, {$longitude});
	var myOptions = {
		zoom: 12,
		center: TxClimbingSites.origin,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	
	TxClimbingSites.map = new google.maps.Map(document.getElementById("{$mapId}"), myOptions);
	TxClimbingSites.marker = new google.maps.Marker({
		map: TxClimbingSites.map,
		position: TxClimbingSites.origin,
		draggable: true
	});
	google.maps.event.addListener(TxClimbingSites.marker, 'dragend', function() {
		var lat = TxClimbingSites.marker.getPosition().lat().toFixed(6);
		var lng = TxClimbingSites.marker.getPosition().lng().toFixed(6);

        // update fields
		TxClimbingSites.updateValue('{$latitudeField}', lat);
        TxClimbingSites.updateValue('{$longitudeField}', lng);

		// Update address
		TxClimbingSites.reverseGeocode(TxClimbingSites.marker.getPosition().lat(), TxClimbingSites.marker.getPosition().lng());

		// Tell TYPO3 that fields were updated
		TxClimbingSites.positionChanged();
	});
	TxClimbingSites.geocoder = new google.maps.Geocoder();

};

TxClimbingSites.refreshMap = function() {
	google.maps.event.trigger(TxClimbingSites.map, 'resize');
	TxClimbingSites.map.setCenter(TxClimbingSites.marker.getPosition());
	// No need to do it again
	Ext.fly(TxClimbingSites.tabPrefix + '-MENU').un('click', TxClimbingSites.refreshMap);
}

TxClimbingSites.localize = function(address) {
    TxClimbingSites.geocoder.geocode({'address': address}, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            // Get Position
            lat = results[0].geometry.location.lat().toFixed(6);
            lng = results[0].geometry.location.lng().toFixed(6);

            formatedAddress = results[0].formatted_address

            // Update Map
            TxClimbingSites.map.setCenter(results[0].geometry.location);
            TxClimbingSites.marker.setPosition(results[0].geometry.location);

            // Update fields
            TxClimbingSites.updateValue('{$latitudeField}', lat);
            TxClimbingSites.updateValue('{$longitudeField}', lng);
           

            TxClimbingSites.positionChanged();
        } else {
            alert("Geocode was not successful for the following reason: " + status);
        }
    });
}

/***************************/
TxClimbingSites.codeByAddress = function() {
	var city = document.getElementsByName("{$cityFieldName}")[0].value;
	    address = city;
	    	
    TxClimbingSites.localize(address);
}

TxClimbingSites.positionChanged = function() {
    {$updateLatitudeJs}
    {$updateLongitudeJs}
    TYPO3.FormEngine.Validation.validate();
}

TxClimbingSites.updateValue = function(fieldName, value) {
    document[TBE_EDITOR.formname][fieldName].value = value;
    window.$('[data-formengine-input-name="' + fieldName + '"]').val(value);
}

TxClimbingSites.setMarker = function(lat, lng) {
	var latlng = new google.maps.LatLng(lat, lng);
	TxClimbingSites.geocoder.geocode({'latLng': latlng}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			TxClimbingSites.map.setCenter(results[0].geometry.location);
			TxClimbingSites.marker.setPosition(results[0].geometry.location);
		} else {
			alert("Geocode was not successful for the following reason: " + status);
		}
	});
}

TxClimbingSites.reverseGeocode = function(latitude, longitude) {
	var latlng = new google.maps.LatLng(latitude, longitude);
	TxClimbingSites.geocoder.geocode({'latLng': latlng}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK && results[1]) {
			TxClimbingSites.positionChanged();
		}
	});
}

TxClimbingSites.convertAddress = function(addressOld) {


	TxClimbingSites.geocoder.geocode({'address':addressOld}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			TxClimbingSites.map.setCenter(results[0].geometry.location);
			TxClimbingSites.marker.setPosition(results[0].geometry.location);
			var lat = TxClimbingSites.marker.getPosition().lat().toFixed(6);
			var lng = TxClimbingSites.marker.getPosition().lng().toFixed(6);

            TxClimbingSites.updateValue('{$latitudeField}', lat);
            TxClimbingSites.updateValue('{$longitudeField}', lng);

			
		} else {
			alert("Geocode was not successful for the following reason: " + status);
		}
	});
}

window.onload = TxClimbingSites.init;
EOT;
        $out[] = '</script>';
        $out[] = '<div id="' . $baseElementId . '">';
        $out[] = '
			
			<input id="gme-btn-address"
			       type="button" 
			       value="Update by city" 
			       class="btn btn-sm btn-default"
			       onclick="TxClimbingSites.codeByAddress()">
		';
        $out[] = '<div id="' . $mapId . '" style="height:400px;margin:10px 0;width:400px"></div>';
        $out[] = '</div>'; // id=$baseElementId

        $resultArray['html'] = implode('', $out);

        return $resultArray;
    }

    /**
     * Get definitive TypoScript Settings from
     * plugin.tx_gomapsext.settings.
     *
     * @return array
     */
    private static function getSettings(): array
    {
        return GeneralUtility::makeInstance(ObjectManager::class)
            ->get(ConfigurationManagerInterface::class)
            ->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            )['plugin.']['tx_sg_sitepackage.']['settings.'] ?? [];
    }
}
