<?php
namespace SG\SgEstateBase\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

use SG\SgEstateBase\Controller\BaseController;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ReactCommand extends Command
{

    protected function configure()
    {
        $this->setName('sg.base.react');
        $this->setDescription('Make static json for react');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $file = dirname(__FILE__) . '/../../Resources/Public/Data/react.json';
        $f = @fopen($file, "r+");
        if ($f !== false) {
            ftruncate($f, 0);
            fclose($f);
        }
        $json = GeneralUtility::makeInstance(BaseController::class)->getReactJson();
        file_put_contents($file, $json);
        return 0;
    }

}
