<?php

namespace SG\SgEstateBase\Util;

class AddFields implements \TYPO3\CMS\Core\SingletonInterface
{

  /**
   * Adds Template Layouts from PageTS to Flexform of Search Plugin
   *
   * @param $config
   * @return mixed
   */
    public function addSearchTemplateLayouts($config)
    {
        $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['search.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['search.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['search.'];
        } else {
            $templateLayouts = [];
            $optionList = [];
        }
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
        0 => $value,
        1 => $key
      ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of List Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addListTemplateLayouts($config)
    {
        $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['list.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['list.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['list.'];
        } else {
            $templateLayouts = [];
            $optionList = [];
        }
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
        0 => $value,
        1 => $key
      ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Detail Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addDetailTemplateLayouts($config)
    {
        $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['detail.'];
        } else {
            $templateLayouts = [];
            $optionList = [];
        }
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
        0 => $value,
        1 => $key
      ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Detail Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addContactTemplateLayouts($config)
    {
        $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.']) && is_array($pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgestatebase.']['layouts.']['contact.'];
        } else {
            $templateLayouts = [];
            $optionList = [];
        }
        foreach ($templateLayouts as $key => $value) {
            $optionList[] = [
        0 => $value,
        1 => $key
      ];
        }
        $config['items'] = array_merge($config['items'], $optionList);

        return $config;
    }
}
