<?php
namespace SG\SgEstateBase\Controller;

use SG\SgEstateCore\Domain\Model\Badausstattung;
use SG\SgEstateCore\Domain\Model\Filter;
use SG\SgEstateCore\Domain\Model\Heizungsart;
use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Objektart;
use SG\SgEstateCore\Domain\Model\Objektarttyp;
use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Region;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\ImmobilieRepository;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\ObjektarttypRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use SG\SgEstateCore\Domain\Repository\StadtteilRepository;
use SG\SgEstateCore\Util\Services;
use SG\SgEstateCore\Util\SessionHandler;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Mvc\Exception\StopActionException;
use TYPO3\CMS\Extbase\Mvc\Exception\UnsupportedRequestTypeException;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Service\ImageService;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Extbase\Validation\Validator\NotEmptyValidator;
use TYPO3\CMS\Fluid\View\StandaloneView;
use TYPO3\CMS\Core\Context\Context;

class BaseController extends ActionController {

    /**
     * @var RegionRepository
     */
    private $regionRepository;

    /**
     * @param RegionRepository $regionRepository
     */
    public function injectRegionRepository(RegionRepository $regionRepository){
        $this->regionRepository = $regionRepository;
    }

    /**
     * @var OrtRepository
     */
    private $ortRepository;

    /**
     * @param OrtRepository $ortRepository
     */
    public function injectOrtRepository(OrtRepository $ortRepository){
        $this->ortRepository = $ortRepository;
    }

    /**
     * @var StadtteilRepository
     */
    private $stadtteilRepository;

    /**
     * @param StadtteilRepository $stadtteilRepository
     */
    public function injectStadtteilRepository(StadtteilRepository $stadtteilRepository){
        $this->stadtteilRepository = $stadtteilRepository;
    }

    /**
     * @var ImmobilieRepository
     */
    private $immobilieRepository;

    /**
     * @param ImmobilieRepository $immobilieRepository
     */
    public function injectImmobilieRepository(ImmobilieRepository $immobilieRepository){
        $this->immobilieRepository = $immobilieRepository;
    }

    /**
     * @var ObjektartRepository
     */
    private $objektartRepository;

    /**
     * @param ObjektartRepository $objektartRepository
     */
    public function injectObjektArtRepository(ObjektartRepository $objektartRepository){
        $this->objektartRepository = $objektartRepository;
    }

    /**
     * @var ObjektarttypRepository
     */
    private $objektarttypRepository;

    /**
     * @param ObjektarttypRepository $objektarttypRepository
     */
    public function injectObjektarttypRepository(ObjektarttypRepository $objektarttypRepository){
        $this->objektarttypRepository = $objektarttypRepository;
    }

    /**
     * @var HeizungsartRepository
     */
    private $heizungsartRepository;

    /**
     * @param HeizungsartRepository $heizungsartRepository
     */
    public function injectHeizungsartRepository(HeizungsartRepository $heizungsartRepository){
        $this->heizungsartRepository = $heizungsartRepository;
    }

    /**
     * @var SessionHandler
     */
    private $sessionHandler;

    /**
     * @param SessionHandler $sessionHandler
     */
    public function injectSessionHandler(SessionHandler $sessionHandler){
        $this->sessionHandler = $sessionHandler;
    }

    /**
     * @var Services
     */
    private $sgEstateCoreServices;

    /**
     * @param Services $services
     */
    public function injectSgEstateCoreServices(Services $services){
        $this->sgEstateCoreServices = $services;
    }

    /**
     * @var ImageService
     */
    protected $imageService;

    /**
     * @param ImageService $imageService
     */
    public function injectImageService(ImageService $imageService){
        $this->imageService = $imageService;
    }

    /**
     * @var Filter
     */
    private $filter;

    /**
     * @var FrontendInterface
     */
    private $cache;

    /**
     * Initializing is called before every Action
     *
     * @throws NoSuchArgumentException
     */
    public function initializeAction(){
        $this->setFilter();

        // Instantiates Cache
        $this->cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgestate_cache');
    }

    /********************************************
     * Actions for MVC
     *********************************************/

    /**
     * Action for Standard Searchbox
     */
    public function searchAction(){
		
		// this fix multilanguge sites 
		$cacheIdentifier = 'search_'.$this->settings['search']['layout'].'_'.implode('', $this->settings['show']).'_'.$this->settings['search']['layout'].'_L'.$this->getLanguageUid();
		//$cacheIdentifier = strtolower($this->settings['search']['layout']).'_search_' . $this->filter->getCacheIdentifier();
	
        
        if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
            $kindOfObjectUids = explode(',', $this->settings['search']['kindOfObjects']);
            foreach ($kindOfObjectUids as $kindOfObjectUid){
                $kindOfObject = $this->objektartRepository->findByUid($kindOfObjectUid);
                if ($kindOfObject instanceof Objektart){
                    $this->filter->addObjektart($kindOfObject);
                }
            }

            if (isset($this->settings['importids']) && $this->settings['importids'] != ''){
                $arrayOfImportIds = explode(',', $this->settings['importids']);
                if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){
                    $this->filter->setImportIds($arrayOfImportIds);
                }else{
                    $this->filter->setImportIds(array());
                }
            }else{
                $arrayOfImportIds = null;
            }

            if ($this->settings['preset']['search']['useSlider'] == 1){
                // BEGIN: Assign Values for Slider-Configuration to View
                $this->view->assign('sizeSliderData', $this->getSizeSliderData());
                $this->view->assign('roomSliderData', $this->getRoomSliderData());
                $this->view->assign('amountSliderData', $this->getAmountSliderData());
                // END: Assign Values for Slider-Configuration to View
            }

            $this->view->assign('regionOptions', $this->regionRepository->getAllForFilter($arrayOfImportIds));
            $this->view->assign('districtOptions', $this->stadtteilRepository->getAllForFilter($this->settings['preset']['search']['districtFormat'], $arrayOfImportIds));
            $this->view->assign('cityOptions', $this->ortRepository->getAllForFilter($arrayOfImportIds));
            $this->view->assign('groupedCitiesAndDistricts', $this->ortRepository->getGroupedCitiesAndDistrictsForFilter($arrayOfImportIds));
            $this->view->assign('filter', $this->filter);

            $entry = $this->view->render();

            $tags = array('search');
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
    }

    /**
     * Action for Standard List View
     */
    public function listAction(){
        /**
         * @var $filter Filter
         */

        if (isset($this->settings['importids']) && $this->settings['importids'] != ''){
            $arrayOfImportIds = explode(',', $this->settings['importids']);
            if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){
                $this->filter->setImportIds($arrayOfImportIds);
            }else{
                $this->filter->setImportIds(array());
            }
        }else{
            $arrayOfImportIds = null;
        }

        if( isset( $this->settings['list']['layout'] ) && $this->settings['list']['layout'] == "LiveSearch" )
        {

            $filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');

            // add city to this filte
            $ort = $this->filter->getOrt();
            if( $ort instanceof Ort )
            {
                $filter->addOrt( $ort );
            }
            if (isset($this->settings['importids']) && $this->settings['importids'] != ''){
                $filter->setImportIds($this->filter->getImportIds());
            }

            $filterToUse = $filter;
            $cacheIdentifier = 'list_'. $this->filter->getCacheIdentifier();
        }
        else
        {
            $filterToUse = $this->filter;
            $cacheIdentifier = 'list_'.$filterToUse->getCacheIdentifier();
        }



        if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {


            $realties = $this->immobilieRepository->findAllWithFilter( $filterToUse );

            if ($this->settings['preset']['search']['useSlider'] == 1){
                // BEGIN: Assign Values for Slider-Configuration to View
                $this->view->assign('sizeSliderData', $this->getSizeSliderData());
                $this->view->assign('roomSliderData', $this->getRoomSliderData());
                $this->view->assign('amountSliderData', $this->getAmountSliderData());
                // END: Assign Values for Slider-Configuration to View
            }
            $this->view->assign('realties', $realties);
            $this->view->assign('instantFilter', $this->generateInstantFilterPresetsFromResult( $realties ) );
            $this->view->assign('districtOptions', $this->stadtteilRepository->getAllForFilter($this->settings['preset']['search']['districtFormat'], $arrayOfImportIds));
            $this->view->assign('cityOptions', $this->ortRepository->getAllForFilter($arrayOfImportIds));
            $this->view->assign('groupedCitiesAndDistricts', $this->ortRepository->getGroupedCitiesAndDistrictsForFilter($arrayOfImportIds));
            $this->view->assign('filter', $this->filter);
            $this->view->assign('aggregatedFilterData', json_encode($this->getAggregatedFilterData()));

            $entry = $this->view->render();

            $tags = array('listing','searchresult');
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;

    }

    /**
     * Action for Standard Detail View
     *
     * @return mixed|string|null
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    public function detailAction(){
        $entry = null;
        if ($this->request->hasArgument('realty')){
            $cacheIdentifier = 'detail_' . sha1($this->request->getArgument('realty'));

            // If $entry is null, it hasn't been cached. Calculate the value and store it in the cache:
            if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
                $realty = $this->immobilieRepository->findOneByUrlIdentifier($this->request->getArgument('realty'));
                $this->view->assign('realty', $realty);
                $this->view->assign('filter', $this->filter);
                $entry = $this->view->render();

                $tags = array('detail');
                $lifetime = $this->settings['defaultCacheLifetime'];

                // Save value in cache
                $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
            }
        }else{
            $this->redirectToUri('/');
        }
        return $entry;
    }

    /**
     * Action for Standard Contact Form & Process
     *
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    public function contactAction(){
        $this->pregenerateContactForm();
        if ($this->request->hasArgument('realty')){
            $realty = $this->immobilieRepository->findOneByUrlIdentifier($this->request->getArgument('realty'));
            $this->view->assign('realty', $realty);
        }elseif ($this->request->hasArgument('formValues')){
            $this->processContactForm();
        }else{
            $this->redirectToUri('/');
        }
    }

    /**
     * Action for Mapinfo Called via AJAX
     */
    public function mapinfoAction(){
        if (isset($_REQUEST['uid'])&&is_numeric($_REQUEST['uid'])){
            $cacheIdentifier = 'mapinfo_' . sha1($_REQUEST['uid']);

            if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
                $immobilie = $this->immobilieRepository->findByUid($_REQUEST['uid']);
                if ($immobilie instanceof \SG\SgEstateCore\Domain\Model\Immobilie){
                    $this->view->assign('realty',$immobilie);
                    $entry = $this->view->render();

                    $tags = array('mapinfo');
                    $lifetime = $this->settings['defaultCacheLifetime'];

                    // Save value in cache
                    $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                }else{
                    $entry = '';
                }
            }
            return $entry;
        }else{
            return '';
        }
    }

    /**
     * Action used for several AJAX Calls
     *
     * ViewHelper for URI Function "allRealties" <f:uri.action action='ajax' controller='Base' arguments='{function:"allRealties"}' additionalParams='{type: 1403693888}' noCacheHash='true' />
     *
     * @return mixed|string
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    public function ajaxAction(){
        if ($this->request->hasArgument('function')){
            $function = $this->request->getArgument('function');
            $this->view->assign('function', ucfirst($function));
            switch ($function){
                case 'realtiesForReactApplication':
                    $cacheIdentifier = 'ajax_realtiesForReactApplication';
                    if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
                        $allRealties = $this->immobilieRepository->findAll();
                        $arrayReturn = array(
                            'realties' => array()
                        );
                        $processingInstructions = array(
                            'width' => '150c',
                            'height' => '112c',
                        );
                        foreach ($allRealties as $realty){
                            /**
                             * @var $realty Immobilie
                             */
                            $district = array();
                            if( $realty->getObjektStadtteil() instanceof Stadtteil )
                            {
                                $district = array(
                                    'id' => $realty->getObjektStadtteil()->getUid(),
                                    'name' => $realty->getObjektStadtteil()->getBezeichner()
                                );
                            }
                            $image = $this->imageService->getImage(Environment::getPublicPath().'/uploads/tx_sgestatecore/media/'.$realty->getTitelbild()->getDatei(),null,false);
                            $processedImage = $this->imageService->applyProcessingInstructions($image, $processingInstructions);

                            array_push($arrayReturn['realties'], array(
                                'show' => false,
                                'highlighted' => false,
                                'id' => $realty->getUid(),
                                'data' => [
                                    'title' => $realty->getObjekttitel(),
                                    'street' => $realty->getObjektStrasse(),
                                    'houseNumber' => $realty->getObjektHausnummer(),
                                    'zip' => $realty->getObjektPlz(),
                                    'size' => $realty->getWohnflaeche(),
                                    'rooms' => $realty->getAnzahlZimmer(),
                                    'rent' => $realty->getNettokaltmiete(),
                                    'balcony' => $realty->getAnzahlBalkone() > 0 ? true : false,
                                    'city' => array(
                                        'id' => $realty->getObjektOrt()->getUid(),
                                        'name' => $realty->getObjektOrt()->getBezeichner()
                                    ),
                                    'district' => $district,
                                ],
                                'media' => [
                                    'preview' => $this->imageService->getImageUri($processedImage)
                                ],
                                'geometry' => [
                                    'location' => [
                                        'lat' => $realty->getObjektBreitengrad(),
                                        'lng' => $realty->getObjektLaengengrad()
                                    ]
                                ],
                            ));
                        }
                        $this->view->assign('jsonReturn', json_encode($arrayReturn));

                        $entry = $this->view->render();

                        $tags = array('ajax_realtiesForReactApplication');
                        $lifetime = $this->settings['defaultCacheLifetime'];

                        // Save value in cache
                        $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                    }
                    break;
                case 'allRealties':
                    $cacheIdentifier = 'ajax_allRealties';

                    if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
                        $allRealties = $this->immobilieRepository->findAll();
                        $arrayReturn = array(
                            'realties' => array(),
                            'cities' => array(),
                            'size' => array('min' => 0, 'max' => 0 ),
                            'rooms' => array('min' => 0, 'max' => 0 ),
                            'rent' => array('min' => 0, 'max' => 0 )
                        );

                        // make list of cities and districts
                        // and find min and max values for slider fields
                        $cities = array();
                        foreach( $allRealties as $realty )
                        {
                            // see whether this realty has higher or lower limes values
                            // size
                            if( $realty->getGesamtflaeche() > $arrayReturn['size']['max'] )
                            {
                                $arrayReturn['size']['max'] = $realty->getGesamtflaeche();
                            }
                            if( $realty->getGesamtflaeche() < $arrayReturn['size']['min'] ||  $arrayReturn['size']['min'] == 0 )
                            {
                                $arrayReturn['size']['min'] = $realty->getGesamtflaeche();
                            }
                            // rooms
                            if( $realty->getAnzahlZimmer() > $arrayReturn['rooms']['max'] )
                            {
                                $arrayReturn['rooms']['max'] = $realty->getAnzahlZimmer();
                            }
                            if( $realty->getAnzahlZimmer() < $arrayReturn['rooms']['min'] || $arrayReturn['rooms']['min'] == 0 )
                            {
                                $arrayReturn['rooms']['min'] = $realty->getAnzahlZimmer();
                            }
                            // rent
                            if( $realty->getNettokaltmiete() > $arrayReturn['rent']['max'] )
                            {
                                $arrayReturn['rent']['max'] = $realty->getNettokaltmiete();
                            }
                            if( $realty->getNettokaltmiete() < $arrayReturn['rent']['min'] || $arrayReturn['rent']['min'] == 0 )
                            {
                                $arrayReturn['rent']['min'] = $realty->getNettokaltmiete();
                            }

                            // find city in cities
                            $cityMatched = false;
                            $citiesCount = count( $cities );
                            for( $i = 0; $i < $citiesCount; $i++ )
                            {
                                if( $cities[$i]['id'] == $realty->getObjektOrt()->getUid() )
                                {
                                    // found match. we have this city
                                    $cityMatched = true;
                                    // take all districts and walk through all districts to find out
                                    // whether we also have this district
                                    $districtMatched = false;
                                    $countDistricts = count( $cities[$i]['districts'] );
                                    if( $realty->getObjektStadtteil() instanceof Stadtteil )
                                    {
                                        for( $k = 0; $k < $countDistricts; $k++ )
                                        {

                                            if( $cities[$i]['districts'][$k]['id'] == $realty->getObjektStadtteil()->getUid() )
                                            {
                                                // this district exists
                                                $districtMatched = true;
                                            }
                                        }
                                        if( $districtMatched === false )
                                        {
                                            // add district to this city
                                            $thisDistrict = array(
                                                'id' => $realty->getObjektStadtteil()->getUid(),
                                                'name' => $realty->getObjektStadtteil()->getBezeichner()
                                            );
                                            $cities[$i]['districts'][] = $thisDistrict;
                                        }
                                    }
                                }
                            }
                            if( $cityMatched === false )
                            {
                                // add city to city stack
                                // add district to new city stack
                                $districts = array();
                                if( $realty->getObjektStadtteil() instanceof Stadtteil )
                                {
                                    $districts = array(
                                        array(
                                            'id' => $realty->getObjektStadtteil()->getUid(),
                                            'name' => $realty->getObjektStadtteil()->getBezeichner()
                                        )
                                    );
                                }
                                $thisCity = array(
                                    'id' => $realty->getObjektOrt()->getUid(),
                                    'name' => $realty->getObjektOrt()->getBezeichner(),
                                    'districts' => $districts
                                );
                                $cities[] = $thisCity;
                            }
                        }
                        $arrayReturn['cities'] = $cities;

                        $tempRegions = array();

                        foreach ($cities as $city){
                            $regionsForCity = $this->regionRepository->findRegionsForCity($this->ortRepository->findByUid($city['id']));
                            foreach ($regionsForCity as $region){
                                /**
                                 * @var Region $region
                                 */
                                $tempRegions[$region->getBezeichner()] = array(
                                    'id' => $region->getUid(),
                                    'name' => $region->getBezeichner()
                                );
                            }
                        }
                        ksort($tempRegions);
                        $tempRegions = array_values($tempRegions);

                        $arrayReturn['regions'] = $tempRegions;

                        foreach ($allRealties as $realty){
                            /**
                             * @var $realty Immobilie
                             */
                            $district = array();
                            if( $realty->getObjektStadtteil() instanceof Stadtteil )
                            {
                                $district = array(
                                    'id' => $realty->getObjektStadtteil()->getUid(),
                                    'name' => $realty->getObjektStadtteil()->getBezeichner()
                                );
                            }
                            array_push($arrayReturn['realties'], array(
                                'uid' => $realty->getUid(),
                                'city' => array(
                                    'id' => $realty->getObjektOrt()->getUid(),
                                    'name' => $realty->getObjektOrt()->getBezeichner()
                                ),
                                'district' => $district,
                                'rooms' => $realty->getAnzahlZimmer(),
                                'size' => $realty->getWohnflaeche(),
                                'rent' => $realty->getNettokaltmiete(),
                            ));
                        }

                        $this->view->assign('jsonReturn', json_encode($arrayReturn));

                        $entry = $this->view->render();

                        $tags = array('ajax_allRealties');
                        $lifetime = $this->settings['defaultCacheLifetime'];

                        // Save value in cache
                        $this->cache->set($cacheIdentifier, $entry, $tags, $lifetime);
                    }
                    return $entry;
                    break;
                case 'contactForm':
                    $this->pregenerateContactForm();
                    if ($this->request->hasArgument('realtyUid')){
                        $this->view->assign('realty', array('uid' => $this->request->getArgument('realtyUid')));
                    }
                    if ($this->request->hasArgument('formValues')){
                        $this->processContactForm();
                    }
                    break;
                case 'getDistance':
                    if ($this->request->hasArgument('realtyUid')){
                        $realty = $this->immobilieRepository->findOneByUid($this->request->getArgument('realtyUid'));
                        if ($realty instanceof Immobilie){
                            $this->view->assign('distance', $this->calcDistance($realty->getObjektBreitengrad(), $realty->getObjektLaengengrad(), $this->filter->getLatitude(), $this->filter->getLongitude()));
                        }
                    }
                    break;
                default:
                    break;
            }
        }else{
            die('');
        }

    }

    /********************************************
     * Internal & Helper Functions
     *********************************************/

    private function calcDistance($latitudePoint1, $longitudePoint1, $latitudePoint2, $longitudePoint2){
        $pi80 = M_PI / 180;
        $latitudePoint1 *= $pi80;
        $longitudePoint1 *= $pi80;
        $latitudePoint2 *= $pi80;
        $longitudePoint2 *= $pi80;
        $r = 6372.797; // mean radius of Earth in km
        $dlat = $latitudePoint2 - $latitudePoint1;
        $dlon = $longitudePoint2 - $longitudePoint1;
        $a = sin($dlat / 2) * sin($dlat / 2) + cos($latitudePoint1) * cos($latitudePoint2) * sin($dlon / 2) * sin($dlon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $km = $r * $c;
        return $km;
    }

    private function pregenerateContactForm(){
        $this->view->assign('salutationOptions', $this->getSalutationOptions());
    }

    private function transformFieldConfiguration(){
        $transformedConfiguration = array();
        foreach ($this->settings['contact']['fields'] as $fieldConfiguration){
            $transformedConfiguration[$fieldConfiguration['name']] = $fieldConfiguration;
        }
        return $transformedConfiguration;
    }

    /**
     * @throws NoSuchArgumentException
     * @throws StopActionException
     * @throws UnsupportedRequestTypeException
     */
    private function processContactForm(){
        /**
         * @var $formValues array
         * @var $realty Immobilie
         */
        $formValues = $this->request->getArgument('formValues');

        $processedFormValues = array();
        $errors = array();
        foreach ($this->settings['contact']['fields'] as $fieldConfiguration){
            if ($fieldConfiguration['required'] == 1 && (!isset($formValues[$fieldConfiguration['name']]) || $formValues[$fieldConfiguration['name']] == '')){
                $errors[$fieldConfiguration['name']][] = 'required';
            }else{
                $processedFormValues[$fieldConfiguration['name']] = isset($formValues[$fieldConfiguration['name']]) ? $formValues[$fieldConfiguration['name']] : '';
            }
        }

        $realty = $this->immobilieRepository->findByUid($formValues['realty']);

        if (count($errors) == 0){
            $valid = true;
        }else{
            $valid = false;
        }

        if ($valid){
            // Generate Receivers
            if ($this->settings['contact']['useRealtyContactAsReceiver'] == 1){
                $emailDirekt = $realty->getKontaktperson()->getEmailDirekt();
                $emailZentrale = $realty->getKontaktperson()->getEmailZentrale();
                $emailSonstige = $realty->getKontaktperson()->getEmailSonstige();
                if (GeneralUtility::validEmail($emailDirekt)){
                    $receivers = array($emailDirekt);
                }elseif (GeneralUtility::validEmail($emailZentrale)){
                    $receivers = array($emailZentrale);
                }elseif (GeneralUtility::validEmail($emailSonstige)){
                    $receivers = array($emailSonstige);
                }else{
                    $receivers = explode(',',$this->settings['contact']['receivers']);
                }
            }else{
                $receivers = explode(',',$this->settings['contact']['receivers']);
            }

            if ($this->settings['contact']['addFeedbackAttachment']){
                $attachmentContent = $this->generateFeedbackAttachment('Email/FeedbackAttachment', array('processedFormValues' => $processedFormValues, 'settings' => $this->settings, 'realty' => $realty), 'xml');
                $attachment = [
                    'type' => 'content',
                    'content' => $attachmentContent,
                    'filename' => 'feedback.xml'
                ];
                $attachments = array($attachment);
            }else{
                $attachments = array();
            }


            $success = $this->sgEstateCoreServices->sendTemplateEmail($receivers,$this->settings['contact']['sender'],$this->settings['contact']['subject'],'SgEstateBaseContact',array(),array('realty' => $realty, 'formValues' => $processedFormValues, 'settings' => $this->settings),$attachments,$this->settings['contact']['mailformat']);

            if ($success && intval($this->settings['contact']['redirectPidSuccess'])>0){
                $uriBuilder = $this->controllerContext->getUriBuilder();
                $uriBuilder->reset();
                $uriBuilder->setTargetPageUid(intval($this->settings['contact']['redirectPidSuccess']));
                $uri = $uriBuilder->build();
                $this->redirectToUri($uri);
            }elseif (!$success && intval($this->settings['contact']['redirectPidFailure'])>0){
                $uriBuilder = $this->controllerContext->getUriBuilder();
                $uriBuilder->reset();
                $uriBuilder->setTargetPageUid(intval($this->settings['contact']['redirectPidFailure']));
                $uri = $uriBuilder->build();
                $this->redirectToUri($uri);
            }elseif ($success && intval($this->settings['contact']['redirectPidSuccess']) == 0){
                $this->view->assign('showResult', true);
                $this->view->assign('success', true);
            }elseif (!$success && intval($this->settings['contact']['redirectPidFailure']) == 0){
                $this->view->assign('showResult', true);
                $this->view->assign('success', false);
            }
        }else{
            $this->view->assign('formValues', $formValues);
            if (is_array($formValues['channel'])){
                $this->view->assign('channelValues', array_fill_keys(array_keys(array_flip($formValues['channel'])), 1));
            }
            if (is_array($formValues['wish'])){
                $this->view->assign('wishValues', array_fill_keys(array_keys(array_flip($formValues['wish'])), 1));
            }
            $this->view->assign('errors', $errors);
        }
        $this->view->assign('realty', $realty);
    }

    /**
     * Get Salutation for Contact Form
     *
     * @return array
     */
    private function getSalutationOptions(){
        return array(
            'mr' => LocalizationUtility::translate('template.contact.salutation.mr', 'sg_estate_base'),
            'mrs' => LocalizationUtility::translate('template.contact.salutation.mrs', 'sg_estate_base' ),
        );
    }

    /**
     * Sets Property Filter from Request Arguments
     *
     * @throws NoSuchArgumentException
     */
    private function setFilter(){
        if ($this->request->hasArgument('filter')){
            /**
             * @var $filterValues array
             */
            $this->filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');

            $filterValues = $this->request->getArgument('filter');

            // extract city and districts from groupedCitiesAndDistricts if set
            // and override filter value city and add filter values district
            if( isset( $filterValues['groupedCitiesAndDistricts'] ) && $filterValues['groupedCitiesAndDistricts'] != '' )
            {
                $split = explode('_', $filterValues['groupedCitiesAndDistricts'] );
                if( isset( $split[0] ) && is_numeric( $split[0] ) )
                {
                    $filterValues['city'] = $split[0];
                }
                if( isset( $split[1] ) && is_numeric( $split[1] ) )
                {
                    $filterValues['district'][] = $split[1];
                }
            }

            if (isset($filterValues['regions']) && is_array($filterValues['regions']) && count($filterValues['regions']) > 0){
                foreach ($filterValues['regions'] as $regionUid){
                    $region = $this->regionRepository->findByUid($regionUid);
                    if ($region instanceof Region){
                        $this->filter->addRegion($region);
                    }
                }
            }
            if (isset($filterValues['region']) && is_numeric($filterValues['region'])){
                $region = $this->regionRepository->findByUid($filterValues['region']);
                if ($region instanceof Region){
                    $this->filter->setRegion($region);
                }
            }

            if (is_numeric($filterValues['city'])){
                $ort = $this->ortRepository->findByUid($filterValues['city']);
                if ($ort instanceof \SG\SgEstateCore\Domain\Model\Ort){
                    $this->filter->setOrt($ort);
                }
            }
            if (isset($filterValues['cities']) && is_array($filterValues['cities']) && count($filterValues['cities']) > 0){
                foreach ($filterValues['cities'] as $cityUid){
                    $city = $this->ortRepository->findByUid($cityUid);
                    if ($city instanceof Ort){
                        $this->filter->addOrt($city);
                    }
                }
            }

            if (is_numeric($filterValues['district'])){
                $stadtteil = $this->stadtteilRepository->findByUid($filterValues['district']);
                if ($stadtteil instanceof \SG\SgEstateCore\Domain\Model\Stadtteil){
                    $this->filter->addStadtteil($stadtteil);
                }

            }elseif(is_array($filterValues['district'])){
                foreach($filterValues['district'] as $stadtteilUid){
                    $stadtteil = $this->stadtteilRepository->findByUid($stadtteilUid);
                    if ($stadtteil instanceof \SG\SgEstateCore\Domain\Model\Stadtteil){
                        $this->filter->addStadtteil($stadtteil);
                    }
                }
            }

            $this->filter->setRaeumeAb(is_numeric($filterValues['roomMin']) ? floatval($filterValues['roomMin']) : null);
            $this->filter->setRaeumeBis(is_numeric($filterValues['roomMax']) ? floatval($filterValues['roomMax']) : null);

            $this->filter->setFlaecheAb(is_numeric($filterValues['sizeMin']) ? floatval($filterValues['sizeMin']) : null);
            $this->filter->setFlaecheBis(is_numeric($filterValues['sizeMax']) ? floatval($filterValues['sizeMax']) : null);

            $this->filter->setKaltmieteAb(is_numeric($filterValues['rentMin']) ? floatval($filterValues['rentMin']) : null);
            $this->filter->setKaltmieteBis(is_numeric($filterValues['rentMax']) ? floatval($filterValues['rentMax']) : null);

            if (isset($filterValues['kindOfObjects'])){
                $objektarten = new ObjectStorage();
                foreach ($filterValues['kindOfObjects'] as $uid){
                    $objektart = $this->objektartRepository->findByUid($uid);
                    if ($objektart instanceof Objektart){
                        $objektarten->attach($objektart);
                    }
                }
                if ($objektarten->count() > 0){
                    $this->filter->setObjektarten($objektarten);
                }
            }

            if (isset($filterValues['objektartTypen'])&&is_array($filterValues['objektartTypen'])){
                $objektartTypen = new ObjectStorage();
                foreach ($filterValues['objektartTypen'] as $item){
                    $objektartTyp = $this->objektarttypRepository->findOneByKuerzel($item);
                    if ($objektartTyp instanceof Objektarttyp){
                        $objektartTypen->attach($objektartTyp);
                    }
                }
                if ($objektartTypen->count() > 0){
                    $this->filter->setObjektarttypen($objektartTypen);
                }
            }

            if (isset($filterValues['heizungsarten'])&&is_array($filterValues['heizungsarten'])){
                $heizungsarten = new ObjectStorage();
                foreach ($filterValues['heizungsarten'] as $item){
                    $heizungsart = $this->heizungsartRepository->findOneByKuerzel($item);
                    if ($heizungsart instanceof Heizungsart){
                        $heizungsarten->attach($heizungsart);
                    }
                }
                if ($heizungsarten->count() > 0){
                    $this->filter->setHeizungsarten($heizungsarten);
                }
            }
            $this->filter->setAufzug(is_numeric($filterValues['aufzug']) ? intval($filterValues['aufzug']) : null);
            $this->filter->setBarrierefrei(is_numeric($filterValues['barrierefrei']) ? intval($filterValues['barrierefrei']) : null);

            if (isset($filterValues['latitude']) && isset($filterValues['longitude']) && is_numeric($filterValues['latitude']) && is_numeric($filterValues['longitude']) && $filterValues['latitude'] != 0 && $filterValues['longitude'] != 0){
                $this->filter->setLatitude($filterValues['latitude']);
                $this->filter->setLongitude($filterValues['longitude']);
                if (isset($filterValues['radius']) && is_numeric($filterValues['radius']) && $filterValues['radius'] > 0){
                    $this->filter->setRadius($filterValues['radius']);
                }else{
                    $this->filter->setRadius($this->settings['preset']['search']['radius']);
                }
            }
            if (isset($filterValues['addressString']) && $filterValues['addressString'] != ''){
                $this->filter->setAddressString($filterValues['addressString']);
            }else{
                $this->filter->setAddressString('');
            }

            if (isset($filterValues['personsFrom']) && is_numeric($filterValues['personsFrom']) && $filterValues['personsFrom'] > 0){
                $this->filter->setPersonsFrom($filterValues['personsFrom']);
            }else{
                $this->filter->setPersonsFrom(0);
            }
            if (isset($filterValues['personsTo']) && is_numeric($filterValues['personsTo']) && $filterValues['personsTo'] > 0){
                $this->filter->setPersonsTo($filterValues['personsTo']);
            }else{
                $this->filter->setPersonsTo(0);
            }
            if (isset($filterValues['persons']) && $filterValues['persons'] != ''){
                $this->filter->setPersonsString($filterValues['persons']);

                $tempPersonsArray = explode('-', $filterValues['persons']);
                if (isset($tempPersonsArray[0]) && is_numeric($tempPersonsArray[0]) && $tempPersonsArray[0] > 0){
                    $this->filter->setPersonsFrom($tempPersonsArray[0]);
                }else{
                    $this->filter->setPersonsFrom(0);
                }
                if (isset($tempPersonsArray[1]) && is_numeric($tempPersonsArray[1]) && $tempPersonsArray[1] > 0){
                    $this->filter->setPersonsTo($tempPersonsArray[1]);
                }else{
                    $this->filter->setPersonsTo(0);
                }
            }
        }else{
            // No Data for Filter in Request
            $filter = $this->sessionHandler->restoreFromSession('filter');
            if ($filter instanceof Filter){
                $this->filter = $filter;
            }else{
                $this->filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');
            }
        }

        $this->sessionHandler->writeToSession($this->filter, 'filter');
    }

    /**
     * Generate Array with Slider Data for the Size Slider
     * @todo: Read from Config
     *
     * @return array
     */
    private function getSizeSliderData(){
        return array(
            'range' => $this->settings['preset']['slider']['size']['range'],
            'min'   => $this->settings['preset']['slider']['size']['min'],
            'max'   => $this->settings['preset']['slider']['size']['max'],
            'value' => $this->settings['preset']['slider']['size']['value']
        );
    }

    /**
     * Generate Array with Slider Data for the Room Slider
     * @todo: Read from Config
     *
     * @return array
     */
    private function getRoomSliderData(){
        return array(
            'range' => $this->settings['preset']['slider']['room']['range'],
            'min'   => $this->settings['preset']['slider']['room']['min'],
            'max'   => $this->settings['preset']['slider']['room']['max'],
            'value' => $this->settings['preset']['slider']['room']['value']
        );
    }

    /**
     * Generate Array with Slider Data for the Amount Slider
     * @todo: Read from Config
     *
     * @return array
     */
    private function getAmountSliderData(){
        return array(
            'range' => $this->settings['preset']['slider']['amount']['range'],
            'min'   => $this->settings['preset']['slider']['amount']['min'],
            'max'   => $this->settings['preset']['slider']['amount']['max'],
            'value' => $this->settings['preset']['slider']['amount']['value']
        );
    }

    /**
     * @param $result
     * @return array
     */
    private function generateInstantFilterPresetsFromResult( $result )
    {
        $presets = array();

        // Initialize
        $cities = array();
        $balcony = false;
        $lift = false;
        $wbs = false;
        $bathShower = false;
        $bathTub = false;
        $bathWindow = false;

        foreach ($result as $realty) {
            /**
             * @var $realty Immobilie
             */
            // City & Distric
            $cities[$realty->getObjektOrt()->getUid()]['bezeichner'] = $realty->getObjektOrt()->getBezeichner();
            if (is_object($realty->getObjektStadtteil())){
                $cities[$realty->getObjektOrt()->getUid()]['districts'][$realty->getObjektStadtteil()->getUid()] = array(
                    'uid' => $realty->getObjektStadtteil()->getUid(),
                    'bezeichner' => $realty->getObjektStadtteil()->getBezeichner()
                );
            }

            // Balcony
            if ($realty->getAnzahlBalkone() > 0){$balcony = true;}

            // Lift
            if ($realty->getAufzugPersonen() == 1){$lift = true;}

            // WBS
            if ($realty->getWbsErforderlich() == 1){$wbs = true;}

            // Bath
            /**
             * @var $badAusstattung Badausstattung
             */
            foreach ($realty->getAusstattungBad() as $badAusstattung){
                if ($badAusstattung->getKuerzel() == 'WANNE'){$bathTub = true;}
                if ($badAusstattung->getKuerzel() == 'DUSCHE'){$bathShower = true;}
                if ($badAusstattung->getKuerzel() == 'FENSTER'){$bathWindow = true;}
            }
        }

        $regions = array();

        foreach ($cities as $key => $value){
            $regionsForCity = $this->regionRepository->findRegionsForCity($this->ortRepository->findByUid($key));
            foreach ($regionsForCity as $region){
                /**
                 * @var Region $region
                 */
                $regions[$region->getBezeichner()] = array(
                    'id' => $region->getUid(),
                    'name' => $region->getBezeichner()
                );
            }
        }

        ksort($regions);
        $regions = array_values($regions);

        // Build Return Variable
        $presets['regions'] = $regions;
        $presets['cities'] = $cities;
        $presets['balcony'] = $balcony;
        $presets['lift'] = $lift;
        $presets['wbs'] = $wbs;
        $presets['bathShower'] = $bathShower;
        $presets['bathTub'] = $bathTub;
        $presets['bathWindow'] = $bathWindow;

        return $presets;
    }

    private function generateFeedbackAttachment($templateName, array $variables = array(), $format = 'xml'){
        /**
         * @var $standaloneView StandaloneView
         */
        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);

        $standaloneView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
        $standaloneView->setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $standaloneView->setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $standaloneView->setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $standaloneView->setTemplate($templateName);

        $standaloneView->setFormat($format);
        $standaloneView->assignMultiple($variables);

        $fileContent = $standaloneView->render();

        return $fileContent;

    }

    /**
     * Sends Mail via configured TYPO3 Mailer System with Fluid Standalone Template
     *
     * @todo: Use Function from Core
     *
     * @param array $recipients
     * @param array $bcc
     * @param $sender
     * @param $subject
     * @param $templateName
     * @param array $variables
     * @param string $format
     * @return bool
     */
    private function sendTemplateEmail(array $recipients = array(), array $bcc = array(), $sender, $subject, $templateName, array $variables = array(), $format = 'text/plain', $attachments = array()) {
        /**
         * @var $emailView StandaloneView
         * @var $message MailMessage
         */
        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);

        $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
        $emailView->setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $emailView->setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $emailView->setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $emailView->setTemplate($templateName);

        $emailView->setFormat('html');
        $emailView->assignMultiple($variables);

        $emailBody = $emailView->render();

        $message = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');

        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)){
            $message->setFrom($sender);
        }else{
            return false;
        }

        // Add Recipients
        $recipients = array_filter($recipients);
        if (count($recipients) > 0){
            foreach ($recipients as $email){
                if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
                    $message->addTo($email);
                }
            }
        }else{
            return false;
        }

        if (count($bcc) > 0){
            foreach ($bcc as $email){
                if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
                    $message->addBcc($email);
                }
            }
        }

        if ($subject != ''){
            $message->setSubject($subject);
        }else{
            return false;
        }

        if (count($attachments) > 0){
            foreach ($attachments as $attachment){
                $message->attach($attachment);
            }
        }

        $message->setBody($emailBody, $format);

        $message->send();
        return $message->isSent();
    }
    
    
    /**
	 * Get the current language
	 */
	private function getLanguageUid() {
		$context = GeneralUtility::makeInstance(Context::class);
		$sysLanguageUid = $context->getPropertyFromAspect('language', 'id');
		if (is_numeric($sysLanguageUid)) {
			return $sysLanguageUid;
		} else {
			return 0;
		}
	}

	private function getAggregatedFilterData(){
        return [
            'size' => !$this->filter->getFlaecheAb() ? $this->getSizeSliderData()['value'] : $this->filter->getFlaecheAb(),
            'rooms' => !$this->filter->getRaeumeAb() ? $this->getRoomSliderData()['value'] : $this->filter->getRaeumeAb(),
            'rent' => !$this->filter->getKaltmieteBis() ? $this->getAmountSliderData()['value'] : $this->filter->getKaltmieteBis()
        ];
    }

}
