<?php
namespace SG\SgDisposer\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class DisposerController extends ActionController
{
    /**
     * @var \SG\SgDisposer\Domain\Repository\CityRepository
     * @inject
     */
    protected $cityRepository;


    public function indexAction(){
        $cacheIdentifier = 'disposer_city_list';
        $cache = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class)->getCache('sgdisposer_cache');

        if (($entry = $cache->get($cacheIdentifier)) === FALSE) {

            $this->view->assign('cities', $this->cityRepository->findAll());
            $entry = $this->view->render();

            $tags = array();
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
    }
}