<?php
namespace SG\SgCourses\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Mark Kirstein 
 */
class CourseControllerTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \SG\SgCourses\Controller\CourseController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\SG\SgCourses\Controller\CourseController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function listActionFetchesAllCoursesFromRepositoryAndAssignsThemToView()
    {

        $allCourses = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->disableOriginalConstructor()
            ->getMock();

        $courseRepository = $this->getMockBuilder(\SG\SgCourses\Domain\Repository\CourseRepository::class)
            ->setMethods(['findAll'])
            ->disableOriginalConstructor()
            ->getMock();
        $courseRepository->expects(self::once())->method('findAll')->will(self::returnValue($allCourses));
        $this->inject($this->subject, 'courseRepository', $courseRepository);

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $view->expects(self::once())->method('assign')->with('courses', $allCourses);
        $this->inject($this->subject, 'view', $view);

        $this->subject->listAction();
    }

    /**
     * @test
     */
    public function showActionAssignsTheGivenCourseToView()
    {
        $course = new \SG\SgCourses\Domain\Model\Course();

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $this->inject($this->subject, 'view', $view);
        $view->expects(self::once())->method('assign')->with('course', $course);

        $this->subject->showAction($course);
    }
}
