<?php

namespace SG\SgCourses\Controller;

use SG\SgCourses\Domain\Model\Course;
use SG\SgCourses\Utility\SiteConfigurationUtility;
use TYPO3\CMS\Core\TypoScript\TypoScriptService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\Category;
use TYPO3\CMS\Extbase\Mvc\View\ViewInterface;

/***
 *
 * This file is part of the "Courses" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein
 *
 ***/

/**
 * CourseController
 */
class CourseController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    const EXT_KEY = 'sg_courses';
    const EXT_KEY_PROVIDER = 'sg_sitepackage_bizzel';

    /**
     * courseRepository
     *
     * @var \SG\SgCourses\Domain\Repository\CourseRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $courseRepository = null;

    /**
     * courseRepository
     *
     * @var \SG\SgCourses\Domain\Repository\CourseDateRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $courseDateRepository = null;

    /**
     * action list
     *
     * @return void
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function listAction()
    {
        $courses = $this->courseDateRepository->findByFilter(
            (int)$this->settings['maxItems'],
            $this->settings['eventCategories'],
            0
        );
        $filterCategories = [];
        if ($courses->count() > 0) {
            foreach ($courses as $date) {
                foreach ($date->getCourse()->getCourseCategories() as $category) {
                    $filterCategories[$category->getUid()] = $category;
                }
            }
        }
        $this->view->assignMultiple(
            [
                'courses' => $courses,
                'filterCategories' => $filterCategories
            ]
        );
    }

    /**
     * @param Category $category
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function listByCategoryAction(Category $category)
    {
        $allCcourses = $this->courseDateRepository->findByFilter(
            (int)$this->settings['maxItems'],
            $this->settings['eventCategories'],
            0
        );
        $filterCategories = [];
        $filteredCourses = [];
        if ($allCcourses->count() > 0) {
            foreach ($allCcourses as $date) {
                foreach ($date->getCourse()->getCourseCategories() as $cat) {
                    $filterCategories[$cat->getUid()] = $cat;
                    if ($cat->getUid() === (int)$category->getUid()) {
                        $filteredCourses[] = $date;
                    }
                }
            }
        }

        $this->view->assignMultiple([
            'filterCategory' => $category,
            'filterCategories' => $filterCategories,
            'courses' => $filteredCourses
        ]);
    }

    /**
     * action show
     *
     * @param \SG\SgCourses\Domain\Model\Course $course
     * @param int $timestamp
     * @return void
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function showAction(Course $course = null, $timestamp = null)
    {
        if ($course) {
            $clickedDate = null;
            if ($timestamp !== null) {
                foreach ($course->getDates() as $date) {
                    if ($date->getCourseStart()->getTimestamp() === $timestamp) {
                        $clickedDate = $date;
                        break;
                    }
                }
            }

            if ($course->getRelated()->count() < 1) {
                $courseCategories = [];
                foreach ($course->getCourseCategories() as $category) {
                    $courseCategories[] = $category->getUid();
                }

                $shuffleLimit = 15;
                $countAllCourses = $this->courseRepository->countUpcoming(implode(',', $courseCategories));
                $maxOffsetValue = $countAllCourses - $shuffleLimit;

                $maxOffsetValue < $shuffleLimit ? $maxOffset = 0 : $maxOffset = $maxOffsetValue;

                $offset = rand(1, $maxOffset);
                $randomCourses = $this->courseRepository->findAdditional(
                    (int)15,
                    implode(',', $courseCategories),
                    $offset
                )->toArray();

                $shuffledCourses = array();
                $keys = array_keys($randomCourses);
                shuffle($keys);

                foreach ($keys as $key) {
                    $shuffledCourses[$key] = $randomCourses[$key];
                }
            } else {
                $shuffledCourses = $course->getRelated();
            }

            $this->view->assignMultiple([
                'course' => $course,
                'date' => $clickedDate,
                'shuffledCourses' => $shuffledCourses
            ]);
        }
    }

    /**
     * action show
     *
     * @param \SG\SgCourses\Domain\Model\Course $course
     * @param int $timestamp
     * @return void
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function bookingAction(Course $course = null, $timestamp = null)
    {
        $clickedDate = null;
        if ($timestamp !== null) {
            foreach ($course->getDates() as $date) {
                if ($date->getCourseStart()->getTimestamp() === $timestamp) {
                    $clickedDate = $date;
                    break;
                }
            }
        }

        $this->view->assignMultiple([
            'course' => $course,
            'date' => $clickedDate
        ]);
    }

    /**
     * Adds Site Configuration to every Fluid View
     *
     * @param ViewInterface $view
     */
    protected function initializeView(ViewInterface $view)
    {
        parent::initializeView($view); // TODO: Change the autogenerated stub
        $this->view->assign('config', SiteConfigurationUtility::getExtensionConfigurationFromSite([
            'sgCoursesSeminarsListPid',
            'sgCoursesSeminarsDetailPid',
            'sgCoursesSeminarsBookingPid'
        ]));
        $typoScriptService = GeneralUtility::makeInstance(TypoScriptService::class);
        $trimDots = $typoScriptService->convertTypoScriptArrayToPlainArray($GLOBALS['TSFE']->tmpl->setup);
        $this->settings = array_replace_recursive(
            $this->settings,
            $trimDots['plugin']['tx_sg_sitepackage']['settings']
        );
    }
}
