<?php

namespace SG\SgCourses\Domain\Model;

/***
 *
 * This file is part of the "Courses" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein
 *
 ***/

/**
 * Course
 */
class Course extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * id
     *
     * @var string
     */
    protected $id = '';

    /**
     * id
     *
     * @var string
     */
    protected $pathSegment = '';

    /**
     * externalLink
     *
     * @var string
     */
    protected $externalLink = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * subtitle
     *
     * @var string
     */
    protected $subtitle = '';

    /**
     * images
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $images = null;

    /**
     * teaser
     *
     * @var string
     */
    protected $teaser = '';

    /**
     * bodytext
     *
     * @var string
     */
    protected $bodytext = '';

    /**
     * priceVvk
     *
     * @var float
     */
    protected $priceVvk = 0.0;

    /**
     * priceCashbox
     *
     * @var float
     */
    protected $priceCashbox = 0.0;

    /**
     * priceReduced
     *
     * @var float
     */
    protected $priceReduced = 0.0;

    /**
     * courseCategories
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseCategory>
     */
    protected $courseCategories = null;

    /**
     * dates
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseDate>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $dates = null;

    /**
     * related
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\Course>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $related = null;

    /**
     * locations
     *
     * @var \SG\SgCourses\Domain\Model\CourseLocation
     */
    protected $locations = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->images = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->dates = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->related = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->courseCategories = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the id
     *
     * @return string $id
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Sets the id
     *
     * @param string $id
     * @return void
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the subtitle
     *
     * @return string $subtitle
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }

    /**
     * Sets the subtitle
     *
     * @param string $subtitle
     * @return void
     */
    public function setSubtitle($subtitle)
    {
        $this->subtitle = $subtitle;
    }

    /**
     * Adds a FileReference
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
     * @return void
     */
    public function addImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $image)
    {
        $this->images->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove The FileReference to be removed
     * @return void
     */
    public function removeImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove)
    {
        $this->images->detach($imageToRemove);
    }

    /**
     * Returns the images
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     */
    public function getImages()
    {
        return $this->images;
    }

    /**
     * Sets the images
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     * @return void
     */
    public function setImages(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $images)
    {
        $this->images = $images;
    }

    /**
     * Returns the bodytext
     *
     * @return string $bodytext
     */
    public function getBodytext()
    {
        return $this->bodytext;
    }

    /**
     * Sets the bodytext
     *
     * @param string $bodytext
     * @return void
     */
    public function setBodytext($bodytext)
    {
        $this->bodytext = $bodytext;
    }

    /**
     * Returns the priceVvk
     *
     * @return float $priceVvk
     */
    public function getPriceVvk()
    {
        return $this->priceVvk;
    }

    /**
     * Sets the priceVvk
     *
     * @param float $priceVvk
     * @return void
     */
    public function setPriceVvk($priceVvk)
    {
        $this->priceVvk = $priceVvk;
    }

    /**
     * Returns the priceCashbox
     *
     * @return float $priceCashbox
     */
    public function getPriceCashbox()
    {
        return $this->priceCashbox;
    }

    /**
     * Sets the priceCashbox
     *
     * @param float $priceCashbox
     * @return void
     */
    public function setPriceCashbox($priceCashbox)
    {
        $this->priceCashbox = $priceCashbox;
    }

    /**
     * Returns the priceReduced
     *
     * @return float $priceReduced
     */
    public function getPriceReduced()
    {
        return $this->priceReduced;
    }

    /**
     * Sets the priceReduced
     *
     * @param float $priceReduced
     * @return void
     */
    public function setPriceReduced($priceReduced)
    {
        $this->priceReduced = $priceReduced;
    }

    /**
     * Adds a CourseDate
     *
     * @param \SG\SgCourses\Domain\Model\CourseDate $date
     * @return void
     */
    public function addDate(\SG\SgCourses\Domain\Model\CourseDate $date)
    {
        $this->dates->attach($date);
    }

    /**
     * Removes a CourseDate
     *
     * @param \SG\SgCourses\Domain\Model\CourseDate $dateToRemove The CourseDate to be removed
     * @return void
     */
    public function removeDate(\SG\SgCourses\Domain\Model\CourseDate $dateToRemove)
    {
        $this->dates->detach($dateToRemove);
    }

    /**
     * Returns the dates
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseDate> $dates
     */
    public function getDates()
    {
        return $this->dates;
    }

    /**
     * Sets the dates
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseDate> $dates
     * @return void
     */
    public function setDates(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $dates)
    {
        $this->dates = $dates;
    }

    /**
     * Adds a Course
     *
     * @param \SG\SgCourses\Domain\Model\Course $related
     * @return void
     */
    public function addRelated(\SG\SgCourses\Domain\Model\Course $related)
    {
        $this->related->attach($related);
    }

    /**
     * Removes a Course
     *
     * @param \SG\SgCourses\Domain\Model\Course $relatedToRemove The Course to be removed
     * @return void
     */
    public function removeRelated(\SG\SgCourses\Domain\Model\Course $relatedToRemove)
    {
        $this->related->detach($relatedToRemove);
    }

    /**
     * Returns the related
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\Course> $related
     */
    public function getRelated()
    {
        return $this->related;
    }

    /**
     * Sets the related
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\Course> $related
     * @return void
     */
    public function setRelated(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $related)
    {
        $this->related = $related;
    }

    /**
     * Adds a CourseCategory
     *
     * @param \SG\SgCourses\Domain\Model\CourseCategory $courseCategory
     * @return void
     */
    public function addCourseCategory(\SG\SgCourses\Domain\Model\CourseCategory $courseCategory)
    {
        $this->courseCategories->attach($courseCategory);
    }

    /**
     * Removes a CourseCategory
     *
     * @param \SG\SgCourses\Domain\Model\CourseCategory $courseCategoryToRemove The CourseCategory to be removed
     * @return void
     */
    public function removeCourseCategory(\SG\SgCourses\Domain\Model\CourseCategory $courseCategoryToRemove)
    {
        $this->courseCategories->detach($courseCategoryToRemove);
    }

    /**
     * Returns the courseCategories
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseCategory> $courseCategories
     */
    public function getCourseCategories()
    {
        return $this->courseCategories;
    }

    /**
     * Sets the courseCategories
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgCourses\Domain\Model\CourseCategory> $courseCategories
     * @return void
     */
    public function setCourseCategories(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $courseCategories)
    {
        $this->courseCategories = $courseCategories;
    }

    /**
     * Returns the locations
     *
     * @return \SG\SgCourses\Domain\Model\CourseLocation $locations
     */
    public function getLocations()
    {
        return $this->locations;
    }

    /**
     * Sets the locations
     *
     * @param \SG\SgCourses\Domain\Model\CourseLocation $locations
     * @return void
     */
    public function setLocations(\SG\SgCourses\Domain\Model\CourseLocation $locations)
    {
        $this->locations = $locations;
    }

    /**
     * @return string
     */
    public function getPathSegment(): string
    {
        return $this->pathSegment;
    }

    /**
     * @param string $pathSegment
     */
    public function setPathSegment(string $pathSegment): void
    {
        $this->pathSegment = $pathSegment;
    }

    /**
     * @return string
     */
    public function getTeaser()
    {
        return $this->teaser;
    }

    /**
     * @param string $teaser
     */
    public function setTeaser($teaser)
    {
        $this->teaser = $teaser;
    }

    /**
     * @return string
     */
    public function getExternalLink()
    {
        return $this->externalLink;
    }

    /**
     * @param string $externalLink
     */
    public function setExternalLink($externalLink)
    {
        $this->externalLink = $externalLink;
    }
}
