<?php

namespace SG\SgCourses\Controller;

use PDO;
use SG\SgCourses\Domain\Model\Course;
use SG\SgCourses\Service\SearchService;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Messaging\AbstractMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Mvc\Exception\StopActionException;
use TYPO3\CMS\Extbase\Mvc\Exception\UnsupportedRequestTypeException;
use TYPO3\CMS\Extbase\Persistence\Generic\Exception;

/***
 *
 * This file is part of the "Events" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein, smply.gd
 *
 ***/

/**
 * EventController
 */
class AdministrationController extends ActionController
{

    /**
     * courseRepository
     *
     * @var \SG\SgCourses\Domain\Repository\CourseRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $courseRepository = null;

    /**
     * action list
     *
     * @return void
     */
    public function listAction()
    {
        $courses = $this->courseRepository->findAll();
        $this->view->assign('courses', $courses);
    }

    /**
     * action search
     *
     * @param string $searchString
     * @return void
     * @throws NoSuchArgumentException
     * @throws Exception
     * @throws StopActionException
     */
    public function searchAction($searchString = null)
    {
        if ($this->request->hasArgument('searchString')) {
            if (strlen($this->request->getArgument('searchString')) > 0) {
                $rawResult = SearchService::search(
                    $this->request->getArgument('searchProperty'),
                    $this->request->getArgument('searchString')
                );
                $resultArray = [
                    'Courses' => null
                ];
                foreach ($rawResult as $item) {
                    foreach ($item as $result) {
                        if ($result instanceof Course) {
                            $resultArray['Courses'][] = $result;
                        }
                    }
                }
                $this->view->assignMultiple([
                    'result' => $resultArray,
                    'searchString' => $this->request->getArgument('searchString'),
                    'searchProperty' => $this->request->getArgument('searchProperty')
                ]);
            }
        } else {
            $this->forward('list', 'Administration', 'SgCourses');
        }
    }

    /**
     *
     * @throws NoSuchArgumentException
     */
    public function deleteAction()
    {
        $queryBuilder = GeneralUtility::makeInstance(
            ConnectionPool::class
        )->getQueryBuilderForTable(
            $this->request->getArgument('type')
        );

        $affectedRows = $queryBuilder->delete($this->request->getArgument('type'))->where($queryBuilder->expr()->eq(
            'uid',
            $queryBuilder->createNamedParameter($this->request->getArgument('item'), PDO::PARAM_INT)
        ))->execute();

        $searchParams = [
            'searchString' => null,
            'searchProperty' => null
        ];

        if ($this->request->hasArgument('searchString') && $this->request->hasArgument('searchProperty')) {
            if (strlen($this->request->hasArgument('searchString')) > 0 &&
                strlen($this->request->hasArgument('searchProperty')) > 0
            ) {
                $searchParams = [
                    'searchString' => $this->request->getArgument('searchString'),
                    'searchProperty' => $this->request->getArgument('searchProperty')
                ];
            }
        }

        $this->addFlashMessage('Datensatz wurde gelöscht', 'Löschen erfolgreich!', AbstractMessage::OK);

        try {
            $this->redirect($this->request->getArgument('backAction'), 'Administration', 'SgCourses', $searchParams);
        } catch (NoSuchArgumentException $e) {
        } catch (StopActionException $e) {
        } catch (UnsupportedRequestTypeException $e) {
        }
    }
}
